 $PASCAL ' 91790-16118 REV.4010 <860325.1358> '  $ TITLE 'MMGR Initializer' $  $ RECURSIVE OFF, RANGE OFF $  $ HEAP 0  $ DEBUG       PROGRAM mminit;       {------------------------------------------------------------        (c) COPYRIGHT HEWLETT PACKARD COMPANY 1986. ALL RIGHTS    RESERVED. NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED,   REPRODUCED OR TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT    THE PRIOR WRITTEN CONSENT OF THE HEWLETT-PACKARD COMPANY.       ------------------------------------------------------------}      {}  
{      NAME: mminit  
 {    SOURCE: 91790-18118  {     RELOC: 91790-16118  {      PGMR: jar  {}      {}  {------------------------------------------------------------   { MODIFICATIONS:  {   {  Date   PCO  Prgmr Description  {  831213 ---- jar   Tell him that MMTBJ has become MMGR   {  831221 ---- jar   Supply "reasonable" values to DS_SetUpDSAM    {  840106 ---- jar   Search ".lib"  {  840119 ---- jar   40 Socket Buffers  {  840213 ---- jar   Add debug option (any runparms)  {  840214 ---- jar   Start up the debug on "mmgr.deb"   {  840319 ---- jar   HEAP 0   {  840405 ---- jar   Don't be critical at initialization.   {  840406 ---- jar   Return error to caller   %{  840412 ---- jar   Runstring is "mminit sbnum minclnum tablesize [d/r/]" %  {  840503 ---- jar   Let DS_SetUpDSAM rp MMGR, except for debug    {  840727 ---- jar   Wate even longer   {  840815 ---- jar   Extend interface for DSInit  {  840815 ---- jar   ***********Post ot INT1*****************   {  840919 ---- jar   Add urecnum to call/parameters    {  840925 ---- jar   Only mmstuff (ADSINIT) if DS_SetUpDSAM left   {  840925                 ADSINITIALIZING   {  841023            Defaults: 250 sbufs  {  841029            **************** Post ******************   ${  841029            Bug: was defaulting to MMINITGENLINUSE, vice ...CL  $ {  841107            Bug: retry counter   {  841107            **************** Post ******************   ${  850222            Call DS_InitEnterCrit/DS_InitLeaveCrit to prep the  $ {                    Synchronized Debuggable Real MM  #{  850327   lms      To change into a ccp, deleting debug parameter 6  # "{                    and fmprunprogram of MMGR.  Also put runstring  " {                    parsing into a subroutine.   "{  850328   lms      Added debug code for dsinit.  MMInit now reads  " "{                    a testcase number from the file mminit.test, if " #{                    the mminitdebug flag is set for ccp.  If the file # ${                    does not exist MMInit uses test case 0, which means $ {                    perform as usual.  "{*************************POST ************************************* " !{860310 lms       Submittal n365: Enhance MMINIT's error reporting ! {                 in the pascal error catcher.  "{************************POST*************************************** "  {860325 lms       submittal N368: Add MMBADCRITRN, MMNOCRITRN to   {                 test code as 18 & 19.   {   {  Last edit: <860325.1358>   {   {------------------------------------------------------------   {}      {}  { PROGRAM DESCRIPTION:  {   {  Starts the memory manager.   {   {  Runstring:   {     mminit <sbnum><minclnum><tablesize><urecnum><security>  {   {  DEFAULTS   {  sbnum                250.  {  minclnum               0.  {  tablesize          32767.  {  urecnum              256.  {  security code MMSECURITY.  #{  ******************************************************************* # !{     Note: If using mminitdebug flag 0 is a valid security code.  ! {     This is the only time this security code is valid.  #{  ******************************************************************* # {   {   {  Returns:   {     RMPAR parameters:   {        p1    The "error" return from DS_SetUpDSAM   ${        p2    Either 0, or the number of pages required for the system. $ !{        p3    DS.  ( Unless mminitdebug flag is set at ccp time.  ! '{                   Then this parm could be something else for dsinit tests).  ' {   {}  IMPORT                       $SEARCH 'phtm/BODEC.REL'       bodec,   {  General-purpose declarations                    }                        $SEARCH 'phtm/MMDEC.REL'       mmdec,   {  Memory-Manager declarations                     }                        $SEARCH 'phtm/MMEXT.REL'       ds_mm,   {  The Memory Manager                              }                        $ SEARCH 'phtm/init_dec.rel'      init_dec;      CONST      DS = ord ( 'D' )*256 + ord ( 'S' );     HI = ord ( 'H' )*256 + ord ( 'I' );     NO = ord ( 'N' )*256 + ord ( 'O' );      TYPE     parm_array  =  ARRAY [1..5] OF Int16;          VAR          startupstring  :  string[80];     securitycode   :  Int16;      pages          :  Int16;          dummy          :  Int16;      sbnum          :  Int16;      minclnum       :  Int16;      tablesize      :  Integer;      urecnum        :  Int16;      error          :  Int16;      parms          :  parm_array;     canhandle      :  Boolean;      astring        :  string[80];      
PROCEDURE DS_OSDSAMState;  
    EXTERNAL;      $PROCEDURE ErrorCatcher                     $ ALIAS 'Pas.ErrorCatcher' $  $   (    err_type:     ErrorType;          err_no:       Int16;          err_line:     Int16;          err_file:     FNameType;          err_flen:     Int16 );      FORWARD;      { Trap and recover from pascal errors }      
PROCEDURE exec_halt  
 $ALIAS 'EXEC'      (  ecode :  Int16 );      EXTERNAL;          FUNCTION pas_sparameters     $ALIAS 'PAS.SPARAMETERS'      (        pos   :  Int16;         VAR   parm  :  string )      :  Int16;     EXTERNAL;      "FUNCTION PascalStringData                $ ALIAS 'Pas.StringData1' $ "    ( VAR s:          String ):  PCharTypePtr;      EXTERNAL;     { return a packed array of char pointer to a string }      PROCEDURE prtn     (  VAR   p  :  parm_array );      EXTERNAL;      $PROCEDURE RtePrint             $ ALIAS 'REIO', HEAPPARMS OFF, NOABORT $  $   ( writereq:     Int16;      conwd:        Int16;      msg:          PCharType;  
    msglen:       Int16 ); 
    EXTERNAL;     { Print a message on the scheduling terminal }           $ SUBTITLE 'ErrorCatcher', PAGE $   {------------------------------------------------------------}  {                                                            }  {                    ErrorCatcher                            }  {                                                            }  {------------------------------------------------------------}  PROCEDURE ErrorCatcher    (    err_type:     ErrorType;          err_no:       Int16;          err_line:     Int16;          err_file:     FNameType;          err_flen:     Int16 );       {}  #{  Purpose: To handle pascal errors internally instead of blowing up.  # {   {  Input: err_type-  The type of error that occurred  {         err_no-    the numeric value of the error.  "{         err_line-  the line number in the program where the error  " {                      occurred   "{         err_file   the file name associated with the error, if any " %{         err_flen   the length of the filename associated with the error  % {   {  Output:  none  {  Global variables accessed:   %{      Init_Dec booleans to indicate what type of operation is being done- % {           opening- opening a file   {           reading- reading from a file  {           converting- converting a string to a number   {   &{  Global variables Changed:  hiterror- set to TRUE when routine is entered  & "{                             pascal_error record has its fields set " {                                to err_type and err_no.  {   '{  Routines Called:  RtePrint to print error if condition is not recoverable.  ' %{     ShootSelf which TERMINATES the program if the error is not handled.  % {}      VAR      handled:    Boolean;      nextpos:    Int16;          BEGIN    { ErrorCatcher }      #   { if hiterror flag already set we may be in infinite loop.  Halt. } # 
   IF hiterror THEN  
       BEGIN    { potential loop }   "      astring := '** MMINIT: Hit error catcher twice. Terminating.'; "           RtePrint( XWRITEREQ, LU1, PascalStringData( astring )^,               -Strlen( astring ));           BEGIN    { error on rte print }  
         { ignore errors } 
          END;     { error on rte print }            Halt( -32767 );         END;     { potential loop }          { set global indicating got to the error catcher }   
   hiterror := TRUE; 
        IF NOT canhandle THEN        BEGIN    { print an error and quit }  
      astring := ''; 
     %      Strwrite( astring, 1, nextpos, '**MMINIT: Pascal Error ', err_no:1,  % !         ' of type ', err_type, ' at line ', err_line:1, '.***' ); !           RtePrint( XWRITEREQ, LU1, PascalStringData( astring )^,               -Strlen( astring ));           BEGIN    { error on rte print }  
         { ignore errors } 
          END;     { error on rte print }            IF err_type = FMP THEN           BEGIN    { print fmp info }           astring := '';            nextpos := 0;      #         Strwrite( astring, 1, nextpos, '*** File Name is ', err_file: #             err_flen, '.***' );                 RtePrint( XWRITEREQ, LU1, PascalStringData( astring )^,                  -Strlen( astring ));               BEGIN    { error on RTE print }                   { ignore errors }               END;     { error on RTE print }            END;     { print fmp info }      
      Halt(-32767);  
           END;     { print an error and quit }     END;     { ErrorCatcher }          $ SUBTITLE 'ReadRunstringCounts', PAGE $  PROCEDURE ReadRunstringCounts;     BEGIN    { ReadRunstringCounts }          IF ( pas_sparameters ( 1, startupstring ) <= 0 ) THEN         BEGIN {  Default sbnum                                   }   
      sbnum       := 250;  
        END   {  Default sbnum                                   }      ELSE          BEGIN {  Use parameter sbnum                             }         StrRead ( startupstring, 1, dummy, sbnum );          END;  {  Use parameter sbnum                             }          IF ( pas_sparameters ( 2, startupstring ) <= 0 ) THEN         BEGIN {  Default minclnum                                }         minclnum    := MMINITGENLINUSECL;          END   {  Default minclnum                                }      ELSE          BEGIN {  Use parameter minclnum                          }         StrRead ( startupstring, 1, dummy, minclnum );         END;  {  Use parameter minclnum                          }          IF ( pas_sparameters ( 3, startupstring ) <= 0 ) THEN         BEGIN {  Default tablesize                               }         tablesize   := MAXINT16;         END   {  Default tablesize                               }      ELSE          BEGIN {  Use paramter minclnum                           }         StrRead ( startupstring, 1, dummy, tablesize );          END;  {  Use paramter minclnum                           }          IF ( pas_sparameters ( 4, startupstring ) <= 0 ) THEN  '      BEGIN {  Default urecnum                                              }  '       urecnum  := 256;  '      END   {  Default urecnum                                              }  '    ELSE   '      BEGIN {  use parameter urecnum                                        }  '       StrRead ( startupstring, 1, dummy, urecnum );   '      END;  {  use parameter urecnum                                        }  '        END;     { ReadRunstringCounts }       $ SUBTITLE 'MMInit', PAGE $   	BEGIN {  MMINIT }  	        SetStrLen ( startupstring, StrMax ( startupstring ) );          ReadRunstringCounts;          IF ( pas_sparameters ( 5, startupstring ) <= 0 ) THEN        BEGIN    { use hardcoded security code }        securitycode := 0;        END      { use hardcoded security code }     ELSE         BEGIN    { read caller's security code }        StrRead ( startupstring, 1, dummy, securitycode );        END;     { read caller's security code }  $   DS_SetUpDSAM   (  sbnum, minclnum, tablesize, urecnum, securitycode,  $       pages, error );          securitycode := DS;         parms[1] := error;      parms[2] := pages;      parms[3] := securitycode;      	   prtn ( parms ); 	     
   exec_halt ( 6 );  
     	END.  {  MMINIT }  	    