 $PASCAL '91790-16132 REV.4010 <860509.1420>'  
$Standard_Level 'HP1000'$  
 $Recursive Off$   $Debug$   $Heap 0$  $Range Off$       PROGRAM NFTMN;      {------------------------------------------------------------        (c) COPYRIGHT HEWLETT PACKARD COMPANY 1986. ALL RIGHTS    RESERVED. NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED,   REPRODUCED OR TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT    THE PRIOR WRITTEN CONSENT OF THE HEWLETT-PACKARD COMPANY.       ------------------------------------------------------------}      {}  
{       NAME: NFTMN  
 
{     SOURCE: 91790-18132  
 
{      RELOC: 91790-16132  
 	{       PGMR: TDS  	 {}      {}  {------------------------------------------------------------   { MODIFICATIONS:  {   {  Date     PCO   Prgmr   Description   { 12/20/85  ---   EW      Delete references to IPCUABORT.   { 12/31/85  2626  EW      CCP out optional DETACH.   { 12/31/85  2626  EW      Recode to perofrm logon and attach to    !{                         session before cloning server.SR #30957  ! ${ 01/31/86  2626  EW      Added trigger 7403 for enter critical failure. $ {                         SR # none   ${ 03/26/86  2626  EW      Only move 6 bytes from the RINIT message into  $ {                         the session key. SR # none  ${ 05/09/86  5000  EW      Don't attempt to attach to session if in DEBUG $ {                         mode.   {------------------------------------------------------------   {}      {}  { PROGRAM DESCRIPTION:  {   !{   This is the Network File Transfer Monitor program. It accepts  !  {   incoming connection requests for NFT service. It then clones   {   the appropriate server (NFT Producer or NFT Consumer) and   {   passes the connection off to it.  {}      $Page   #{-------------------------------------------------------------------}  # #{                            MAIN LABELS                            }  # #{-------------------------------------------------------------------}  #     LABEL      999;  { Labels the end of the main routine }           $Page   #{-------------------------------------------------------------------}  # #{                                                                   }  # #{                          MODULE GLOBALS                           }  # #{                                                                   }  # #{-------------------------------------------------------------------}  #     MODULE GLOBALS;           #{-------------------------------------------------------------------}  # #{ GLOBALS                      IMPORT                       GLOBALS }  # #{-------------------------------------------------------------------}  #     IMPORT         $SEARCH 'phtm/BODEC.REL'$  BODEC,     $SEARCH 'phtm/SODEC.REL'$  SODEC,     $SEARCH 'phtm/MMDEC.REL'$  MMDEC,     $SEARCH 'phtm/MMEXT.REL'$  DS_MM,     $SEARCH 'phtm/TRCMOD.REL'$ TRCMOD;       #{-------------------------------------------------------------------}  # #{ GLOBALS                      EXPORT                       GLOBALS }  # #{-------------------------------------------------------------------}  #     EXPORT      CONST      DEBUG_MODE              =   -99;      MAX_ERROR_STRING_BYTES  =    80;       TYPE     { These types are used in conjunction with AdsErrorLookup }  #   ErrorPacType    = PACKED ARRAY [1..MAX_ERROR_STRING_BYTES] OF CHAR; #    ErrorStringType = STRING [MAX_ERROR_STRING_BYTES];       "   { This is used to enter options for Ipc calls. Enough space is }  " "   { allocated for four options and two data bytes per option     }  "    IpcOptionsType = PACKED ARRAY [0..43] OF Byte;           	PROCEDURE LogEvent 	    (nft_log_error_code : Int16;       instance           : Int16;       error_or_warning   : Int16;       parm1              : Int32;       parm2              : Int32;       parm3              : Int32);          $Page   #{-------------------------------------------------------------------}  # #{ GLOBALS                     IMPLEMENT                     GLOBALS }  # #{-------------------------------------------------------------------}  #     IMPLEMENT       CONST          $INCLUDE 'src/NFTCONSTS.PASI'      #{-------------------------------------------------------------------}  # #{ GLOBALS                     LOG ERROR                     GLOBALS }  # #{-------------------------------------------------------------------}  # { Log an event to the log file.   {   { Parameters  {   {     nft_log_error_code (Input)  "{        An error code defined by NFT/1000 that should be logged to  " {        the log file.  {   {     instance (Input)  {        Gives the instance of the error code. This will be a   "{        different number for each location where LogEvent is called " {        with the given nft_log_error_code.   {   {     error_or_warning (input)  !{        Will be either EL_ERROR for an error, or EL_WARNING for a ! 	{        warning.  	 {   
{     parm1 (Input)  
 !{        A parameter whose usage depends on the nft_log_error code ! {   
{     parm2 (Input)  
 !{        A parameter whose usage depends on the nft_log_error code ! {   
{     parm3 (Input)  
 !{        A parameter whose usage depends on the nft_log_error code ! {}  
PROCEDURE  LogEvent  
    (nft_log_error_code : Int16;       instance           : Int16;       error_or_warning   : Int16;       parm1              : Int32;       parm2              : Int32;       parm3              : Int32);      VAR      dummy       : ContextWords;     info_msg    : ARRAY [1..4] OF Int16;      result      : Int16;      wkmp        : Int16;       BEGIN      dummy.longint := 0;     info_msg [1]  := nft_log_error_code;   
   info_msg [2]  := parm1; 
 
   info_msg [3]  := parm2; 
 
   info_msg [4]  := parm3; 
        DS_EnterCritical (wkmp, result);          IF result = 0 THEN         BEGIN         Log_Event (error_or_warning, HP_NFT, instance, dummy, 4,                   info_msg [1], result);         DS_LeaveCritical (wkmp);  	      END;  { IF } 	     	END;  { LogEvent } 	     END;  { MODULE GLOBALS }          $Page   #{-------------------------------------------------------------------}  # #{                                                                   }  # #{                            MODULE NFT                             }  # #{                                                                   }  # #{-------------------------------------------------------------------}  #     MODULE NFT;           #{-------------------------------------------------------------------}  # #{ NFT                          IMPORT                           NFT }  # #{-------------------------------------------------------------------}  #     IMPORT         GLOBALS,          $SEARCH 'phtm/BODEC.REL'$   BODEC,      $SEARCH 'phtm/SODEC.REL'$   SODEC,      $SEARCH 'phtm/MMDEC.REL'$   MMDEC,      $SEARCH 'phtm/MMEXT.REL'$   DS_MM,      $SEARCH 'phtm/SIGMOD.REL'$  SIGMOD,     $SEARCH 'phtm/TRCMOD.REL'$  TRCMOD;      #{-------------------------------------------------------------------}  # #{ NFT                          EXPORT                           NFT }  # #{-------------------------------------------------------------------}  #     EXPORT         PROCEDURE  NftCallHandler        (VAR call_socket_descr : Int32;          VAR fatal_error       : BOOLEAN);         PROCEDURE  NftVcSocketHandler        (VAR vc_socket_descr   : Int32;              param             : Int16;          VAR fatal_error       : BOOLEAN);      #{-------------------------------------------------------------------}  # #{ NFT                         IMPLEMENT                         NFT }  # #{-------------------------------------------------------------------}  #     IMPLEMENT           #{-------------------------------------------------------------------}  # #{ NFT                         CONSTANTS                         NFT }  # #{-------------------------------------------------------------------}  #     CONST      { Include the common NFT constant declarations }      $INCLUDE 'src/NFTCONSTS.PASI'      "   { We will not specify ::PROGRAMS for these; let DS_RSM_Clone() }  " "   { find them wherever they may be (may be on ::0).              }  "    CONSUMER_PROG_NAME   = 'CONSM ';      PRODUCER_PROG_NAME   = 'PRODC ';          { Exec schedule request code }      IMMEDIATE_NO_WAIT    =  10;      #   { These are for the message buffer declared below. The only type }  # #   { of messages we deal with are control messages. NFT limits the  }  # #   { control messages to 700 bytes in size.                         }  #    MAX_BUFFER_BYTES     =  700;      MAX_BUFFER_WORDS     =  MAX_BUFFER_BYTES DIV 2;         { Length of RTE program name }      PROG_NAME_LENGTH     =  5;       $Page   #{-------------------------------------------------------------------}  # #{ NFT                          TYPES                            NFT }  # #{-------------------------------------------------------------------}  #     TYPE     { Used to access the individual bits of a byte }      ByteAsBits = PACKED RECORD         CASE BOOLEAN OF            TRUE : (whole_byte : Byte);           FALSE: (bits       : PACKED ARRAY [0..7] OF BOOLEAN);     END;          { This is a field in the Rinit, Ainit messages }      CapabilityMaskRecord = PACKED RECORD         CASE BOOLEAN OF            TRUE : (whole_word   : Int32);             FALSE: (unused1      : PACKED ARRAY [0..28] OF BOOLEAN;                    hierarchical : BOOLEAN;                   unused2      : BOOLEAN;                   switch_roles : BOOLEAN);      END;       "   { This is the type of the session key as defined by DsRsm/1000 }  "    DsSessionKeyType = RECORD        CASE BOOLEAN OF   $         TRUE:  (bytes : PACKED ARRAY [1..SESSION_KEY_WORDS*2] OF Byte); $           FALSE: (words : ARRAY [1..SESSION_KEY_WORDS] OF Int16);      END;           LogonPacType = PACKED ARRAY [1..MAX_NFT_LOGON_CHARS] OF CHAR;          { This is the buffer type for a Messs() call }      MesssBufferType = PACKED ARRAY [1..72] OF CHAR;         { This is a field in the Rinit, Ainit messages }      MiscFlagsType = PACKED RECORD        CASE BOOLEAN OF            TRUE : (whole_byte : Byte);           FALSE: (unused     : PACKED ARRAY [0..6] OF BOOLEAN;                    consumer   : BOOLEAN);      END;          { Ainit message fields }      AinitMsgType = PACKED RECORD         debug_flags          : ByteAsBits;        misc_flags           : MiscFlagsType;         system_type          : Int16;         op_sys_version       : Int16;         buffer_size          : Int16;         capability_mask      : CapabilityMaskRecord;        sys_specif_capa_mask : Int16;         nft_error_code       : Int16;         local_error_msg_ptr  : Int16;         error_code_enhan_ptr : Int16;         end_ptr              : Int16;      END;          { Rinit message fields }      RinitMsgType = PACKED RECORD         debug_flags          : ByteAsBits;        misc_flags           : MiscFlagsType;         system_type          : Int16;         op_sys_version       : Int16;         buffer_size          : Int16;         capability_mask      : CapabilityMaskRecord;        sys_specif_capa_mask : Int16;         logon_id_ptr         : Int16;         logon_id_pass_ptr    : Int16;         session_id_ptr       : Int16;         share_session_id_ptr : Int16;         end_ptr              : Int16;      END;          { This defines the second word of each Nft message }      NftHeaderType = PACKED RECORD  
      protocol_id : Byte;  
 
      msg_type    : Byte;  
    END;           { This is the structure of the Nft messages. We handle only }       { the Rinit and Ainit messages                              }   
   NftMessageType = RECORD 
       msg_length_bytes  : Int16;        message_type      : NftHeaderType;  
      CASE Int16 OF  
          0 : (ainit_msg : AinitMsgType);           1 : (rinit_msg : RinitMsgType);     END;       
   MsgBufferType = RECORD  
 
      CASE Int16 OF  
          0 : (msg    : NftMessageType);   #         1 : (bytes  : PACKED ARRAY [0..MAX_BUFFER_BYTES -1] OF Byte); # #         2 : (chars  : PACKED ARRAY [0..MAX_BUFFER_BYTES -1] OF CHAR); #           3 : (words  : ARRAY [0..MAX_BUFFER_WORDS -1] OF Int16);      END;          ProgFileNameStringType = String [20];          ProgramPacType = PACKED ARRAY [1..PROG_NAME_LENGTH] OF CHAR;           ProgramStringType = String [PROG_NAME_LENGTH];       $Page   #{-------------------------------------------------------------------}  # #{ NFT                          VARIABLES                        NFT }  # #{-------------------------------------------------------------------}  #     VAR   "   { This flag will be true only if the Rinit message requested a }  " "   { consumer server, else will be false.                         }  "    consumer_desired  : BOOLEAN;           { The Nft messages (Rinit, Ainit) pass through this buffer }       msg_buffer        : MsgBufferType;       $Page   #{-------------------------------------------------------------------}  # #{ NFT                EXTERNAL & FORWARD ROUTINES                NFT }  # #{-------------------------------------------------------------------}  #     PROCEDURE AdsErrorLookup     (    service         : Int16;          error_number    : Int32;      VAR buffer          : ErrorPacType);     EXTERNAL;      PROCEDURE AddOpt     (VAR opts            : IpcOptionsType;           entry_number    : Int16;          arg_code        : Int16;          data_length     : Int16;          data            : Int16;      VAR error           : Int16);      EXTERNAL;      FUNCTION DS_Rsm_Attach     $FIXED_STRING ON $      (VAR wkmp            : Int16;      VAR session_key     : DSSessionKeyType)      : Int16;      $ FIXED_STRING OFF $      EXTERNAL;      PROCEDURE DS_Rsm_Detach;     EXTERNAL;      FUNCTION DS_Rsm_Clone   
   $FIXED_STRING ON$ 
    (VAR wkmp            : Int16;      VAR clone_name      : ProgFileNameStringType;       VAR id_address      : Int16)     : Int16;      $FIXED_STRING OFF$      EXTERNAL;      FUNCTION DS_Rsm_Logoff     (VAR wkmp            : Int16;      VAR key             : DsSessionKeyType)      : Int16;      EXTERNAL;      FUNCTION DS_Rsm_Logon      (VAR wkmp            : Int16;      VAR acct            : LogonPacType;       VAR key             : DsSessionKeyType)      : Int16;      EXTERNAL;      PROCEDURE DS_StoreUrec     (VAR urec_id         : Int16;      VAR urec            : Int16);      EXTERNAL;      PROCEDURE ExecSchedule  $ALIAS 'EXEC', NOABORT$      (    exec_code       : Int16;      VAR prog_name       : ProgramPacType;           parm1           : Int16;          parm2           : Int16;          parm3           : Int16;          parm4           : Int16;          parm5           : Int16);      EXTERNAL;      	PROCEDURE InitOpt  	    (VAR opts            : IpcOptionsType;           total_entries   : Int16;      VAR error           : Int16);      EXTERNAL;      
PROCEDURE IpcControl 
    (VAR descr           : Int32;          request         : Int32;          wrtdata         : Int16;          wrtlength       : Int32;          readdata        : Int16;          readlength      : Int32;      VAR flags           : Int32;      VAR ipc_error       : Int32);      EXTERNAL;      	PROCEDURE IpcRecv  	    (VAR socket_descr    : Int32;      VAR msg_buffer      : MsgBufferType;          data_length     : Int32;      VAR ipc_flags       : Int32;      VAR ipc_options     : IpcOptionsType;       VAR ipc_error       : Int32);      EXTERNAL;      
PROCEDURE IpcRecvCn  
    (VAR call_descr      : Int32;      VAR vc_descr        : Int32;      VAR ipc_flags       : Int32;      VAR ipc_options     : IpcOptionsType;       VAR ipc_error       : Int32);      EXTERNAL;      	PROCEDURE IpcSend  	    (VAR socket_descr    : Int32;      VAR msg_buffer      : MsgBufferType;          data_length     : Int32;      VAR ipc_flags       : Int32;      VAR ipc_options     : IpcOptionsType;       VAR ipc_error       : Int32);      EXTERNAL;      PROCEDURE IpcShutDown      (VAR socket_descr    : Int32;      VAR ipc_flags       : Int32;      VAR ipc_options     : IpcOptionsType;       VAR ipc_error       : Int32);      EXTERNAL;      FUNCTION Messs     (VAR command_buffer  : MesssBufferType;          length          : Int16)     : Int16;      EXTERNAL;      FUNCTION MyIdAdd     : Int16;      EXTERNAL;      PROCEDURE PerformLogon     (VAR msg_buffer      : MsgBufferType;      VAR wkmp            : Int16;      VAR vc_socket_descr : Int32;      VAR consumer        : BOOLEAN;      VAR sons_name       : String;       VAR session_key     : DSSessionKeyType;       VAR nft_error       : Int16);      FORWARD;       PROCEDURE SendAinitMsg     (VAR vc_socket_descr : Int32;      VAR msg_buffer      : MsgBufferType;          nft_error       : Int16;          nft1000_error   : Int16;          ds_rsm_error    : Int16);      FORWARD;           $Page   #{-------------------------------------------------------------------}  # #{ NFT                 CLEANUP SERVER RESOURCES                  NFT }  # #{-------------------------------------------------------------------}  # #{ Cleanup after the server program. We want to release his id segment, # !{ user record and any resources in the user record. All we have to ! #{ do is OF the server. This will cause the DS abort processor to take  # "{ over. This routine can be called while critical since a Messs call " { is acceptable then.   {   { Parameters:   {   
{     server_name (Input)  
 {        The name of the server program to cleanup after  {}  PROCEDURE  CleanupServerResources      (VAR server_name  : String);       CONST      COMMAND_LENGTH = PROG_NAME_LENGTH + 6;      OF_PROGRAM_ID  = 'OF,XXXXX,ID';      VAR      command_pac : MesssBufferType;      loop        : Int16;      result      : Int16;       BEGIN      command_pac := OF_PROGRAM_ID;         FOR loop := 1 TO PROG_NAME_LENGTH DO         command_pac [loop + 3] := server_name [loop];          result := Messs (command_pac, COMMAND_LENGTH);       END;  { CleanupServerResources }          $Page   #{-------------------------------------------------------------------}  # #{ NFT                     MOVE UREC SOCKET                      NFT }  # #{-------------------------------------------------------------------}  # "{ Move a socket from one user record to another thereby changing the " !{ owner of the socket. The caller is responsible for ensuring that ! !{ the local socket descriptor represents an existing socket in the ! { source user record.   {   { Parameters:   {   {   socket_descr (Input/Output)   !{     On input, gives the local socket descriptor of the socket to !  {     be moved from src_urec. On output, gives the local socket    {     descriptor of the moved socket in targ_urec.  {   {   src_urec (Input/Output)    {     The user record that contains the socket descriptor of the   {     socket to be moved. NOTE: This user record is not posted  {     by this routine after being modified.   {   {   targ_urec (Input/Output)   {     The user record into which the socket descriptor is to be    !{     moved. NOTE: This user record is not posted by this routine  ! {     after being modified.   {   {   targ_urec_id (Input)   {     The user record id of the target user record. This will be   {     inserted into the "so_urecid" field of the socket record  {}  
PROCEDURE  MoveUrecSocket  
    (VAR socket_descr    : Int32;      VAR src_urec        : UserRecord;       VAR targ_urec       : UserRecord;       VAR targ_urec_id    : Int16);       VAR      socket      : SocketRecord;     targ_descr  : Int16;       BEGIN      { Grab a free socket descriptor slot in the target urec }     targ_descr         := targ_urec.ur_sfree;     targ_urec.ur_sfree := - targ_urec.ur_smap [targ_descr];         { Move the socket descriptor }   #   targ_urec.ur_smap [targ_descr] := src_urec.ur_smap [socket_descr];  #        { Delete the socket from the source user record }     src_urec.ur_smap [socket_descr] := - src_urec.ur_sfree;     src_urec.ur_sfree               := socket_descr;       "   { Insert the user record id of the target user record into the }  " "   { socket record of the new socket. Also, insert the resource   }  " "   { number descriptor of the new owner of the socket (the server)}  " "   { so that signals will be sent to the proper user program.     }  " !   DS_SOFetchElement (targ_urec.ur_smap [targ_descr], socket.int); !    socket.so_urecid    := targ_urec_id;      socket.so_b.userrnd := targ_urec.ur_rnd;   !   DS_SOStoreElement (targ_urec.ur_smap [targ_descr], socket.int); !        { Return the target socket descr }      socket_descr := targ_descr;      END;  { MoveUrecSocket }          $Page   #{-------------------------------------------------------------------}  # #{ NFT                      NFT CALL HANDLER                     NFT }  # #{-------------------------------------------------------------------}  # "{ The Nft call socket has selected as readable. All we need to do is " "{ accept the connection request. Since Ipc will record the vc socket " "{ descriptor in our user record, we will be able to dig it out later " 
{ and select on it.  
 {   { Parameters:   {   {     call_socket_descr (Input)   {        The Nft call socket descriptor. It exception selected  {   
{     fatal_error (Output) 
 {        Returns true only if a fatal error occurred  {}  
PROCEDURE  NftCallHandler  
    (VAR call_socket_descr : Int32;      VAR fatal_error       : BOOLEAN);       LABEL      99;   { Labels end of the procedure }      VAR      data_length       : Int32;      dummy             : Int16;      error             : Int16;      ipc_error         : Int32;      ipc_flags         : Int32;      ipc_options       : IpcOptionsType;     nft_buffer_words  : Int16;      nft_checksum_flag : Int16;      vc_socket_descr   : Int32;      wkmp              : Int16;       BEGIN      DS_EnterCritical (wkmp, error);     fatal_error := error <> 0;      IF fatal_error THEN        GOTO 99;         { Fetch NFT's global parameters }     DS_FetchGlobal (NFT_BUFF_SIZE, 1, nft_buffer_words);      DS_FetchGlobal (NFT_CHECKSUM,  1, nft_checksum_flag);         DS_LeaveCritical (wkmp);       "   { Tell Ipc what the send and receive buffer sizes should be on  } " "   { the connection. At this point we do not know if this end of   } " "   { the connection is for a producer or consumer. The send buffer } " "   { size will be the same for both but the receive buffer size    } " "   { will vary. We will guess producer here and adjust the buffer  } " "   { requirements when the RINIT message tells us consumer later.  } " "   { Also, set the burst size for the connection. The receive size } " "   { is what we are concerned about since it could be for the      } " "   { consumer's connection.                                        } "    InitOpt (ipc_options, 3, error);   !   AddOpt (ipc_options, 0, IPC_MAX_SEND_SIZE, 2, MAX_BUFFER_BYTES, ! 	           error); 	 $   AddOpt (ipc_options, 1, IPC_MAX_RECEIVE_SIZE, 2, nft_buffer_words*2,  $ 	           error); 	 $   AddOpt (ipc_options, 2, IPC_MIN_BURST_IN, 2, NFT_BURST_SIZE, error);  $        ipc_flags := IPC_MSG_MODE;           { If the sign bit of the checksum word is set then checksum }      IF nft_checksum_flag < 0 THEN        ipc_flags := ipc_flags + IPC_CHECKSUM_FLAG;          IpcRecvCn (call_socket_descr, vc_socket_descr, ipc_flags,                ipc_options, ipc_error);      "   { If we tried to receive a connect request and we had no free   } " "   { sockets, then Ipc will return the error (IPC_NO_SOCKETS) but  } " "   { will retain the request. If no sockets free up before we come } " "   { back around to this procedure again, then we will get the     } " "   { same error. This will continue until a socket frees up, which } " "   { should not be long. The lack of free sockets is probably rare } " "   { so this should not be a problem.                              } " !   IF (ipc_error <> 0) AND (ipc_error <> IPC_ERR_NO_SOCKETS) THEN  ! !      LogEvent (M_LOG_RECVCN_ERROR, 1, EL_ERROR, ipc_error, 0, 0); !     #   { Now that we have a vc socket that identifies a connection, set }  # #   { the read threshold for it. This is needed for the IpcSelect    }  # #   { call that we will do later.                                    }  #    IF ipc_error = 0 THEN        BEGIN         data_length := 0;         ipc_flags   := 0;         IpcControl (vc_socket_descr, IPC_SET_READ_THRESHOLD,                    MAX_BUFFER_BYTES, 2, dummy, data_length,                    ipc_flags, ipc_error);  	      END;  { IF } 	     99:   END;  { NftCallHandler }          $Page   #{-------------------------------------------------------------------}  # #{ NFT                  NFT VC SOCKET HANDLER                    NFT }  # #{-------------------------------------------------------------------}  # "{ The vc socket passed as a parameter has just selected as readable. " !{ There should be a RINIT (initialization) message hanging on the  ! #{ socket. Preview that message (the server will consume it), allocate  # { resources and schedule the requested server.  {   "{ The process of scheduling a server requires us to allocate a user  " #{ record for the server so that we have a place to record the server's # "{ resources as they are being allocated. If anything goes wrong, all " 
{ resources are released.  
 {   { Parameters:   {   {     vc_socket_descr (Input)    {        Gives the socket descriptor of the socket that selected   {        as readable.   {   
{     param (Input)  
 "{        If this is equal to DEBUG_MODE then the NFT server will be  " !{        restored (RP'ed) but not scheduled. Otherwise it will be  ! 
{        scheduled.  
 {   
{     fatal_error (Output) 
 {        If true this indicates that a fatal error occurred in  {        this procedure.  {}  PROCEDURE  NftVcSocketHandler      (VAR vc_socket_descr : Int32;          param           : Int16;      VAR fatal_error     : BOOLEAN);       LABEL      99;   { Labels end of the procedure }      VAR      bad_message    : BOOLEAN;  
   data_length    : Int32; 
 
   dummy          : Int16; 
 
   error          : Int16; 
 
   index          : Int16; 
 
   ipc_error      : Int32; 
 
   ipc_flags      : Int32; 
    ipc_options    : IpcOptionsType;      my_urec        : UserRecord;   
   my_urec_id     : Int16; 
 
   nft_error      : Int16; 
 
   nft1000_error  : Int16; 
    pac_name       : ProgramPacType;      server_name    : ProgFileNameStringType;      session_key    : DsSessionKeyType;   
   son_id_address : Int16; 
    son_urec       : UserRecord;   
   son_urec_id    : Int16; 
    sons_name      : ProgramStringType;  
   trigger_temp   : Int16; 
 
   wkmp           : Int16; 
     BEGIN      nft_error     := 0;     nft1000_error := 0;     ipc_flags     := IPC_PREVIEW_MSG;     data_length   := MAX_BUFFER_BYTES;      InitOpt (ipc_options, 0, error);       "   { The vc socket selected as readable so let's find out what it  } " "   { has to say by reading it. We'll get an error or a message.    } " "   { We are previewing, not consuming the message for two reasons: } " "   {    1) The son needs the message also so he will consume it    } " "   {    2) If we abort and get rescheduled before we hand off the  } " "   {       connection to the son, then the message will still be   } " "   {       there as if nothing ever happened.                      } "     IpcRecv (vc_socket_descr, msg_buffer, data_length, ipc_flags,               ipc_options, ipc_error);      
   IF ipc_error <> 0 THEN  
        LogEvent (M_LOG_RECV_ERROR, 1, EL_ERROR, ipc_error, 0, 0);           "   { If the NFT message length field does not match the number of }  " "   { bytes received for the message then the message is bad       }  "    bad_message := FALSE;     IF (ipc_error = 0)                                  AND        (data_length <> msg_buffer.msg.msg_length_bytes) THEN         BEGIN   
      bad_message := TRUE; 
       LogEvent (M_LOG_BAD_MSG_LENGTH, 1, EL_ERROR,                  msg_buffer.msg.message_type.msg_type,                   msg_buffer.msg.msg_length_bytes, data_length);  	      END;  { IF } 	     "   { We are assuming that any Ipc error here means the connection }  " "   { was aborted or something went wrong. In that case, or if the }  " "   { message appears bad, shut down the socket.                   }  "    IF (ipc_error <> 0) OR bad_message THEN        BEGIN         ipc_flags := 0;   $      IpcShutDown (vc_socket_descr, ipc_flags, ipc_options, ipc_error);  $       GOTO 99;        END;  { IF ipc_error }          #   { Make sure the message hanging on the socket is an Rinit message } #    IF msg_buffer.msg.message_type.msg_type = RINIT THEN         BEGIN   #      { !! If the RINIT message indicates a producer is desired then } # #      { !! part of the receive buffer space we allocated for the     } # #      { !! connection could be released here. See NftCallHandler().  } #       END      ELSE         BEGIN   #      { The message is not an Rinit. The NFT service requestor looks } # #      { sick. Don't even try to send a reply; just log an error and  } # #      { close the connection.                                        } #       LogEvent (M_LOG_ILLEGAL_MSG, 1, EL_ERROR,                   msg_buffer.msg.message_type.msg_type, 0, 0);        ipc_flags := 0;         IpcShutDown (vc_socket_descr, ipc_flags, ipc_options,                      ipc_error);        GOTO 99;        END;  { ELSE of IF msg_buffer }       !   { Set a global flag indicating which server we are scheduling } ! "   consumer_desired := msg_buffer.msg.rinit_msg.misc_flags.consumer; "        IF consumer_desired THEN         server_name := CONSUMER_PROG_NAME      ELSE         server_name := PRODUCER_PROG_NAME;         DS_EnterCritical (wkmp, error);         IF error <> 0 THEN         BEGIN   
      fatal_error := TRUE; 
       GOTO 99;        END;      !   {---------------------- PREPARE SESSION ----------------------} !        { Set up the session for the server }     WITH msg_buffer.msg.rinit_msg DO         BEGIN   !      { Either the Rinit message contains a session key for the }  ! !      { server to attach to or it contains a logon string. Pull }  ! !      { out the correct field.                                  }  !       IF session_id_ptr <> share_session_id_ptr THEN           BEGIN  "         { A session key is present so use it. Note that we do not } " "         { place this key into the son's user record since he is   } " "         { not responsible for logging it off. The creator of the  } " "         { session is responsible for this.                        } "          FOR index := 0 TO (SESSION_KEY_BYTES - 1) DO   	            BEGIN  	             session_key.bytes [index +1] :=                  msg_buffer.bytes [session_id_ptr + index];               END;  { FOR index }            END  { IF session_id_ptr }         ELSE           BEGIN           { A logon string was given so use it to logon }  &         PerformLogon (msg_buffer, wkmp, vc_socket_descr, consumer_desired,  &                        sons_name, session_key, nft_error);           IF nft_error <> 0 THEN   $            { If we receive an error in perform_logon, we will not be }  $ $            { critical upon return, so just bail out.                 }  $ 
            GOTO 99; 
          END; { ELSE of IF session_id_ptr }         END;  { WITH msg_buffer }       !   {--------------------- ATTACH TO SESSION ---------------------} ! !   { We will only attempt to attach to a session if the session  } ! !   { key is non-zero. If the key returned by Ds_Rsm_Logon is     } ! !   { zero (but no error was reported), then we are running in    } ! !   { a single user system so attach doesn't make sense.          } !    IF (session_key.words [1] <> 0) OR         (session_key.words [2] <> 0) OR         (session_key.words [3] <> 0) THEN         BEGIN { attempt attach }        error := Ds_Rsm_Attach (wkmp, session_key);             IF error <> 0 THEN           BEGIN { Can't attach }   #         { IF we created the session, attempt to log it off. We will } # #         { ignore any errors here since we already have an error.    } #          WITH msg_buffer.msg.rinit_msg DO   
            BEGIN { with } 
             IF session_id_ptr = share_session_id_ptr THEN               dummy := Ds_Rsm_Logoff (wkmp, session_key);   
            END;  { with } 
          IF dummy <> MMDSAMCORRUPT THEN               DS_LeaveCritical (wkmp);                LogEvent (M_LOG_CANT_ATTACH, 1, EL_ERROR, error, 0, 0);                IF consumer_desired THEN   	            BEGIN  	             nft_error     := CANT_START_NFT_TARGET;               nft1000_error := CANT_SCHEDULE_CONSUMER;              END            ELSE   	            BEGIN  	             nft_error     := CANT_START_NFT_SOURCE;               nft1000_error := CANT_SCHEDULE_PRODUCER;              END;  { ELSE of IF consumer_desired }       #         { Consume the Rinit message so the socket it is hanging on }  # #         { does not select as readable again in the main routine    }  #          data_length := MAX_BUFFER_BYTES;            ipc_flags := 0;  #         IpcRecv (vc_socket_descr, msg_buffer, data_length, ipc_flags, #                   ipc_options, ipc_error);      $         { Send a Ainit message indicating that we cannot initiate NFT } $ $         { service. Also, may want to log an error here later.         } $          SendAinitMsg (vc_socket_descr, msg_buffer, nft_error,                         nft1000_error, 0);   	         GOTO 99;  	          END;  { Can't attach }         END;  { Attempt attach }          !   {----------------------- CLONE SERVER ------------------------} ! !   { Clone a copy of the requested server. Note that we have to  } ! !   { do this before creating a user record since we need the id  } ! !   { segment address of the server first to create the user rec. } !        error := DS_Rsm_Clone (wkmp, server_name, son_id_address);      sons_name := Str (server_name, 1, PROG_NAME_LENGTH);       "   { If an error occurred in cloning the server then send a Ainit }  " "   { message to the service requestor giving the error.           }  "    IF error <> 0 THEN         BEGIN { IF error on clone }   #      { IF we created the session, clean it up. We will also leave  }  # #      { critical if we can. We will not, however report any erros   }  # #      { encountered while logging off the session since we already  }  # #      { have an error to report to the user.  One way or another,   }  # #      { at the end of the next section, we will not be critical.    }  #       IF error <> MMDSAMCORRUPT THEN           BEGIN { error but not with DSAM }           WITH msg_buffer.msg.rinit_msg DO   
            BEGIN { with } 
             IF session_id_ptr = share_session_id_ptr THEN                  dummy := Ds_Rsm_Logoff (wkmp, session_key);  
            END;  { with } 
          IF dummy <> MMDSAMCORRUPT THEN               DS_LeaveCritical (wkmp);           END;  { error but not with DSAM }            IF consumer_desired THEN           BEGIN  #         LogEvent (M_LOG_CANT_CLONE_CONSM, 1, EL_ERROR, error, 0, 0);  #          nft_error     := CANT_START_NFT_TARGET;           nft1000_error := CANT_SCHEDULE_CONSUMER;   
         END  { IF } 
       ELSE           BEGIN  #         LogEvent (M_LOG_CANT_CLONE_PRODC, 1, EL_ERROR, error, 0, 0);  #          nft_error     := CANT_START_NFT_SOURCE;           nft1000_error := CANT_SCHEDULE_PRODUCER;            END;  { ELSE }       !      { Consume the Rinit message so the socket it is hanging on } ! !      { does not select as readable again in the main routine    } !       data_length := MAX_BUFFER_BYTES;        ipc_flags := 0;         IpcRecv (vc_socket_descr, msg_buffer, data_length,                 ipc_flags, ipc_options, ipc_error);            { Send an Ainit message reply }         SendAinitMsg (vc_socket_descr, msg_buffer, nft_error,                       nft1000_error, 0);        GOTO 99;        END;  { IF error on clone }       !   { First, retrieve our user record. It must already exist so  }  ! !   { disregard errors which should only occur when creating one }  !    FindUserRecord (MyIdAdd, my_urec_id, my_urec, error);      !   { Create a user record for the son program. We just RPed the }  ! !   { son program so there must not be a user record existing for}  ! !   { a program at that id segment address. FindUserRecord will  }  ! !   { not find the user record so he will create one.            }  ! !   FindUserRecord (son_id_address, son_urec_id, son_urec, error);  !     
   IF error = 0 THEN 
       BEGIN   $      { If we created a session for the server, then put the          }  $ $      { session key into it since the server will then be responsible }  $ $      { for cleaning up the session.                                  }  $       IF msg_buffer.msg.rinit_msg.session_id_ptr =             msg_buffer.msg.rinit_msg.share_session_id_ptr THEN            BEGIN { we did logon }            son_urec.ur_sessionkey [1] := session_key.words [1];            son_urec.ur_sessionkey [2] := session_key.words [2];            son_urec.ur_sessionkey [3] := session_key.words [3];            END;  { we did logon }       "      { Link the user records to each other. If server program is }  " "      { OFfed or aborts then appropriate action can be taken by   }  " "      { UPLIN to cleanup after the server. If we are OFfed or     }  " "      { abort the server's resources can be released by UPLIN.    }  "       my_urec.ur_ptrs.ur_sonurecptr     := son_urec_id;         son_urec.ur_ptrs.ur_parenturecptr := my_urec_id;            DS_StoreUrec (my_urec_id, my_urec.int);         DS_StoreUrec (son_urec_id, son_urec.int);         END      ELSE         BEGIN          { An error occurred in creating or initializing the user }          { record for the son. Release the son's id segment.      }         CleanupServerResources (sons_name);             DS_LeaveCritical (wkmp);            LogEvent (M_LOG_UREC_ERROR, 1, EL_ERROR, error, 0, 0);            { The error was probably due to lack of resources }         IF consumer_desired THEN           nft_error := INSUFF_RESOURCES_TARGET         ELSE           nft_error := INSUFF_RESOURCES_SOURCE;      !      { Consume the Rinit message so the socket it is hanging on } ! !      { does not select as readable again in the main routine    } !       data_length := MAX_BUFFER_BYTES;        ipc_flags := 0;         IpcRecv (vc_socket_descr, msg_buffer, data_length,                 ipc_flags, ipc_options, ipc_error);      "      { Send an Ainit message reply to the service requestor. May }  " "      { want to map the error from FindUserRecord into a string   }  " "      { later. It is a documented Ipc error.                      }  " !      SendAinitMsg (vc_socket_descr, msg_buffer, nft_error, 0, 0); !       GOTO 99;        END;  { ELSE of IF error }          !   {-------------------- PASS OFF CONNECTION --------------------} !     "   { Move the socket descriptor the message arrived on from our    } " "   { user record to the user record of the son. This is faster,    } " "   { safer, and easier than IpcGive/IpcGet. Recall that the socket } " "   { still has the Rinit message queued on it. The vc_socket_descr } " "   { returned here is for the son_urec.                            } " "   MoveUrecSocket (vc_socket_descr, my_urec, son_urec, son_urec_id); "        { Post both of the user records }     DS_StoreUrec (my_urec_id, my_urec.int);     DS_StoreUrec (son_urec_id, son_urec.int);      !   {---------------------- SCHEDULE SERVER ----------------------} !           BEGIN  { schedule server }        FOR index := 1 TO PROG_NAME_LENGTH DO            pac_name [index] := sons_name [index];       $      { Schedule the server and pass him the session key to attach to }  $       ExecSchedule (IMMEDIATE_NO_WAIT + NO_ABORT, pac_name,                       session_key.words [1],                      session_key.words [2],                      session_key.words [3], 0, 0);                { This is the error return for the schedule call }            BEGIN { error on schedule }  #         { Retract the socket from the son program, release his user } # #         { record and send a Ainit message giving the error.         } # %         MoveUrecSocket (vc_socket_descr, son_urec, my_urec, my_urec_id);  %     %         { Remove the pointers between our user record and the server's }  %          my_urec.ur_ptrs.ur_sonurecptr     := NULL;            son_urec.ur_ptrs.ur_parenturecptr := NULL;                { Write out both of the user records }            DS_StoreUrec (my_urec_id, my_urec.int);           DS_StoreUrec (son_urec_id, son_urec.int);               { Free up the son's user record and all resources }           CleanupServerResources (sons_name);               DS_LeaveCritical (wkmp);                IF consumer_desired THEN   	            BEGIN  	             nft_error     := CANT_START_NFT_TARGET;               nft1000_error := CANT_SCHEDULE_CONSUMER;              END            ELSE   	            BEGIN  	             nft_error     := CANT_START_NFT_SOURCE;               nft1000_error := CANT_SCHEDULE_PRODUCER;              END;  { ELSE of IF consumer_desired }       #         { Consume the Rinit message so the socket it is hanging on }  # #         { does not select as readable again in the main routine    }  #          data_length := MAX_BUFFER_BYTES;            ipc_flags := 0;  #         IpcRecv (vc_socket_descr, msg_buffer, data_length, ipc_flags, #                   ipc_options, ipc_error);      $         { Send a Ainit message indicating that we cannot initiate NFT } $ $         { service. Also, may want to log an error here later.         } $          SendAinitMsg (vc_socket_descr, msg_buffer, nft_error,                         nft1000_error, 0);   	         GOTO 99;  	          END;  { Error Return }             END;  { schedule server }   "   { Remove the pointers between our user record and the server's. } " "   { The son is now on his own. He will consume the Rinit message  } " "   { hanging on the socket and send an Ainit reply.                } "    my_urec.ur_ptrs.ur_sonurecptr     := NULL;      son_urec.ur_ptrs.ur_parenturecptr := NULL;          DS_StoreUrec (my_urec_id, my_urec.int);     DS_StoreUrec (son_urec_id, son_urec.int);         DS_LeaveCritical (wkmp);       99:   !   {------------------ DETACH FROM SESSION ---------------------}  ! !   { No matter whether we encountered errors or not we want to  }  ! !   { detach back into the system session. If we could not start }  ! !   { the server then we will be the last one in the session. In }  ! !   { this case, the system will clean up the session after us.  }  ! !   { If we are running on a single user system this call will   }  ! !   { have no effect.                                            }  ! 	   Ds_Rsm_Detach;  	     END;  { NftVcSocketHandler }      $Page   #{-------------------------------------------------------------------}  # #{ NFT                      PERFORM LOGON                        NFT }  # #{-------------------------------------------------------------------}  # !{ There is an RINIT message sitting in the msg_buffer. It in turn  ! "{ contains a logon string that should be used to logon so extract it " { and perform the logon.  {   !{ This procedure must be called while critical. If an error occurs ! "{ in logging on then all of the son's resources will be released, an " { Ainit message will be sent and we will return non-critical.   {   { Parameters:   {   {     msg_buffer (Input)  !{        Carries in the Rinit message in its entirety. Contains a  ! {        logon string and maybe a logon password string.  {   
{     wkmp (Input/Output)  
 "{        The current working map. If nft_error is returned non-zero  " {        then we will return non-critical and this is invalid.  {   {     vc_socket_descr (Input/Output)  {        The vc socket on which the service request arrived.  {   {     consumer (Input)  {        True if we are logging on for a consumer server, else  {        this is false and we are logging on for a producer   {   {     sons_name (Input)   {        The name of the server clone   {   
{     session_key (Output) 
 {        The session key returned from DS_Rsm_Logon.  {   {     nft_error (Output)  !{        Returns zero if successful, else non-zero and no further  ! {        error handling is needed by the caller   {}  PROCEDURE  PerformLogon      (VAR msg_buffer      : MsgBufferType;      VAR wkmp            : Int16;      VAR vc_socket_descr : Int32;      VAR consumer        : BOOLEAN;      VAR sons_name       : String;       VAR session_key     : DSSessionKeyType;       VAR nft_error       : Int16);       LABEL      99;      VAR      data_length          : Int16;     error                : Int16;     index                : Int16;     ipc_error            : Int32;     ipc_flags            : Int32;     ipc_options          : IpcOptionsType;      logon_error          : Int16;     logon_length         : Int16;     logon_string         : LogonPacType;      cant_enter_critical  : BOOLEAN;     nft1000_error        : Int16;      BEGIN   	   nft_error := 0; 	    cant_enter_critical := FALSE;         WITH msg_buffer.msg.rinit_msg DO         BEGIN   "      { Extract the logon string from the Rinit message. The logon } " "      { password will be appended to it. Currently there is no way } " "      { we can receive separate logon and logon password strings   } " "      { since no NFT initiator ever pulls them apart.              } "       logon_length := logon_id_pass_ptr - logon_id_ptr;         IF logon_length = 0 THEN           BEGIN  "         { The logon string may be null for two reasons:           } " "         {   1) We are running MultiUser and the user forgot or    } " "         {      did not know the logon.                            } " "         {   2) We are not running MultiUser, the user was aware   } " "         {      of that and did not specify a logon.               } " "         { For both cases we will try to logon anyway. For case 2  } " "         { we will get an error from Ds_Rsm_Logon indicating that  } " "         { MultiUser is not installed and we will continue without } " "         { returning an error. For case 1 we will return the error } " "         { DsRsm gives us (probably NO_SUCH_ACCOUNT). Note that we } " "         { are making the logon string a space here instead of a   } " "         { null string. FORTRAN routines (e.g., DsRsmLogon) will   } " "         { blow up if we try to pass them a null string.           } "          logon_string := SPACE;            END        ELSE           BEGIN           { There is a logon string present so extract it }           IF logon_length > MAX_NFT_LOGON_CHARS THEN               logon_length := MAX_NFT_LOGON_CHARS;           logon_string := SPACE;            FOR index := 1 TO logon_length DO  	            BEGIN  	             logon_string [index] :=                  msg_buffer.chars [logon_id_ptr + index -1];              END; { FOR index }           END;  { ELSE of IF logon_length }        END;  { WITH msg_buffer }       #   { Do the logon. We will get a returned session key if successful. } # #   { NOTE: In the call to DS_Rsm_Logon we must leave the critical    } # #   { state temporarily. Because of this the state of the world may   } # #   { have changed after we return.                                   } # !   logon_error := DS_Rsm_Logon (wkmp, logon_string, session_key);  !        { If we could not re-enter critical then bailout }      IF logon_error = MMDSAMCORRUPT THEN        BEGIN         cant_enter_critical := TRUE;        GOTO 99;  	      END;  { IF } 	     #      { If MultiUser is not installed, we will want to continue. The } # #      { returned session key is undefined so clear it. We will note  } # #      { that the key is zero later and not attempt to attach to any  } # #      { session before cloning the server.                           } #       IF logon_error = DS_RSM_NOT_MULTIUSER THEN           BEGIN  
         logon_error := 0; 
          { Clear the session key since is meaningless }            session_key.words [1] := 0;           session_key.words [2] := 0;           session_key.words [3] := 0;           END;  { IF logon_error }       99:      IF (logon_error <> 0) OR (nft_error <> 0) THEN         BEGIN   "      { We are not currently critical if cant_enter_critical so do } " "      { not attempt to leave critical.                             } "       IF NOT cant_enter_critical THEN            DS_LeaveCritical (wkmp);       #      { If a logon error occurred then log the error and choose the }  # #      { proper error codes for the Ainit message.                   }  #       IF logon_error <> 0 THEN           BEGIN  $         LogEvent (M_LOG_LOGON_ERROR, 1, EL_WARNING, logon_error, 0, 0); $ #         { DS_Rsm_Logon could return Memory Manager errors. If this }  # #         { appears to be the case then clear it. We will not return }  # #         { these errors to the user, although we will log them.     }  #          IF logon_error < DS_RSM_ERROR_BASE THEN              logon_error := 0;            IF consumer_desired THEN               nft_error := CANT_LOGON_TARGET_NODE            ELSE               nft_error := CANT_LOGON_SOURCE_NODE;           nft1000_error := 0;           END;  { IF logon_error }       !      { Consume the Rinit message so the socket it is hanging on } ! !      { does not select as readable again in the main routine    } !       data_length := MAX_BUFFER_BYTES;        ipc_flags   := 0;         InitOpt (ipc_options, 0, error);  "      IpcRecv (vc_socket_descr, msg_buffer, data_length, ipc_flags,  "                ipc_options, ipc_error);       "      { Return the proper error code in an Ainit message. The NFT }  " "      { service requestor will then shut down the connection. May }  " "      { want to include a local error string here later.          }  "       SendAinitMsg (vc_socket_descr, msg_buffer, nft_error,                       nft1000_error, logon_error);  
      END; { ELSE }  
     END;  { PerformLogon }          $Page   #{-------------------------------------------------------------------}  # #{ NFT                      SEND AINIT MSG                       NFT }  # #{-------------------------------------------------------------------}  # #{ Send an Ainit message in response to the Rinit message we received.  # "{ This message will contain the result of the attempt to initialize  "  { the server. If an error occurs in sending the message then the   { connection will be closed.  {   { Parameters:   {   {     vc_socket_descr (Input)   {        The socket on which the Ainit message is to be sent  {   
{     msg_buffer (Neither) 
 {        The Ainit message is built here  {   {     nft_error (Input)   {        The Nft error code to be placed in the Ainit message   {   {     nft1000_error (Input)   {        An Nft/1000 error code number. If non-zero should be   !{        converted to a string and inserted in the Ainit message.  ! "{        Nft1000_error and ds_rsm_error should not both be non-zero  " {   
{     ds_rsm_error (Input) 
 !{        A DsRsm error code. If non-zero then should be converted  ! !{        to a string and inserted in the message. Ds_rsm_error and ! {        local_error should not both be non-zero.   {}  PROCEDURE  SendAinitMsg      (VAR vc_socket_descr : Int32;      VAR msg_buffer      : MsgBufferType;          nft_error       : Int16;          nft1000_error   : Int16;          ds_rsm_error    : Int16);       VAR   
   error          : Int16; 
    error_pac      : ErrorPacType;      error_string   : ErrorStringType;  
   ipc_error      : Int32; 
 
   ipc_flags      : Int32; 
    ipc_options    : IpcOptionsType;   
   loop           : Int16; 
     BEGIN      { First build the message }     WITH msg_buffer, msg, message_type, ainit_msg DO         BEGIN         protocol_id             := NFT;         msg_type                := AINIT;             debug_flags.whole_byte  := 0;         misc_flags.whole_byte   := 0;         system_type             := RTE;         op_sys_version          := 0;       #      { The buffer size we are returning here may not be the actual }  # #      { buffer size we opened the connection with, but that's ok.   }  # #      { We are returning an error in the Ainit message and therefore}  # #      { the service requestor must close the connection.            }  #       buffer_size := MAX_BUFFER_BYTES;            capability_mask.whole_word   := 0;        capability_mask.hierarchical := TRUE;             sys_specif_capa_mask    := 0;         nft_error_code          := nft_error;             local_error_msg_ptr     := MIN_AINIT_BYTES;              { Insert the local error message string if either the   }           { nft1000_error or ds_rsm_error are non-zero. Otherwise }           { null out the string                                   }          IF (nft1000_error = 0) AND (ds_rsm_error = 0) THEN           BEGIN           error_code_enhan_ptr := local_error_msg_ptr;            END        ELSE           BEGIN           error_pac := ' ';    { Blank fill error_pac }           IF ds_rsm_error <> 0 THEN  !            AdsErrorLookup (RSM_SERVICE, ds_rsm_error, error_pac)  !          ELSE   "            AdsErrorLookup (NFT_SERVICE, nft1000_error, error_pac);  "              SetStrLen (error_string, StrMax (error_string));            FOR loop := 1 TO MAX_ERROR_STRING_BYTES DO               error_string [loop] := error_pac [loop];           error_string := StrRtrim (error_string);                { Insert the local error string in the message }            FOR loop := 0 TO StrLen (error_string) -1 DO   	            BEGIN  	             msg_buffer.chars [local_error_msg_ptr + loop] :=                 error_string [loop + 1];   
            END;  { FOR }  
              error_code_enhan_ptr := local_error_msg_ptr +                                   StrLen (error_string);            END;  { ELSE of IF (nft1000_error }            end_ptr          := error_code_enhan_ptr;         msg_length_bytes := end_ptr;  
      END;  { WITH } 
        InitOpt (ipc_options, 0, error);          { Send the Ainit message on its way }  	   ipc_flags := 0; 	    IpcSend (vc_socket_descr, msg_buffer, msg_buffer.msg.  !            msg_length_bytes, ipc_flags, ipc_options, ipc_error);  !     "   { If any send error then assume that it is fatal. Shutdown the }  " "   { socket. Ipc will remove the socket from our user record and  }  " "   { therefore we will not find it when we extract sockets in the }  " "   { main routine                                                 }  " 
   IF ipc_error <> 0 THEN  
       BEGIN          LogEvent (M_LOG_SEND_ERROR, 1, EL_ERROR, ipc_error, 0, 0);         ipc_flags := 0;         IpcShutDown (vc_socket_descr, ipc_flags, ipc_options,                      ipc_error);        END;  { IF ipc_error }      END;  { SendAinitMsg }      
END;  { MODULE NFT } 
     $Page   #{-------------------------------------------------------------------}  # #{                           MAIN IMPORT                             }  # #{-------------------------------------------------------------------}  #     IMPORT         GLOBALS,    { The globals module in this compilation unit }     NFT,        { The NFT module in this compilation unit }         $SEARCH 'phtm/BODEC.REL'$   BODEC,      $SEARCH 'phtm/SODEC.REL'$   SODEC,      $SEARCH 'phtm/MMDEC.REL'$   MMDEC,      $SEARCH 'phtm/MMEXT.REL'$   DS_MM,      $SEARCH 'phtm/SIGMOD.REL'$  SIGMOD,     $SEARCH 'phtm/ENVOK.XPT'$   ENVOK,      $SEARCH 'phtm/TRCMOD.REL'$  TRCMOD;      $Page   #{-------------------------------------------------------------------}  # #{                           MAIN CONSTS                             }  # #{-------------------------------------------------------------------}  #     CONST          $INCLUDE 'src/NFTCONSTS.PASI'         NFT_MONITOR_NAME = 'NFTMN ';       $Page   #{-------------------------------------------------------------------}  # #{                            MAIN TYPES                             }  # #{-------------------------------------------------------------------}  #     TYPE  #   CatchErrorType = (RUN_TIME_ERROR, EMA_ERROR, I_O_ERROR, FILE_ERROR, #                      SEGMENTATION_ERROR, WARNING_ERROR);         LogicalFileNameType = PACKED ARRAY [1..150] OF CHAR;       "   { Used to pickup the runstring parms.                          }  "    NumericParamsType = ARRAY [1..5] OF Int16;          SocketBitMapType = RECORD        CASE BOOLEAN OF            TRUE:  (bits : PACKED ARRAY [1..32] OF BOOLEAN);            FALSE: (words : ARRAY [1..2] OF Int16);     END;          SocketListType = ARRAY [1..MAX_SOCKETS_PER_USER] OF Int32;       $Page   #{-------------------------------------------------------------------}  # #{                           MAIN VARIABLES                          }  # #{-------------------------------------------------------------------}  #     VAR      error                : Int16;          { This is used in the main. True if a fatal error occurred }       fatal_error          : BOOLEAN;         index                : Int16;         ipc_error            : Int32;         ipc_flags            : Int32;         ipc_options          : IpcOptionsType;          { Gives the last valid socket descriptor in the bit map }     last_socket          : Int32;         nft_call_socket      : Int32;         { Gives the number of sockets in our user record }      number_sockets       : Int16;         { These are used in the IpcSelect calls }     except_map           : SocketBitMapType;      read_map             : SocketBitMapType;      write_map            : SocketBitMapType;          params               : NumericParamsType;         { List of sockets we own }      socket_list          : SocketListType;          { This is only used with the Trigger calls }      trigger_temp         : Int16;      
   { Current working map } 
    wkmp                 : Int16;          $Page   #{-------------------------------------------------------------------}  # #{                   EXTERNAL & FORWARD ROUTINES                     }  # #{-------------------------------------------------------------------}  #     PROCEDURE AddOpt     (VAR opts            : IpcOptionsType;           entry_number    : Int16;          arg_code        : Int16;          data_length     : Int16;          data            : Int16;      VAR error           : Int16);      EXTERNAL;      PROCEDURE CleanupAndTerminate;     FORWARD;       PROCEDURE Ds_Rsm_Detach;     EXTERNAL;      PROCEDURE GetNumericParams  $ALIAS 'Pas.NumericParms'$     (VAR params          : NumericParamsType);      EXTERNAL;      	PROCEDURE InitOpt  	    (VAR opts            : IpcOptionsType;           total_entries   : Int16;      VAR error           : Int16);      EXTERNAL;      
PROCEDURE IpcCreate  
    (    socket_kind     : Int32;          protocol        : Int32;      VAR flags           : Int32;      VAR options         : IpcOptionsType;       VAR vc_socket_descr : Int32;      VAR ipc_error       : Int32);      EXTERNAL;      
PROCEDURE IpcSelect  
    (VAR last_socket     : Int32;      VAR read_map        : SocketBitMapType;       VAR write_map       : SocketBitMapType;       VAR except_map      : SocketBitMapType;           time_out        : Int32;      VAR ipc_error       : Int32);      EXTERNAL;      PROCEDURE IpcShutDown      (VAR socket_descr    : Int32;      VAR ipc_flags       : Int32;      VAR ipc_options     : IpcOptionsType;       VAR ipc_error       : Int32);      EXTERNAL;      FUNCTION MyIdAdd     : Int16;      EXTERNAL;          $Page   $Range Off  #{-------------------------------------------------------------------}  # #{                          CATCH ERROR                              }  # #{-------------------------------------------------------------------}  # "{ This is the Pascal error catcher procedure. If we are called then  " { just log an error and bailout.  {}  PROCEDURE  CatchError  $ALIAS 'PAS.ErrorCatcher'$      (error_type    : CatchErrorType;   
    error_number  : Int16; 
 
    line_number   : Int16; 
     file_name     : LogicalFileNameType;      file_name_len : Int16);       BEGIN   !   LogEvent (M_LOG_INTERNAL_ERROR, 1, EL_ERROR, Ord (error_type),  !              error_number, line_number);         CleanupAndTerminate;       
END;  { CatchError } 
         $Page   #{-------------------------------------------------------------------}  # #{                        CLEANUP AND TERMINATE                      }  # #{-------------------------------------------------------------------}  # !{ A fatal error has occurred. Release resources and terminate the  ! { program.  {}  PROCEDURE  CleanupAndTerminate;       BEGIN      {}      { NOTE: If and when the functionality is added to UPLIN to      {       reschedule programs, the "ur_reschedule" bit should     {       be cleared in our user record here so that we will      {       not be rescheduled.     {}          GOTO 999;      END;  { CleanupAndTerminate }           $Page   #{-------------------------------------------------------------------}  # #{                         CREATE CALL SOCKET                        }  # #{-------------------------------------------------------------------}  # { Create the NFT call socket. Return its descriptor.  {   { Parameters:   {   {     nft_call_socket (Output)  {        The call socket descriptor of the NFT call socket  {}  PROCEDURE  CreateCallSocket      (VAR nft_call_socket    : Int32);      VAR      error       : Int16;      ipc_error   : Int32;      ipc_flags   : Int32;      ipc_options : IpcOptionsType;      BEGIN   	   ipc_flags := 0; 	     "   { For NFT's call socket, bind it to it's well known address so }  " "   { the service requestors can send connect requests without     }  " "   { performing a directory lookup (IpcLookup) first. Also, tell  }  " "   { Ipc how many connection requests we want queued at any given }  " "   { time.                                                        }  "    InitOpt (ipc_options, 2, error);      AddOpt (ipc_options, 0, IPC_TCP_PORT, 2, CA_HP_NFT, error);  !   AddOpt (ipc_options, 1, IPC_MAX_CON_REQS_QUEUED, 2, 5, error);  !    IpcCreate (IPC_CALL_SOCKET, 0, ipc_flags, ipc_options,                 nft_call_socket, ipc_error);      
   IF ipc_error <> 0 THEN  
       BEGIN         { Some unexpected error occurred so bailout }   #      LogEvent (M_LOG_INITIALIZE_ERROR, 1, EL_ERROR, ipc_error, 0, 0); # 
      CleanupAndTerminate; 
       END;  { IF ipc_error }      
END;  { CreateCallSocket } 
         $Page   #{-------------------------------------------------------------------}  # #{                       GET UREC SOCKET LIST                        }  # #{-------------------------------------------------------------------}  # "{ Return a list of the socket descriptors from our user record, not  " #{ including the root socket. This routine is not smart enough to know  # "{ which descriptors in our user record are for sockets and which are " !{ for path reports, but it does not have to be. At no time should  ! { there be path report descriptors in our user record.  {   { Parameters:   {   {   socket_list (Output)   {      A list from 1 to number_sockets of socket descriptors for   {      sockets we own.  {   {   number_sockets (Output)   {      The number of valid entries in socket_list   {   {   fatal_error (Output)  {      If true this indicates we encountered a fatal error  {}  PROCEDURE  GetUrecSocketList     (VAR socket_list     : SocketListType;       VAR number_sockets  : Int16;      VAR fatal_error     : BOOLEAN);       LABEL      99;      VAR      error       : Int16;      my_urec     : UserRecord;     my_urec_id  : Int16;      smap_index  : Int16;      wkmp        : Int16;       BEGIN      { Go extract our user record }      DS_EnterCritical (wkmp, error);     fatal_error := error <> 0;      IF fatal_error THEN        GOTO 99;     FindUserRecord (MyIdAdd, my_urec_id, my_urec, error);     DS_LeaveCritical (wkmp);          number_sockets := 1;          FOR smap_index := 1 TO MAX_SOCKETS_PER_USER DO         BEGIN          { If the "global" socket descriptor is positive then it }           { represents a valid socket descriptor                  }          IF my_urec.ur_smap [smap_index] > 0 THEN           BEGIN           socket_list [number_sockets] := smap_index;           number_sockets := number_sockets + 1;           END;  { IF }   
      END;  { FOR }  
        number_sockets := number_sockets - 1;      99:   END;  { GetUrecSocketList }           $Page   #{-------------------------------------------------------------------}  # #{                           MAIN PROGRAM                            }  # #{-------------------------------------------------------------------}  #     BEGIN   #   { Wait for NS to initialize completely. If something goes wrong, }  # #   { this routine could terminate us.                               }  #    DS_EnvOk (NFT_MONITOR_NAME);       "   { Pick up the scheduling parameters. The first parameter is the } " "   { only one we care about. If it is DEBUG_MODE then we will not  } " "   { detach from the session we were scheduled in and we will not  } " "   { schedule NFT server programs. This will make it easier to     } " "   { debug the monitor and/or the server programs.                 } "    GetNumericParams (params);          { Get into the system session }  
      DS_Rsm_Detach; 
     "   { If the functionality is added to UPLIN to reschedule NFTMN if } " "   { it is aborted, then a check should be made here as to whether } " "   { the call socket already exists (call GetUrecSocketList). If   } " "   { the call socket does exist (number_sockets > 0) then the call } " "   { here to create the call socket should not be made.            } "    CreateCallSocket (nft_call_socket);         REPEAT         { Extract the list of sockets from our user record }  "      GetUrecSocketList (socket_list, number_sockets, fatal_error);  " 
      IF fatal_error THEN  
          CleanupAndTerminate;             { Clear all of the bit maps for the IpcSelect call }        FOR index := 1 TO 2 DO           BEGIN           except_map.words [index] := 0;            read_map.words   [index] := 0;   !         write_map.words  [index] := 0;  { Write map is not used } !          END;  { FOR }      "      { Set bits in the read map for existing vc sockets. We know }  " "      { that the last call socket in socket_list is at index      }  " "      { nft_call_socket. The rest of the sockets are vc sockets   }  " "      { that belong to NFT.                                       }  "       FOR index := nft_call_socket + 1 TO number_sockets DO            read_map.bits [socket_list [index]] := TRUE;       #      { Set bits in the exception map for vc and call sockets. Also }  # #      { determine which of the sockets is the last one that we want }  # #      { to select on so we can tell Ipc.                            }  #       last_socket := MININT;        FOR index := 1 TO number_sockets DO            BEGIN           except_map.bits [socket_list [index]] := TRUE;            IF socket_list [index] > last_socket THEN              last_socket := socket_list [index];            END;  { FOR }      #      { Block selecting on all sockets until something happens. Note } # #      { that when NS is being shutdown, IPC will return the error    } # #      { U_NETWORK_GOING_DOWN.                                        } #       IpcSelect (last_socket, read_map, write_map, except_map,                   IPC_INFINITE_TIME_OUT, ipc_error);                 { Bailout on any Ipc error }        IF ipc_error <> 0 THEN           BEGIN  #         LogEvent (M_LOG_SELECT_ERROR, 1, EL_ERROR, ipc_error, 0, 0);  #          CleanupAndTerminate;            END;  { IF ipc_error }              { If any vc socket exception selected then shut it down }          ipc_flags := 0;         InitOpt (ipc_options, 0, error);        FOR index := nft_call_socket +1 TO number_sockets DO           BEGIN           IF except_map.bits [socket_list [index]] THEN              IpcShutDown (socket_list [index], ipc_flags,                           ipc_options, ipc_error);            END;  { FOR index }      #      { Look at the vc sockets first. We would like to pass off vc  }  # #      { sockets to their servers as soon as possible since there is }  # #      { a limit on the total number of sockets anyone can own. We   }  # #      { are starting from the index following the NFT call socket   }  # #      { since that is where the vc socket descriptors begin.        }  #       FOR index := nft_call_socket +1 TO number_sockets DO           BEGIN           IF read_map.bits [socket_list [index]] THEN  	            BEGIN  	              NftVcSocketHandler (socket_list [index], params [1],                                   fatal_error);               IF fatal_error THEN                  CleanupAndTerminate;               END;  { IF }           END;  { FOR index }            IF except_map.bits [socket_list [nft_call_socket]] THEN            BEGIN  #         NftCallHandler (socket_list [nft_call_socket], fatal_error);  #          IF fatal_error THEN              CleanupAndTerminate;  
         END; { IF } 
        UNTIL FALSE;       999:  END.  { NFTMN }  