 $PASCAL '91790-1X136 REV.4010 <860321.1737> '   $STANDARD_LEVEL 'HP1000'  $debug$   $WIDTH 90   $HEAPPARMS OFF  
$RECURSIVE OFF, RANGE OFF$ 
 $HEAP 0   	$HEAP_DISPOSE OFF  	     MODULE nodinit;   	$ALIAS 'N$nodinit' 	     {------------------------------------------------------------    (c) COPYRIGHT HEWLETT PACKARD COMPANY 1986. ALL RIGHTS    RESERVED. NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED,   REPRODUCED OR TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT    THE PRIOR WRITTEN CONSENT OF THE HEWLETT-PACKARD COMPANY.   ------------------------------------------------------------}  {}  {     NAME:   NODINIT   
{     SOURCE: 91790-18136  
 	{     RELOC:  NONE 	 	{     PGMR:   EMS  	 {}      {}  {------------------------------------------------------------   { MODIFICATIONS:  {   {  Date   PCO  Prgmr Description  {  860210      lms   Correct socket count calculation (n314).   "{  860225      lms   correct error handling at init/shutdown (n356). " {  Last edit: <860321.1737>   {   {------------------------------------------------------------   {}      {}  {   {  This module contains the nodal resource portion of NSINIT.   {   {}      IMPORT  $SEARCH 'phtm/bodec.rel'     bodec,   $SEARCH 'phtm/mmdec.rel'     mmdec,   $SEARCH 'phtm/mmext.rel'     ds_mm,   $SEARCH 'phtm/SODEC.rel'     sodec,   
$SEARCH 'phtm/TRCMOD.rel'$ 
    trcmod,  
$SEARCH 'phtm/sigmod.rel'$ 
    sigmod,  $SEARCH 'phtm/LKLB.rel'$     lk,  
$SEARCH 'phtm/tmrdec.rel'$ 
    tmrdec,  
$SEARCH 'phtm/TCPGB.rel'$  
    tg,  
$SEARCH 'phtm/tuser.rel'$  
    tuser,   
$SEARCH 'phtm/Tcplb.rel'$  
    tl,  
$SEARCH 'phtm/PXPLB.rel'$  
    px,  $SEARCH 'phtm/init_dec.rel'      init_dec,  $SEARCH 'phtm/initmulti.xpt'     initmulti,   
$SEARCH 'phtm/parsdd.xpt'  
    parser,  
$SEARCH 'phtm/filemad.xpt' 
    fileman;       $SUBTITLE ' Export procedures ', PAGE$      EXPORT      {--------------------------------------------------------}  {                                                        }  {          EXPORT   PROCEDURES                           }  {                                                        }  {--------------------------------------------------------}          PROCEDURE SynNod     (VAR smbsize     : Int16;      VAR dsamtbsize  : Int16;      VAR socketcnt   : Int16;      VAR classcnt    : Int16;      VAR resourcnt   : Int16;      VAR result      : Int16);           	PROCEDURE ShutNod  	    (    trustvar    : TrustType;      VAR result      : Int16);           	PROCEDURE InitNod  	    (VAR result : Int16);      {----------------------------------------------------}  {               Implement Section                    }  {----------------------------------------------------}      IMPLEMENT       VAR      message:             PromptType;      numberuserrecs:      Int16;      !{----------------------------------------------------------------} ! !{   EXTERNAL ROUTINES                                            } ! !{----------------------------------------------------------------} !     PROCEDURE DS_StoreUrec     (    urecid : Int16;       VAR urec   : Int16);     EXTERNAL;      PROCEDURE Rnrq  $ NOABORT $   
(     icon  : INt16; 
 
  VAR irn   : Int16; 
   VAR istat : Int16  );      EXTERNAL;      $SUBTITLE 'SynNod',PAGE$   {-------------------------------------------------------------}     {                                                             }     {                       SynNod                                }     {                                                             }     {-------------------------------------------------------------}        PROCEDURE SynNod     (VAR smbsize     : Int16;      VAR dsamtbsize  : Int16;      VAR socketcnt   : Int16;      VAR classcnt    : Int16;      VAR resourcnt   : Int16;      VAR result      : Int16);           {}  !{ Description: Get user input to nod configuration items; perform  !  {   validity check on the inputs; returns DSAM Table size to the   {   caller.   {   { Parameters:   {   dsamtbsize (output)   {   socketcnt  (output)    not used by this segment.  {   classcnt   (output)    not used by this segment.  {   resourcnt  (output)    not used by this segment.  {   smbsize    (output)    not used by this segment.  {   result     (output)    Set to zero if successfull.  {}      LABEL      99;      CONST      NUMBERPROMPTS =   6;      PROGBANNER    =   4;      SOCKBANNER    =   5;          SOCKETMIN     =   9;      PROGMIN       =   1;       TYPE     BannerType = Array[1..NUMBERPROMPTS] OF IStringType;       CONST      BANNERS = BannerType[         IStringType[      '*++   NS Nodal Information   ++*'],      IStringType[      '*'],     IStringType[      '* Defaults are derived from previous responses.'],     IStringType[      '*     Maximum number of active NS programs is: '],     IStringType[      '*     Maximum number of active NS sockets is:  '],     IStringType[      '*']];       !   CDOMODQUEST = '* Do you want to modify these values [Y/(N)]?_'; !    CPROGQUEST =    '* Enter the maximum number of active NS programs [1..(';     CSOCKQUEST =     '* Enter the maximum number of active NS sockets [9..(';      VAR      answer:              OneCharType;     default:             Boolean;     dummy:               Int16;     index:               Int16;     internalprogcnt:     Int16;     internalsockcnt:     Int16;     internal_result:     Int16;     progcount:           Int16;     sockcount:           Int16;     terminator:          Boolean;      	PROCEDURE ExitSyn; 	    BEGIN    { ExitSyn }          { used so there is only one GOTO in this procedure }      GOTO 99;          END;     { ExitSyn }           	   BEGIN {synnod}  	        { Assume all variables cleared by NSINIT }          internal_result := GOOD;   	   sockcount := 0; 	 	   progcount := 0; 	        WITH initglobals DO        BEGIN    { WITH }          { get the counts from the user services, add nodal sfuff }       !         { count from services (NFT/EVMON) + 1 for: inpro, outpro, ! "                        uplin, and 10 for user programs           }  "       internalprogcnt := IG_tot_nodal_progs + 3 + 10;                 { count from services (NFT/EVMON) + 1 for: probe,                             ifpm, timer, tcp, pxp, ip, nodal reg +    !                         3 sockets * 10 user programs            } !       internalsockcnt := IG_tot_nodal_sockets + 7 + 30;       &      { Verify ranges are reasonable.  Make modifications if they are not }  & "      IF internalprogcnt < PROGMIN THEN internalprogcnt := PROGMIN;  " $      IF internalsockcnt < SOCKETMIN THEN internalsockcnt := SOCKETMIN;  $           IF internalprogcnt > 100 THEN internalprogcnt := 100;         IF internalsockcnt > 200 THEN internalsockcnt := 200;             END;     { WITH }          { print the banner stuff }      FOR index := 1 TO NUMBERPROMPTS DO         BEGIN    { print banner }         message := BANNERS[index];            IF index = PROGBANNER THEN  %         Strwrite( message, Strlen(message)+1, dummy, internalprogcnt:1 ); %       IF index = SOCKBANNER THEN  %         Strwrite( message, Strlen(message)+1, dummy, internalsockcnt:1 ); %           PrintPrompt( FALSE, message, internal_result );         IF internal_result <> GOOD THEN ExitSyn;        END;     { print banner }       
   default := TRUE;  
         YesNoInput( CDOMODQUEST, default, answer, internal_result );       IF internal_result <> GOOD THEN ExitSyn;          IF default THEN answer := 'N';          IF answer = 'Y' THEN         BEGIN    { get new values for numbers }       !      Strwrite( message, 1, dummy, CPROGQUEST, internalprogcnt:1,  ! "                                                      ')..100]:_' ); "       default := TRUE;  
      terminator := FALSE; 
     #      IntInput( message, default, terminator, 100, PROGMIN, progcount, #             internal_result );        IF internal_result <> GOOD THEN ExitSyn;            IF default THEN progcount := internalprogcnt;             default := TRUE;  !      Strwrite( message, 1, dummy, CSOCKQUEST, internalsockcnt:1,  ! #                                                       ')..200]: _' ); #       IntInput( message, default, terminator, 200, SOCKETMIN,   "                                       sockcount, internal_result ); "       IF internal_result <> GOOD THEN ExitSyn;            IF default THEN sockcount := internalsockcnt;             END      { get new values for numbers }        ELSE         BEGIN    { use default numbers }            progcount := internalprogcnt;         sockcount := internalsockcnt;         END;     { use default numbers }        numberuserrecs := progcount;      !      dsamtbsize := TL_LAST + ( HPDSN_DOMAIN * DOMAINREC_SIZE ) +  !             (( LAST_INDIVIDUAL_PID - FIRST_INDIVIDUAL_PID +1 ) *    !                                               PROTOCOLREC_SIZE ); ! 99:          result := internal_result;      WITH initglobals DO  
         BEGIN    { WITH } 
              IG_tot_nodal_progs := progcount;            IG_tot_nodal_sockets := sockcount;   
         END;     { WITH } 
     	   END;  {synnod}  	         $SUBTITLE 'nod Shutdown module', PAGE$  {-------------------------------------------}   {              Shutdnnod                    }   {-------------------------------------------}       	PROCEDURE ShutNod  	    (    trustvar    : TrustType;      VAR result      : Int16 );      {}  { Description: Module to be called by NSINIT.   {    This routine deallocates the resource numbers.   {   { Parameters:   {    trustvar   (input)  Indicates potential corruption of  {                        data structures.   {   {    result     (output) = 0 if no error, <>0 otherwise.  {   {}      LABEL      99;      VAR   
   i        : Int16; 
 
   ierr     : Int16; 
 
   istat    : Int16; 
 
   maxurecid: Int16; 
 
   temp     : Int16; 
    temp_int : INTEGER;  
   urec     : UserRecord;  
 
   wkmp     : Int16; 
         
BEGIN    { ShutNod } 
 result := 0;  ierr := 0;      IF trustvar = NOTRUST THEN GOTO 99;       DS_InitEnterCritical (wkmp, ierr);  IF ierr = 0 THEN     BEGIN    { are critical }     { Attempt to deallocated any allocated resource numbers.}         DS_FetchElement ( DS_TrackTD, TL_OUTPRO_RN, temp );     IF ( temp <> 0) THEN         BEGIN       { dealloc the rn }  	      istat := 0;  	       Rnrq ( RN_DEALLOCATE + RN_NO_ABORT, temp, istat );           BEGIN    { rnrq error }               END;     { rnrq error }            temp := 0;        DS_StoreElement ( DS_TrackTD, TL_OUTPRO_RN, temp );         END;        { dealloc the rn }      "   { Get descriptor for the last user record in the system. Use this "    { as an upper bound for cleaning user records.      {}      DS_FetchGlobal (DS_MaxUrId, 1, maxurecid);          FOR i := NUM_UR_BUCKETS + 1 TO maxurecid DO       BEGIN     { FOR }           DS_UrFetchElement ( i, urec.int );   	     WITH urec DO  	          BEGIN     { WITH }            IF (ur_rn <> 0) THEN               BEGIN        { dealloc the rn }               istat := 0;                Rnrq ( RN_DEALLOCATE + RN_NO_ABORT, ur_rn, istat );                   BEGIN    { rnrq error }                 END;     { rnrq error }                  ur_rn := 0;               temp := 0;              DS_RNStoreElement ( ur_rnd, temp );               END;         { dealloc the rn }   
         END;     { WITH } 
           DS_StoreUrec ( i, urec.int );         END;     { FOR }         DS_InitLeaveCritical (wkmp );     END      { are critical }    ELSE     BEGIN    { error going critical }     result := CANT_ENTER_CRIT;      END;     { error going critical }      99:   
   END;  { ShutNod } 
     
$SUBTITLE 'InitNod', PAGE$ 
 {------------------------------------------------------------}  {                                                            }  {                  InitNod                                   }  {                                                            }  {------------------------------------------------------------}      	PROCEDURE Initnod  	    (VAR result:       Int16);       {}  {   {}  LABEL      99;      VAR   
   burstin        : Int16; 
 
   burstout       : Int16; 
    domainrec      : DomainRecord;   
   nullvar        : Int16; 
 
   gsd            : Int16; 
 
   i              : Int16; 
 
   ierr           : Int16; 
 
   incc           : Int16; 
 
   j              : Int16; 
 
   lastgsd        : Int16; 
 
   outcc          : Int16; 
    protocolrec    : ProtocolRecord;   
   rn             : Int16; 
 
   rnd            : Int16; 
    socketrec      : SocketRecord;   
   temp           : Int16; 
    urec           : UserRecord;   
   wkmap          : Int16; 
         $SUBTITLE 'ExitNodInit', PAGE $   
   PROCEDURE ExitNodInit;  
    BEGIN    { ExitNodInit }      GOTO 99;      END;     { ExitNodInit }   $SUBTITLE 'GeneralInit', PAGE $   
   PROCEDURE GeneralInit;  
      {--------------------------------------------------------------}    {   GeneralInit;                                               }    {--------------------------------------------------------------}   VAR   	   index:   Int16; 	        BEGIN    { GeneralInit }   
   nullvar := NULL;  
        DS_InitEnterCritical ( wkmap, ierr );     IF ierr <> SUCCESSFUL THEN ExitNodInit;         DS_GetTableSpace ( DS_Tracktd, 1, TL_LAST, 1, ierr);      IF ierr <> SUCCESSFUL THEN         BEGIN    { error }        DS_InitLeaveCritical( wkmap );  	      ExitNodInit; 	       END;     { error }         FOR index := 1 TO TL_LAST DO         DS_StoreElement ( DS_Tracktd, index, nullvar);     DS_InitLeaveCritical ( wkmap );          {----------------------------------------------------------}        {   BIT MAP INITIALIZATION                                 }        {----------------------------------------------------------}           { At start up JR guarantees that pmap.bits[maxsoid] will be     { set and all bits before pmap.bits[maxsoid] will be clear.     { These conditions are necessary to make scanning of the      { outbound select bit map by OUTPRO fast.     {}           {----------------------------------------------------------}        {   DOMAIN RECORD INITIALIZATION                           }        {----------------------------------------------------------}           DS_InitEnterCritical (wkmap, ierr);     IF ierr <> SUCCESSFUL THEN ExitNodInit;         DS_GetTableSpace (DS_DomainsTD, HPDSN_DOMAIN, HPDSN_DOMAIN,                        DOMAINREC_SIZE, ierr);     IF ierr <> SUCCESSFUL THEN         BEGIN    { error }        DS_InitLeaveCritical( wkmap );  	      ExitNodInit; 	       END;     { error }      
   WITH domainrec DO 
       BEGIN         dr_ipcpids.longint := 0;        dr_memberpids.longint := 0;         dr_domain := HPDSN_DOMAIN;        dr_vnapid := IP;  
      dr_vnas := 0;  
       END; {WITH domainrec}           DS_StoreElement (DS_DomainsTD, HPDSN_DOMAIN, domainrec.int);       DS_InitLeaveCritical (wkmap);         END;     { GeneralInit }       $SUBTITLE 'RNTableInit', PAGE $   
   PROCEDURE RNTableInit;  
     VAR      internal_result :    Int16;     BEGIN    { RNTableInit }       !   {-------------------------------------------------------------} ! !   {   RN TABLE INITIALIZATION                                   } ! !   {-------------------------------------------------------------} !        {}      { We now rely upon the memory manager to initialize the     { resource number table. Our job here is to make sure that      { the necessary "well-known" resource     { numbers get allocated and placed into the RN Table.     { Currently there are two such numbers, one used by the     { outbound protocol process and the other used by users     { waiting for a root socket to become available.      {}          DS_InitEnterCritical ( wkmap, ierr );     IF ierr <> SUCCESSFUL THEN ExitNodInit;         GetSignalRn ( rnd, rn ); {get critical}     IF (rn = MEANINGLESS) THEN         BEGIN    { rn error }         DS_InitLeaveCritical( wkmap );        internal_result := NODINIT_RNERR;   	      ExitNodInit; 	       END;     { rn error }          DS_StoreElement (DS_TrackTD, TL_OUTPRO_RN, rn );      DS_InitLeaveCritical ( wkmap );         END;     { RNTableInit }       $SUBTITLE 'UserRecordsInit', PAGE $   
PROCEDURE UserRecordsInit; 
     {----------------------------------------------------------}  {   USER RECORD INITIALIZATION                             }  {----------------------------------------------------------}      {}  { Initialize all user records.  {}  VAR      i,j : Int16;       BEGIN    { UserRecordsInit }  DS_InitEnterCritical ( wkmap, ierr );   IF ierr <> SUCCESSFUL THEN ExitNodInit;       FOR i := 1 TO numberuserrecs + NUM_UR_BUCKETS DO        BEGIN   	      WITH urec DO 	          BEGIN           IF i <= NUM_UR_BUCKETS THEN              ur_progname.chars := 'BUCKET'            ELSE               ur_progname.chars := 'NOBODY';           ur_procidaddr := 0;           ur_sfree := 1;   
         ur_smap[0] := 0;  
          FOR j := 1 TO (MAX_SOCKETS_PER_USER - 1) DO              ur_smap[j] := -(j + 1);            ur_smap[MAX_SOCKETS_PER_USER] := NULL;   
         ur_give_cnt := 0; 
          ur_so_giveptr := NULL;            ur_pa_giveptr := NULL;            ur_ptrs.ur_parenturecptr := NULL;           ur_ptrs.ur_sonurecptr := NULL;            ur_reschedule := FALSE;  
         ur_rn := 0; 
          ur_rnd := 0;            ur_sessionkey [1] := 0;           ur_sessionkey [2] := 0;           ur_sessionkey [3] := 0;           IF i <= NUM_UR_BUCKETS THEN              ur_urecptr := NULL           ELSE               ur_urecptr := i + 1;  
         END; {WITH urec}  
           DS_UrStoreElement ( i, urec.int );  	      END; {FOR i} 	        urec.ur_urecptr := NULL;   "   DS_UrStoreElement ( numberuserrecs + NUM_UR_BUCKETS, urec.int );  "        temp := NUM_UR_BUCKETS + 1;     DS_StoreElement ( DS_Tracktd, TL_USER_FREEPTR, temp );          temp := NULL;     DS_StoreGlobal ( DS_UrCleanupPtr, 1, temp );          DS_InitLeaveCritical ( wkmap );      END;     { UserRecordsInit }      $SUBTITLE 'SocketInit', PAGE $     PROCEDURE SocketInit;  VAR      index:      Int16;       
   BEGIN    { SocketInit } 
         {----------------------------------------------------------}        {   SOCKET INITIALIZATION                                  }        {----------------------------------------------------------}       {     { Circularly link all of the system's sockets into the free     { pool.     {}          DS_InitEnterCritical ( wkmap, ierr );     IF ierr <> SUCCESSFUL THEN ExitNodInit;         DS_FetchGlobal ( DS_SbTotal, 1, lastgsd );      lastgsd := lastgsd DIV 2;         FOR index := FIRST_GSD TO lastgsd DO         BEGIN         WITH socketrec DO            BEGIN           so_UserSig.longint := 0;            so_ProtoSig.longint := 0;           so_b.UserRnd := 0;            so_b.ProtoRnd := 0;           so_b.kind := 0;  
         so_b.state := 0;  
          so_k.max_burstin := 0;            so_k.max_burstout := 0;           so_k.max_sndcc := 0;            so_k.max_rcvcc := 0;            so_urecid := 0;  
         so_giveptr := 0;  
 
         so_namesptr := 0; 
          so_down_pathref := 0;  
         so_down_pid := 0; 
 
         so_timeout := 0;  
          so_f.asynchmode := FALSE;           so_f.deferred_give := FALSE;            so_f.call_data := FALSE;                so_fptr := index + 1;           so_bptr := index - 1;  
         END; {WITH} 
       DS_SoStoreElement ( index, socketrec.int );         END; {FOR}         DS_SoFetchElement ( FIRST_GSD, socketrec.int );     socketrec.so_bptr := lastgsd;     DS_SoStoreElement ( FIRST_GSD, socketrec.int );         DS_SoFetchElement ( lastgsd, socketrec.int );     socketrec.so_fptr := FIRST_GSD;     DS_SoStoreElement ( lastgsd, socketrec.int );         temp := FIRST_GSD;      DS_StoreElement ( DS_Tracktd, TL_SOCKET_FREEPTR, temp );      DS_InitLeaveCritical ( wkmap );      
   END;     { SocketInit } 
     $SUBTITLE 'CreateTCPRootSocket', PAGE $      PROCEDURE CreateTCPRootSocket;      BEGIN    { CreateTCPRootSocket }       { Create the special TCP socket. This will be the socket that       { TCP charges its "spontaneously" generated messages against.       { We place the socket's gsd in a well-known location so that       { TCP may find it when necessary.     {}      burstin := 1;  	   burstout := 3;  	    outcc := 512;     incc := 0;          DS_InitEnterCritical ( wkmap, ierr );     IF ierr <> SUCCESSFUL THEN ExitNodInit;      %   SoInitCreate ( burstin, incc, burstout, outcc, ROOTSOCKET, gsd, ierr);  %    IF ( ierr <> SUCCESSFUL ) THEN         BEGIN         DS_InitLeaveCritical ( wkmap );   	      ExitNodInit; 	 
      END; {IF ierr} 
        DS_StoreElement ( DS_TrackTD, TL_TCP_SOCKET, gsd );     DS_SoFetchElement (gsd, socketrec.int);     socketrec.so_down_pathref := -1; {per TCP's request}      socketrec.so_down_pid := TCP;     DS_SoStoreElement (gsd, socketrec.int);     DS_InitLeaveCritical ( wkmap );         END;     { CreateTCPRootSocket }       $SUBTITLE 'CreatePXPRootSocket', PAGE $      PROCEDURE CreatePXPRootSocket;      BEGIN    { CreatePXPRootSocket }           { Create the special PXP socket. This will be the socket that       { PXP charges its "spontaneously" generated messages against.       { We place the socket's gsd in a well-known location so that       { PXP may find it when necessary.     {}      burstin := 1;  	   burstout := 1;  	    outcc := 0;     incc := 0;      DS_InitEnterCritical ( wkmap, ierr );     IF ierr <> SUCCESSFUL THEN ExitNodInit;      %   SoInitCreate ( burstin, incc, burstout, outcc, ROOTSOCKET, gsd, ierr);  %    IF ( ierr <> SUCCESSFUL ) THEN         BEGIN         DS_InitLeaveCritical ( wkmap );   	      ExitNodInit; 	 
      END; {IF ierr} 
        DS_StoreElement ( DS_TrackTD, TL_PXP_SOCKET, gsd );     DS_InitLeaveCritical ( wkmap );         END;     { CreatePXPRootSocket }       $SUBTITLE 'ProtocolRecordInit', PAGE $     PROCEDURE ProtocolRecordInit;      VAR   	 pindex:    Int16; 	        BEGIN    { ProtocolRecordInit }              {----------------------------------------------------------}        {    PROTOCOL RECORD INITIALIZATION                        }        {----------------------------------------------------------}       {     { Initialize protocol records for all protocols in the      { system. Note that to facilitate path report evaluation we  "   { also create and initialize some protocol records for protocols  "    { that our system doesn't support.      {}          DS_InitEnterCritical ( wkmap, ierr );     IF ierr <> 0 THEN ExitNodInit;      DS_GetTableSpace ( DS_ProtosTD, FIRST_INDIVIDUAL_PID,  $                      (LAST_INDIVIDUAL_PID - FIRST_INDIVIDUAL_PID + 1),  $                       PROTOCOLREC_SIZE, ierr);  
   IF ierr <> 0 THEN 
       BEGIN    { table error }        DS_InitLeaveCritical( wkmap );  	      ExitNodInit; 	       END;     { table error }         WITH protocolrec DO        BEGIN         pr_rnd := MEANINGLESS;        pr_services.int := 0;         pr_supportingpids.longint := 0;         pr_path_mbufid := MEANINGLESS;        pr_pathlen := 0;        pr_maxmsglen := 0;  #      pr_default_timeout := 1500; {15 second for now; 1 minute later}  #       pr_default_incc := 0;         pr_default_outcc := 0;        END; {WITH protocol_pool}           FOR pindex := FIRST_INDIVIDUAL_PID TO LAST_INDIVIDUAL_PID DO          BEGIN          DS_StoreElement ( DS_ProtosTD, pindex, protocolrec.int );    
      END; { FOR pindex }  
        DS_InitLeaveCritical ( wkmap );         END;     { ProtocolRecordInit }      $SUBTITLE 'CreateIPRootSocket', PAGE $     PROCEDURE CreateIPRootSocket;     BEGIN    { CreateIPRootSocket }      { Create the special IP socket. This will be the socket that        { IP charges its "spontaneously" generated messages against.        { We place the socket's gsd in a well-known location so that       { IP may find it when necessary.      {}      burstin := 2;  	   burstout := 2;  	    outcc := 0;     incc := 0;      DS_InitEnterCritical ( wkmap, ierr );     IF ierr <> SUCCESSFUL THEN ExitNodInit;      %   SoInitCreate ( burstin, incc, burstout, outcc, ROOTSOCKET, gsd, ierr);  %    IF ( ierr <> SUCCESSFUL ) THEN         BEGIN         DS_InitLeaveCritical ( wkmap );   	      ExitNodInit; 	 
      END; {IF ierr} 
        DS_StoreElement (DS_TrackTD, TL_IP_SOCKET, gsd);      { We need to put the down pid into IP's socket so that we     { know where satellite beam messages should be sent.      {}      DS_SoFetchElement ( gsd, socketrec.int );     socketrec.so_down_pid := IP;      DS_SoStoreElement (gsd, socketrec.int);     DS_InitLeaveCritical ( wkmap );         END;     { CreateIPRootSocket }      
   BEGIN { InitNod } 
 	   result := GOOD; 	        GeneralInit;      RNTableInit;      SocketInit;  
   UserRecordsInit;  
    ProtocolRecordInit;         CreateTCPRootSocket;      CreatePXPRootSocket;      CreateIPRootSocket;      99:   	   result := ierr; 	     
   END; { InitNod }  
     END   .  