 $PASCAL ',20 91790-12002 REV.4010 <860321.1751> '   $ TITLE 'NS Initialization Program'$  $ STANDARD_LEVEL'HP1000', RECURSIVE OFF, RANGE OFF, HEAP 0  $   $ DEBUG $   $ CODE_INFO on      {------------------------------------------------------------        (c) COPYRIGHT HEWLETT PACKARD COMPANY 1986. ALL RIGHTS    RESERVED. NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED,   REPRODUCED OR TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT    THE PRIOR WRITTEN CONSENT OF THE HEWLETT-PACKARD COMPANY.       ------------------------------------------------------------}      {}  
{      NAME: NSINIT  
 {    SOURCE: 91790-18147  {     RELOC: 91790-12002  {      PGMR: EMS  {}      {}  {------------------------------------------------------------   { MODIFICATIONS:  {   {  Date  Prgmr  Description   {   {  860210  lms  NSINIT coalescence (n345).  {  860228  lms  Initialized var. in CheckOption (n356).   {   {------------------------------------------------------------   {}      {}  { PROGRAM DESCRIPTION:  !{  This is the NS/1000 initialization program main.  Other modules ! !{  that are part of the main are: INITCLEAN, INITSTATE, INITERRCK. ! {   #{  The main calls many other routines, three for each protocol segment #  {  in NS.  At the present time the protocol segments live in six   "{  subordinate programs NSPR1..6.  The parser for the program is in  " #{  NSPARS.  The programs communicate via Class I/O.  NSINIT allocated  # !{  the class numbers with ownership in the module INIT_MMULT.  If  ! !{  this program were converted to CDS, the INIT_MMULT module could ! {  be discarded.  {   !{  To make the class I/O transparent, each subroutine residing in  ! !{  a subordinate program has a dummy routine that builds the class ! "{  I/O buffer and sends it to the appropriate program.  All of these " {  routines will be unnecssary in a CDS environment as well.  "{  The real routines are in these modules: IPINIT, MONINIT, NFTINIT, " !{  NMINIT, NRGINIT, IPCINIT, NSLNKINIT, TCPINIT, PXPINIT, MUINIT,  ! !{  RTRINIT, S1KINIT, S3KINIT, NODINIT, PROBINIT, TMRINIT, IFPINIT. ! {   {  The dummy routines are in: IPINID, MONINID, etc.   {    {  In addition to the protocol segments, there are some general     {  purpose routines.  The following modules makea up the parser:   {  INITERRMSG, PARSER, FILEMAN, INIT_GENERAL.   {}      PROGRAM NSINIT;       IMPORT         { memory manager declarations }  
$SEARCH 'phtm/bodec.rel '$ 
    bodec,   
$SEARCH 'phtm/mmdec.rel '$ 
    mmdec,   
$SEARCH 'phtm/mmext.rel'$  
    ds_mm,      { Global Declarations (mostly types ) }  $SEARCH 'phtm/init_dec.rel'$     Init_Dec,  $SEARCH 'phtm/initmulti.xpt' $     Initmulti,   $SEARCH 'phtm/filemad.xpt'$      FileMan,      { General purpose routines ( mostly for I/O ) }  
$SEARCH 'phtm/parsdd.xpt'$ 
    Parser,  
$SEARCH 'phtm/dres.xpt' $  
    dres,  
$SEARCH 'phtm/alloc.xpt' $ 
    alloc,   $SEARCH 'phtm/init_rte_if.xpt'$      init_rte_if,   $SEARCH 'phtm/s3kinid.xpt' $     s3kinit,   $SEARCH 'phtm/s1kinid.xpt' $     s1kinit,   $SEARCH 'phtm/ipcinid.xpt' $     ipcinit,   $SEARCH 'phtm/pxpinid.xpt' $     pxpinit,   $SEARCH 'phtm/tcpinid.xpt' $     tcpinit,   $SEARCH 'phtm/nrginid.xpt' $     nrginit,   $SEARCH 'phtm/tmrinid.xpt' $     tmrinit,   $SEARCH 'phtm/muinid.xpt' $      muinit,  $SEARCH 'phtm/probinid.xpt' $      probinit,  $SEARCH 'phtm/nminid.xpt' $      nminit,  $SEARCH 'phtm/ifpinid.xpt' $     ifpinit,   $SEARCH 'phtm/nslnkinid.xpt' $     nslnkinit,   $SEARCH 'phtm/moninid.xpt' $     moninit,   $SEARCH 'phtm/ipinid.xpt' $      ipinit,  $SEARCH 'phtm/nodinid.xpt' $     nodinit,   $SEARCH 'phtm/nftinid.xpt' $     nftinit,   $SEARCH 'phtm/rtrinid.xpt' $     rtrinit,   $SEARCH 'phtm/initerrck.xpt' $     initerrck,   $SEARCH 'phtm/initstate.xpt' $     initstate,   $SEARCH 'phtm/initclean.xpt'$      initclean;       $ SUBTITLE 'GLOBALS FOR MAIN', PAGE $   LABEL      999;       CONST   
   myname = 'NSINI'; 
 	   IDSAMSIZE = 1;  	    ISMBSIZE = 4;     ICLASS_N = 2;  	   IRESOURC_N = 3; 	    ISOCKETS = 5;  	   FIRSTRESRC = 1; 	 	   LASTRESRC = 5;  	     TYPE         ActionType =         ( BUILD,          BUILDANDSTART,          STARTUP,          SHUT );          TResrcType = RECORD        TResrcArray:    Array[FIRSTRESRC..LASTRESRC] OF Int16;        tot_dsamsize:  Int32;         END;         TimeBufferType = Packed Array[1..30] OF Char;      VAR      main_input:    IStringType;         action:       ActionType;  &   aseg_class_n: Int16;      { number of RTE class numbers this seg wants }  &    aseg_dsamsize:Int16;      { amount of DSAM this seg wants }  %   aseg_resourcn:Int16;      { number of resource numbers this seg wants } %    aseg_smbsize: Int16;      { amount of SAM this seg wants }   #   aseg_sockets: Int16;      { number of IPC sockets this seg wants }  # 
   dostart:      Boolean;  
    ds_stateword: Int16;      ds:           DsStateType;      dscondition:  DsStateType;      ds_sam:       Int16;      { amt. sam DS needs }     ds_dsam:      Int16;      { amt. dsam DS needs }      errorstring:  MultiErrorType;  
   goodresponse: Boolean;  
 
   main_def:     Boolean;  
    main_halt:    Int16;   
   main_term:    Boolean;  
    max_sam:      Integer;      { tot amt sam DS will need }   !   message:      PromptType; { message used to print info/errors } !    netmancode:   Int16OrCharType;      userseccode:  Int16OrCharType;      result:       Int16;      segment:      Int16;      { current protocol segment }      stringfornumb:FiveCharType;     temp:         Int16;      totalsysres:  TResrcType; { tot resources DS will need }       $ SUBTITLE 'Internal Routines', PAGE $      PROCEDURE AskForAction    (VAR action:    ActionType );      FORWARD;      { Find out what the user wants to do }       PROCEDURE AskForSecurity    (VAR netmancode:   Int16OrCharType;      VAR userseccode:  Int16OrCharType;      VAR passedresult: Int16 );      FORWARD;     { Get the network security code from the input device }       PROCEDURE AskIfStartup    (VAR dostart:   Boolean );     FORWARD;   &   { ask user if NS startup should occur, set goahead to TRUE if it should } &     
PROCEDURE CheckSemantics;  
    FORWARD;   !   { Have each protocol segment test the semantics of user input } !     $PROCEDURE ErrorCatcher                     $ ALIAS 'Pas.ErrorCatcher' $  $   (    err_type:     ErrorType;          err_no:       Int16;          err_line:     Int16;          err_file:     FNameType;          err_flen:     Int16 );      FORWARD;      { Trap and recover from pascal errors }      
PROCEDURE InitializeVars;  
    FORWARD;      { initialize booleans, clear pascal error flags }      $PROCEDURE InitPascalHeap;                   $ ALIAS 'Pas.InitMemInfo2' $ $    EXTERNAL;     { Have Pascal Initialize its Heap. }       "FUNCTION PascalStringData                $ ALIAS 'Pas.StringData1' $ "    ( VAR s:          String ):  PCharTypePtr;      EXTERNAL;     { return a packed array of char pointer to a string }      #PROCEDURE PascalStringEndCheck            $ ALIAS 'Pas.StrEndCheck '$  #    (     stringcheck:      Boolean );      EXTERNAL;     { Truncate strings instead of aborting on string errors }      
PROCEDURE PrintStartMsgs;  
    FORWARD;      { Print startup messages on input device }       $PROCEDURE RtePrint             $ ALIAS 'REIO', HEAPPARMS OFF, NOABORT $  $   ( writereq:     Int16;      conwd:        Int16;      msg:          PCharType;  
    msglen:       Int16 ); 
    EXTERNAL;     { Print a message on the scheduling terminal }       $FUNCTION RunString             $ ALIAS 'PAS.SPARAMETERS',HEAPPARMS OFF$  $   (    pnum:      Int16;     VAR p:         String): Int16;      EXTERNAL;     { Pick up run-time parameters as a string }      	PROCEDURE SetUpIO  	    (VAR passedresult:    Int16 );      FORWARD;      { Get file names from runstring, open log and input devices }        PROCEDURE SetUpOutput      (VAR passedresult:        Int16 );      FORWARD;      { Set up output file name and open the output file }        PROCEDURE SystemTime                          $ ALIAS 'FTIME' $       (VAR timebuf:     TimeBufferType );     EXTERNAL;     { Get the system time in an ascii string }       FUNCTION UserIsSuper:   Int16;     EXTERNAL;  !   { RTE-A routine.  Returns 0 if NOT superuser <0 if superuser. } !     $ SUBTITLE 'AskForAction', PAGE $   {------------------------------------------------------------}  {                                                            }  {                   AskForAction                             }  {                                                            }  {------------------------------------------------------------}  {}  PROCEDURE AskForAction    (VAR action:    ActionType );   {}   {  This routine prompts the user for the type of action desired.   {  The user has four options:   {     Build an output file,   {     Build output file and initialize DS   
{     Initialize DS  
 	{     Shut down DS 	 {   ${ The routine checks the input, and then sets action to the appropriate  $ {  action.  {   {  Input:   none  	{  Output:  action 	 {  Global variables accessed:   {     messgae, main_def, main_term  
{     tried_action.  
 {    {  Globals initialized: action, ds, ds_stateword, goodresponse.    {   
{  Routines called:  
 {     MsgFilePrint, IntInput, BailOut.  {}      CONST          OPNHI = 4;      OPNLO = 1;       VAR      index:               Int16;     internal_result:     Int16;     optionno:            Int16;     endindex:            Int16;     printplace:          PrintMsgType;      startindex:          Int16;      $ SUBTITLE 'CheckOption (AskForAction)', PAGE $      PROCEDURE CheckOption     ( VAR co_result:     Int16 );            BEGIN    { CheckOption }        co_result := GOOD;         {  If the input file is interactive and the user enters        enters: "start" action will be BUILDANDSTART.             If the input file is NOT interactive and the user          enters "start" action will be STARTUP.                  }              CASE optionno OF               1:    BEGIN                { 1: BUILD }                 action := BUILD;                  { don't need to check operating conditions }                  goodresponse := TRUE;                 END;                 { 1: BUILD }               2:    BEGIN                { 2: BUILDANDSTART }                 action := BUILDANDSTART;       "               CheckStartConditions( ds, goodresponse, co_result );  "                END;                 { 2: BUILDANDSTART }               3:    BEGIN                { 3: START }                 action := STARTUP;       "               CheckStartConditions( ds, goodresponse, co_result );  "                    IF co_result = GOOD THEN                     BEGIN    { check if outfile in runstring }                    IF initglobals.IG_outputfile <> '' THEN                        BEGIN       { outfile in runstring }   %                     { output file in runstring overrides the menu number. % #                       change the action number to 2 internally, user  # &                       really wants buildandstart.                        }  &                          action := BUILDANDSTART;                        END;        { outfile in runstring }                     END;     { check if outfile in runstring }                 END;                 { 3: START }               4:    BEGIN                { 4: SHUT }                  action := SHUT;                     { Check that conditions are ok for shut down }                  CheckShutConditions( ds, ds_stateword,                                       goodresponse, co_result );                 END;                 { 4: SHUT }       	         OTHERWISE 	             BEGIN    { IntInput internal error }                  co_result := ERR_INTINPUT;              CheckResult( co_result );                   { always terminate here }   
            BailOut; 
             END;     { IntInput internal error }  
         END;     { Case } 
           END;     { CheckOption }      $ SUBTITLE' AskForAction', PAGE $          BEGIN    { AskForAction }         REPEAT             internal_result := GOOD;            FOR index := COPTN0 TO COPTN4 DO           BEGIN    { print messages }                PrintPrompt( FALSE, INITMSG[index], internal_result );             CheckResult( internal_result );           IF internal_result <> GOOD THEN BailOut;            END;     { print messages }            main_def := TRUE;   
      main_term := FALSE;  
 "      IntInput( INITMSG[COPTNNO], main_def, main_term, OPNHI, OPNLO, " !                                      optionno, internal_result ); !       CheckResult( internal_result );         IF internal_result <> GOOD THEN BailOut;            IF main_def THEN          BEGIN    { user entered default }            optionno := OPNLO;            END;     { user entered default }      "      { Verify that the option is appropriate for the state of NS. } " $      { Routine will print msg if problem occurs, still need to quit. }  $       CheckOption( internal_result );         IF internal_result <> GOOD THEN BailOut;            IF NOT goodresponse THEN           BEGIN    { don't have good action }               IF ( NOT initglobals.IG_interactive ) THEN               BEGIN    { must abort the user }                  index := CINVOPTNMUSTABORT;               END      { must abort the user }             ELSE               BEGIN    { tell user to try again }                   index := CINVOPTN;              END;     { tell user to try again }                MsgFilePrint( index, PMT_ERROR, 0, internal_result );           CheckResult( internal_result );           IF internal_result <> GOOD THEN BailOut;                IF index = CINVOPTNMUSTABORT THEN BailOut;            END;     { don't have good action }      
      UNTIL goodresponse;  
    END;     { AskForAction }      $ SUBTITLE 'AskForSecurity', PAGE $   {------------------------------------------------------------}  {                                                            }  {                 AskForSecurity                             }  {                                                            }  {------------------------------------------------------------}  {}  PROCEDURE AskForSecurity    (VAR netmancode:   Int16OrCharType;      VAR userseccode:  Int16OrCharType;      VAR passedresult:       Int16 );     { Get the network security code from the input device }       VAR      internal_result:  Int16;          BEGIN    { AskForSecurity }         main_def := FALSE;      main_term := FALSE;         { prompt for network security code }      CharInput( INITMSG[CNMSC1] + INITMSG[CNMSC2], FALSE,            main_def, main_term, main_input, internal_result );         IF internal_result = GOOD THEN         BEGIN    { save net man code }            Setstrlen( main_input, TWOCHAR );          Strmove( TWOCHAR, main_input, 1, netmancode.CIOrCType, 1);         DS_Encrypt( netmancode.IIorCType );       !      { assume that main_def and main_term are false because they  ! "         were init above.                                         }  "       CharInput( INITMSG[CUSRSC1], TRUE,           main_def, main_term, main_input, internal_result );            IF internal_result = GOOD THEN           BEGIN    { save user code }               Setstrlen( main_input, TWOCHAR );  #         Strmove( TWOCHAR, main_input, 1, userseccode.CIOrCType, 1 );  #          DS_Encrypt( userseccode.IIOrCType );            END;     { save user code }        END;     { save net man  code }          { any errors will be passed back to the caller }      passedresult := internal_result;          END;     { AskForSecurity }      $ SUBTITLE 'AskIfStartup', PAGE $   {------------------------------------------------------------}  {                                                            }  {                   AskIfStartup                             }  {                                                            }  {------------------------------------------------------------}  {}  PROCEDURE AskIfStartup    (VAR dostart:   Boolean );      {}  {  This routine asks the user if NS is to be started up on the  {  node using the responses he/she just entered.  {   {  The routine is only called if action is BUILDANDSTART.   {   {  Input:   none  {   !{  Output:  action - set to STARTUP if the user wants to startup,  ! {            OR if the input device is NOT interactive  {                    set to BUILD otherwise.  {   {           passedresult- <> 0 if error; = 0 otherwise  {   {  Global Variables accessed:   {     main_def, message, action.  {   {  Routines called:  YesNoInput, BailOut.   {   {}      VAR      input_char:       OneCharType;      internal_result:  Int16;          BEGIN       { AskIfStartup }          internal_result := GOOD;       	   CASE action of  	 
      BUILDANDSTART: 
          BEGIN    { buildandstart }                IF initglobals.IG_interactive THEN               BEGIN    { check if want to startup }                   main_def := TRUE;               initglobals.IG_save_in_out := FALSE;      !            YesNoInput( INITMSG[CSTARTUPQ], main_def, input_char,  !                   internal_result);               CheckResult( internal_result );               IF internal_result <> GOOD THEN BailOut;                  IF (( input_char = 'Y' ) OR main_def ) THEN   
               BEGIN 
                dostart := TRUE;   	               END 	 	              ELSE 	 
               BEGIN 
                dostart := FALSE;  
               END;  
             END      { check if want to startup }              ELSE               BEGIN    { input not interactive: startup }               { since there is no user to ask, do startup. }              dostart := TRUE;              END;     { input not interactive: startup }            END;     { buildandstart }             STARTUP:           BEGIN    { startup }   
         dostart := TRUE;  
          END;     { startup }             BUILD:   ;            { no otherwise because of enumerated type }       
      END;  { CASE } 
        END;        { AskIfStartup }       $ SUBTITLE 'CheckSemantics', PAGE $   {------------------------------------------------------------}  {                                                            }  {                 Check Semantics                            }  {                                                            }  {------------------------------------------------------------}  {}  { Purpose:   {  Check Semantics calls each protocol segment semantic checker.   !{  The routine is basically a case statement with error checking.  !  {  It also keeps counts of the total amount of system resources    #{  each checker requires.  The counts are kept in aseg_xxx.  They are  # ${  then added to the totals.  If any segment reports an error condition  $ "{  in the result parameter, control is returned to the main program. " {   { Parameters:   	{    Input:  none  	 {   !{    Output: result.  Result is an integer flag to indicate if any ! "{     errors occurred during the execution of the subroutine, or if  " "{     any errors were reported by any routines which CheckSemantics  " {     calls.  {   { Side Effects:   "{  None that are directly related to this routine, but it does call  " {  each segment's semantic checker.   {  Side effects may be generated by those routines.   {   {}      $ SUBTITLE 'CheckSemantics', PAGE $   {------------------------------------------------------------}  {                                                            }  {                 CheckSemantics                             }  {                                                            }  {------------------------------------------------------------}  {}  
PROCEDURE CheckSemantics;  
     VAR      internal_result:     Int16;     c_index:             Int16;      $ SUBTITLE 'CheckSemantics', PAGE $   {------------------------------------------------------------}  {                                                            }  {                 Check Semantics                            }  {                                                            }  {------------------------------------------------------------}  {}  { Purpose:   {  Check Semantics calls each protocol segment semantic checker.   !{  The routine is basically a case statement with error checking.  !  {  It also keeps counts of the total amount of system resources    #{  each checker requires.  The counts are kept in aseg_xxx.  They are  # ${  then added to the totals.  If any segment reports an error condition  $ "{  in the result parameter, control is returned to the main program. " {   { Parameters:   	{    Input:  none  	 {   !{    Output: result.  Result is an integer flag to indicate if any ! "{     errors occurred during the execution of the subroutine, or if  " "{     any errors were reported by any routines which CheckSemantics  " {     calls.  {   { Side Effects:   "{  None that are directly related to this routine, but it does call  " {  each segment's semantic checker.   {  Side effects may be generated by those routines.   {   {}      $ SUBTITLE 'GetandPrintEMASizes', PAGE $  {------------------------------------------------------------}  {                                                            }  {            GetandPrintEMASizes                             }  {                                                            }  {------------------------------------------------------------}  {}  PROCEDURE GetandPrintEMASizes;      VAR      dummy:      Int16;      e_result:   Int16;      ema_avail:  Int16;      ema_used:   Int16;      ierr:       Int16;      index:      Int16;          BEGIN    { GetandPrintEMASizes }      FOR index := FIRSTEMABANN TO LASTEMABANN DO        BEGIN    { banner FOR }             PrintPrompt( FALSE, INITMSG[index], e_result );         CheckResult( e_result );        IF e_result <> GOOD THEN BailOut;         END;     { banner FOR }          WITH initglobals DO        BEGIN    { WITH initglobals }   !      { Loop for all proto programs.  There are 2 less proto progs !         than there are names in the program name array.  The 2  "        extra are for NSPARS and NSINIT, respectively.             } "       FOR index := FIRSTMP_PROG TO LASTMP_PROG-2 DO   
         BEGIN    { FOR }  
              IG_whichguy := REMA;             { Don't bother to set up subroutine parms before call,    !           since they are all output parms.                     }  !              DoSubCall( index );           WITH globalstring DO               BEGIN    { WITH globalstring }                  { get the output parms out of initglobals }               ema_avail := REMAema_avail;               ema_used := REMAema_used;               ierr := REMAierr;               END;     { WITH globalstring }      
         IF ierr = 0 THEN  
             BEGIN    { print data from subordinate }      
            message := ''; 
 $            Strwrite( message, 1, dummy, '*    ', PROGNAMEARRAY[index],  $ $               '           ', ema_avail:1, '           ', ema_used:1 );  $             PrintPrompt( FALSE, message, e_result );              CheckResult( e_result );              IF e_result <> GOOD THEN BailOut;               END;     { print data from subordinate }      
         END;     { FOR }  
       END;     { WITH initglobals }          END;     { GetandPrintEMASizes }       $ SUBTITLE 'PrintResourceStats', PAGE $   {------------------------------------------------------------}  {                                                            }  {             PrintResourceStats                             }  {                                                            }  {------------------------------------------------------------}  {}  PROCEDURE PrintResourceStats;   { Print Statistics about the resources this file requires }       VAR      index:            Int16;      nextchar:         Int16;      printresult:      Int16;          BEGIN    { PrintResourceStats }         PrintPrompt( FALSE, INITMSG[CRESRCBANNR], printresult );      CheckResult( printresult );     IF printresult <> GOOD THEN BailOut;          { Do not print number of sockets, but continue to       maintain the count in the resource array.      }      FOR index := FIRSTRESRC TO LASTRESRC -1 DO         BEGIN    { print resource info }      
      message := ''; 
       IF index = IDSAMSIZE THEN            BEGIN    { move dsam size into print buffer }      #         Strwrite( message, 1, nextchar, INITMSG[CRESRCBANNR + index], #                               totalsysres.tot_dsamsize );            END      { move dsam size into print buffer }          ELSE           BEGIN    { move the proper int16 value to buffer }       #         Strwrite( message, 1, nextchar, INITMSG[CRESRCBANNR + index], #                                totalsysres.TResrcArray[index] );             END;     { move the proper int16 value to buffer }             PrintPrompt( FALSE, message, printresult );         CheckResult( printresult );         IF printresult <> GOOD THEN BailOut;            END;     { print resource info }     END;     { PrintResourceStats }      $ SUBTITLE 'GetProtoInput', PAGE $  {------------------------------------------------------------}  {                                                            }  {                  GetProtoInput                             }  {                                                            }  {------------------------------------------------------------}  {}  PROCEDURE GetProtoInput   (     segment:          Int16;    VAR aseg_smbsize:     Int16;    VAR aseg_dsamsize:    Int16;    VAR aseg_sockets:     Int16;    VAR aseg_class_n:     Int16;    VAR aseg_resourcn:    Int16;    VAR passedresult:     Int16 );         BEGIN    { GetProtoInput }       	   CASE segment OF 	       seg_NM:            BEGIN               SynNM( aseg_smbsize, aseg_dsamsize, aseg_sockets,                 aseg_class_n, aseg_resourcn, passedresult );            END;             seg_1K_IN:           BEGIN               Syn1ks( aseg_smbsize, aseg_dsamsize, aseg_sockets,                  aseg_class_n, aseg_resourcn, passedresult );             END;            seg_Nod:           BEGIN               SynNod( aseg_smbsize, aseg_dsamsize, aseg_sockets,                  aseg_class_n, aseg_resourcn, passedresult );             END;            seg_IPC:           BEGIN               SynckIPC( aseg_smbsize, aseg_dsamsize, aseg_sockets,                  aseg_class_n, aseg_resourcn, passedresult );            END;             seg_TCP:           BEGIN               SynckTCP( aseg_smbsize, aseg_dsamsize, aseg_sockets,                  aseg_class_n, aseg_resourcn, passedresult );            END;             seg_PXP:           BEGIN               SynckPXP( aseg_smbsize, aseg_dsamsize, aseg_sockets,                  aseg_class_n, aseg_resourcn, passedresult );               END;            seg_RTR:           BEGIN               SynRTR( aseg_smbsize, aseg_dsamsize, aseg_sockets,                  aseg_class_n, aseg_resourcn, passedresult );            END;             seg_NRV:           BEGIN               SynNRV( aseg_smbsize, aseg_dsamsize, aseg_sockets,                  aseg_class_n, aseg_resourcn, passedresult );            END;             seg_IFP:           BEGIN               SynIFP( aseg_smbsize, aseg_dsamsize, aseg_sockets,                  aseg_class_n, aseg_resourcn, passedresult );            END;       	      seg_MON_IN:  	          BEGIN               SynMON( aseg_smbsize, aseg_dsamsize, aseg_sockets,                  aseg_class_n, aseg_resourcn, passedresult );            END;             seg_IP:            BEGIN               SynIP( aseg_smbsize, aseg_dsamsize, aseg_sockets,                 aseg_class_n, aseg_resourcn, passedresult );            END;             seg_3KLNK:           BEGIN           Syn3k2( aseg_smbsize, aseg_dsamsize, aseg_sockets,                    aseg_class_n, aseg_resourcn, passedresult);           END;             seg_NFT:           BEGIN           SynNFT( aseg_smbsize, aseg_dsamsize, aseg_sockets,                    aseg_class_n, aseg_resourcn, passedresult);           END;             seg_NRG:           BEGIN           SynNRG( aseg_smbsize, aseg_dsamsize, aseg_sockets,                    aseg_class_n, aseg_resourcn, passedresult);           END;             seg_PROB:            BEGIN           SynPROB( aseg_smbsize, aseg_dsamsize, aseg_sockets,                   aseg_class_n, aseg_resourcn, passedresult);           END;             seg_MU:            BEGIN           SynMU( aseg_smbsize, aseg_dsamsize, aseg_sockets,                   aseg_class_n, aseg_resourcn, passedresult);           END;             seg_TMR:           BEGIN           SynTMR( aseg_smbsize, aseg_dsamsize, aseg_sockets,                    aseg_class_n, aseg_resourcn, passedresult);           END;           !      { the following segments are not used for semantic checks }  ! 
      seg_NSLNK:  ;  
 
      seg_1K_SH:  ;  
 
      seg_3K_SH:  ;  
 
      seg_MON_SH: ;  
           OTHERWISE            BEGIN  $         MsgFilePrint( CINTERR_SEG, PMT_ERROR, segment, passedresult );  $          { ignore errors on print }       	         BailOut;  	          END;         END;       {case for protocol segment syntax checks }          END;     { GetProtoInput }       $ SUBTITLE 'ReadRestofIputFile (CheckSemtantics)',PAGE $  PROCEDURE ReadRestOfInputFile   
( VAR result:     Int16 ); 
     VAR      internal_result:     Int16;            BEGIN    { ReadRestofInputFile }            internal_result := GOOD;  %      { Read until end of file on input file if input is not interactive.  % %        If the input device is interactive, do nothing.                  } %           IF NOT initglobals.IG_interactive THEN           BEGIN    { Read 'till end of file }  	            REPEAT 	             ReadInput( message, internal_result );              IF internal_result = GOOD THEN                 BEGIN    { write string in output file }                      WriteOnOutput( message, internal_result );                  END;     { write string in output file }               UNTIL internal_result <> GOOD;               IF internal_result = EOFONREAD THEN              BEGIN    { hit eof }      "            { This is expected condition, clear error indication. }  "             internal_result := GOOD;              END;     { hit eof }           END;     { Read 'till end of file }      #      { pass any reading or writing errors other than EOF to caller }  #       result := internal_result;        END;     { ReadRestofInputFile }      $ SUBTITLE 'CheckSemantics',PAGE $         BEGIN    { CheckSemantics }      { Have each protocol segment go through startup procedures }           { Always save protocol segment's prompts & responses }      initglobals.IG_save_in_out := TRUE;         segment := FIRST_SEGMENT;         WITH totalsysres DO        BEGIN    { WITH }         FOR c_index := FIRSTRESRC TO LASTRESRC DO   
         BEGIN    { FOR }  
          { Clear the system resource counts }                TResrcArray[c_index] := 0;   
         END;     { FOR }  
           tot_dsamsize := 0;        END;     { WITH }          REPEAT       $      { continue until have gotten all responses or an error occurred }  $       { initialize the single segment totals }        aseg_smbsize := 0;  
      aseg_dsamsize := 0;  
       aseg_sockets := 0;        aseg_class_n := 0;  
      aseg_resourcn := 0;  
     $      GetProtoInput( segment, aseg_smbsize, aseg_dsamsize, aseg_sockets, $ !                  aseg_class_n, aseg_resourcn, internal_result );  !       CheckResult( internal_result );         IF internal_result <> GOOD THEN BailOut;            { update resource counts for this segment }   
      WITH totalsysres DO  
 
         BEGIN    { WITH } 
 $         TResrcArray[ISMBSIZE] := TResrcArray[ISMBSIZE] + aseg_smbsize;  $ $         TResrcArray[ISOCKETS] := TResrcArray[ISOCKETS] + aseg_sockets;  $ $         TResrcArray[ICLASS_N] := TResrcArray[ICLASS_N] + aseg_class_n;  $          TResrcArray[IRESOURC_N] :=   !                          TResrcArray[IRESOURC_N] + aseg_resourcn; !          tot_dsamsize := tot_dsamsize + aseg_dsamsize;               segment := segment + 1;               IF segment > LAST_SEGMENT THEN               BEGIN          { all done }               internal_result := QUEST_DONE;                 { need an additional resource number for                                      initialization itself  }   "            TResrcArray[IRESOURC_N] := TResrcArray[IRESOURC_N] + 1;  "             END;           { all done }       
         END;     { WITH } 
           UNTIL internal_result <> GOOD;         IF internal_result = QUEST_DONE THEN         BEGIN         internal_result := GOOD;            { now get the network security code.}   !      AskForSecurity( netmancode, userseccode, internal_result );  !       CheckResult( internal_result );         IF internal_result <> GOOD THEN BailOut;            { Read the rest of the input file, for comments, etc }        ReadRestOfInputFile( internal_result );         CheckResult( internal_result );         IF internal_result <> GOOD THEN BailOut;             { Ask each protocol segment for its EMA size.  Print this    !        information for the user too.                            } ! 
      GetandPrintEMASizes; 
 !      { this routine will bail out if it gets an error printing }  !           { print statistics about RTE and NS resources required          for this startup.                                    }  
      PrintResourceStats;  
 !      { this routine will bail out if it gets an error printing }  !           END        ELSE         BEGIN    { error in question/answer }         CheckSegPrint( internal_result, segment );        BailOut;            END;     { error in question/answer }          END;     { CheckSemantics }      $ SUBTITLE 'ErrorCatcher', PAGE $   {------------------------------------------------------------}  {                                                            }  {                    ErrorCatcher                            }  {                                                            }  {------------------------------------------------------------}  PROCEDURE ErrorCatcher    (    err_type:     ErrorType;          err_no:       Int16;          err_line:     Int16;          err_file:     FNameType;          err_flen:     Int16 );       {}  #{  Purpose: To handle pascal errors internally instead of blowing up.  # {   {  Input: err_type-  The type of error that occurred  {         err_no-    the numeric value of the error.  "{         err_line-  the line number in the program where the error  " {                      occurred   "{         err_file   the file name associated with the error, if any " %{         err_flen   the length of the filename associated with the error  % {   {  Output:  none  {  Global variables accessed:   %{      Init_Dec booleans to indicate what type of operation is being done- % {           opening- opening a file   {           reading- reading from a file  {           converting- converting a string to a number   !{        type from NSINIT to describe where we are in the process: ! {   &{  Global variables Changed:  hiterror- set to TRUE when routine is entered  & "{                             pascal_error record has its fields set " {                                to err_type and err_no.  {   '{  Routines Called:  RtePrint to print error if condition is not recoverable.  ' ${     BailOut which terminates the program if the error is not handled.  $ {}      VAR      nextpos:    Int16;          BEGIN    { ErrorCatcher }      #   { if hiterror flag already set we may be in infinite loop.  Halt }  # 
   IF hiterror THEN  
       BEGIN    { possible infinite loop }             message := NSINITE[EERRORCATCH2] + ' NSINIT. **';         RtePrint( XWRITEREQ, LU1, PascalStringData( message )^,                     -Strlen( message ));           BEGIN    { print error }   
         { ignore errors } 
          message := '';            END;     { print error }             Halt( 1 );        END;     { possible infinite loop }          { set global indicating got to the error catcher }   
   hiterror := TRUE; 
     	   message := '';  	 %   Strwrite( message, 1, nextpos, '** (9013) NS: Pascal Error ', err_no:1, % %         ' of type ', err_type, ' at line ', err_line:1, ' NSINIT. **' );  %        RtePrint( XWRITEREQ, LU1, PascalStringData( message )^,  !                                              -Strlen( message )); !       BEGIN    { error on rte print }         { there is nothing to do about errors in this case }  
      message := ''; 
       END;     { error on rte print }          { Terminate the program. }      BailOut;          END;     { ErrorCatcher }      $ SUBTITLE 'InitializeVars', PAGE $   {------------------------------------------------------------}  {                                                            }  {                 InitializeVars                             }  {                                                            }  {------------------------------------------------------------}  
PROCEDURE InitializeVars;  
 {}  {}  VAR      dummy:      Int16;          BEGIN    { InitializeVars }         IF UserIsSuper >= 0 THEN         BEGIN { NOT superuser }             message := INITMSG[CNOTSUPER];        RtePrint( XWRITEREQ, LU1, PascalStringData( message )^,               -Strlen( message ));           BEGIN    { error on print }           message := '';            END;     { error on print }            { no subordinate programs to clean up.  Quit }        Halt(1);        END;  { NOT superuser }          { clear all pascal error flags }      hiterror := FALSE;      converting := FALSE;   
   reading := FALSE; 
    pascal_error.ernumber := 0;         { turn string end checking off for pascal }     PascalStringEndCheck( FALSE );          { Initialize all globals in the global array }      WITH initglobals DO        BEGIN    { WITH }             { initialize multiprogramming variables }   $      { clear the global which would contain the caller's class number.  $ %        There is no caller for NSINIT.                                   } %       initglobals.IG_callerclass := 0;             { initialize protocol segment flags, we don't know whether   "        the user will have these options.  Assume he/she does not }  "       IG_have_IEEE802 := FALSE;   { no IEEE 802.3 LAN }         IG_are_gateway := FALSE;    { not a gateway }   #      IG_HP3000_enable := FALSE;  { have no links to a DS/3000 node }  # &      IG_1K50_enable := FALSE;    { have no DS/1000-IV compatible services } & !      IG_need_queue := FALSE;     { don't need queue (and grpm) }  !       IG_need_RTR := FALSE;       { don't need Router/1000 }         IG_MSTO := 0;               { 91750 master timeout is 0 }          IG_tot_nodal_progs := 0;        IG_tot_nodal_sockets := 0;        IG_nextavailsmbaddr := 0;             { Initialize parser information }   %      IG_filemaninit := FALSE;     { Tell parser to init it's variables }  % #      IG_save_in_out := FALSE;     { don't save input in output file } # !      IG_uselogforinput := FALSE;  { don't use log dev for input } !       END;     { WITH }          END;     { InitializeVars }      $ SUBTITLE 'PrintStartMsgs', PAGE $   {------------------------------------------------------------}  {                                                            }  {                 PrintStartMsgs                             }  {                                                            }  {------------------------------------------------------------}  
PROCEDURE PrintStartMsgs;  
 {}  #{  Purpose: Write general information to output device for interactive # {     user.   {   {  Input:   none  {   {  Output:  {     result <> 0 if error, 0 otherwise   {   {  Global Variables accessed: interactive   {   {  Routines Called: PrintPrompt, CheckResult  {   {}      CONST       CASEFOLD = TRUE;     { tell CharInput to upshift lower case }       VAR      internal_result:     Int16;         BEGIN   {PrintStartMsgs}          { print one message everywhere }      PrintError( INITMSG[CBANNER1], internal_result );     CheckResult( internal_result );     IF internal_result <> GOOD THEN BailOut;          IF initglobals.IG_interactive THEN         BEGIN { interactive }             { print startup messages on user terminal. }            PrintPrompt( FALSE, INITMSG[CBANNER2], internal_result);        CheckResult( internal_result );         If internal_result <> GOOD THEN BailOut;            PrintPrompt( FALSE, '', internal_result);         CheckResult( internal_result );         IF internal_result <> GOOD THEN BailOut;            END;  { interactive }          END;  { PrintStartMsgs }       $ SUBTITLE 'SetUpIO', PAGE $  {------------------------------------------------------------}  {                                                            }  {                    SetUpIO                                 }  {                                                            }  {------------------------------------------------------------}  {}      	PROCEDURE SetUpIO  	    (VAR passedresult:       Int16 );      {}  { Purpose: Set up the input and log devices.  {   {  Input:   none  {  Output:  result <>0 If error, 0 Otherwise  {   {  Global variables accessed:  from init_dec:   {     file name strings: logfile, inputfile, outputfile.  {   {  Routines called: Runstring ( pascal routine)    {                   OpenLog, OpenInput, WriteOnLog, CheckResult    {   #{  Descripton: Get the input,output, and log devices specified in the  # 
{  runstring if any. 
 {   {  Open the Log and input devices.  {   %{  Side Effects:  OpenInput initializes the interactive flag to determine  % {  if the input device is interactive.  {   {}          VAR      internal_result:   Int16;     name_len:          Int16;     openflag:          Boolean;      
   BEGIN       { SetUpIO } 
        internal_result := GOOD;          { Initialize the I/O file names }     initglobals.IG_logfile := '';     initglobals.IG_inputfile := '';     initglobals.IG_outputfile := '';          { Get the scheduling parameters }     name_len := RunString(3,initglobals.IG_logfile);      name_len := RunString(1,initglobals.IG_inputfile);      name_len := RunString( 2, initglobals.IG_outputfile );          { Open the log device to print error messages }     { Do this first in case get errors opening other files }      OpenLog( internal_result );         { don't care if default lu was opened. }       IF internal_result = OPENEDDEF THEN internal_result := GOOD;           IF internal_result = GOOD  THEN        BEGIN      { Open Input file }               REPEAT                openflag := FALSE;                { open the input device to read from                    & to write to if interactive.}            OpenInput( internal_result );           IF internal_result = GOOD THEN               BEGIN    { file open }              openflag := TRUE;               END      { file open }             ELSE               IF (( initglobals.IG_inputfile <> DEFAULT_LU ) AND  !                             ( initglobals.IG_interactive )) THEN  !                BEGIN       { use default }                     { tell OpenInput to use default }                 initglobals.IG_inputfile := DEFAULT_LU;                 internal_result := GOOD;       $               MsgFilePrint( CUSEDDEF, PMT_ERROR, 0, internal_result );  $                CheckResult( internal_result );                 IF internal_result <> GOOD THEN BailOut;                      END         { use default }  	              ELSE 	                 BEGIN       { error opening, tell user aborting }   %               MsgFilePrint( COPENINERR, PMT_ERROR, 0, internal_result );  %                internal_result := ERR_ALREADY_PRINTED;                      END;        { error opening, tell user aborting }                UNTIL (( openflag ) OR ( internal_result <> GOOD ));             END      { Open Input file }       ELSE         BEGIN    { Error Opening Log }        CheckResult( internal_result );         END;     { Error Opening Log }         passedresult := internal_result;       
   END;        { SetUpIO } 
     $ SUBTITLE 'SetUpOutput', PAGE $  {------------------------------------------------------------}  {                                                            }  {                      SetUpOutput                           }  {                                                            }  {------------------------------------------------------------}  {    { Purpose: Open output device for writing.  File name came from    { 2nd parameter in run string or from interactive user.   {   {}  PROCEDURE SetUpOutput      (VAR passedresult:        Int16 );   {}  {  Input: none  {  Output:  result <>0 If error, 0 otherwise  {   "{  Global variables accessed: outpufile (contains output file name ) " {   %{  Routines called: all internal routines: ( GetOutputName, CheckOutIsIn,  % {     CheckForExistence and PrintOutputOpenMsgs ) as well as:   {     BailOut, HandleDefFileName, PrintPrompt, & CheckResult.   {   #{  Description: GetOutputName is called to get the file name, from the # #{  runstring or from the user if interactive.  If not interactive, and # "{  no name in the runstring, the output file is opened. The filename " &{  is checked to see if user wants the default by calling HandleDefFileName. & {   ${  If the result parameter from this routine indicates that the file can $ ${  be opened, it is opened by calling OpenOutput.  The name of the file  $ {  is printed on the input device if input is interactive.  {   "{  If a file was opened, header messages are printed in the file by  " {  calling PrintOutputOpenMsgs.   {   {}          CONST          NOCCTL = 'NOCCTL';      OUTBASE = 'nsout';       VAR          wantoutput:          Boolean;     idummy:              Int16;     output_result:       Int16;     open_successful:     Boolean;          $ SUBTITLE 'CheckOutIsIn (SetUpOutput)', PAGE $   %{------------------------------------------------------------------------} % %{  (LOCAL)    CheckOutIsIn                  (LOCAL)                      } % %{------------------------------------------------------------------------} % 
   PROCEDURE CheckOutIsIn  
      ( VAR passedresult:       Int16 );   {}  #{  Purpose: To check the output file name against the input file name  # {  to ensure that they are not one and the same.  {   {  Output: passedresult <> 0 if error, 0 otherwise  {   {  Global Variables accessed: outputfile , inputfile  {   {  Routines called: MsgFilePrint, CheckResult, and BailOut.   {}        BEGIN    { CheckOutIsIn }         passedresult := GOOD;       #      IF (( initglobals.IG_outputfile = initglobals.IG_inputfile ) AND # !                       ( initglobals.IG_outputfile <> '1' ))  THEN !          BEGIN    { in = out }      !         { the output file cannot be the same as the input file }  !              MsgFilePrint( COUTISIN, PMT_ERROR, 0, passedresult );           CheckResult( passedresult );            IF passedresult <> GOOD THEN BailOut;               passedresult := NOTOPEN;                END;     { in = out }        END;     { CheckOutIsIn }       $ SUBTITLE 'CheckForExistence (SetUpOutput)', PAGE $  %{------------------------------------------------------------------------} % %{  (LOCAL)      CheckForExistence             (LOCAL)                    } % %{------------------------------------------------------------------------} %    PROCEDURE CheckForExistence     ( VAR passedresult:     Int16 );   {}  {  Purpose: To get an output file name from the user.   {   {  Input:   none  {  Output:  result <>0 if error, 0 otherwise  {   '{  Global variables accessed: outputfile is changed to contain the file name.  ' {  Routines Called: CharInput.  {   {}  VAR      exists_result:     Int16;     input_char:        OneCharType;            BEGIN    { CheckForExistence }      "      IF FileExists( initglobals.IG_outputfile, exists_result ) THEN "          BEGIN    { Ask if overwrite }      
         main_def := TRUE; 
          YesNoInput( INITMSG[COVERWRITEOQ], main_def,   !                                      input_char, passedresult );  !          CheckResult( passedresult );            IF passedresult <> GOOD THEN BailOut;               IF input_char = 'N' THEN               BEGIN    { won't overwrite }  #            MsgFilePrint( CNO_OVERWRITE, PMT_ERROR, 0, passedresult ); #             passedresult := NOTOPEN;                  initglobals.IG_outputfile := '';              END;     { won't overwrite }           END      { Ask if overwrite }          ELSE IF ( exists_result <> GOOD ) THEN              BEGIN    { have problem ? }                IF ( exists_result <> INITPASCALE+NOSUCHFILE ) THEN                   BEGIN    { error opening file }                 initglobals.IG_outputfile := '';       "               { unanticipated error occurred opening output file. } "                MsgFilePrint( COUTFILEOPENERR, PMT_ERROR,  $                             exists_result-INITPASCALE, passedresult );  $                passedresult := ERR_ALREADY_PRINTED;                  END;     { error opening file }              END;     { have problem ? }         END;     { CheckForExistence }      $ SUBTITLE 'GetOutputName (SetUpOutput)', PAGE $  %{-----------------------------------------------------------------------}  % %{   (LOCAL)        GetOutputName                       (LOCAL)          }  % %{-----------------------------------------------------------------------}  %     
   PROCEDURE GetOutputName 
    ( VAR wantoutput:    Boolean );  {}  { Purpose: To get the output file name.   {   {  Input:   none  %{  Output:  wantoutput: TRUE if we have output file name, FALSE otherwise. % #{           main_def:    TRUE if user wants to use default file name.  # {   %{  Global Variables accessed:  initglobals: IG_interactive, IG_outputfile. % {  Routines called:  CharInput  {   {}     VAR        nameresult:     Int16;            BEGIN    { GetOutputName }  
      WITH initglobals DO  
 
         BEGIN    { WITH } 
           { If no name in run string ask user for it if input is                interactive.  If it's not, don't use file name unless   "           it's in the runstring.                                  } "          IF (( Strlen( IG_outputfile ) <= 0 ) AND                                   ( IG_interactive ) ) THEN               BEGIN    { get name }                   main_def := TRUE;               main_term := FALSE;               IG_outputfile := '';                  CharInput( INITMSG[COUTFILEQ], TRUE, main_def,  !                            main_term, IG_outputfile, nameresult); !             CheckResult( nameresult );              If nameresult <> GOOD THEN BailOut;                   { return name and main_def to caller }              END      { get name }              ELSE IF Strlen( IG_outputfile ) <= 0 THEN                                          wantoutput := FALSE;  
         END;     { WITH } 
       END;     { GetOutputName }      $ SUBTITLE 'PrintOutputOpenMsgs (SetUpOutput)', PAGE $  %{------------------------------------------------------------------------} % %{  (LOCAL)       PrintOutputOpenMsgs          (LOCAL)                    } % %{------------------------------------------------------------------------} %    PROCEDURE PrintOutputOpenMsgs;   {}  {  Purpose: To write header messages in the output file.  {   {  Input:   none  {  Output:  none  !{  Global variables accessed: save_in_out is changed to true, and  ! {     stays that way for the rest of the syntax checking.   {   {  Routines called: WriteOnOutput, CheckResult.   {   {}         CONST        OPNIS = '3       *  Initialize NS *';          VAR        write_result:     Int16;        index:            Int16;        timebuf:          TimeBufferType;          BEGIN    { PrintOutputOpenMsgs }          { First tell the user the name of the output file. }   	   message := '';  	    Strwrite(message, 1, idummy, INITMSG[COUTNAMEPRINT],   $                                      initglobals.IG_outputfile, '.' );  $    PrintPrompt( FALSE, message, write_result );      CheckResult( write_result );      IF write_result <> GOOD THEN BailOut;         initglobals.IG_save_in_out := TRUE;  !   { print the name of the file and the time in the output file }  ! 
   SystemTime( timebuf );  
 	   message := '';  	    WITH initglobals DO        BEGIN    { WITH }         Strwrite( message, 1, index, '* NSINIT file: ',   $         IG_outputfile:Strlen( IG_outputfile ), '   ', timebuf, '. *' ); $           WriteOnOutput( message, write_result );         CheckResult( write_result );        IF write_result <> GOOD THEN BailOut;         END;     { WITH }          { Now print the menu in the file for future reference. }      FOR index := COPTN0 TO COPTNNO DO        BEGIN    { print menu in file }             WriteOnOutput( INITMSG[index], write_result );        CheckResult( write_result );        IF write_result <> GOOD THEN BailOut;         END;     { print menu in file }       "   { Save the option choice as "initialize" so the file is useful }  "    WriteOnOutput( OPNIS, write_result );     CheckResult( write_result );      IF write_result <> GOOD THEN BailOut;          { reset the global to the state it was before this routine }       initglobals.IG_save_in_out := FALSE;          END;     { PrintOutputOpenMsgs }       $ SUBTITLE 'SetUpOutput', PAGE $      
   BEGIN  { SetUpOutput }  
        { assume no errors }      wantoutput:= TRUE;      open_successful := FALSE;     main_def := FALSE;          REPEAT         output_result := GOOD;      "      { If have name in runstring, use it. If interactive, get name  " #        from user.  If neither of these, don't open output file.    }  #       GetOutputName( wantoutput );        IF wantoutput THEN           BEGIN    { want output file }               CheckOutIsIn( output_result );            IF output_result = GOOD THEN               IF main_def THEN                 BEGIN    { get default name }      #               HandleDefFileName( initglobals.IG_outputfile, OUTBASE,  # "                                                    output_result ); "                IF output_result <> GOOD THEN BailOut;                  END      { get default name }  	              ELSE 	                BEGIN    { check for overwrite }                      CheckForExistence( output_result );                 END;     { check for overwrite }                IF (( output_result = GOOD ) AND wantoutput ) THEN               BEGIN    { open file }                  OpenOutput( output_result );  !            IF output_result = GOOD THEN open_successful := TRUE;  !             END;     { open file }               IF ( output_result <> GOOD ) THEN              BEGIN    { error opening file }               IF initglobals.IG_interactive THEN                 BEGIN    { clear file name }                      initglobals.IG_outputfile := '';                  END      { clear file name }   	              ELSE 	                BEGIN    { can't reprompt }                     wantoutput := FALSE;       %               MsgFilePrint( CERROPEN_OUT, PMT_ERROR, 0, output_result );  %                CheckResult( output_result );                 IF output_result <> GOOD THEN BailOut;                      output_result := ERR_ALREADY_PRINTED;                 END;     { can't reprompt }              END;     { error opening file }            END;     { want output file }        UNTIL (( NOT wantoutput ) OR open_successful );       
   IF open_successful THEN 
       BEGIN       { tell user file open }       %      initglobals.IG_outputfile := Strltrim( initglobals.IG_outputfile );  % %      initglobals.IG_outputfile := Strrtrim( initglobals.IG_outputfile );  %           { print messages on screen and in output file }   
      PrintOutputOpenMsgs; 
           END;         { tell user file open }         passedresult := output_result;          END;  { SetUpOutput }      $ SUBTITLE 'Main Program', PAGE $       {------------------------------------------------------------}  {                                                            }  {                      Main Program                          }  {                                                            }  {------------------------------------------------------------}          	BEGIN   { NSINIT } 	     { initialize booleans, set up variables }   InitializeVars;       { schedule other processes that make NSINIT work. }   SetUpChildren;      { Open the log & input files, read the runstring }  	SetUpIO( result ); 	 IF result <> GOOD THEN BailOut;       { Call MsgFilePrint to initialize its internal variables }  MsgFilePrint( 0, PMT_ERROR, 0, result );  CheckResult( result );  IF result <> GOOD THEN BailOut;       { print startup messages on user's terminal }   PrintStartMsgs;       { Ask the user for what to do, prompt until it matches current  !   state of NS if interactive.                                  }  ! AskForAction( action );       IF action = SHUT THEN      BEGIN    { user wants shut }       
   { go handle shut down } 
    HandleShut( ds, ds_stateword, main_halt );      { subroutine will return if security code is not correct. }         END      { Handle Shutdown }     ELSE     BEGIN    { user wants start/build }         IF action <> STARTUP THEN        BEGIN    { set up output file }             { Set up and open the output file }         SetUpOutput( result );        IF result <> GOOD THEN BailOut;         END;     { set up output file }       &   { Get user input (ask questions) call each protocol's semantic checker }  &     	   CheckSemantics; 	    { routine will cleanup and terminate program if error }         { Find out if we are starting DS this time }      AskIfStartup( dostart );       	   IF dostart THEN 	       BEGIN             { go ahead and start up }             { allocate resources }         AllocateResources( ds, totalsysres.TResrcArray[ISMBSIZE],    "                                        totalsysres.tot_dsamsize );  "       { the subroutine will call cleanup if an error occurs }             { startup all proctocol segments }  "      StartUpSegments( netmancode.IIOrCType, userseccode.IIorCType,  " #                                                          main_halt ); # !      { The subroutine will call cleanup if an error occurs before ! "        link initialization.  Otherwise control returned here.     } "           END               { go ahead and start up }        ELSE         BEGIN             { don't start up }            { print message; we're done, & terminate gracefully }       
      message := ''; 
 "      Strwrite( message, 1, temp, INITMSG[CGOODTERM], action, '.');  "       PrintError( message, result );        CheckResult( result );        IF result <> GOOD THEN BailOut;             END;              { don't start up }         END;     { user wants start/build }      999:      KillChildren;       	Halt( main_halt ); 	     	END.    { NSINIT } 	