 $PASCAL ',20 91790-12005 REV.4010 <851125.2010> '   $ DEBUG, STANDARD_LEVEL'HP1000', RECURSIVE OFF, RANGE OFF $   $ HEAP 0 $      Program NSPARS;       {------------------------------------------------------------    (c) COPYRIGHT HEWLETT PACKARD COMPANY 1986. ALL RIGHTS    RESERVED. NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED,   REPRODUCED OR TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT    THE PRIOR WRITTEN CONSENT OF THE HEWLETT-PACKARD COMPANY.   ------------------------------------------------------------}  {}  
{     NAME:   NSPARS 
 
{     SOURCE: 91790-18153  
 
{     RELOC:  91790-12005  
 	{     PGMR:   EMS  	 {}      {}  {  This program contains the REAL parsing routines for NSINIT.  
{  Its runstring is: 
 !{  RU,NSPARS,prot1cl,proto2cl,proto3cl,prot4cl,proto5cl,proto6cl,  ! {           nsparsclass, nsinitclass.   {   {  This program waits on its class for NSINIT or one of the   !{  protocol programs to need a routine from the parser.  When one  ! "{  of these programs needs to execute a routine contained in NSPARS  " #{  it will build a class I/O buffer, and will send it to parserclass.  # {  NSPARS then calls  DoCase to execute the proper subroutine.  ${  It sends the return parameters and the globals back to the caller via $ {  class I/O to initglobals.IG_callerclass.   {   %{  When NSINIT is finished with the parser it sets initglobals.IG_whichguy % {  to SONDONE.  NSPARS then terminates.   {   {}      IMPORT         { basic memory manager declarations }  $ SEARCH 'phtm/bodec.rel' $      bodec,   $ SEARCH 'phtm/mmdec.rel' $      mmdec,   $ SEARCH 'phtm/mmext.rel' $      ds_mm,   $ SEARCH 'phtm/init_dec.rel'$      init_dec,  $ SEARCH 'phtm/init_general.rel'$      init_general,  $ SEARCH 'phtm/fileman.rel'$     fileman,   $ SEARCH 'phtm/strrout.xpt'$     strrout,   $ SEARCH 'phtm/parser.rel'$      parser,  $ SEARCH 'phtm/initmulti.xpt'$     initmulti,   $ SEARCH 'phtm/initerrmsg.rel' $     initerrmsg;      VAR      a_reg:         Int16OrCharType;     b_reg:         Int16OrCharType;  
   continue:      Boolean; 
    errorstring:   MultiErrorType;      stringof80:    IStringType;     dummy:         Int16;     glen:          Int16;      PROCEDURE ABReg   	$ HEAPPARMS OFF $  	    ( VAR a_reg:   Int16;  
     VAR b_reg:   Int16 ); 
    EXTERNAL;  $ HEAPPARMS ON $     { Get the a and b registers from RTE }       PROCEDURE ClassGet                $ ALIAS 'EXEC' $  
$ NOABORT, HEAPPARMS OFF $ 
    (    code:        Int16;           classnum:    Int16;       VAR bigchars:    BPCharType;          buflen:      Int16 );      EXTERNAL;  $ HEAPPARMS ON $     { Get a class buffer ( EXEC21 ) }      PROCEDURE ClassWrite           $ ALIAS 'EXEC' $   $ NOABORT $    (       code:       Int16;            cnwrd:      Int16;            buffer:     BPCharType;           buflen:     Int16;            p1:         Int16;            p2:         Int16;            classnum:   Int16 );      EXTERNAL;     { Write a class buffer ( EXEC20 ) }      	PROCEDURE DoCase;  	    FORWARD;   $   { Case on the subroutine to be executed, go do the subroutine call }  $     $PROCEDURE ErrorCatcher                     $ ALIAS 'Pas.ErrorCatcher' $  $   (    err_type:     ErrorType;          err_no:       Int16;          err_line:     Int16;          err_file:     FNameType;          err_flen:     Int16 );      FORWARD;      { Trap and recover from pascal errors }      
PROCEDURE InitializeVars;  
    FORWARD;      { initialize variables, clear pascal error flags }       $PROCEDURE InitPascalHeap;                   $ ALIAS 'Pas.InitMemInfo2' $ $    EXTERNAL;     { Have Pascal Initialize its Heap. }       "FUNCTION PascalStringData                $ ALIAS 'Pas.StringData1' $ "    ( VAR s:          String ):  PCharTypePtr;      EXTERNAL;     { return a packed array of char pointer to a string }      #PROCEDURE PascalStringEndCheck            $ ALIAS 'Pas.StrEndCheck '$  #    (     stringcheck:      Boolean );      EXTERNAL;     { Truncate strings instead of aborting on string errors }      $PROCEDURE RtePrint             $ ALIAS 'REIO', HEAPPARMS OFF, NOABORT $  $   ( writereq:     Int16;      conwd:        Int16;      msg:          PCharType;  
    msglen:       Int16 ); 
    EXTERNAL;     { Print a message on the scheduling terminal }       $ SUBTITLE 'DoCase', PAGE $   {------------------------------------------------------------}  {                                                            }  {                      DoCase                                }  {                                                            }  {------------------------------------------------------------}  	PROCEDURE DoCase;  	 {}   {  Purpose: To execute the subroutine the caller needs executed.   {   {  input:   none  {  output: none   {  Global Variables Accessed:   #{     initglobals- use IG_whichguy to determine which routine to call. # {     globalstring: The buffer passed by the caller.  Contains  {        the parameter list for the subroutine to be executed.  {    {  Routines called: All routines in this program, and ShootSelf.   {    {  Description: This routine looks at IG_whichguy and calls the    {     appropriate subroutine.   {}         BEGIN    { DoCase }     WITH globalstring DO         BEGIN    { WITH }             CASE initglobals.IG_whichguy OF   	         SONDONE:  	             BEGIN    { SONDONE }              continue := FALSE;              END;     { SONDONE }      
         CCHARINPUT: 
             BEGIN    { CCHARINPUT }                   CharInput( CIpromptstring, CIcasefold, CIdefault,   "                           CIterminator, CIinput_string, CIresult ); "             END;     { CCHARINPUT }       
         CCOUNTERRORMSGS:  
             BEGIN    { CCOUNTERRORMSGS }                  CountErrorMsgs( CEtotalerrorcount );              END;     { CCOUNTERRORMSGS }      
         CERRORMSGSTODSAM: 
             BEGIN    { CERRORMSGSTODSAM }                   ErrorMsgsToDSAM( EMresult );              END;     { CERRORMSGSTODSAM }                CFILEEXISTS:               BEGIN    { CFILEEXISTS }                  FEfnreturn := FileExists( FEname1, FEresult );              END;     { CFILEEXISTS }               CFILEINTRAC:               BEGIN    { CFILEINTRAC }                  FIfnreturn := FileInteractive( FIwhichfile );               END;     { CFILEINTRAC }               CHANDLEDEFF:               BEGIN    { CHANDLEDEFF }      "            HandleDefFileName( HDfilename, HDname_base, HDresult );  "             END;     { CHANDLEDEFF }      
         CINTINPUT:  
             BEGIN    { CINTINPUT }      %            IntInput( IIpromptstring, IIdefault, IIterminator, IIhi_value, %                     IIlo_value, IIint16_value, IIpassed_result );               END;     { CINTINPUT }               CMSGFILEPRINT:               BEGIN    { CMSGFILEPRINT }      "            MsgFilePrint( MFmsgnumber, MFwhichroutine, MFprintinfo,  "                    MFresult );              END;     { CMSGFILEPRINT }      
         COPENINPUT: 
             BEGIN    { COPENINPUT }                   OpenInput( OIresult );              END;     { COPENINPUT }       	         COPENLOG: 	             BEGIN    { COPENLOG }                   OpenLog( OLresult );              END;     { COPENLOG }                COPENOUTPUT:               BEGIN    { COPENOUTPUT }                  OpenOutput( OOresult );               END;     { COPENOUTPUT }               CPRINTERROR:               BEGIN    { PRINTERROR }                   PrintError( PEerror_msg, PEresult );              END;     { PRINTERROR }                CPRINTPROMPT:              BEGIN    { CPRINTPROMPT }       %            PrintPrompt( PPSavePrompt, PPpromptstring, PPpassed_result );  %             END;     { CPRINTPROMPT }       (*           CREADFROMLOG:              BEGIN    { CREADFROMLOG }                   ReadFromLog( RLinput_string, RLresult );              END;     { CREADFROMLOG }   *)      
         CREADINPUT: 
             BEGIN    { CREADINPUT }                   ReadInput( RIinput_string, RLresult );              END;     { CREADINPUT }                CSAYOUTEDIT:               BEGIN    { CSAYOUTEDIT }                  SayOutputNeedsEdit;               END;     { CSAYOUTEDIT }      (*           CSAYUSEINPUT:              BEGIN    { CSAYUSEINPUT }                   SayUsingInputAgain;               END;     { CSAYUSEINPUT }   *)      
         CWORDINPUT: 
             BEGIN    { CWORDINPUT }       #            WordInput( WRpromptstring, WRdefault, WRstring_of_tokens,  #                WRtoken_from_user, WRpassed_result );              END;     { CWORDINPUT }                CWRITEINPUT:               BEGIN    { CWRITEINPUT }                  WriteOnInput( WIwrite_string, WIresult );               END;     { CWRITEINPUT }      
         CWRITELOG:  
             BEGIN    { CWRITELOG }                  WriteOnLog( WLwrite_string, WLresult );               END;     { CWRITELOG }               CWRITEOUTPUT:              BEGIN    { CWRITEOUTPUT }                   WriteOnOutput( WOwrite_string, WOresult );              END;     { CWRITEOUTPUT }                CYESNOINPUT:               BEGIN    { CYESNOINPUT }                   YesNoInput( YIpromptstring, YIdefault, YIyesnovalue,                  YIpassed_result );               END;     { CYESNOINPUT }      	         OTHERWISE 	             BEGIN    { Otherwise }                  WITH errorstring DO                  BEGIN    { WITH }                 ES_number := EOTHERWISE;                  ES_regs[1].CIOrCType[1] :=                       CHR( PARSERPROG + INT_TO_CHAROFFSET );                 END;     { WITH }                  ShootSelf( errorstring );               END;     { Otherwise }  
         END;     { CASE } 
       END;     { WITH }      END;     { DoCase }      $ SUBTITLE 'ErrorCatcher', PAGE $   {------------------------------------------------------------}  {                                                            }  {                    ErrorCatcher                            }  {                                                            }  {------------------------------------------------------------}  PROCEDURE ErrorCatcher    (    err_type:     ErrorType;          err_no:       Int16;          err_line:     Int16;          err_file:     FNameType;          err_flen:     Int16 );       {}  #{  Purpose: To handle pascal errors internally instead of blowing up.  # {   {  Input: err_type-  The type of error that occurred  {         err_no-    the numeric value of the error.  "{         err_line-  the line number in the program where the error  " {                      occurred   "{         err_file   the file name associated with the error, if any " %{         err_flen   the length of the filename associated with the error  % {   {  Output:  none  {  Global variables accessed:   %{      Init_Dec booleans to indicate what type of operation is being done- % {           opening- opening a file   {           reading- reading from a file  {           converting- converting a string to a number   {   &{  Global variables Changed:  hiterror- set to TRUE when routine is entered  & "{                             pascal_error record has its fields set " {                                to err_type and err_no.  {   '{  Routines Called:  RtePrint to print error if condition is not recoverable.  ' %{     ShootSelf which TERMINATES the program if the error is not handled.  % {}      VAR      handled:    Boolean;      nextpos:    Int16;          BEGIN    { ErrorCatcher }      #   { if hiterror flag already set we may be in infinite loop.  Halt. } # 
   IF hiterror THEN  
       BEGIN    { potential loop }         stringof80 := NSINITE[EERRORCATCH2] + 'NSPARS. **';              RtePrint( XWRITEREQ, LU1, PascalStringData( stringof80 )^,               -Strlen( stringof80 ));            BEGIN    { error on rte print }  
         { ignore errors } 
          END;     { error on rte print }            Halt( 1 );        END;     { potential loop }          { set global indicating got to the error catcher }   
   hiterror := TRUE; 
        { clear flag indicating we can handle this error }   
   handled := FALSE; 
     
   CASE err_type OF  
           FMP:  BEGIN    { fmp }                  IF opening THEN                  BEGIN    { openers handle }                 handled := TRUE;                  END;     { openers handle }              END;     { fmp }            RUN:  BEGIN    { run }              IF (( converting ) AND (( err_no = OVERFLOW ) OR  "                ( err_no = NOSTRING ) OR ( err_no = NULLINT ))) THEN "                    BEGIN    { ascii converter handles }                  handled := TRUE;                  END;     { ascii converter handles }               END;     { run }            I_O:  BEGIN    { io }               IF (( reading ) AND (( err_no = EOFERROR ) OR                   ( err_no = TOOLONG ))) OR                   (( converting ) AND ( err_no = INVALIDINT )) THEN                      BEGIN    { input handles }                  handled := TRUE;                  END;     { input handles }               END;     { io }       	      OTHERWISE ;  	           END;     { CASE }          IF NOT handled THEN        BEGIN    { not handled }        stringof80 := '';       #      Strwrite( stringof80, 1, nextpos, '** (9013) NS: Pascal Error ', # !         err_no:1, ' of type ', err_type, ' at line ', err_line:1, !          ' in NSPARS.**' );              RtePrint( XWRITEREQ, LU1, PascalStringData( stringof80 )^,               -Strlen( stringof80 ));            BEGIN    { error on rte print }  
         { ignore errors } 
          END;     { error on rte print }            IF err_type = FMP THEN           BEGIN    { print fmp info }  
         stringof80 := ''; 
          nextpos := 0;      %         Strwrite( stringof80, 1, nextpos, '** (9014) NS: File Name is ',  %             err_file:err_flen, '.**' );       "         RtePrint( XWRITEREQ, LU1, PascalStringData( stringof80 )^,  "                -Strlen( stringof80 ));              BEGIN    { error on RTE print }                   { ignore errors }               END;     { error on RTE print }            END;     { print fmp info }            { EXIT THE PROGRAM. }   
      WITH errorstring DO  
 
         BEGIN    { WITH } 
          ES_number := EERRORCATCHER;           ES_regs[1].CIOrCType[1] :=                       CHR( PARSERPROG + INT_TO_CHAROFFSET );  
         END;     { WITH } 
           ShootSelf( errorstring );             END      { not handled }       ELSE         BEGIN     { handled }   
      WITH pascal_error DO 
          BEGIN       { with }            ernumber := err_no;           ertype := err_type;           END;        { with }   
      END;     { Handled } 
        END;     { ErrorCatcher }      $ SUBTITLE 'InitializeVars', PAGE $   {------------------------------------------------------------}  {                                                            }  {                 InitializeVars                             }  {                                                            }  {------------------------------------------------------------}  
PROCEDURE InitializeVars;  
 {}  {  Purpose: To initialize the globals in this program.  {   {  Input:   none  	{  Output:   none  	 {  Global Variables Accessed:   {   !{     pascal error flags: hiterror, converting, reading, opening,  ! {        and pascal_error.ernumber.   {   #{  Routines Called: PasStringEndCheck so pascal truncates long strings # {     instead of hitting the error catcher.   {   {}         BEGIN    { InitializeVars }         { clear all pascal error flags }      hiterror := FALSE;      converting := FALSE;   
   reading := FALSE; 
    pascal_error.ernumber := 0;         { turn string end checking off for pascal }     PascalStringEndCheck( FALSE );          END;     { InitializeVars }      $ SUBTITLE 'NSPARS', PAGE $   {------------------------------------------------------------}  {                                                            }  {                      NSPARS                                }  {                                                            }  {------------------------------------------------------------}     BEGIN    { NSPARS }      	   InitializeVars; 	        ChildWake( PARSERPROG );          REPEAT             { Wait for someone to need one of my subroutines. }         globalstring.CCBChars := '';      #      { Get the buffer from the caller that has the global variables,  # "        which subroutine to call, which class to write the reply to, " $        and all the subroutine's parms.                               }  $           ClassGet( NAEXEC21, myclass + SAVECLASSBIT,               globalstring.CCBChars, -BIGSTRSIZE );            BEGIN    { error on exec }            WITH errorstring DO              BEGIN    { WITH }                ABReg( ES_regs[1].IIorCType, ES_regs[2].IIorCType );               ES_number := ECLGET;              END;     { WITH }                MultiError( errorstring );            END;     { error on exec }             { get the buffer length (transmission log) }        ABReg( a_reg.IIOrCType, glen );         IF glen <= 0 THEN            BEGIN    { length error }           WITH errorstring DO              BEGIN    { WITH }               ES_regs[1].CIOrCType[1] :=                      CHR( PARSERPROG + INT_TO_CHAROFFSET );              ES_number := ECLGETLENGTH;              END;     { WITH }                MultiError( errorstring );            END;     { length error }                { Get the globals from the class buffer.  "        NSINIT sets whichguy to SONDONE to tell son to terminate. }  "       initglobals := globalstring.globIGs;      !      { assume want to contine, DoCase will clear this flag if it  ! "         finds out NSINIT is done with NSPARS.                    }  "       continue := TRUE;           %      { Call the appropriate subroutine based on initglobals.IG_whichguy } %       DoCase;             IF continue THEN           BEGIN    { send caller a message }                { copy the globals back to the class I/O buffer, the   $           return parameters were already put there by the subroutine }  $          globalstring.GlobIGs := initglobals;                { write the caller its reply }            Classwrite( NAEXEC20, 0, globalstring.CCBChars,              -BIGSTRSIZE, 0, 0, initglobals.IG_callerclass );              BEGIN    { exec error }               WITH errorstring DO                  BEGIN    { WITH }  "               ABReg( ES_regs[1].IIorCType, ES_regs[2].IIorCType );  "                ES_number := ECLWRITE;                  END;     { WITH }                  MultiError( errorstring );              END;     { exec error }                END;     { send caller a message }       
      UNTIL NOT continue;  
        END.     { NSPARS } 