 $PASCAL ',7 91790-1X180 REV.4010 <860321.1013> '  $STANDARD_LEVEL 'HP1000'  $debug$   "$HEAP 2, HEAPPARMS OFF, HEAP_DISPOSE OFF, RECURSIVE OFF, RANGE OFF$  "     MODULE PROBINIT;  
$ALIAS 'N$PROBINIT'  
     {------------------------------------------------------------    (c) COPYRIGHT HEWLETT PACKARD COMPANY 1986. ALL RIGHTS    RESERVED. NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED,   REPRODUCED OR TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT    THE PRIOR WRITTEN CONSENT OF THE HEWLETT-PACKARD COMPANY.   ------------------------------------------------------------}  {}  {     NAME:   PROBINIT  
{     SOURCE: 91790-18180  
 	{     RELOC:  NONE 	 	{     PGMR:   EMS  	 {}      {}  {------------------------------------------------------------   { MODIFICATIONS:  {   {  Date   PCO  Prgmr Description  "{  860225      lms   correct error handling at init/shutdown (n356). " !{                    Also moved some error strings to NSINIT.MSG.  !  {  860319      lms   Add dres and init_rte_if to imports (n370).   {  Last edit: <860321.1013>   {   {------------------------------------------------------------   {}      {}  { PROGRAM DESCRIPTION:  {   {  Probe initialization module.   {}      IMPORT      $SEARCH 'phtm/BODEC.REL'     bodec,   $SEARCH 'phtm/SODEC.REL'     sodec,   $SEARCH 'phtm/MMDEC.REL'     mmdec,   $SEARCH 'phtm/MMEXT.REL'     ds_mm,   
$SEARCH 'phtm/TRCMOD.REL'  
    trcmod,  
$SEARCH 'phtm/SIGMOD.REL'  
    sigmod,  $SEARCH 'phtm/LKLB.REL'      lk,  
$SEARCH 'phtm/TMRDEC.REL'  
    tmrdec,  $SEARCH 'phtm/TCPGB.REL'     tg,  $SEARCH 'phtm/TUSER.REL'     tuser,   $SEARCH 'phtm/IPDEC.REL,phtm/IPLIB.REL,phtm/IPDB.REL'      iplib,   $SEARCH 'phtm/IPPATH.REL,phtm/IPPCTL.REL,phtm/IPACTP.REL'      ippath,  $SEARCH 'phtm/TCPLB.REL'     tl,  $SEARCH 'phtm/PXPLB.REL'     px,  $SEARCH 'phtm/lan8.xpt'      lan8,  
$SEARCH 'phtm/sreglib.rel' 
    sreglib,   $SEARCH 'phtm/lanui.xpt'     lanui,   $SEARCH 'phtm/init_dec.rel'      init_dec,  $SEARCH 'phtm/initmulti.xpt'     initmulti,   
$SEARCH 'phtm/parsdd.xpt'  
    parser,  
$SEARCH 'phtm/filemad.xpt' 
    fileman,   $SEARCH 'phtm/dres.xpt'      dres,  $SEARCH 'phtm/init_rte_if.xpt'     init_rte_if,   
$SEARCH 'phtm/laninit.xpt' 
    laninit,   $SEARCH 'phtm/prbdec.rel'$ {Probe data structure declarations}     prbdec,  
$SEARCH 'phtm/ipinid.rel'  
    ipinit;      $SUBTITLE ' Export procedures ', PAGE$      EXPORT      {--------------------------------------------------------}  {                                                        }  {          EXPORT   PROCEDURES                           }  {                                                        }  {--------------------------------------------------------}          	PROCEDURE SynPROB  	    (VAR smbsize     : Int16;      VAR dsamtbsize  : Int16;      VAR socketcnt   : Int16;      VAR classcnt    : Int16;      VAR resourcnt   : Int16;      VAR result      : Int16);           	PROCEDURE ShutPROB 	    (    trustvar    : TrustType;      VAR result      : Int16);           	PROCEDURE InitPROB 	    (VAR result : Int16);      {----------------------------------------------------}  {               Implement Section                    }  {----------------------------------------------------}      IMPLEMENT       CONST      { The constants below are to be used as indices into the      { userinput array.      {}   
   Q_MAX_PCBS        =  1; 
 
   Q_RETRY_INTERVAL  =  2; 
        FIRSTINTQ         =  Q_MAX_PCBS;      LASTINTQ          =  Q_RETRY_INTERVAL;       
   TARGET_INDEX = 1; 
 
   PROXY_INDEX = 2;  
         CONST      FIRSTBANN =           1;      DEFPCBBANN =          2;      LASTBANN =            5;      CHANGEDEFQ =          6;      PCBQ1 =               7;      PCBQ2 =               8;      TIMEOUTQ  =           9;      NREGSERVQ =          10;      GWYSERVQ =           11;      FIRSTMCASTBANN =     12;      LASTMCASTBANN =      16;      CHANGEMCASTDEFQ =    17;      FIRSTMCENTRYBANN =   18;      LASTMCENTRYBANN =    22;      LANIEEE802 =         23;   %   MCASTOFFSET =        23;  { This is so the index into PROBEMSG will be  % &                               correct for multicast addr entry (24 & 25). } &        LASTPROBEMSG =       25;           TYPE     ProbeMsgType = Array[1..LASTPROBEMSG] OF IStringType;      CONST      PROBEMSG = ProbeMsgType[      IStringType[      '*+++        PROBE      +++*'],     IStringType[      '* Maximum number of active PCB Records:      '],     IStringType[      '* Retry interval timeout in centi-seconds:  100'],     IStringType[      '* Proxy Nodal Registry Server:              No'],      IStringType[      '*'],     IStringType[      '* Do you want to modify these values [Y/(N)]:_'],      IStringType[   !   '* Enter the maximum number of PCB Records.  The maximum is '], !    IStringType[      ' based on previous responses. [1..('],     IStringType[   & '* Enter the retry interval timeout in centi-seconds [50..(100)..200]:_'],  &    IStringType[   !   '* Do you want to be a Proxy Nodal Registry Server [Y/(N)]:_'], !    IStringType[      '* Do you want to be a Gateway Server [(Y)/N]:_' ],     IStringType[      '*'],     IStringType[      '* Default IEEE-802 Multicast Addresses for Probe:'],     IStringType[      '*    Target Address: 09-00-09-00-00-01'],      IStringType[      '*    Proxy Address:  09-00-09-00-00-02'],      IStringType[      '*'],     IStringType[      '* Do you want to modify these values [Y/(N)]?_'],      IStringType[      '* For each IEEE-802 LU enter the following:'],     IStringType[      '* Target multicast address: HH-HH-HH-HH-HH-HH '],      IStringType[      '* Proxy multicast address:  HH-HH-HH-HH-HH-HH '],      IStringType[      '* Where H is one hexadecimal digit.  Type /E to end.'],      IStringType[      '*'],     IStringType[      '* IEEE-802 LU  '],     IStringType[      '* Enter a target address [/D = 09-00-09-00-00-01]:_'],     IStringType[      '* Enter a proxy address [/D = 09-00-09-00-00-02]:_']     ];       TYPE     QuestArrayType = Array[FIRSTINTQ..LASTINTQ] OF Int16;         LanTabPtr = ^LanTabEntry;         LanTabEntry = RECORD         LT_link:    LanTabPtr;        LT_info:    McastInfo;        END;      VAR      are_nreg_server:     Boolean;     are_gateway_server:  Boolean;     dummy:               Int16;     lantabhead:          LanTabPtr;     lantabtail:          LanTabPtr;     message:             PromptType;      update_mcastaddrs:   Boolean;     userinput:           QuestArrayType;       
$SUBTITLE 'SynPROB',PAGE$  
  {-------------------------------------------------------------}     {                                                             }     {                      SynPROB                                }     {                                                             }     {-------------------------------------------------------------}        	PROCEDURE SynPROB  	    (VAR smbsize     : Int16;      VAR dsamtbsize  : Int16;      VAR socketcnt   : Int16;      VAR classcnt    : Int16;      VAR resourcnt   : Int16;      VAR result      : Int16);           {}  "{ Description: Get user input to PROBE configuration items; perform  "  {   validity check on the inputs; returns DSAM Table size to the   {   caller.   {   { Parameters:  ( all assumed to be 0 on input )   {   dsamtbsize (output)   {   socketcnt  (output)   {   classcnt   (output)   {   resourcnt  (output)   {   smbsize    (output)   {   result     (output)    Set to zero if successful.   {}      LABEL      99;      CONST      LOVALUES = QuestArrayType[1,50];   
   CASEFOLD  = TRUE; 
     TYPE     McastStringType = String[17];  $   McastArrayType = Array[TARGET_INDEX..PROXY_INDEX] OF McastStringType; $     CONST      DEFMCAST = McastArrayType[      McastStringType['09-00-09-00-00-01'],     McastStringType['09-00-09-00-00-02']];       VAR      hivalues:  QuestArrayType;      defvalues:  QuestArrayType;  VAR      answer:              OneCharType;     default:             Boolean;     index:               Int16;     internal_result:     Int16;     terminator:          Boolean;      
PROCEDURE AskIfGwyServer;  
    FORWARD;       	PROCEDURE ExitSyn  	 (    errorparm:      Int16 );      FORWARD;       PROCEDURE GetMcastAddrs;     FORWARD;       
PROCEDURE GetNonDefValues; 
    FORWARD;       
PROCEDURE PrintInfo  
 (     startoffset:      Int16;        endoffset:        Int16 );     FORWARD;       PROCEDURE PutAddrInEMA  (    lan_lu:            Int16;       mcast_addr:        StatAddr;        index:             Int16 );     FORWARD;       $ SUBTITLE 'AskIfGwyServer', PAGE $   {-----------------------------------------------------}   {         AskIfGwyServer (SynProb)                    }   {-----------------------------------------------------}   
PROCEDURE AskIfGwyServer;  
    BEGIN    { AskIfGwyServer }      #   { Now find out if IP thinks we are a gateway.  If we are a gateway, # $     ask the user if the node should be a gateway server.              } $    IF initglobals.IG_are_gateway THEN         BEGIN    { ask if want to be server }             default := TRUE;  %      YesNoInput( PROBEMSG[GWYSERVQ], default, answer, internal_result );  % !      IF internal_result <> GOOD THEN ExitSyn( internal_result );  !           IF (( default ) OR ( answer ='Y' )) THEN           BEGIN    { change module boolean }                are_gateway_server := TRUE;           END      { change module boolean }         END;     { ask if want to be servers }         { Assume are_gateway server pre-initialized to FALSE }      END;     { AskIfGwyServer }      $ SUBTITLE 'ExitSyn', PAGE $  {-----------------------------------------------------}   {              ExitSyn  (SynProb)                     }   {-----------------------------------------------------}   	PROCEDURE ExitSyn  	 (    errorparm:      Int16 );      BEGIN    { ExitSyn }          result := errorparm;          { used so there is only one GOTO in this procedure }      GOTO 99;          END;     { ExitSyn }       $ SUBTITLE 'GetMcastAddrs', PAGE $  {-----------------------------------------------------}   {                GetMcastAddrs (SynProb)              }   {-----------------------------------------------------}   PROCEDURE GetMcastAddrs;  {}   {  Purpose: To ask the user for the multicast addresses for each   {  Lan LU they entered in the IP section of NSINIT.   {   {  Input: none  {  Output: none   !{  Global Variables changed: This routine builds a multicast list  ! {     in EMA by calling PutAddrInEma.   {   {  Routines called: Internal proc: NotifyBadLanAddr,  {     PutAddrInEma, CharInput, UserToInternal, PrintPrompt,   {     MsgFilePrint, PrintInfo, ExitSyn.   {   !{ Algorithm: For Each Lan LU, print the lu, ask for the target and ! #{     proxy mcast addrs. Check that the addr is a valid lan addr, and  # #{     a valid mcast addr.  If ok, save addr in ema.  If not ok, print  # !{     message, abort if not interactive, reprompt if interactive.  ! {   {}      VAR      addrbits:         MMFlagsType;      default:          Boolean;      goodresponse:     Boolean;      ierr:             Int16;      index:            Int16;      internal_result:  Int16;      lan_index:        Int16;      lan_lu:           Int16;      temp_mcast:       StatAddr;     terminator:       Boolean;      user_string:       IStringType;      $ SUBTITLE 'NotifyBadLanAddr (GetMcastAddrs)', PAGE $   {-------------------------------------------------------}   {  NotifyBadLanAddr (GetMcastAddrs (SynProb))           }   {-------------------------------------------------------}   
PROCEDURE NotifyBadLanAddr 
 (     errormsgnumber:      Int16 );   {}  !{  Purpose: To print a message telling the user an error occurred  ! {     getting the lan mcast addrs, and to attempt to recover.   {   #{  Input: errormsgnumber- The offset into the probe array of messages. # {  Output: none   {   {  Global Var Accessed: initglobals.IG_interactive is checked.  {   {  Routines Called: MsgFilePrint, SayOutputNeedsEdit, ExitSyn.  {   !{  Side Effects: ExitSyn is called to go to the end of SynProb on  ! {     printing errors.  The routine is also called to bail out  {     if the input device is not interactive.   {   "{  Description: Get the appropriate error message, call MsgFilePrint " #{     to print it.  Inform the user the output file may need updating. # !{     If the input device is not interactive, tell the user NSINIT ! {     is aborting due to input error, bubble an error message   {     back to SynProb.  {   {}         BEGIN       { NotifyBadLanAddr }       !   MsgFilePrint( errormsgnumber, PMT_ERROR, 0, internal_result );  !    IF internal_result <> GOOD THEN ExitSyn( internal_result );         SayOutputNeedsEdit;     IF NOT initglobals.IG_interactive THEN         BEGIN    { must abort }         { input error, must abort }         { !!! watch that message is printed here }            ExitSyn( ERRUSERINPUT );        END;     { must abort }          { If interactive and bad addr will reprompt for new addr }      END;        { NotifyBadLanAddr }       $ SUBTITLE 'GetMcastAddrs', PAGE $     BEGIN    { GetMcastAddrs }      { Set up ema list head/tail }     lantabhead := NIL;      lantabtail := NIL;       	   lan_index := 1; 	        { Print multicast banners }     PrintInfo( FIRSTMCENTRYBANN, LASTMCENTRYBANN );     { routine will exit on error }          REPEAT             internal_result := GOOD;            { Continue asking Lan S/W in IP for a LAN lu          until it returns EMPTYLU                  }             LanFetchLu( lan_index, lan_lu, ierr );        IF ierr = 0 THEN           BEGIN    { continue prompting user }       $         { increment the lan_index for the next time through the loop }  $          lan_index := lan_index +1;                { Build the prompt for the user with the LU in it }           message := '';            Strwrite( message, 1, index, PROBEMSG[LANIEEE802],               lan_lu:1, ':' );           PrintPrompt( FALSE, message, internal_result );  "         IF internal_result <> GOOD THEN ExitSyn( internal_result ); "              terminator := FALSE;                FOR index := TARGET_INDEX TO PROXY_INDEX DO              BEGIN    { FOR }  !            { get 2 mcast addrs: Target and Proxy from the user }  !                 goodresponse := FALSE;      	            REPEAT 	                 { Keep asking same question until user enters the   #                 correct response if interactive.  If not interactive, # $                 Loop will be exited on first invalid response.        } $                    default := TRUE;       %               CharInput( PROBEMSG[MCASTOFFSET+index], CASEFOLD, default,  %                   terminator, user_string, internal_result );   %               IF internal_result <> GOOD THEN ExitSyn( internal_result ); %                    IF default THEN                    user_string := DEFMCAST[index];                      { convert string to lan station address }                 UserToInternal( user_string, temp_mcast,                                                 internal_result );                   IF internal_result = GOOD THEN                     BEGIN    { check bits of addr }                         { get addresss as a bit stream }                    addrbits.int := temp_mcast[1];                        { See if addr is true Multicast addr }                    IF addrbits.bits[-8] THEN                        BEGIN    { save addr }                        { Addr is ok; save it in EMA }                            goodresponse := TRUE;                        PutAddrInEma( lan_lu, temp_mcast, index );                         END      { save addr }                       ELSE                       BEGIN    { bad bits }  !                     { Addr is a Lan addr; but not an mcast addr } !                          NotifyBadLanAddr( BAD_LAN_BITS );                       END;     { bad bits }                    END      { check bits of addr }                    ELSE                     BEGIN    { bad addr }                     { Addr is not a Lan addr }                        NotifyBadLanAddr( BAD_LAN_ADDR );                     END;     { bad addr }                  UNTIL goodresponse;              END;     { FOR }           END;     { continue prompting user }             UNTIL (( terminator ) OR ( ierr <> 0 ));         IF (( ierr <> 0 ) AND ( ierr <> EMPTYLU )) THEN        BEGIN    { internal_error }       $      MsgFilePrint( PROBE_MCASTERR, PMT_ERROR, ierr, internal_result );  $       ExitSyn( ERR_ALREADY_PRINTED );         END;     { internal_error }      END;     { GetMcastAddrs }       $ SUBTITLE 'GetNonDefValues', PAGE $  {-----------------------------------------------------}   {              GetNonDefValues  (SynProb)             }   {-----------------------------------------------------}       
PROCEDURE GetNonDefValues; 
     {}  { Abstract:    {  This procedure may be called to read in values for parameters   {  that the nodal manager doesn't wish to see configured.   {   { Global Output Parameters (side effects):  {    {  userinput[Q_MAX_PCBS]: The number of PCB records that should    {     be allocated for Probe's use.   {   "{  userinput[Q_MAX_RETRY_INTERVAL]: The retry interval, measured in  " {     tenths of seconds, that Probe should use.   {    {  are_nreg_server: Set to TRUE if the local node should assume    {     the role of proxy name server.  {   {  Routines Called: IntInput, YesNoInput, ExitSyn.  {   {  Side Effects: Will call ExitSyn to go to the end of SynProb  {     on error returns from IntInput, YesNoInput.   {}      VAR      index:      Int16;          BEGIN    { GetNonDefValues }      terminator := FALSE;          FOR index := FIRSTINTQ TO LASTINTQ DO        BEGIN    { get integer input }        default := TRUE;      
      CASE index OF  
     
         Q_MAX_PCBS: 
             BEGIN    { Q_MAX_PCBS }                   { set up pcb question prompt }              message := PROBEMSG[PCBQ1];               Strwrite( message, Strlen( message ), dummy,                 PROBEMSG[PCBQ2], defvalues[FIRSTINTQ]:1, ')..',                 hivalues[FIRSTINTQ]:1, ']:_' );              END;    { Q_MAX_PCBS }      
         Q_RETRY_INTERVAL: 
             BEGIN    { Q_RETRY_INTERVAL }                   { Set up retry interval prompt }              message := PROBEMSG[TIMEOUTQ];              END;     { Q_RETRY_INTERVAL }                OTHERWISE   ; { This is an internal error condition }  
         END; {CASE index} 
           IntInput( message, default, terminator, hivalues[index],           LOVALUES[index], userinput[index], internal_result );  !      IF internal_result <> GOOD THEN ExitSyn( internal_result );  !     #      { if user wants defaults the userinput variable is already set } #           END;     { get integer input }         { now get Nreg server response }   
   default := TRUE;  
 $   YesNoInput( PROBEMSG[NREGSERVQ], default, answer, internal_result );  $    IF internal_result <> GOOD THEN ExitSyn( internal_result );         IF answer = 'Y' THEN         are_nreg_server := TRUE;         END;     { GetNonDefValues }       $ SUBTITLE 'PrintInfo', PAGE $  {-----------------------------------------------------}   {            PrintInfo (SynProb)                     }  {-----------------------------------------------------}   
PROCEDURE PrintInfo  
 (     startoffset:      Int16;        endoffset:        Int16 );  {}  {  Purpose: To print prompts on the appropriate devices.  {   {  Input: startoffset: Starting offset into the prompt array.   {         endoffset:   last prompt to be printed.   {   {  Side Effects: Will call ExitSyn to exit out of synprob if  {     an error is returned from PrintPrompt.  {   {  Routines Called: PrintPrompt, ExitSyn.   {   {}      VAR      index:      Int16;       
   BEGIN    { PrintInfo }  
        FOR index := startoffset TO endoffset DO         BEGIN    { do a print }         IF index = DEFPCBBANN THEN           BEGIN    { handle special case }                message := PROBEMSG[index];           Strwrite( message, Strlen( message ), dummy,                                          defvalues[FIRSTINTQ]:1 );                 PrintPrompt( FALSE, message, internal_result );           END      { handle special case }           ELSE           BEGIN    { print as usual }            PrintPrompt( FALSE, PROBEMSG[index], internal_result );            END;     { print as usual }      !      IF internal_result <> GOOD THEN ExitSyn( internal_result );  !       END;     { do a print }       
   END;     { PrintInfo }  
     $SUBTITLE 'PutAddrInEMA',PAGE$   {-------------------------------------------------------------}     {              PutAddrInEMA   (SynProb)                       }     {-------------------------------------------------------------}        PROCEDURE PutAddrInEMA  (    lan_lu:            Int16;       mcast_addr:        StatAddr;        index:             Int16 );  {}  !{  Purpose: To put a multicast address into EMA so it can be saved ! {     until initialization time.  {   {  Input: lan_lu- Lan lu for the multicast addresses  {         mcast_addr- address to be saved   {         index- indication of which address is being saved.  {                =TARGET_INDEX- save as target addr   {                =PROXY_INDEX- save as proxy addr   {                OTHERWISE-    internal error.  {   {  Output: none   {    {  Global Var accessed: This routine builds the mcast addr list    {     in EMA. It updates lantabhead and lantabtail.   {   {  Routines called: none  {   !{  Expected Use: This routine will be called successively to store ! {     the target addr, and then the proxy addr.   #{     The ema storage is allocated when the target addr is requested.  # {     There is room for both addrs, and the lan lu.  When the   {     proxy addr is stored it is assumed that the target addr   {     Lan lu is the same lu as the proxy addr lan lu.   {}      VAR      lantabvar:     LanTabPtr;         BEGIN    { PutAddrInEMA }     CASE index OF      
      TARGET_INDEX:  
          BEGIN    { target index }               { get space for this entry in ema }  
         New( lantabvar ); 
     !         { always make variable's link pointer point to nothing }  !          lantabvar^.LT_link := NIL;       !         { Put the target addr and the lu into the new variable }  !          WITH lantabvar^.LT_info DO               BEGIN    { WITH }                   mc_target := mcast_addr;              mc_lu := lan_lu;              END;     { WITH }                IF lantabhead = NIL THEN               BEGIN    { special case first item in list }                  { make the head point to the variable }               lantabhead := lantabvar;              END      { special case first item in list }             ELSE               BEGIN    { insert at end of list }                  { Change the link of the entry pointed to by                 the tail from NIL to point to the new variable.  }               lantabtail^.LT_link := lantabvar;               END;     { insert at end of list }                { always make the tail now point to the new variable }             lantabtail := lantabvar;            END;     { target index }      	      PROXY_INDEX: 	          BEGIN    { proxy index }                 { Put the proxy address into the last variable inserted   $           onto the list.  Note we assume the variable is on the list. } $              WITH lantabtail^.LT_info DO              BEGIN    { WITH }                   mc_proxy := mcast_addr;               END;     { WITH }            END;     { proxy index }             OTHERWISE ;    { internal error condition }             END;     { CASE }          END;     { PutAddrInEMA }      
$SUBTITLE 'SynPROB',PAGE$  
 	   BEGIN {SynPROB} 	        { Assume all variables cleared by DSINIT }      internal_result := GOOD;          { Set up the hi value array.   $     The max. number of pcb records=number of user records=number progs. $ "     The max. retry interval timeout = 20 sec (200tenths of secs). } "      hivalues[FIRSTINTQ] := initglobals.IG_tot_nodal_progs;        hivalues[LASTINTQ] := 200;          { set up the default value array. }       defvalues[FIRSTINTQ] := 10;       defvalues[LASTINTQ] := 100;      $   { Set up the user input array.  Assume the user wants the defaults }  $    FOR index := FIRSTINTQ TO LASTINTQ DO        BEGIN    { FOR }  "      { Verify ranges are acheivable.  Tweek them if they are not }  "       IF defvalues[index] < LOVALUES[index] THEN                     defvalues[index] := LOVALUES[index];         IF defvalues[index] > hivalues[index] THEN                     defvalues[index] := hivalues[index];             userinput[index] := defvalues[index];             END;     { FOR }         { Pre-initialize server booleans for the module:                default for nodal registry server is NOT to be one.                default for gateway server is NOT to be one.  #            default for updating mcast addrs is NOT to update them. }  #    are_nreg_server := FALSE;     are_gateway_server := FALSE;      update_mcastaddrs := FALSE;         IF NOT initglobals.IG_have_IEEE802 THEN        BEGIN       { no external probe }         { We don't have any external probe in this node.           Just update the dsam sizes for internal probe and exit }             ExitSyn( GOOD );        END;        { no external probe }          PrintInfo( FIRSTBANN, LASTBANN );     { The routine will go to the end of SynProb on error }       
   default := TRUE;  
 $   YesNoInput( PROBEMSG[CHANGEDEFQ], default, answer, internal_result ); $    IF internal_result <> GOOD THEN ExitSyn( internal_result );      $   { If default is true then the user doesn't want to change any values. $ %     Go on to the next question set.                                     } %    IF answer = 'Y' THEN         BEGIN    { ask for non-default values }             { get pcb, interval timeout, and nreg server responses }        GetNonDefValues;        { The routine will go to the end of SynProb on error }        END;     { ask for non-default values }   (*  Comment out the gateway server code for first release.  The   #boolean are_gateway_server is pre-initialized to FALSE, so commenting  # out the call to this routine is all that is required.       	   AskIfGwyServer; 	    { The routine will go to the end of SynProb on error }   *)      !   { Find out if we need to do anything with multicast addresses } !    IF initglobals.IG_have_IEEE802 THEN        BEGIN    { check mcast addrs }            PrintInfo( FIRSTMCASTBANN, LASTMCASTBANN );         { the routine will go to the end of SynProb on error }            default := TRUE;        YesNoInput( PROBEMSG[CHANGEMCASTDEFQ], default,                                  answer, internal_result );   !      IF internal_result <> GOOD THEN ExitSyn( internal_result );  !     
      IF answer = 'Y' THEN 
          BEGIN    { change mcast addrs }               update_mcastaddrs := TRUE;                GetMcastAddrs;             { the routine will go to the end of SynProb on error }             END;     { change mcast addrs }        END;     { check mcast addrs }          99:      { Always update the dsam table size for the caller.  If we   !     are also returning an error value in result the main program  ! "     will not use the value.                                      }  "    dsamtbsize := dsamtbsize + PB_PROBEGREC_SIZE +                       userinput[Q_MAX_PCBS] * PCBREC_WSIZE;       	   END;  {SynPROB} 	         $SUBTITLE 'PROB Shutdown module', PAGE$   {-------------------------------------------}   {               ShutPROB                    }   {-------------------------------------------}       	PROCEDURE ShutPROB 	    (    trustvar    : TrustType;      VAR result      : Int16 );      {}  { Description: Module to be called by NSINIT at shutdown.   {   { Parameters:   {    trustvar   (input)  Indicates potential corruption of  {                        data structures. For PROBE there no  {                        shutdown.  {   {    result     (output) Always returns successful.   {   {}         BEGIN { ShutPROB }      { Always return successfully }      result := 0;      END;  { ShutPROB }           $SUBTITLE 'InitPROB', PAGE$   {------------------------------------------------------------}  {                                                            }  {                    InitProb                                }  {                                                            }  {------------------------------------------------------------}      	PROCEDURE InitPROB 	    (VAR result:       Int16);       LABEL 100;      VAR      burstin     : Int16;      burstout    : Int16;      i           : Int16;      ierr        : Int16;      incc        : Int16;      probegrec   : ProbeGRecord;     gsd         : Int16;      outcc       : Int16;      pcbrec      : PCBRecord;      protorec    : ProtocolRecord;     wkmp        : Int16;       $ SUBTITLE 'Escape', PAGE $      PROCEDURE Escape ( error : Int16 );        BEGIN         result := error;        GOTO 100;   
      END; {Escape}  
     $ SUBTITLE 'GiveLanMcastAddrs', PAGE $  PROCEDURE GiveLanMCastAddrs   ( VAR ierr:    Int16 );   VAR      lantabvar:        LanTabPtr;              BEGIN    { GiveLanMCastAddrs }      ierr := GOOD;         IF update_mcastaddrs THEN        BEGIN    { hand info to LAN }             lantabvar := lantabhead;            REPEAT               { give values to lan software to put in dsam }   
         ierr := 0;  
          LanStoreMcast( lantabvar^.LT_info, ierr );                { update the ema pointer to the next record }           lantabvar := lantabvar^.LT_link;                UNTIL (( ierr <> 0 ) OR ( lantabvar = NIL ));            IF ierr <> 0 THEN            BEGIN    { error giving lan info }   "         MsgFilePrint( PROBE_MCASTSAVEERR, PMT_ERROR, ierr, dummy ); "          ierr := ERR_ALREADY_PRINTED;            END;     { error giving lan info }             END;     { hand info to LAN }      END;     { GiveLanMCastAddrs }       $ SUBTITLE 'InitProb', PAGE $   BEGIN    { InitProb }   ierr := GOOD;       "{ Give the lan software the multicast addrs.  Note this only happens " "  if the user updated them in the question part.  Otherwise the lan  " #  software stores the defaults itself.                               } # 
GiveLanMcastAddrs( ierr ); 
 IF ierr <> 0 THEN Escape( ierr );       DS_InitEnterCritical (wkmp, ierr);  IF (ierr <> SUCCESSFUL) THEN Escape( U_NETWORK_IS_DOWN );       #{ First we try to allocate Probe's globals record. For now we zero it  # { out., Later we'll fill in the fields.   {}  DS_GetTableSpace (DS_ProbeGTD, 1, 1, PB_PROBEGREC_SIZE, ierr);  IF (ierr <> SUCCESSFUL) THEN     BEGIN    { table space error }      DS_InitLeaveCritical( wkmp );     Escape(ierr);     END;     { table space error }       DS_GetTableSpace (DS_ProbePCBTD, 1, userinput[Q_MAX_PCBS],                     PCBREC_WSIZE, ierr);   IF (ierr <> SUCCESSFUL) THEN     BEGIN    { table space error }      DS_InitLeaveCritical( wkmp );  	   Escape (ierr);  	    END;     { table space error }       !{ NOTE: Probe's special socket should already have been allocated  !  { by NRGINIT. The socket's gsd should have been stored in IPC's    { TrackTable.   {}  
WITH probegrec, pcbrec DO  
    BEGIN     DS_FetchElement (DS_TrackTD, TL_PROBE_SOCKET, gsd);     pg_probegsd := gsd;  	   pg_nxtseq := 1; 	    pg_freeq := 1; {first PCBRecord id}  
   pg_nameq := NULL; 
 
   pg_vnaq := NULL;  
    pg_tempvnaq := NULL;      pg_vnatimerid.index := NULL;      pg_vnatimerid.key := NULL;      pg_retryinterval := userinput[Q_RETRY_INTERVAL];      pg_unsol_interval := 30000; {5 minutes}     pg_qbits.int := 0;      pg_qbits.bits[0] := are_nreg_server; {proxy server bit}      pg_qbits.bits[-1] := are_gateway_server; {gateway server bit}      pg_maxpcbid := userinput[Q_MAX_PCBS];         { First we zero out all the fields of the PCBRecord.      {}      FOR i := 0 TO ( PCBREC_WSIZE -1 ) DO         BEGIN   
      pcbrec.ints[i] := 0; 
 	      END; {FOR i} 	        { Next we link the pcbrecs together & write them into DSAM.     {}      FOR i := 1 TO (userinput[Q_MAX_PCBS] - 1) DO         BEGIN   
      pcb_nxtptr := i + 1; 
       DS_StoreElement (DS_ProbePCBTD, i, pcbrec.int);   	      END; {FOR i} 	        pcb_nxtptr := NULL; {the last pcbrec gets null pointer}  #   DS_StoreElement (DS_ProbePCBTD, userinput[Q_MAX_PCBS], pcbrec.int); #        DS_StoreElement (DS_ProbeGTD, 1,probegrec.int);     END; {WITH}      IF initglobals.IG_have_IEEE802 THEN      BEGIN      { The final thing we do, if our local node is attached to an       { IEEE-802 LAN, is to record in SocketRegistry's protocol  $   { record that Probe will be available to offer support on this node.  $    {}      DS_FetchElement (DS_ProtosTD, SREG, protorec.int);      protorec.pr_supportingpids.bits[PROBE] := TRUE;     DS_StoreElement (DS_ProtosTD, SREG, protorec.int);      END; {IF initglobals}         DS_InitLeaveCritical (wkmp);       100:;   	END; { InitPROB }  	     END   .  