 $PASCAL '91790-1X186 REV.4010 <851122.1300>'$   $STANDARD_LEVEL 'HP1000'  $debug$   $WIDTH 90   $HEAPPARMS OFF  
$RECURSIVE OFF, RANGE OFF$ 
 $HEAP 0   	$HEAP_DISPOSE OFF  	     MODULE px;  $ALIAS 'N$PX'$      {------------------------------------------------------------    (c) COPYRIGHT HEWLETT PACKARD COMPANY 1986. ALL RIGHTS    RESERVED. NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED,   REPRODUCED OR TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT    THE PRIOR WRITTEN CONSENT OF THE HEWLETT-PACKARD COMPANY.   ------------------------------------------------------------}          {}  {       NAME: PXPLB.PAS                              }  {     SOURCE: 91790-18186                            }  {      RELOC: NONE                                   }  {       PGMR: MCL                                    }  {}      IMPORT     $SEARCH 'phtm/BODEC.REL'      bodec,      $SEARCH 'phtm/SODEC.REL'      sodec,      $SEARCH 'phtm/MMDEC.REL'      mmdec,      $SEARCH 'phtm/mmext.rel'      ds_mm,      $SEARCH 'phtm/trcmod.rel'     trcmod,     $SEARCH 'phtm/sigmod.rel'     sigmod,     $SEARCH 'phtm/tmrdec.rel'     tmrdec,     $SEARCH 'phtm/tuser.rel'      tuser;           $SUBTITLE ' Export procedures ', PAGE$      EXPORT      {--------------------------------------------------------}  {          EXPORT Constants, Vars and Types              }  {--------------------------------------------------------}      TYPE         PxpLineType = PACKED Array[1..22] OF Char;           
   PxpListBufType = Record 
 
      CASE Int16 OF  
       1: (int       : Int16);   !      2: (i_phead   : Int16;   {Pointer to server port list     }  ! !          d_phead   : Int16;   {Pointer to requestor port list  }  ! !          f_phead   : Int16;   {Pointer the free path rec. list }  ! !          nxt_portid: Int16;   {pxp requestor port seed         }  ! !          pxpsndcnt : Int32;   {accumulative send count         }  ! !          pxprcvcnt : Int32;   {accumulative receive count      }  ! !          pxpbadcnt : Int32;   {Bad hppxp packet received       }  ! !          pxpdropcnt: Int32;   {number of pxp message droped    }  ! !          dbflags   : MMFlagsType); {Debug flags - Currently only  ! !                               {bit 0 is defined as trigger flag}  !       END;      PxpOptType = Packed Array [-15 .. 0] OF Boolean;          PXPPathRecType = Record   	   CASE boolean OF 	    false:( int:           Int16);   "   true: ( xp_bptr:       Int16;   {backward pointer              }  " "           xp_fptr:       Int16;   {forward pointer               }  " "           xp_sport:      Int16;   {pxp source port address       }  " "           xp_dport:      Int16;   {pxp destination port address  }  " "           xp_dn_ref:     Int16;   {llp's path pointer            }  " "           xp_ptype:      Int16;   {Pxp port type                 }  " "           xp_rt_ref:     Int16;   {ulp root reference            }  " "           xp_rt_pid:     Int16;   {ulp root pid                  }  " "           xp_up_pid:     Int16;   {ulp upward pid                }  " "           xp_up_ref:     Int16;   {ulp upward path reference     }  " "           xp_dn_pid:     Int16;   {llp's pid                     }  "            xp_option:     MMFlagsType;  "                                   {bit 0 is the one-shot option  }  " "           xp_mbufid:     Int16;   {data buffer pointer           }  " "           xp_req_cnt:    Int16;   {number of outstanding request }  "     "           xp_tout_cnt :  Int16;   {timer expiration count        }  " "           xp_toulp_cnt:  Int32;   {msg count to ulp              }  " "           xp_frmulp_cnt: Int32;   {msg count from ulp            }  " "           xp_tollp_cnt:  Int32;   {msg count to llp              }  " "           xp_frmllp_cnt: Int32;   {msg count from llp            }  " "           xp_timerid   : TimerIdType);  {timer id                 } "            END;           
  {PXP Event Logging Type} 
   PXPEVINFOTYPE = RECORD  
     CASE boolean OF 
         false: (int     : Int16);           true : (err     : Int16;                  path    : PXPPATHRECTYPE);       END;              SearchIDType = RECORD        Case Boolean OF         false: (int       : Int16);         true : (sk_sport  : Int16;   {source pxp port number }                sk_dport  : Int16;   {destination port number}                sk_dnref  : Int16);  {down-path reference    }        END;                 ListPtrType = RECORD   
      CASE Int16 OF  
       1: (int:  Int16);         2: (previous: Int16;       {Backward pointer   }            next:     Int16);      {Forward pointer    }        END;         PxpHdrType = PACKED RECORD         Case boolean OF         false:           (int         : ARRAY[1..8] OF Int16);        true:   $         (ph_sport    : Int16;       {Source port address             }  $ $          ph_dport    : Int16;       {Destination port address        }  $ $          ph_len      : Int16;       {Total packet length in bytes    }  $ $          ph_cksum    : Int16;       {Checksum word, always zero      }  $ $          ph_msgid    : Int32;       {Packet identifier               }  $ $          ph_ver      : Int3;        {HPPxp version number, zero      }  $ $          ph_cls      : Int2;        {HPPxp service class , one       }  $ $          ph_rbit     : Boolean;     {reply bit                       }  $ $          ph_ebit     : Boolean;     {error bit                       }  $ $          ph_rsved    : Int9);       {Reserved - currently not used   }  $           END;        {}  
  { PXPCntlBufType : 
    {    nxt_rqptr   : Pointer to a Mbuf chain which contains the      {                  pxp request.     {    opt_array   : Options. Not defined yet.    {}      
   PxpCntlBufType = RECORD 
       Case Boolean OF         false : (int       : Int16);        true  : (nxt_rqptr : Int16;                  opt_array : ARRAY[1..3] OF Int16);         END;          
   PxpOvlyHdrType = RECORD 
       Case Boolean OF         false: (int : ARRAY[1..12] OF Int16);         true : (bf1 : PxpcntlbufType;                 bf2 : PxpHdrType           );         END;         {}      {PxpBackOffType : Define PXP's timeout value based on     {                 the retry count.      {}      PxpBackOffType = Array[0..7] OF Int16;               CONST          {}      { Field positions of the path linkages in a     { HPPXP Path Record.      {}   
   BACKWARD_LINK     = 0;  
 
   FORWARD_LINK      = 1;  
        {PXP List-head pointers - indices of the path table }  
   PXPIPATHLISTHEAD   = 1; 
 
   PXPDPATHLISTHEAD   = 2; 
 
   PXPFPATHLISTHEAD   = 3; 
        {PXP ID for error logger}  
   PXP_LOGID         = 7;  
     
   NULL_VALUE        = 0;  
 
   PXPDEFAULT        = 0;  
        {Supported HPPxp version number}   
   PXPVERSION        = 0;  
        {Supported hppxp service class}  
   PXPCLASS          = 1;  
        {number of pxp global structures}  
   PXPLISTSIZE       = 1;  
        {size of pxp global structure}   
   SIZEOFPXPLIST     = 13; 
        {Size of pxp header in bytes}  
   SIZEOFPXPHDR      = 14; 
        {size of pxp path structure}   
   SIZEOFPXPPATH     = 25; 
        {Path Data offset pointer}      PXPDATAOFFSET        = 2;         {Size of pxp path data field}     PXPPATHDATASIZE   = SIZEOFPXPPATH - PXPDATAOFFSET;          {hppxp/1000 server port type}  
   PXPSVRPORTTYPE    = 1;  
        {hppxp/1000 request port type}   
   PXPREQPORTTYPE    = 2;  
     !   {max. number of request hppxp/1000 supports per requestor port} ! 
   PXPREQLIMIT       = 1;  
        {Max. number of request per server port allowed}      PXPSRVREQLIMIT    = PXPREQLIMIT * 10;         {hppxp/1000 overlay header1 linage size in bytes}  
   SIZEOFPXPCNTLBUF  = 8;  
        {HPPXP maximum timeout retry count}  
   PXPMAXTOCNT       =  7; 
        {hppxp maximum timeout value in centi-seconds}      PXPMAXTOVAL       =  4000; {more than a minute}         {hppxp timeout value table}     PXPTOVALTABLE     =  PxpBackOffType        [500, 1000, 1500, 1500, 2000, 2000, 2000, 4000];            {[300, 1000, 3000, 8000, 25000, 32767];}         PXPPATHINIT = PXPPathRecType        [xp_bptr:       0,         xp_fptr:       0,         xp_sport:      0,         xp_dport:      0,         xp_dn_ref:     0,         xp_ptype:      0,         xp_rt_ref:     0,         xp_rt_pid:     0,         xp_up_pid:     0,         xp_up_ref:     0,         xp_dn_pid:     0,         xp_option:     MMFlagsType [int : 0],         xp_mbufid:     0,         xp_req_cnt:    0,         xp_tout_cnt:   0,         xp_toulp_cnt:  0,         xp_frmulp_cnt: 0,         xp_tollp_cnt:  0,         xp_frmllp_cnt: 0,         xp_timerid: TimerIdType            [index: -1, key: -1]];          PXPLISTINIT  = PxpListBufType        [i_phead   : PXPIPATHLISTHEAD,         d_phead   : PXPDPATHLISTHEAD,         f_phead   : PXPFPATHLISTHEAD,         dbflags   : MMFlagsType [int: 0],         nxt_portid: 0,          pxpsndcnt : 0,          pxprcvcnt : 0,          pxpbadcnt : 0,          pxpdropcnt: 0];                 PXPHDRINIT  = PxpHdrType         [ph_sport    : 0,          ph_dport    : 0,          ph_len      : 0,          ph_cksum    : 0,          ph_msgid    : 0,          ph_ver      : 0,          ph_cls      : 1,          ph_rbit     : false,          ph_ebit     : false,          ph_rsved    : 0];          
{Event Logging Locations}  
   PXP_SETTIMER      = 1; {Activate timer routine}     PXP_SEND          = 2; {Pxp Send routine      }     PXP_SENDRSP       = 3; {Pxp Send response     }     PXP_GETENTRY      = 4; {Pxp Outbound allocat path}    PXP_QUERYRQ       = 5; {Pxp Outbound Query Request}     PXP_INSTUB        = 6; {Pxp Inbound Stub routine }    PXP_OUTSTUB       = 7; {Pxp Outbound Stub routine}                {hppxp error codes returned locally}  #  PXPEB            = 5000;               {PXP error base            }  # #  PXPNOPATHREC     = PXPEB + 1;          {local error               }  # #  PXPNOENDPOINT    = PXPEB + 2;          {no ipath record found     }  # #  PXPBADHEADER     = PXPEB + 3;          {bad packet length etc.    }  # #  PXPNOSERVICE     = PXPEB + 4;          {service class not suppoted}  # #  PXPPATHEXISTED   = PXPEB + 5;          {path/port already existed }  # #  PXPQLIMITED      = PXPEB + 6;          {server's queue is full    }  # #  PXPINTERNALERR   = PXPEB + 7;          {Internal error            }  # #  PXPBADMSG        = PXPEB + 8;          {Unkown e_msg              }  #    PXPTIMEREXPIRED  = U_RETRY_COUNT_EXHAUSTED; {timeout expired.}         {HPPxp Defined Remote error code}     PXPUNREACHABLE   = 1;     PXPBADVERSION    = 2;     PXPBADCLASS      = 3;           {hppxp port address range and other stuffs}    LLPWILDCARD        = 0;   PXPWILDCARD        = 0;   PXPMIN_DYNAMIC     = 0;      {* = 16384;}   PXPMAX_DYNAMIC     = 32767;   PXPIPOUTBOUNDIDX   = IP * EHS_PER + EHOB_OFFSET;                       {--------------------------------------------------------}  {          EXPORT   PROCEDURES                           }  {--------------------------------------------------------}      PROCEDURE InsertPXlist     (Table           : TableDescriptorIDType;      list_ptr        : Int16;      element_ptr     : Int16);       PROCEDURE SregBinding;          PROCEDURE PxpResponse      (VAR e_msg : EventMsgType);          PROCEDURE PxpGetPortAddr     (VAR  portnumber: Int16);          PROCEDURE PxpDynamicAddr  
   (    pathref   : Int16; 
     VAR dynaddr   : AddressType;      VAR addrlen   : Int16       );          PROCEDURE PxpAddElement      ( VAR sp        : Int16;        VAR stack     : TemplateControlStack;       VAR crec      : TemplateControlRecord;        VAR vnarec    : VNARecord;        VAR pathstart : Int16;        VAR rptr      : Int16;        VAR report    : PathReportRecord;       VAR dynamicptr: Int16;        VAR ierr      : Int16 );           PROCEDURE PxpBuildPath     ( VAR pathreport  : PathReportRecord;           vnaptr      : Int16;            elementptr  : Int16;            uppid       : Int16;        VAR downpid     : Int16;        VAR downref     : Int16;        VAR options     : PathOptionsRecord;        VAR bpwkmap     : Int16;        VAR px_ierr        : Int16 );          
PROCEDURE PxpLookUp  
    (VAR e_msg      : EventMsgType;          listhdptr  : Int16;           skey       : SearchIDType;      VAR error      : Int16     );           
PROCEDURE PxpOutStub 
    (VAR e_msg    : EventMsgType;      VAR result   : Int16           );           
PROCEDURE PxpInStub  
    (VAR e_msg    : EventMsgType;      VAR result   : Int16           );               PROCEDURE PxpOutbound      (VAR e_msg    : EventMsgType;      VAR result   : Int16           );           
PROCEDURE PxpInbound 
    (VAR e_msg    : EventMsgType;      VAR result   : Int16           );           	PROCEDURE PxpInit  	 
   (    maxentry  : Int16; 
     VAR px_ierr      : Int16);          IMPLEMENT       {--------------------------------------------------------}  {                   Global Variables                     }  {--------------------------------------------------------}      VAR      mm_flags        : MMFlagsType;   !   inmbufid        : Int16;          {incoming packet ptr       }  ! !   pxp_err         : Int16;          {error return              }  ! !   rsp_err         : Int16;          {response error to remote  }  ! !   new_mbufid      : Int16;          {mbuf pointer              }  ! !   px_wkmap        : Int16;          {used for critical calls   }  ! !   px_ierr         : Int16;          {used for critical calls   }  ! !   pxppath_ptr     : Int16;          {ptr to pxp's path record  }  ! !   temp_ptr        : Int16;          {temporary path ptr        }  ! !   dummyrefr       : ContextWords;   {Dummy var for event logging} ! !   pxp_port        : PxpPathRecType; {loacl copy of the path    }  ! !   temp_port       : PxpPathRecType; {temp. copy of the path    }  ! !   pxpgbls         : PxpListBufType; {local copt of pxp globals }  ! !   pxpovlyhdr      : PxpOvlyHdrType; {pxp cntl buffer + header  }  ! !   pxphdrbuf       : PxpHdrType;     {pxp header buffer         }  ! !   px_msg          : EventMsgType;   {event msg buffer          }  !         $SUBTITLE ' Forward procedures ', PAGE$   {--------------------------------------------------------}  {           FORWARD AND EXTERNAL PROCEDURES              }  {--------------------------------------------------------}          PROCEDURE ProSw      (VAR e_msg  : EventMsgType;      VAR error  : Int16);     EXTERNAL;      PROCEDURE AdrOf      (VAR bufr    : Int16;      VAR offset  : Int16;  
    VAR addr    : Int16);  
    EXTERNAL;          PROCEDURE PxpGetEntry   
   (    option     :Int16; 
 
    VAR newpath_ptr:Int16; 
     VAR error      :Int16 );     FORWARD;           $SUBTITLE 'Path list routines' ,PAGE$       !{----------------------------------------------------------------} ! !{                       InsertPXList                             } ! !{----------------------------------------------------------------} !     PROCEDURE InsertPXlist     (Table           : TableDescriptorIDType;      list_ptr        : Int16;      element_ptr     : Int16);   {}  { Description:  !{  This procedure insert the list element addressed by element_ptr ! {  into the tail of the list pointed at by list_ptr.  {   { Parameters:   {  list_ptr      INPUT   Pointer to head of a list  {  element_ptr   INPUT   Pointer to an element  {   {}      CONST      PTR_LEN  = 1;      VAR      temp_ptr  : Int16;       	BEGIN {insertlist} 	 DS_FetchFields(Table, list_ptr, temp_ptr,                     BACKWARD_LINK, PTR_LEN);  DS_StoreFields(Table, list_ptr, element_ptr,                    BACKWARD_LINK, PTR_LEN);  DS_StoreFields(Table, temp_ptr, element_ptr,                    FORWARD_LINK, PTR_LEN);   DS_StoreFields(Table, element_ptr, list_ptr,                    FORWARD_LINK, PTR_LEN);   DS_StoreFields(Table, element_ptr, temp_ptr,                    BACKWARD_LINK, PTR_LEN);  	END;  {insertlist} 	             !{----------------------------------------------------------------} ! !{                       DeleteList                               } ! !{----------------------------------------------------------------} !     
PROCEDURE DeleteList 
    (Table          : TableDescriptorIDType;       list_ptr       : Int16;       element_ptr    : Int16 );   {}  { Description:   {    This procedure delete an the element 'element_ptr' from the   {    list pointed to by 'list_ptr'.   {   { Parameters:   {    list_ptr       INPUT    list pointer {not used}  {    element_ptr    INPUT    element pointer  {   {}      VAR   
   temp_ptr : ListPtrType; 
     	BEGIN {Deletelist} 	 WITH temp_ptr DO     BEGIN     {Fetch the backward link and the forward link of the}     {target list element.                               }     DS_FetchFields(Table, element_ptr, temp_ptr.int,                        BACKWARD_LINK, 2);          {Update the linkages of the adjacent elements.      }     DS_StoreFields(Table, previous, next, FORWARD_LINK, 1);     DS_StoreFields(Table, next, previous, BACKWARD_LINK, 1);      END;   	END;  {Deletelist} 	         $SUBTITLE 'Free Pxp table entry', PAGE$   {------------------------------------------------------------}  {                     PxpFreeEntry                           }  {------------------------------------------------------------}      PROCEDURE PxpFreeEntry(pxplistptr: Int16);      {}  { Description:  {  Release the hppxp path structure to the free list.   {   
{ Global Parameters: 
 {  pxppath_ptr  INPUT  Pointer to the path record   {   {}      
BEGIN {pxpfreeentry} 
 {Reset the path record and link it to the free list}  DeleteList (DS_PXPPathTD, pxplistptr, pxppath_ptr);   
temp_port := PXPPATHINIT;  
 DS_StoreFields(DS_PXPPathTD, pxppath_ptr, temp_port.xp_sport,                     PXPDATAOFFSET, PXPPATHDATASIZE);  InsertPXList (DS_PXPPathTD, pxpgbls.f_phead, pxppath_ptr);  
pxppath_ptr := NULL_VALUE; 
 
END;  {pxpfreeentry} 
         $Subtitle 'pxp panic routine ', Page$   {--------------------------------------------}  {           PxpPanic                         }  {--------------------------------------------}      PROCEDURE PxpPanic (err_code, err_loc, path_index :Int16);      {}  { Description: Call message logger to log the error   {    message. The PXP context block (path) is also logged.  {}      CONST      OUR_PID        = 6; {PXP ID }     MSG_LEN        = SIZEOFPXPPATH + 1;      VAR      dummy_err : Int16;      pathrefr  : ContextWords;     pxpevinfo : PXPEvInfoType;       BEGIN {panic}   IF path_index > 0 THEN     BEGIN     {Get the context info from DSAM}   !   DS_FetchElement(DS_PXPPathTD, path_index, pxpevinfo.path.int);  !    END;   
pxpevinfo.err := err_code; 
 pathrefr.longint := path_index;   Log_Event(EL_ERROR, OUR_PID, err_loc, pathrefr,                MSG_LEN, pxpevinfo.int, dummy_err);  END;  {panic}           $SUBTITLE ' Pxp Timer routines', PAGE$  {------------------------------------------------------------}  {                 PXPCancelTimer                             }  {------------------------------------------------------------}      PROCEDURE PXPCancelTimer     (VAR cancelid     : TimerIdType;       VAR result       : Int16);      {}  { Description:  {    This routine calls the timer routine to cancel a active  {    timer specified by message id.   {   { Parameters:   !{    msg_id          INPUT    Sequence number associated with the  ! {                    request.   {}      
BEGIN {canceltimer}  
 IF cancelid.index >= 0 THEN      BEGIN     CancelTimer(cancelid, result);      cancelid.index := -1;     END;   
END;  {canceltimer}  
             !{----------------------------------------------------------------} ! !{                     PXPSetTimer                                } ! !{----------------------------------------------------------------} !     PROCEDURE PXPSetTimer       (timer_value   : Int32 );   {}  { Description:   {    This routine calls timer routine to set a specific timeout    {    with respect to the request.   {   { Parameters:   {    msg_id          INPUT    Request identifier.   {    timer_value     INPUT    Value in centisecond  {   
{ Global Variables:  
 {   {}      VAR      timermsg   : TimerMsgType;       BEGIN {settimer}  
WITH timermsg, pxp_port DO 
    BEGIN {with}   
   socket    := xp_up_ref; 
    signal    := TIMERABLE_1;     direction := OUTBOUND_SIG;          ActivateTimer (timer_value, timermsg, xp_timerid, pxp_err);         IF pxp_err <> 0 THEN         BEGIN         PXPPanic(pxp_err,PXP_SETTIMER, pxppath_ptr);        END;     END;  {with}   END; {settimer}           $SUBTITLE 'HPPxp Send routine', PAGE$   !{----------------------------------------------------------------} ! !{                       PxpSend                                  } ! !{----------------------------------------------------------------} !     	PROCEDURE PxpSend  	    (mbid        : Int16;      off         : Int16;  
    dlen        : Int16);  
         {}  {  Description:   {   make a copy of the data if the copyflag is true; send the   {   data and save context info. It is called by pxpoutbound   {   and pxpoutstub modules.   {   {  Parameters:  {   mbid (input) - mbuf id of the data to send or data to be  {                  copied for transmit;   {   {   off  (input) - offset to the mbuf, where the data should  {                  be copied. If off is zero then no copy is  {                  made.  {   {   dlen (input) - number of bytes to be sent.  {   {  Global Parameters:   {   pxppath_ptr, pxp_port and pxp_err.  {}      VAR      send_ptr    : Int16;       BEGIN {pxpsend}   WITH pxp_port DO     BEGIN {with}      {make a copy if we are asked to do so}   
   IF off <> 0 THEN  
       DS_MBCopy(mbid, off, dlen, send_ptr, pxp_err)      ELSE         send_ptr := mbid;                      {If no error, ship the data}      IF pxp_err = 0 THEN        BEGIN   
      WITH px_msg DO 
          BEGIN           ehport        := PXPIPOUTBOUNDIDX;            em_event      := SEND_REQUEST;            emsr_down_ref := xp_dn_ref;           emsr_mbufid   := send_ptr;            emsr_dlen     := dlen;            emsr_flags.int:= PXPDEFAULT;                {zero out the message count}            emsr_killsnd_cnt   := 0;            emsr_killrcv_cnt   := 0;            END;             xp_tollp_cnt  := xp_tollp_cnt + 1;        pxpgbls.pxpsndcnt := pxpgbls.pxpsndcnt + 1;       
      {Save context} 
 !      DS_StoreFields(DS_PXPPathTD, pxppath_ptr, pxp_port.xp_sport, !                          PXPDATAOFFSET, PXPPATHDATASIZE);         DS_StoreElement(DS_PXPLISTHDTD, 1, pxpgbls.int);            DS_LeaveCritical (px_wkmap);        Prosw(px_msg, pxp_err);         DS_EnterCritical (px_wkmap, px_ierr);         END      ELSE         BEGIN         {panic! }   
      {Save context} 
 !      DS_StoreFields(DS_PXPPathTD, pxppath_ptr, pxp_port.xp_sport, !                          PXPDATAOFFSET, PXPPATHDATASIZE);         DS_StoreElement(DS_PXPLISTHDTD, 1, pxpgbls.int);            PXPPanic(pxp_err,PXP_SEND, pxppath_ptr);        END;     END;  {with}   END;  {pxpsend}               $SUBTITLE 'Send Response to Remote', PAGE$  {-------------------------------------------}   {           PxpResponse                     }   {-------------------------------------------}       PROCEDURE PxpResponse(VAR e_msg: EventMsgType);       {}  { Description:   {    This routine formats and sends a pxp response to its peer;    {   { Parameters:   {   
{ Global Variables:  
 {    pxppath_ptr: Path record pointer.  ${    pxp_port   : Path record; used when response is triggered locally.  $ {    pxphdrbuf  : Has the incoming pxp header.  {   {}      VAR      off,   
   mc       : Int16; 
 
   buf_ptr  : Int16; 
 
   pxp_sb   : Int16; 
    vdbuf    : VectoredDataType;   
   pxprsphdr: PxpHdrType;  
 
   mflags   : MMFlagsType; 
     	BEGIN {pxprespond} 	     WITH e_msg, pxprsphdr DO     BEGIN {with}          {Build hppxp header to respond}  
   WITH pxprsphdr DO 
       BEGIN         pxprsphdr   := PXPHDRINIT;        ph_sport    := pxphdrbuf.ph_dport;        ph_dport    := pxphdrbuf.ph_sport;        ph_msgid    := pxphdrbuf.ph_msgid;  
      ph_rbit     := true; 
 
      ph_ebit     := true; 
       {length is pxp header plus error code}        ph_len      := SIZEOFPXPHDR + 2;        END;      
   {Set erroe code}  
    pxprsphdr.int[8] := rsp_err;          {write the buffer out to dsam}      vdbuf[2] := pxprsphdr.ph_len;  	   off      := 0;  	    AdrOf(pxprsphdr.int[1], off, vdbuf[1]);         {Get pxp's sbufid from ipc's table}     DS_FetchElement ( DS_TrackTD, TL_PXP_SOCKET, pxp_sb );      pxp_sb         := pxp_sb + pxp_sb;      mc             := pxprsphdr.ph_len;     mflags.int     := 0;   
   mflags.bits[0] := true; 
 
   mflags.bits[-2]:= true; 
    DS_SBPut(vdbuf, 4, pxp_sb, mflags, buf_ptr, mc, pxp_err);         IF pxp_err = 0 THEN        BEGIN {send it}   
      WITH px_msg DO 
          BEGIN {format e_msg}            ehport          := PXPIPOUTBOUNDIDX;            em_event        := SEND_REQUEST;            emsr_down_ref   := e_msg.emdi_down_ref;           emsr_mbufid     := buf_ptr;           emsr_flags.int  := PXPDEFAULT;            emsr_dlen       := pxprsphdr.ph_len;            emsr_opt_mbufid := 0;               {excercise the kill path option}            emsr_killsnd_cnt   := 1;            emsr_killrcv_cnt   := 1;            END;  {format e_msg}             {Dump the incoming packet before return our}        {reponse.                                  }        DS_MDispose(inmbufid, pxp_err);             {}        DS_LeaveCritical ( px_wkmap );        ProSw(px_msg, pxp_err);         DS_EnterCritical ( px_wkmap, px_ierr );         {}        END   {send it}      ELSE         BEGIN {no memory}   
      {Push PANIC button}  
       PXPPanic(pxp_err,PXP_SENDRSP, pxppath_ptr);         END;  {no memory}      END;  {with}   	END;  {pxprespond} 	         $SUBTITLE 'allocate a Pxp port', PAGE$  !{----------------------------------------------------------------} ! !{                       PxpGetPortAddr                           } ! !{----------------------------------------------------------------} !     PROCEDURE PxpGetPortAddr     (VAR  portnumber: Int16);      {}  { Description:  {    This routine allocate a unique port address for a new PXP  {    port.  {   { Parameters:   {    portnumber  : OUTPUT  PXP port address.  {   
{  Global variable:  
 !{    nxt_portid:   16 bit port address stored in the global table  ! !{                  area and read in locally whenever the protocol  ! {                  is entered.  {}      VAR         i:            Int16;    found:        BOOLEAN;    duplicate:    BOOLEAN;    path_buf:     PxpPathRecType;       BEGIN {pxpgetportaddr}  WITH pxpgbls DO      BEGIN {with}   	   found:= false;  	    REPEAT   
      {Get a port address} 
       IF nxt_portid = PXPMAX_DYNAMIC THEN            BEGIN {exceed max}            nxt_portid:= PXPMIN_DYNAMIC;   
         END {exceed max}  
       ELSE           BEGIN {not exceed}            nxt_portid := nxt_portid + 1;  
         END; {not exceed} 
       portnumber:= nxt_portid;            {Search for duplication}        duplicate:= false;            {search the d_rec list first}         i := pxpgbls.d_phead;         REPEAT        DS_FetchElement(DS_PXPPathTD, i, path_buf.int);         IF path_buf.xp_sport = portnumber THEN  
         duplicate:= true  
       ELSE           i:= path_buf.xp_fptr;        UNTIL            (duplicate) OR (i = pxpgbls.d_phead);            {search the i_rec list}         IF NOT duplicate THEN            BEGIN {i_rec}           i:= pxpgbls.i_phead;            REPEAT            DS_FetchElement(DS_PXPPathTD, i, path_buf.int);           IF path_buf.xp_sport = portnumber THEN               duplicate:= true           ELSE               i:= path_buf.xp_fptr;            UNTIL (duplicate) OR (i = pxpgbls.i_phead);           END;  {i_rec}        IF NOT duplicate THEN            BEGIN           found := true;            END;      UNTIL found;      END;  {with}       {Write the port_seed value back to dssm table}  DS_StoreFields(DS_PXPLISTHDTD, 1, pxpgbls.nxt_portid, 3, 1);  END; {pxpgetportaddr}               {-----------------------------------------------------}   {            PxpClosePath                             }   {-----------------------------------------------------}       PROCEDURE PxpClosePath;   {}  {   { Description:  {  Delete the path record from respective pxp path list.  {  If the port type is Req then delete from the dpath list  {  otherwise delete it from the ipath list.   {   
{ Global Parameters: 
 {  pxp_port      INPUT pxp path record local copy.  {  pxppath_ptr   INPUT pxp path record pointer.   {   {}      VAR   	   error  : Int16; 	 
   px_msg : EventMsgType;  
     
BEGIN {pxpclosepath} 
 IF pxp_port.xp_ptype = PXPSVRPORTTYPE THEN     BEGIN {server port}     PxpFreeEntry(pxpgbls.i_phead);      END   {server port}  ELSE  
   BEGIN {req port}  
    PxpFreeEntry(pxpgbls.d_phead);   
   END;  {req port}  
         {If we have a down path, destroy it}  IF pxp_port.xp_dn_ref <> NULL_VALUE THEN     BEGIN {has dn_path}  	   WITH px_msg DO  	       BEGIN {abort_dn_path}         ehport       := PXPIPOUTBOUNDIDX;         em_event     := KILL_REQUEST;         emkr_down_ref:= pxp_port.xp_dn_ref;         emkr_msg_rcv_cnt := pxp_port.xp_frmllp_cnt;         emkr_msg_snd_cnt := pxp_port.xp_tollp_cnt + 1;            {}        DS_LeaveCritical ( px_wkmap );        ProSw(px_msg, error);         DS_EnterCritical ( px_wkmap, px_ierr );         {}            END;  {abort_dn_path}      END; {has dn_path}   
END;  {pxpclosepath} 
                 $SUBTITLE 'to allocate pxp resources', PAGE$  {------------------------------------------------------------}  {                      PxpGetEntry                           }  {------------------------------------------------------------}      PROCEDURE PxpGetEntry   
   {    option     :Int16; 
 
    VAR newpath_ptr:Int16; 
     VAR error      :Int16 };      {}  {   { Description:  { This function try to allocate the following resources:  {   {    1. allocate a path/port structure  {   {    If option =  0 then get all and d_rec  {              <> 1 then get all and i_rec  { Parameters:   {  option      INPUT    0 used for d_path; 1 used for i_path;   {  newpath_ptr OUTPUT   path record pointer in table area.  {  error       OUTPUT   successful = 0 else = PXPNOPATHREC  {   {}      VAR     ptr_buf      :  ListPtrType;      
BEGIN {pxpgetentry}  
 	newpath_ptr := 0;  	 error       := PXPNOPATHREC;      {Get the pointer to the free list from our global}  {context block.                                  }  DS_FetchFields(DS_PXPPathTD, pxpgbls.f_phead,      ptr_buf.int, 0, 2);      WITH ptr_buf DO   
   BEGIN {check free list} 
    IF next <> pxpgbls.f_phead THEN  
      BEGIN {*free*} 
       {Yes list is not empty}   
      newpath_ptr := next; 
       DeleteList(DS_PXPPathTD, pxpgbls.f_phead, newpath_ptr);             {Initialize the path structure}         temp_port := PXPPATHINIT;   "      DS_StoreFields(DS_PXPPathTD, newpath_ptr, temp_port.xp_sport,  "                         PXPDATAOFFSET, PXPPATHDATASIZE);            IF option = PXPREQPORTTYPE THEN   
         BEGIN {for d_rec} 
          {put it in the d_path list}  !         InsertPXList(DS_PXPPathTD, pxpgbls.d_phead, newpath_ptr); ! 
         END   {for d_rec} 
       ELSE  
         BEGIN {for i_rec} 
          {put it in i_path list}  !         InsertPXList(DS_PXPPathTD, pxpgbls.i_phead, newpath_ptr); ! 
         END;  {for i_rec} 
       error:= 0;  	      END {*free*} 	    ELSE   
      BEGIN {no free path} 
       {Push the PANIC BUTTON}         PXPPanic(pxp_err, PXP_GETENTRY, pxppath_ptr);   
      END;  {no free path} 
 
   END; {check free list}  
 	END; {pxpgetentry} 	             $SUBTITLE 'to locate a pxp port', PAGE$   {------------------------------------------------------}  {                   PxpLookUp                          }  {------------------------------------------------------}      
PROCEDURE PxpLookUp  
    {VAR e_msg      : EventMsgType;          listhdptr  : Int16;           skey       : SearchIdType;      VAR error      : Int16     };   {}  {   { Description:  {  The routine performs the following tasks.  {   1. Search the specified list for a match.   {   2. If found initialize pxppath_ptr and pxp_port.  {   3. If it is a request for the server port, get  {      a new path record for reply.   {   {   Note: Always return path context in the global variables,   {         pxppath_ptr and pxp_port.   {   { Parameters:   {  listhdptr    INPUT   dpath or ipath list head  {  skey         INPUT   search key  {  error        OUPUT   0 if matched else PXPNOENDPOINT   {   
{ Global Variables:  
 
{   pxppath_ptr, pxp_port  
 {   {}      VAR      newpath_ptr : Int16;      new_port    : PxpPathRecType;      	BEGIN {pxplookup}  	 WITH pxp_port, e_msg DO      BEGIN {with}      error          := 0;      pxppath_ptr    := 0;  {global}          DS_LinkedFindAndFetchFields( DS_PXPPathTD, listhdptr,     listhdptr, 1, 2, 3, skey.int, 0, SIZEOFPXPPATH,     pxp_port.int, pxppath_ptr, pxp_err);          IF (pxp_err = 0) AND (pxppath_ptr <> NULL_VALUE)THEN   
      BEGIN {found}  
       {increment the message count if it's a requestor port;}         {so that we will not screw up IP's message count when }         {we discard the path.                                 }         IF xp_ptype = PXPSVRPORTTYPE THEN            BEGIN {for server}            {Check the request queue limit}           IF xp_req_cnt < PXPSRVREQLIMIT THEN                  BEGIN {within limit}                  {Try to allocate a path/port structure}               PxpGetEntry(PXPSVRPORTTYPE, newpath_ptr, error);                  IF error = 0 THEN                  BEGIN {got it}                  {now increment the queue limit}                 xp_req_cnt := xp_req_cnt + 1;                     {build path record and remember original ipath}                     {Fetch the newly created path record which has}                 {the linkages...                              }                 DS_FetchElement(DS_PXPPathTD, newpath_ptr,                                    new_port.int);                      {Initialize the new path for this pxp request}                  WITH new_port DO                     BEGIN {newport}                     xp_ptype      := PXPSVRPORTTYPE;                    xp_sport      := skey.sk_sport;                     xp_dport      := pxphdrbuf.ph_sport;                    xp_dn_ref     := emdi_down_ref;                     xp_dn_pid     := emdi_down_pid;                     xp_mbufid     := NULL_VALUE;                    xp_up_pid     := pxp_port.xp_up_pid;                    xp_up_ref     := pxp_port.xp_up_ref;                    {Remember our sever port's path reference}                    {so that we do not have to search for it }                    {later on.  And also set the message cnt }                    {to their initial values.                }                    xp_rt_ref     := pxppath_ptr;                     xp_frmllp_cnt := 1;                     xp_toulp_cnt  := 1;                     END;  {newport}       !               {update both the new and the server ports' struct}  ! %               DS_StoreFields(DS_PXPPathTD, pxppath_ptr,pxp_port.xp_sport, % !                                 PXPDATAOFFSET, PXPPATHDATASIZE);  !     %               DS_StoreFields(DS_PXPPathTD, newpath_ptr,new_port.xp_sport, % !                                  PXPDATAOFFSET, PXPPATHDATASIZE); !     #               {Here put both the path reference and the path context} # #               {in variables which the caller expected.              } #                pxppath_ptr := newpath_ptr;                 pxp_port    := new_port;                  END   {got it}               ELSE                 BEGIN {no resource}                 error:= PXPNOPATHREC;  
               END;  
             END   {within limit}           ELSE               BEGIN {limit exceeded}              error := PXPQLIMITED;               END;  {limit execeed}            END;  {for server}   	      END  {found} 	    ELSE         BEGIN {not found}         error:= PXPNOENDPOINT;        END; {not found}     END;  {with}   END; {pxplookup}                      $Subtitle 'Pxp Return Address',PAGE$  {----------------------------}  {   PXPDYNAMICADDR           }  {----------------------------}      PROCEDURE PxpDynamicAddr  
   {    pathref   : Int16; 
     VAR dynaddr   : AddressType;      VAR addrlen   : Int16       };      {}  { Description: Return dynamic PXP port address to caller.   {   No error checking is performed on this call; no user  {   is allowed to use this routine.   {}      	BEGIN {pxpdynamic} 	 DS_FetchElement(DS_PxpPathTD, pathref, pxp_port.int);   dynaddr.int := pxp_port.xp_sport;   	addrlen     := 2;  	 	END;  {txpdynamic} 	         $Subtitle 'Pxp Add Path Element', page$   {---------------------------}   {   PXPADDELEMENT           }   {---------------------------}       PROCEDURE PxpAddElement      { VAR sp        : Int16;        VAR stack     : TemplateControlStack;       VAR crec      : TemplateControlRecord;        VAR vnarec    : VNARecord;        VAR pathstart : Int16;        VAR rptr      : Int16;        VAR report    : PathReportRecord;       VAR dynamicptr: Int16;        VAR ierr      : Int16 };       {}  { Abstract:   {  Called to add protocol elements to path report templates.  {}      LABEL 99;       VAR      i           : Int16;      protorec    : ProtocolRecord;     temprptr    : Int16;      tempcrec    : TemplateControlRecord;       PROCEDURE Escape ( error  : Int16 );     BEGIN  	   ierr := error;  	    GOTO 99;      END; {Escape}      BEGIN   { Add a PXP protocol element to the path report buffer.}  temprptr := (rptr + 1) DIV 2;   report.bytes[rptr] := HP_PXP;   	rptr := rptr + 1;  	 report.bytes[rptr] := 4; {element length}   	rptr := rptr + 1;  	 
temprptr := temprptr + 1;  
 report.ints[temprptr] := 0; {service map}   rptr := rptr + 2; {index dispatch address field}  IF (crec.tc_uppid = IPC) OR (crec.tc_uppid = SREG) THEN      BEGIN     { We're supposed to add a dynamic element.}     temprptr := temprptr + 1;     report.ints[temprptr] := dynamicptr;      dynamicptr := rptr;  
   rptr := rptr + 2; 
    END  ELSE     BEGIN     Escape (PXPINTERNALERR);   
   END; {IF crec.tc_uppid} 
      {Now fetch the PXP protocol record & use it to determine which }    {protocols support PXP. Push a control record onto the template}    {control stack for each one that does.                         }       DS_FetchElement ( DS_ProtosTD, HP_PXP, protorec.int);   FOR i := 0 TO LAST_INDIVIDUAL_PID DO     BEGIN     WITH protorec, tempcrec DO         BEGIN         IF pr_supportingpids.bits[i] THEN            BEGIN           { We've found a supporting protocol.}           tc_activepid := i;            tc_uppid := HP_PXP;               {Always assume we have to copy}           tc_pathoffset := rptr - pathstart;            sp := sp + 1;           stack[sp] := tempcrec;            END; {IF pr_supportingpids}  	      END; {WITH}  	    END; {FOR i}       {Alway do a no copy on the last one}  stack[sp].tc_pathoffset := 0;   ierr := 0;      99:;  
END; {PXPAddElement} 
         $Subtitle 'pxp build path routine'$   {--------------------------------------------}  {    PXPBUILDPATH                            }  {--------------------------------------------}      PROCEDURE PxpBuildPath     { VAR pathreport  : PathReportRecord;           vnaptr      : Int16;            elementptr  : Int16;            uppid       : Int16;        VAR downpid     : Int16;        VAR downref     : Int16;        VAR options     : PathOptionsRecord;        VAR bpwkmap     : Int16;        VAR px_ierr        : Int16 };      {}  { Description:  {  PxpBuildPath is called by ipc to build a pxp path  {  (dpath) and link it to the lower path reference  {  given.   {   { Output:   {    px_ierr : If successful is set to 0  {           If Not successful is set to PXPNOPATHREC  {}      VAR     portnumber  : Int16;      BEGIN {pxpbuild}  DS_FetchElement( DS_PXPLISTHDTD, 1, pxpgbls.int);   PxpGetEntry(PXPREQPORTTYPE, pxppath_ptr, pxp_err);  
IF pxp_err = 0 THEN  
 	   BEGIN {got rsc} 	    {Get the dpath rec with link words}     DS_FetchELement(DS_PXPPathTD, pxppath_ptr, pxp_port.int);         {Get a source port address}     PxpGetPortAddr(portnumber);      
   WITH pxp_port DO  
       BEGIN {build path record}         xp_ptype       := PXPREQPORTTYPE;         xp_sport       := portnumber;             {Check to see if ULP make reference to global}        {addresses (-ve elementptr); If that is the  }        {case we know it wants to talk to Sreg; so   }        {for now we just kluge things up so it will  }        {work...                                     }        IF elementptr < 0 THEN           BEGIN           {DS_FetchFields(DS_STDADR_TD, -elementptr,      }           {                  xp_dport, 0, 1);             }           xp_dport    := 1541; {use socket registry's port id}            END        ELSE           BEGIN            xp_dport    := pathreport.ints[(elementptr + 4) DIV 2];            END;   
      xp_frmllp_cnt  := 1; 
       xp_up_pid      := uppid;        xp_dn_pid      := downpid;  
      xp_up_ref      := 0; 
       xp_dn_ref      := downref;  
      xp_toulp_cnt   := 1; 
       END;  {build path record}           {write path record into dssm and return parameters to caller}       DS_StoreFields(DS_PXPPathTD, pxppath_ptr, pxp_port.xp_sport,                         PXPDATAOFFSET, PXPPATHDATASIZE);      px_ierr := 0;     downpid := HP_PXP;   
   downref := pxppath_ptr; 
 	   END  {got rsc}  	 ELSE     BEGIN {no resources}       	   WITH px_msg DO  	       BEGIN         ehport         := PXPIPOUTBOUNDIDX;         em_event       := KILL_REQUEST;         emkr_down_ref  := downref;        emkr_msg_rcv_cnt   := 1;        emkr_msg_snd_cnt   := 1;        END;         {}      DS_LeaveCritical ( bpwkmap );  
   ProSw(px_msg, px_ierr); 
    DS_EnterCritical ( bpwkmap, px_ierr );      {}          px_ierr := PXPNOPATHREC;      END;  {no resources}   END;  {pxpbuild}              $SUBTITLE 'KillRequest', page$  {---------------------------------------}   {            KillReq                    }   {---------------------------------------}       PROCEDURE KillReq(VAR e_msg : EventMsgType);      {}  { Description:  {   Handle Kill_Request from ULP.   {   {}      BEGIN {killreq}       WITH e_msg, pxp_port DO      BEGIN {with}      DS_FetchElement(DS_PXPPathTD, pxppath_ptr, pxp_port.int);         {Subtract the ulp message count}      xp_frmulp_cnt := xp_frmulp_cnt - (emkr_msg_snd_cnt - 1);       #   { IF it is a server request we have to decrement the requst count.} #    IF xp_ptype = PXPSVRPORTTYPE  THEN         BEGIN         DS_FetchElement(DS_PXPPathTD, xp_rt_ref, temp_port.int);        temp_port.xp_req_cnt := temp_port.xp_req_cnt - 1;   !      DS_StoreFields(DS_PXPPathTD, xp_rt_ref, temp_port.xp_sport,  !                         PXPDATAOFFSET, PXPPATHDATASIZE);        END;         {If we have a request outstanding, flush it}      IF (xp_req_cnt <> 0 ) AND (xp_mbufid <> 0) THEN        BEGIN {clean up}            { Call Cancel Timer here ... }        PXPCancelTimer (xp_timerid, pxp_err);             IF xp_mbufid <> NULL_VALUE THEN            BEGIN           DS_MDispose(xp_mbufid, pxp_err);            END;         END;  {clean up}         {If the event message couts match, close the port and the}      {path.                                                   }      IF xp_frmulp_cnt = 0 THEN  
      PxpClosePath;  
    END;  {with}   END;  {killreq}               $SUBTITLE 'Pxp Query Response', page$   {----------------------------------------}  {            QueryRsp                    }  {----------------------------------------}      PROCEDURE QueryRsp(VAR e_msg : EventMsgType) ;      {}  { Description: Handle Query Response from ULP; send pxp   {    reply packet to remote peer and destroy the path   {    if the oneshot option is chosen.   {   {}      VAR      send_ptr    : Int16;      offset      : Int16;       BEGIN {queryrsp}  {Get local copy of the path & port structure}   WITH e_msg, pxp_port DO      BEGIN  {with}     send_ptr    := emqrs_mbufid;      pxppath_ptr := emqrs_down_ref;      DS_FetchElement(DS_PXPPathTD, pxppath_ptr, pxp_port.int);         {update port and path record in case we have to }     {keep it around; for this release it is possible}     {not to keep or update the path/port record.    }     xp_option.int := emqrs_options.int;     xp_frmulp_cnt := xp_frmulp_cnt + 1;         {Build hppxp header}   
   WITH pxphdrbuf DO 
       BEGIN         pxphdrbuf   := PXPHDRINIT;        ph_sport    := xp_sport;        ph_dport    := xp_dport;        ph_msgid    := emqrs_seq_num;   
      ph_rbit     := true; 
       ph_len      := emqrs_dlen + SIZEOFPXPHDR;         END;         {Append the header to the user data buffer.}      DS_MAppendHead(pxphdrbuf.int[1], SIZEOFPXPHDR,   
      send_ptr, pxp_err);  
     
   {Send the packet} 
    IF pxp_err = 0 THEN        BEGIN   	      offset := 0; 	       PxpSend(send_ptr, offset, pxphdrbuf.ph_len);        END;         {If this is a one shot response; de-allocate the}     {path & port structure.                         }         IF xp_option.bits[-1] = true THEN        BEGIN {close path}        {Before we close the path let's update the request}         {count on the server's path record.               }             DS_FetchElement(DS_PXPPathTD, xp_rt_ref, temp_port.int);            temp_port.xp_req_cnt := temp_port.xp_req_cnt - 1;       !      DS_StoreFields(DS_PXPPathTD, xp_rt_ref, temp_port.xp_sport,  !                         PXPDATAOFFSET, PXPPATHDATASIZE);  
      PxpClosePath;  
       END;  {close path}     END;   {with}  END;  {queryrsp}              $SUBTITLE 'Pxp Request Ipath', page$  {---------------------------------------}   {              QueryReq                 }   {---------------------------------------}       PROCEDURE QueryReq(VAR e_msg : EventMsgType);       {}  !{ Description: Handle query request form ulp; only single request  ! {   is allowed.   {   {}      LABEL      99;      VAR   
  toutval   : Int32; 
 
  offset    : Int16; 
     BEGIN {queryreq}  {Try to get the context (path) record}  DS_FetchElement(DS_PXPPathTD, pxppath_ptr, pxp_port.int);       {See if the path is good or not; if the path is good}   {and we are not currently serving a outstanding     }   {request, start process the request otherwise send  }   {a negative confirmation to ULP.                    }       WITH pxp_port, e_msg, pxpovlyhdr DO      BEGIN {with}      IF (xp_ptype = PXPREQPORTTYPE)            AND (xp_req_cnt < PXPREQLIMIT) THEN        BEGIN {valid context}         {Record the context information}        xp_up_pid     := emqrq_up_pid;        xp_up_ref     := emqrq_up_ref;        xp_option.int := emqrq_options.int;         xp_frmulp_cnt := xp_frmulp_cnt + 1;         xp_req_cnt    := xp_req_cnt + 1;            {Let's append pxp's header + linkages to the}         {mbuf chain; and queue the request to the   }         {path record. When we have to support multiple}         {requests queue the request on the list; for  }         {now this request is the end of list.         }             bf1.nxt_rqptr  := NULL_VALUE;             xp_mbufid      := emqrq_mbufid;         bf2            := PXPHDRINIT;         bf2.ph_sport   := xp_sport;         bf2.ph_dport   := xp_dport;         bf2.ph_msgid   := emqrq_seq_num;        bf2.ph_len     := emqrq_dlen + SIZEOFPXPHDR;            {Use a new variable to call MAPPENDHEAD for it may}         {destroy our input mbuf pointer.                  }         new_mbufid     := xp_mbufid;        DS_MAppendHead(pxpovlyhdr.int[1], SIZEOFPXPHDR +            SIZEOFPXPCNTLBUF, new_mbufid, pxp_err);       
      IF pxp_err <> 0 THEN 
          BEGIN           {mmgr rejects our append; complain}           PXPPanic(pxp_err,PXP_QUERYRQ, pxppath_ptr);  	         GOTO 99;  	          END;             {Save  new mbufid; call pxpsend to transmit. }        {Turn on retransmit timer for this request.  }        {Call timer routine here and save the timer  }        {ID in xp_timerid. The path context is saved }        {in the PxpSend routine.                     }            xp_mbufid   := new_mbufid;            {Call timer routine here...}        xp_tout_cnt := 0;         toutval     := PXPTOVALTABLE[xp_tout_cnt];        PXPSetTimer (toutval);                {Say we want to send a copy only}         offset   := SIZEOFPXPCNTLBUF;             PxpSend(xp_mbufid, offset, bf2.ph_len);         END   {valid context}      ELSE         BEGIN         {Either the path reference is no good or there}         {is already a request outstanding; reject this}         {one.                                         }         END;        99:;        END;  {with}  END;  {queryreq}              $SUBTITLE 'Pxp Request Ipath', page$  {---------------------------------------}   {              ReqIpath                 }   {---------------------------------------}       PROCEDURE ReqIpath(VAR e_msg : EventMsgType);       {}  { Description: Internal routine to build an ipath and   {    allocate a pxp server port; the code supports  {    dynamic pxp port address binding but may not be  
{    used in 1st release.  
 {   {}      VAR      pxp_key :   SearchIDType;    ipathadr :   Int16;       BEGIN {reqipath}  WITH e_msg, pxp_port DO   
   BEGIN {with emsg} 
 	   ipathadr := 0;  	    IF emri_path_len <> 0 THEN         BEGIN {len <> 0}        WITH pxp_key DO            BEGIN           sk_sport  := 77; {need to get it from path report}            sk_dport  := PXPWILDCARD;           sk_dnref  := LLPWILDCARD;           END;           !      DS_LinkedFindAndFetchFields( DS_PXPPathTD, pxpgbls.i_phead,  ! !         pxpgbls.i_phead, 1, 2, 3, pxp_key.int, 0, SIZEOFPXPPATH,  !             temp_port.int, ipathadr, pxp_err);        END; {len <> 0}          {See if we already have an ipath; if we do tell user so}      IF pxp_err = 0 THEN  
      BEGIN {path existed} 
       {Build a reply to user request}         px_msg.em_event      := IPATH_ABORTED;        px_msg.emed_root_ref := emri_root_ref;        px_msg.emed_reason   := U_ADDR_INUSE;   
      END   {path existed} 
    ELSE         BEGIN {new path}        {Try to get a path and tcb structure}         PxpGetEntry(PXPSVRPORTTYPE, pxppath_ptr, pxp_err);      
      IF pxp_err = 0 THEN  
          BEGIN {has resource}            {Get the blank i_path with linkages.}           DS_FetchElement(DS_PXPPathTD, pxppath_ptr,   
            pxp_port.int); 
              {We has got all the necessary resource}           {Get a port address for him too.      }           PxpGetPortAddr(pxp_port.xp_sport);                {initialize the path record.}  
         WITH pxp_port DO  
             BEGIN {build i_path}              xp_ptype       := PXPREQPORTTYPE;               xp_rt_pid      := emri_root_pid;              xp_rt_ref      := emri_root_ref;              xp_up_pid      := emri_up_pid;              xp_up_ref      := emri_up_ref;              xp_option.int  := 0;              xp_frmulp_cnt  := 1;              xp_toulp_cnt   := 1;              xp_dn_ref      := LLPWILDCARD;              END;  {build i_path}               {Write the path record to DSAM Area }           DS_StoreElement(DS_PXPPathTD, pxppath_ptr,   
            pxp_port.int); 
              {Build a reply to user request}           px_msg.em_event       := CONFIRM_IPATH;           px_msg.emcip_root_ref := emri_root_ref;           px_msg.emcip_up_ref   := emri_up_ref;           px_msg.emcip_down_ref := pxppath_ptr;           END   {has resource}         ELSE           BEGIN {no resource}           {Build a reply to user request}           px_msg.em_event      := IPATH_ABORTED;            px_msg.emed_root_ref := emri_root_ref;            px_msg.emed_reason   := PXPNOPATHREC;           END;  {no resource}        END;  {new path}         {Return the reply to ipc.}      px_msg.ehport := xp_rt_pid * EHS_PER + EHIB_OFFSET;         {}      DS_LeaveCritical ( px_wkmap );   
   ProSw(px_msg, pxp_err); 
    DS_EnterCritical ( px_wkmap, px_ierr );     {}          END;  {with e_msg}   END;  {reqipath}          $Subtitle 'pxp data indication', page$  {--------------------------------------------------}  {                    DataInd                       }  {--------------------------------------------------}      PROCEDURE DataInd(VAR e_msg : EventMsgType);      {}  { Description: Handles data inication from IP;  {   get a copy of the hppxp header from the incoming  {   data; if is a request, look for server port   {   else look for requestor port. If it's new request   {   build path; if it's valid reply, deliver it to ULP.   {}      LABEL 33;       VAR   !   pxpsk           : SearchIDType;   {Search key for pxp port   }  !         {----------------------------------------------------}  {               Internal Procedures                  }  {----------------------------------------------------}      PROCEDURE PxpJustDrop   
   ( count      : Int16);  
     {}  { Description: drop the mbuf and destroy the lower path.  {  Called by Procedure DataInd only.  {}      BEGIN {justdrop}      {Dispose the inbound packet and update stat.}   DS_MDispose(inmbufid, pxp_err);   pxpgbls.pxpdropcnt := pxpgbls.pxpdropcnt + 1;       
{Send kill request to LLP} 
 WITH px_msg DO     BEGIN {abort_dn_path}     ehport       := PXPIPOUTBOUNDIDX;     em_event     := KILL_REQUEST;     emkr_down_ref:= e_msg.emdi_down_ref;   
   emkr_msg_rcv_cnt := 1;  
 
   emkr_msg_snd_cnt := 1;  
        {}      DS_LeaveCritical ( px_wkmap );   
   ProSw(px_msg, pxp_err); 
    DS_EnterCritical ( px_wkmap, px_ierr );     {}      END;  {abort_dn_path}  Goto 33;  END;  {justdrop}          {--------------------------------------}  {        PxpDropWithRsp                }  {--------------------------------------}      
PROCEDURE PxpDropWithRsp;  
     {}  { Description: Send response to remote; drop the packet   {  and destry the path:   {}      BEGIN {dwrsp}   
PxpResponse(e_msg);  
 Goto 33;  END;  {dwrsp}                       
{------------------------} 
 
{ Main Body Of DataInd   } 
 
{------------------------} 
     BEGIN {dataind}   {get pxp header}  WITH e_msg, pxphdrbuf, pxp_port DO     BEGIN {with}          inmbufid := emdi_mbufid;                      {Check packet length}     IF emdi_dlen < SIZEOFPXPHDR THEN         BEGIN   
      {Bad packet length}  
       pxpgbls.pxpbadcnt := pxpgbls.pxpbadcnt + 1;         PxpJustDrop( 1 );         END;         {Do a destructive read on the incoming header.}  
   mm_flags.int      := 0; 
    mm_flags.bits[0]  := false;     DS_MRead(pxphdrbuf.int[1], SIZEOFPXPHDR, inmbufid, 0,  
      mm_flags, pxp_err);  
        IF pxp_err <> 0 THEN PxpJustDrop( 1 );              {Check version and service class}     IF ph_ver <> PXPVERSION THEN         BEGIN         {version or class of service not supported}         rsp_err := PXPBADVERSION;             {Do not respond to reply packacts}  
      IF NOT ph_rbit THEN  
           BEGIN   
          PxpDropWithRsp;  
           END;        END;         IF ph_cls <> PXPCLASS THEN         BEGIN         {version or class of service not supported}         rsp_err := PXPBADCLASS;   
      IF NOT ph_rbit THEN  
          PxpDropWithRsp;        END;         {Got a valid packet. Build search key and do lookup}      {according to the packet type.                    }         pxpsk.sk_sport := ph_dport;         IF ph_rbit OR ph_ebit THEN         BEGIN         {it's a reply packet; the search key must be exact}         pxpsk.sk_dport := ph_sport;         pxpsk.sk_dnref := emdi_down_ref;            PxpLookup(e_msg, pxpgbls.d_phead, pxpsk, pxp_err);      
      IF pxp_err <> 0 THEN 
          BEGIN  
         PxpJustDrop( 1 ); 
          END;             {Found the requestor port}            {Cancel Active timer...}        PXPCancelTimer (xp_timerid, pxp_err);             {Build confirm message}   
      WITH px_msg DO 
          BEGIN           ehport        := xp_up_pid * EHS_PER + EHIB_OFFSET;           em_event      := QUERY_CONFIRM;           emqc_up_ref   := xp_up_ref;           emqc_down_pid := HP_PXP;            emqc_seq_num  := ph_msgid;            emqc_mbufid   := inmbufid;            emqc_dlen     := ph_len - SIZEOFPXPHDR;           emqc_result   := 0;      !         {If it is an error packet, just retrieve the error code}  ! !         {and release the incoming buffer; let ULP that the     }  ! !         {request is no good.                                   }  !          IF ph_ebit THEN  	            BEGIN  	             mm_flags.int      := 0;               mm_flags.bits[0]  := true;              DS_MRead(pxphdrbuf.int[8], 2, inmbufid, 0,                          mm_flags, pxp_err);               emqc_mbufid := NULL_VALUE;              emqc_dlen   := 0;               {emqc_result := pxphdrbuf.int[8];}              emqc_result := U_NO_REGISTRY_RESPONSE;              DS_MDispose(inmbufid, pxp_err);               END;           END;              {Now we send the confirm message to ulp and when we come}           {back we will clean up.                                 }              {}        IF xp_req_cnt <> 0 THEN            BEGIN           {Update the counters.}            xp_req_cnt    := xp_req_cnt - 1;            xp_toulp_cnt  := xp_toulp_cnt + 1;            xp_frmllp_cnt := xp_frmllp_cnt + 1;               {Save the path/port structures}  #         DS_StoreFields(DS_PXPPathTD, pxppath_ptr, pxp_port.xp_sport,  #                            PXPDATAOFFSET, PXPPATHDATASIZE);                DS_LeaveCritical (px_wkmap);            Prosw(px_msg, pxp_err);           DS_EnterCritical (px_wkmap, px_ierr);           END;         {}            {Here check if we have to dispose the path and/or}        {the mbuf. If it is a error packet dispose the   }        {mbuf; if one-shot is true, kill the path too.   }        {In any case we have to dispose the original req.}        {mbuf.                                           }             {Dispose the request mbuf in dsam; for multiple requests}           {one has to search for the 'right' request to dispose.  }          DS_MDispose(xp_mbufid, pxp_err);            IF xp_option.bits[-1] = true THEN            PxpClosePath;        END      ELSE         BEGIN  {wildcard}         pxpsk.sk_dport := PXPWILDCARD;        pxpsk.sk_dnref := LLPWILDCARD;            PxpLookup(e_msg, pxpgbls.i_phead, pxpsk, pxp_err);            IF pxp_err = PXPNOENDPOINT THEN            BEGIN           {Could'nt find the port; return error}            rsp_err := PXPUNREACHABLE;            PxpDropWithRsp;           END        ELSE IF pxp_err <> 0 THEN             BEGIN             {Queue limit exceeded; just drop it for now, so}            {the remote can retry again.                   }            PxpJustDrop( 1 );             END;            {We had not drop the packet, deliver it to ulp}   
      WITH px_msg DO 
          BEGIN           ehport          := xp_up_pid * EHS_PER + EHIB_OFFSET;           em_event        := QUERY_INDICATION;            emqi_up_ref     := xp_up_ref;           emqi_down_pid   := HP_PXP;            emqi_down_ref   := pxppath_ptr;           emqi_seq_num    := pxphdrbuf.ph_msgid;            emqi_mbufid     := inmbufid;            emqi_dlen       := pxphdrbuf.ph_len - SIZEOFPXPHDR;           END;             {}        {Update the counters.}            {Save the path/port structures}   !      DS_StoreFields(DS_PXPPathTD, pxppath_ptr, pxp_port.xp_sport, !                         PXPDATAOFFSET, PXPPATHDATASIZE);            DS_LeaveCritical (px_wkmap);        ProSw(px_msg, pxp_err);         DS_EnterCritical (px_wkmap, px_ierr);         {}        END;  {wildcard}     END; {with}      33:;      
{Update the global stats}  
 pxpgbls.pxprcvcnt := pxpgbls.pxprcvcnt + 1;   DS_StoreElement(DS_PXPLISTHDTD, 1, pxpgbls.int);      END;  {dataind}               $Subtitle 'pxp kill indication', page$  {--------------------------------------------------}  {                 KillInd;                         }  {--------------------------------------------------}      PROCEDURE KillInd(VAR e_msg : EventMsgType);      {}  { Description: Handles kill_indication form LLP;  {}      BEGIN {killind}   DS_FetchElement(DS_PXPPathTD, pxpgbls.d_phead, temp_port.int);  	WITH temp_port DO  	 
   BEGIN {with temp_path}  
    WHILE xp_fptr <> pxpgbls.d_phead DO  
      BEGIN {while}  
 
      temp_ptr := xp_fptr; 
       DS_FetchElement(DS_PXPPathTD,                          temp_ptr, temp_port.int);        IF xp_dn_ref = e_msg.emki_down_ref THEN   
         BEGIN {fi}  
          xp_tout_cnt := PXPMAXTOCNT - 1;  "         DS_StoreFields(DS_PXPPathTD, temp_ptr, temp_port.xp_sport,  "                            PXPDATAOFFSET, PXPPATHDATASIZE);   
         END;  {fi}  
 
      END;  {while}  
 
   END;  {with temp_path}  
 END;  {killind}               $Subtitle 'pxp timer response', page$   {-------------------------------------------------}   {               TimerRsp                          }   {-------------------------------------------------}       PROCEDURE TimerRsp(VAR e_msg : EventMsgType);       {}  { Description: Handle timer message fro ulp.  {   {}      VAR      toutval   : Int32;      searchkey : Int16;       BEGIN {timerrsp}  {User the up_ref as the key to search for the HPPXP port}   WITH e_msg, pxp_port DO      BEGIN {with}      {Need to iron out this part with CW}      searchkey := e_msg.emtr_up_ref;         DS_LinkedFindAndFetchFields( DS_PXPPathTD, pxpgbls.d_phead,        pxpgbls.d_phead, 1, 9, 1, searchkey, 0, SIZEOFPXPPATH,        pxp_port.int, pxppath_ptr, pxp_err);         IF (pxp_err = 0) AND (xp_mbufid <> NULL_VALUE) THEN        BEGIN {fi}  
      {Clear the timer Id} 
       pxp_port.xp_timerid.index := -1;            {Get the pxp's overlay header}        mm_flags.int      := 0;         mm_flags.bits[0]  := true;  !      DS_MRead(pxpovlyhdr.int[1], SIZEOFPXPCNTLBUF + SIZEOFPXPHDR, !          xp_mbufid, 0, mm_flags, pxp_err);             {If retry count exceeded, return error and close the path}          {else call PxpSend to send another packet if there is one}         xp_tout_cnt := xp_tout_cnt + 1;         toutval     := PXPTOVALTABLE[xp_tout_cnt];            IF toutval > PXPMAXTOVAL THEN            BEGIN {retry exceeded}            {build the reply event message to ulp}            WITH px_msg DO   	            BEGIN  	              ehport         := xp_up_pid * EHS_PER + EHIB_OFFSET;               em_event       := QUERY_CONFIRM;              emqc_up_ref    := xp_up_ref;              emqc_seq_num   := pxpovlyhdr.bf2.ph_msgid;              emqc_mbufid    := NULL_VALUE;               emqc_dlen      := 0;              emqc_result    := PXPTIMEREXPIRED;              END;               {Let ulp know the bad news}               {}            DS_LeaveCritical (px_wkmap);            Prosw(px_msg, pxp_err);           DS_EnterCritical (px_wkmap, px_ierr);           {}                {Dispose the mbuf and the path if neccessary}           DS_MDispose(xp_mbufid, pxp_err);            xp_mbufid := NULL_VALUE;            IF xp_option.bits[-1] = true THEN  
            PxpClosePath;  
          END   {retry exceeded}         ELSE           BEGIN {retry}           PXPSetTimer( toutval);   #         PxpSend(xp_mbufid, SIZEOFPXPCNTLBUF, pxpovlyhdr.bf2.ph_len);  #          END;  {retry}        END; {fi}      END;  {with}   END;  {timerrsp}              $SUBTITLE 'Pxp outbound stub', page$  !{---------------------------------------------------------------}  ! !{                       PXPOUTSTUB                              }  ! !{---------------------------------------------------------------}  !     
PROCEDURE PxpOutStub 
    {VAR e_msg    : EventMsgType;      VAR result   : Int16           };       {}  { Description:  {  Pxp outbound stub called by pxp inbound process; it  {  sends a signal to the pxp outbound process or tears  {  down a broken path.  {}      BEGIN {outbound stub}   DS_EnterCritical(px_wkmap, px_ierr);      {Log the Event message if tracing is on}  Log_Event(EL_EVENT, HP_PXP, 0, dummyrefr,                EMSG_WORD_LEN, e_msg.int, px_ierr);      {get and initialize all globals}  DS_FetchElement( DS_PXPLISTHDTD, 1, pxpgbls.int);       WITH e_msg DO      BEGIN {with e_msg}       
   CASE em_event OF  
           QUERY_RESPONSE:            BEGIN           IF emqrs_down_ref <> NULL_VALUE THEN   	            BEGIN  	             QueryRsp(e_msg);              END;           END;       
      ABORT_REQUEST: 
          BEGIN {abort}           pxp_err := PXPINTERNALERR;            PXPPanic(pxp_err,PXP_OUTSTUB, pxppath_ptr);           END;  {abort}      
      KILL_REQUEST:  
          BEGIN {abort}           IF emkr_down_ref <> NULL_VALUE THEN  	            BEGIN  	             pxppath_ptr := emkr_down_ref;               Killreq(e_msg);               END;           END;  {abort}      
      INTERNAL_MSG:  
          BEGIN {internal msg}            pxp_err := PXPINTERNALERR;            PXPPanic(pxp_err,PXP_OUTSTUB, pxppath_ptr);           END;  {internal msg}             OTHERWISE            BEGIN           pxp_err := PXPBADMSG;           PXPPanic(pxp_err,PXP_OUTSTUB, pxppath_ptr);           END;         END; {end case event type}     END;  {with e_msg}       DS_LeaveCritical(px_wkmap);   END;  {outbound stub}           {-----------------------------------------------------------}   {                  PXPINSTUB                                }   {-----------------------------------------------------------}       
PROCEDURE PxpInStub  
    {VAR e_msg    : EventMsgType;      VAR result   : Int16           };   {}  {  Description:   {    The PXP inbound stub is used to handle error indication  {    from lower level protocol.   {}      VAR      temp_ptr  : Int16;       
BEGIN {inbound stub} 
 DS_EnterCritical(px_wkmap, px_ierr);      {Log the Event message if tracing is on}  Log_Event(EL_EVENT, HP_PXP, 0, dummyrefr,                EMSG_WORD_LEN, e_msg.int, px_ierr);      	{get PXP globals}  	 DS_FetchElement(DS_PXPLISTHDTD, 1, pxpgbls.int);      CASE e_msg.em_event OF      
   KILL_INDICATION:  
 	      BEGIN {kill} 	       {KillInd(e_msg);}   	      END;  {kill} 	        STATUS_INDICATION:         BEGIN   	      {Do Nothing} 	       END;         OTHERWISE       BEGIN       {ignore all other message}        pxp_err := PXPINTERNALERR;        PXPPanic(pxp_err,PXP_INSTUB, pxppath_ptr);        END;   	   END; {end case} 	     DS_LeaveCritical(px_wkmap);   
END;  {inbound stub} 
             $SUBTITLE 'Pxp outbound ', page$  !{---------------------------------------------------------------}  ! !{                       PXPOUTBOUND                             }  ! !{---------------------------------------------------------------}  !     PROCEDURE PxpOutbound      {VAR e_msg    : EventMsgType;      VAR result   : Int16           };       {}  { Description:  {  PXP outbound is called by ipc routines in the outbound   {  process; it is responsible for 1) transmit packet, 2)  {  handle retransmission, 3) kill request from ulp and  {  4) deliver reply or error to ulp.  {}      BEGIN {outbound}  {let's go critical so no one can bother us}   DS_EnterCritical(px_wkmap, px_ierr);      {Log the Event message if tracing is on}  Log_Event(EL_EVENT, HP_PXP, 0, dummyrefr,                EMSG_WORD_LEN, e_msg.int, px_ierr);      {get and initialize all globals}  DS_FetchElement(DS_PXPLISTHDTD, 1, pxpgbls.int);      WITH e_msg DO      BEGIN {with e_msg}       
   CASE em_event OF  
     
      QUERY_REQUEST: 
 
         BEGIN {queryreq}  
          pxppath_ptr := emqrq_down_ref;            IF pxppath_ptr <> NULL_VALUE THEN              QueryReq(e_msg);  
         END;  {queryreq}  
     
      REQUEST_IPATH: 
          BEGIN {requestipath}   
         ReqIpath(e_msg);  
          END;  {requestipath}       
      KILL_REQUEST:  
          BEGIN {abort}           IF emkr_down_ref <> NULL_VALUE THEN  	            BEGIN  	             pxppath_ptr := emkr_down_ref;               Killreq(e_msg);               END;           END;  {abort}            QUERY_RESPONSE:            BEGIN {query_response}            IF emqrs_down_ref <> NULL_VALUE THEN   	            BEGIN  	             QueryRsp(e_msg);              END;           END;  {query_response}             TIMER_RESPONSE:           BEGIN           TimerRsp(e_msg);          END;            OTHERWISE            BEGIN           END;         END; {end case event type}         {Reset the  path pointer}     pxppath_ptr   := NULL_VALUE;      END;  {with e_msg}   {}  DS_LeaveCritical(px_wkmap);   {}  END;  {outbound}          {-----------------------------------------------------------}   {                  PXPINBOUND                               }   {-----------------------------------------------------------}       
PROCEDURE PxpInbound 
    {VAR e_msg    : EventMsgType;      VAR result   : Int16           };   {}  {  Description:   {    The pxp inbound is called by llp to handle 1) data   {    indication form LLP and kill_indication from LLP.  {    Look up destination port and deliver data to ulp.  {    Return error packet to peer if no address is found.  {}      BEGIN {inbound}       DS_EnterCritical(px_wkmap, px_ierr);      {Log the Event message if tracing is on}  Log_Event(EL_EVENT, HP_PXP, 0, dummyrefr,                EMSG_WORD_LEN, e_msg.int, px_ierr);      	{get pxp globals}  	 DS_FetchElement( DS_PXPLISTHDTD, 1, pxpgbls.int);       CASE e_msg.em_event OF      
   DATA_INDICATION:  
 	      BEGIN {data} 	       DataInd(e_msg);   	      END;  {data} 	         
   KILL_INDICATION:  
 	      BEGIN {kill} 	       {KillInd(e_msg)};   	      END;  {kill} 	        OTHERWISE       BEGIN       {ignore all other message}        END;   	   END; {end case} 	     DS_LeaveCritical(px_wkmap);       END;  {inbound}           $SUBTITLE 'Initialize PXP stuffs', PAGE$  {-----------------------------------------------------------}   {                 SregBinding                               }   {-----------------------------------------------------------}       PROCEDURE SregBinding;      {}  { Description: Build a PXP ipath with SREG's well-known   {   address.  {}      BEGIN   {for now we just use the pid as the address}  DS_FetchElement( DS_PXPLISTHDTD, 1, pxpgbls.int);   PxpGetEntry(PXPSVRPORTTYPE, pxppath_ptr, pxp_err);      
IF pxp_err = 0 THEN  
 	   BEGIN {got it}  	    {Fetch the newly created path record which has}     {the linkages...                              }     DS_FetchElement(DS_PXPPathTD, pxppath_ptr,                         pxp_port.int);        {Initialize the new path for this pxp request}       WITH pxp_port DO           BEGIN {newport}           xp_ptype      := PXPSVRPORTTYPE;          xp_sport      := 1541; {socket registry's port id}          xp_dport      := PXPWILDCARD;           xp_dn_ref     := LLPWILDCARD;           xp_dn_pid     := 0;           xp_mbufid     := 0;           xp_up_pid     := SREG;          xp_up_ref     := 0;           xp_frmllp_cnt := 0;           xp_toulp_cnt  := 0;           END;  {newport}      END; {got it}  {update both the new and the server ports' struct}  DS_StoreFields(DS_PXPPathTD, pxppath_ptr, pxp_port.xp_sport,                    PXPDATAOFFSET, PXPPATHDATASIZE);  END;          $SUBTITLE 'Initialize PXP stuffs', PAGE$  {------------------------------------------------------------}  {               Pxp Initialization                           }  {------------------------------------------------------------}      	PROCEDURE PxpInit  	 
   {VAR maxentry : Int16;  
     VAR px_ierr     : Int16};       {}  { The routine does the following:   {   {  1. Allocate pxp path structures.   {  2. Allocate pxp global record  {  3. Initialize path pointers in DSAM.   {  4. Create free list for the pxp path structures.   {   {  Parameters:  {   {     maxentry  - maximum number of pxp table entries needed;   {                 it should be equal to the max. number of  {                 sockets supported in the system and has to  {                 be greater than 10.   {   {     px_ierr      - Error if MM calls fails  {   {   {     Note: Caller has to be critical to use this routine.  {}      LABEL 44;       VAR      i           : Int16;      pathbuffer  : PxpPathRecType;     pxplistbuf  : PxpListBufType;     domainrec   : DomainRecord;     protorec    : ProtocolRecord;      BEGIN { init }      {Get pxp control and path structures}   DS_GetTableSpace(DS_PXPLISTHDTD, 1, PXPLISTSIZE,                      SIZEOFPXPLIST, px_ierr);  
{Get PXP path structures}  
 
IF px_ierr = 0 THEN  
    BEGIN     DS_GetTableSpace(DS_PXPPathTD, 1, maxentry,                        SIZEOFPXPPATH, px_ierr);     END;       {check if we have problem with MM}  
IF px_ierr <> 0 THEN 
    GOTO 44;       {initialize the lists }       	WITH pxplistbuf DO 	    BEGIN         {Initialize tha pxp globals}      pxplistbuf := PXPLISTINIT;      DS_StoreElement(DS_PXPLISTHDTD, 1, pxplistbuf.int);         {initialize list pointers}      WITH pathbuffer DO         BEGIN         {initialize all path records}         pathbuffer := PXPPATHINIT;      
      {free path sentinel} 
 
      xp_fptr := f_phead;  
 
      xp_bptr := xp_fptr;  
       DS_StoreElement(DS_PXPPathTD, f_phead, pathbuffer.int);             {i_path sentinel}   
      xp_fptr := i_phead;  
 
      xp_bptr := xp_fptr;  
       DS_StoreElement(DS_PXPPathTD, i_phead, pathbuffer.int);             {d_path sentinel}   
      xp_fptr  := d_phead; 
 
      xp_bptr  := xp_fptr; 
       DS_StoreElement(DS_PXPPathTD, d_phead, pathbuffer.int);             {Initialize the path free list}         FOR i := PXPFPATHLISTHEAD + 1 TO maxentry DO           BEGIN {free path list}            InsertPXList(DS_PXPPathTD, f_phead, i);           END;  {free path list}         END;     END;       { Initialize PXP's protocol record.}      DS_FetchElement (DS_ProtosTD, HP_PXP, protorec.int);      WITH protorec DO     BEGIN  
   pr_rnd := RND_OUTBOUND; 
    pr_services.bits[REQUEST] := TRUE;      pr_maxmsglen := MAX_USER_BYTES;  
   pr_default_incc := 100; 
    pr_default_outcc := 100;      pr_default_timeout := 0; {don't know yet}     END; {WITH protorec}       DS_StoreElement (DS_ProtosTD, HP_PXP, protorec.int);      { Modify the HPDSN domain record to reflect PXP's role within}  { the domain.                                                }      DS_FetchElement (DS_DomainsTD, HPDSN_DOMAIN, domainrec.int);      	WITH domainrec DO  	    BEGIN     dr_memberpids.bits[HP_PXP] := TRUE;     END; {WITH domainrec}      DS_StoreElement (DS_DomainsTD, HPDSN_DOMAIN, domainrec.int);       { Update the SReg protocol record to reflect the fact that PXP}     { is one of SReg's direct supporters.                         }        DS_FetchElement ( DS_ProtosTD, SREG, protorec.int);   protorec.pr_supportingpids.bits[HP_PXP] := TRUE;  DS_StoreElement (DS_ProtosTD, SREG, protorec.int);      44: ;   END; { init }       END   .  