 $PASCAL ',6,7 91790-16219 REV.4010 <860319.1602>'   
$RECURSIVE OFF, RANGE OFF$ 
 
$HEAP_DISPOSE OFF $  
 
$STANDARD_LEVEL 'HP1000'$  
 $DEBUG$       PROGRAM Timer;      #{--------------------------------------------------------------------  #      (c) COPYRIGHT HEWLETT PACKARD COMPANY 1986.  ALL RIGHTS   RESERVED.  NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED,    REPRODUCED OR TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT    THE PRIOR WRITTEN CONSENT OF THE HEWLETT-PACKARD COMPANY.      #--------------------------------------------------------------------}  #     {}  
{       NAME : Timer 
 
{     SOURCE : 91790-18219 
 
{      RELOC : 91790-16219 
 	{       PGMR : SLL 	 {}  {}  #{--------------------------------------------------------------------  # { MODIFICATIONS   {     3/6/84   ash  modified to work in DSAM.   !{     3/20/84  ash  Modified to notify all users whose timers have ! {                   expired at once.  {   #{     10/3/84  ash  timer name is given as TIMER for Exec call instead # 
{                   of 0.  
 {   !{     10/11/84 ash  Added procedures AddToNotifyList, Process, and ! "{                   WakeUp from the module TUser so that it could be " {                   heap 0.   {   {      5/15/85 ash  Added DS_DSAMCheck call.  {   !{      5/16/85 ash  Added error check after DS_EnterCritical call  ! {   !{      9/23/85 ash  Remove FIVEMINS constant and add to tmrdec.pas ! {      9/30/85 ash  Search trcmod before sigmod   
{      2/13/86 ash  #35170 
 #{                   Modify to allow a runstring parameter to indicate  # #{                   pop all timers.  Since we have an absolute clock,  # &{                   users will need to reset timers after setting sys time.  & 
{      2/18/86 ash  #35196 
 {                   Decrement stat.activ when a timer pops  #--------------------------------------------------------------------}  # {}  { PROGRAM DESCRIPTION :   {   { The timer program is the alarm clock for AdvanceDs.  A user   { will request notification using an offset from the current   { time with the ActivateTimer intrinsic.  See Timer ES for more    { details concerning the timer.   {}  {}  {   {    Result conventions   {    {       Result < 0 - An error condition exists that resulted in    {                    the failure of the request.  !{       Result = 0 - No errors and no additional action necessary. ! {       Result > 0 - No errors, but reschedule the timer.   {   {    What the user can expect:  {    {       a. The user can expect delivery within 10ms of the time    {          requested.  The request time should be in the range  {          0 to 23 hrs 59 min 59 sec 99 csec.  A request for  {          delivery in 0 seconds will be satisfied in the time  {          necessary to process the request.  {          ( This remains to be substantiated -ash )  {}  $PAGE$          LABEL      999;       IMPORT                       $SEARCH 'phtm/bodec.rel'       bodec,   {  General-purpose declarations                    }                        $search 'phtm/sodec.rel'      sodec,                        $search 'phtm/mmdec.rel'       mmdec,   {  Memory-Manager declarations                     }                        $search 'phtm/mmext.rel'       ds_mm,   {  The Memory Manager                              }                        $ SEARCH 'phtm/trcmod.rel'$     trcmod,                       $search 'phtm/sigmod.rel'      sigmod,  {  The signal procedures                           }                        $ SEARCH 'phtm/tmrdec.rel'$      tmrdec,  {  Timer declarations                              }                        $ SEARCH 'phtm/tuser.rel'$       tuser,   {  Timer procedures                                }                        $ SEARCH 'phtm/envok.xpt'$      envok;       CONST      NS    =  20051;      { ascii equivalent of "NS" }      TYPE     NotifyListPtr    = ^NotifyListEntry;          NotifyListEntry  =  RECORD                          Index   : Int16;                          NextPtr : NotifyListptr;                          END;   { NotifyListEntry }      Parmarray        = ARRAY [1..5] of Int16;          VAR      checktime   : Int32;      ierr        : Int16;      maxtime     : Int32;      NotifyHead  : NotifyListPtr; { Head of timed out list }     Pops        : ParmArray;   
   rsched      : Boolean;  
    starttime   : Int32;      stat        : StatTableType;      timerresult : Int16;      tname       : TimerName;      wkmp        : Int16;       
PROCEDURE AddToNotifyList  
    (    index       : Int16;      VAR NotifyHead  : NotifyListPtr);   	         FORWARD;  	         { Called when we need to pop all of our timers }  PROCEDURE PopAll     (VAR stat        : StatTableType);   	         FORWARD;  	         { Called to find out which timer users need to be notified }  	PROCEDURE Process  	    (VAR stat        : StatTableType;          currenttime : Int32;      VAR NotifyHead  : NotifyListPtr;      VAR ProcessErr  : Int16);   	         FORWARD;  	             	{ Get runstring }  	 PROCEDURE rmpar      (VAR parms  : parmarray );      EXTERNAL;          { Notifies users of expired timers }  PROCEDURE WakeUp     (VAR NotifyHead : NotifyListPtr;       VAR Stat       : StatTableType);  	         FORWARD;  	         $ SUBTITLE 'AddToNotifyList', PAGE$   #{-------------------------------------------------------------------}  # #{                                                                   }  # #{                 AddToNotifyList                                   }  # #{                                                                   }  # #{  This procedure manages a linked list of two word records which   }  # #{  are used to keep track of which timer customers must be notified }  # #{  of timer expiration.                                             }  # #{                                                                   }  # #{ Parameters                                                        }  # #{                                                                   }  # #{  Index (INPUT)                                                    }  # #{     Index into the TimerEntry table of the entry to be notified.  }  # #{                                                                   }  # #{  NotifyHead (INPUT/OUTPUT)                                        }  # #{     Head of the list of active "notify nodes".                    }  # #{                                                                   }  # #{-------------------------------------------------------------------}  #     
PROCEDURE AddToNotifyList  
   (    index       : Int16;      VAR NotifyHead  : NotifyListPtr);      VAR      newlyfree : NotifyListPtr;       BEGIN { AddToNotifyList}      
   New (newlyfree);  
        newlyfree^.index := index;     { Store the index }   #   newlyfree^.nextptr := NotifyHead;  { push it onto the notify list } #    NotifyHead := newlyfree;       END;  { AddToNotifyList}      
$SUBTITLE 'PopAll', PAGE$  
 #{-------------------------------------------------------------------}  # #{                       PopAll                                      }  # #{                                                                   }  # #{  Procedure to pop all timers in the system.  Called when TIMER    }  # #{  has been scheduled with parameter 'NS', possibly when the system }  # #{  time has been reset.                                             }  # #{                                                                   }  # #{  Input/output                                                     }  # #{     stat  The stat table which contains the soonest time and      }  # #{           all statistics.                                         }  # #{-------------------------------------------------------------------}  # PROCEDURE PopAll     (VAR stat   : stattableType);      VAR      entry       : TimerEntryType;     ht          : HashEntry;      i           : Int16;        { loop counter }      index       : Int16;      NotifyHead  : NotifyListPtr;       $ PAGE $  BEGIN {popall}  DS_FetchElement (DS_TimerHashTD, 1, ht.mmbuf);  	NotifyHead := NIL; 	 FOR i := 0 TO NUMBEROFBUCKETS - 1 DO  !   { if there are any active entries attached to the bucket, we }  ! #   { clean up the bucket and then shoot the chain, adding each entry } #    { index to the notify list }          WITH ht.tbl [i] DO         IF bucket_tos <> EMPTYENTRY THEN           BEGIN           index := bucket_tos;            bucket_tos := EMPTYENTRY;           bucket_timeout := EMPTYTIME;            REPEAT   !            DS_FetchElement (DS_TimerEntryTD, index, entry.mmbuf); !             AddToNotifyList ( index, NotifyHead);               stat.npops := stat.npops + 1;               stat.activ := stat.activ - 1;               index := entry.right_ptr;            UNTIL index = EMPTYENTRY;           END;       
IF NotifyHead <> NIL THEN  
    BEGIN { something to pop }   #   { Store the modified hash table, notify all timer users, and then } # #   { remove ourselves from the time list.                            } #    stat.soonest := EMPTYTIME;      DS_StoreElement (DS_TimerHashTD, 1, ht.mmbuf);      WakeUp ( NotifyHead, Stat );   $   { We will not remove ourselves from the time list; instead we will }  $ $   { clean up so that if the timer is scheduled there will be nothing }  $    { to do.  We already handle that case }     END;  { something to pop }       END;  {popall}      
$SUBTITLE 'Process', PAGE$ 
 #{-------------------------------------------------------------------}  # #{                                                                   }  # #{                 Process                                           }  # #{                                                                   }  # #{ This routine is called by the timer program.  It searches through }  # #{  the entire list attached to a hash bucket looking for any entry  }  # #{  whose timer has popped.  It creates a linked list of entries     }  # #{  to be notified of timer expiration.  Note: at this time, the     }  # #{  timer tables are in an inconsistent state.  The timer must       }  # #{  always be allowed to operate from a critical state!.             }  # #{                                                                   }  # #{ Parameters:                                                       }  # #{  Stat  (INPUT/OUTPUT)                                             }  # #{     The stat table which contains the soonest time and other      }  # #{     statistics which will be updated here.  A new soonest time    }  # #{     will be returned here.                                        }  # #{  CurrentTime (INPUT)                                              }  # #{     The current time as of the call to Process.                   }  # #{  NotifyHead (INPUT/OUTPUT)                                        }  # #{     Head of the list of indices to entries whose timers have      }  # #{     expired.                                                      }  # #{  ProcessErr (OUTPUT)                                              }  # #{     Carries any processing result back to the calling procedure.  }  # #{                                                                   }  # #{  ERROR RETURNS                                                    }  # #{     NOMATCH  No entry could be found which matched the            }  # #{              time in timerevent.                                  }  # #{     INVALIDTIME the value of timerevent was a negative number     }  # #{                                                                   }  # #{-------------------------------------------------------------------}  #     PROCEDURE Process(VAR stat        : StatTableType;                        currenttime : Int32;                    VAR NotifyHead  : NotifyListPtr;                    VAR ProcessErr  : Int16);       VAR      entry    : TimerEntryType;   
   hash     : Int16; 
    hb       : Bucket;      entryindex : Int16;  #   found : Boolean;     { Says whether any matching entry was found }  #    rmv_stat : Int16; { result of remove from list operation }       $page$  	   BEGIN {Process} 	 	   found := FALSE; 	 
   ProcessErr := 0;  
        hash := HashFunction (stat.soonest); { Find the bucket }   %   DS_FetchFields (DS_TimerHashTD, 1, hb.bucket_tos, hash*BKTLEN, BKTLEN); % "   entryindex := hb.bucket_tos;   { Get pointer to the first entry } "    IF entryindex <> EMPTYENTRY THEN         REPEAT  { if there are more entries in the list }   !      DS_FetchElement (DS_TimerEntryTD, entryindex, entry.mmbuf);  !        { If the time of this entry means it should be processed }         IF (entry.time >= stat.soonest) AND            (entry.time <= stat.soonest + HASHDELTA - 1) THEN           BEGIN { found a matching entry }            stat.npops := stat.npops + 1;           DeleteFromChain (entry, entryindex, hb);            stat.activ := stat.activ - 1;                { Push this entry onto the list of entries to notify }             AddToNotifyList (entryindex, NotifyHead);           found := TRUE;            END;  { found a matching entry }         entryindex := entry.right_ptr;        UNTIL (entryindex = EMPTYENTRY);      #{  NOT FOUND should occur only if the bucket is empty or if no time in # %{  the bucket matched the timeout time.  This would probably occur during  % ${  a race between the timer process and a cancel/reset request, and will $ %{  not be considered an error.  The timer should be rescheduled, however.  % {}     IF found THEN        BEGIN         { reset timeout for this hash }         hb.bucket_timeout := HashSoonest(hb, currenttime);         DS_StoreFields (DS_TimerHashTD, 1, hb.bucket_tos, hash*3,                           BKTLEN);         END;         {reset timeout for the system }     stat.soonest := SystemSoonest (currenttime);   #   IF stat.soonest <> EMPTYTIME THEN  { There are active timers left } #       processerr := RESCHDTIMER      ELSE ProcessErr := NOERROR;  END;  {Process}   
$SUBTITLE 'WakeUp', PAGE$  
     %{-----------------------------------------------------------------------}  % %{                                                                       }  % %{                    WakeUp                                             }  % %{                                                                       }  % %{                                                                       }  % %{  Procedure which notifies timer users that their timers have expired. }  % %{  Timers are set by IPC users who are notified by the intrinsic        }  % %{  DS_TimerSignal.                                                      }  % %{                                                                       }  % %{  Input:                                                               }  % %{     NotifyHead  Head of the linked list of indices into the timer     }  % %{                  entry table of entries whose timers have expired.    }  % %{                                                                       }  % %{  Algorithm:                                                           }  % %{     Each timer entry in the list is examined to determine the socket  }  % %{     where the timer signal should be set, and which type of signal    }  % %{     it is.  The timer entry is then reinitialized and then pushed     }  % %{     onto the free list.  The node which contained the index is        }  % %{     onto the list of free notify nodes.                               }  % %{                                                                       }  % %{-----------------------------------------------------------------------}  %     PROCEDURE WakeUp  (VAR NotifyHead : NotifyListPtr;                     VAR stat       : StatTableType);       LABEL      99;      CONST      BIGVAL = MAXINT16;       VAR   
   entry : TimerEntryType; 
    nextentry : Int16;      nxttowake : NotifyListPtr;   #   temp      : NotifyListPtr;  { temp storage for list manipulation }  #    result : Int16;      { result from send_event call }       $PAGE$  BEGIN { WakeUp }      NxtToWake := NotifyHead;      REPEAT     nextentry := nxttowake^.index;      DS_FetchElement (DS_TimerEntryTD, nextentry, entry.mmbuf);       "   DS_TimerSignal (entry.socket, entry.direction, entry.signalkind); "        AddToFreeList (entry, nextentry, stat.freelsthd);      $   nxttowake := nxttowake^.nextptr;  { save location of next to notify } $ UNTIL nxttowake = NIL;      99:   END;  { WakeUp }      $SUBTITLE 'Main Timer Program', PAGE $  BEGIN  {Timer}  { First get our runstring to see if we must pop all }   rmpar (pops);       { Then make sure everything is OK in DSAM }   DS_DSAMCheck ('TIMER');   DS_EnterCritical (wkmp, ierr);  IF ierr <> 0 THEN goto 999;       DS_FetchElement (DS_TimerStatTD, FIRST, stat.mmbuf);      IF pops [1] = NS THEN      BEGIN { we must pop them all }   	   PopAll (stat);  	    DS_StoreElement (DS_TimerStatTD, FIRST, stat.mmbuf);      DS_LeaveCritical (wkmp);      END   { we must pop them all }   ELSE     BEGIN { a normal run of TIMER }  "   { The timer will loop processing expired timers and rescheduling  " $   {  itself until there are no further requests.  At that time it will  $ '   {  leave the loop and become dormant, waiting to be rescheduled elsewhere.  '    {}   %   { The initial check is to ensure that there has not been a race between % $   { the timer and another process.  If another process has changed the  $ &   { soonest time in the system then we should be sure it is valid to notify &    { the owner of the indicated timer request.     {}   
   checktime := TimeOfDay; 
    { starttime is five minutes sooner than now }     IF checktime < FIVEMINS THEN         starttime := checktime - FIVEMINS + CSPD     ELSE starttime := checktime - FIVEMINS;      #   IF (stat.soonest <> EMPTYTIME) AND   { if there is anyone to pop }  #       WithinWindow (starttime, checktime, stat.soonest) THEN        BEGIN  { while someone to pop }         rsched  := FALSE;    { reinitialize each loop }         NotifyHead := NIL;            REPEAT           Process(stat, starttime, NotifyHead, timerresult);            maxtime := TimeOfDay + (HASHDELTA*5);           IF timerresult = RESCHDTIMER THEN  	            BEGIN  	             rsched  := TRUE;              END          UNTIL NOT WithinWindow (starttime, maxtime, stat.soonest);             IF (NotifyHead <> NIL)        THEN WakeUp (NotifyHead, stat);             DS_StoreElement (DS_TimerStatTD, FIRST, stat.mmbuf);            tname.name := 'TIMER';  !      IF rsched  THEN  { if not resched then nothing left to do }  !          BEGIN           ReSchedule(stat.soonest, tname, timerresult);           END;             DS_LeaveCritical (wkmp);        END  { if someone to pop }         ELSE         BEGIN { nothing to do }         DS_LeaveCritical (wkmp);        END;  { nothing to do }      END;  { a normal run of TIMER }  999:  END. 