 $PASCAL '91790-1X226 REV.4010 <860401.1531>'  
$STANDARD_LEVEL 'HP1000' $ 
 $DEBUG $  $Heap 0$  $RANGE OFF$   $RECURSIVE OFF$       MODULE TrcMod;  	$ALIAS 'N$TRCMOD'  	     %{------------------------------------------------------------------------  %     "   (c) COPYRIGHT HEWLETT-PACKARD COMPANY 1986.  ALL RIGHTS RESERVED. "    NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED, REPRODUCED, OR   "   TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT THE PRIOR WRITTEN  "    CONSENT OF THE HEWLETT-PACKARD COMPANY.      % ------------------------------------------------------------------------} %     {}  {        NAME : TrcMod  {      SOURCE : 91790-18226   
{       RELOC : none 
 
{        PGMR : ASH  
 {}      ${----------------------------------------------------------------------- $    MODIFICATIONS     7/15/84  #      Remove enter_ and leave_critical calls.  Caller MUST be critical # 
      to use this routine. 
        7/18/84  #      Incorporate the module trcgbl, which has all the trace specific  # 
      declarations.  
        12/1/84  "      Delete the trace declarations.  Delete NewSeqNo (done in mmgr) "        4/30/85  #      Add Procedure Log_Event, which will send a standard format event # %      to EvMon.   Changed globals to be of the new format.  Added version  % $      number in the message sent to EVMON, changed send_event to read a  $       logging mask rather than the severity.         5/21/85  $      Add flag bit in eventtype in logevent for backwards compatibility  $ $      with send_event.  If set, the message is from log_event, if clear  $       it is from send_event.         11/10/85         remove log mask to the global area in dsam.          1/27/86        Dispose mbuf if ds_sbput succeeds and ds_sbappend fails.         3/19/86        Remove Send_Event forever.  % -----------------------------------------------------------------------}  % {}  { DESCRIPTION :   ${  This module is used by all processes which wish to have events logged $ !{  by EvMon, the event monitor.  All messages will have a standard ! {  format.  {}  IMPORT                 $search 'phtm/BODEC.rel'   bodec,      { General Purpose declarations }                 $search 'phtm/SODEC.rel'$  sodec,      { Socket specific declarations }                 $search 'phtm/MMdec.rel'$  mmdec,      { memory manager specific declarations }                 $search 'phtm/mmext.rel'$  ds_mm;      { the memory manager }      $ page  EXPORT      CONST      (*  Severity codes *)  
   { Event Types  }  
         EL_TESTMSG     = 7;      { For logging ascii trace messages }       EL_RESOURCELIM = 6;      { Resource limit exceeded          }       EL_DISASTER    = 5;      { Unrecoverable error              }       EL_ERROR       = 4;      { NonDisastrous errors             }       EL_WARNING     = 3;      { May signify error, cannot tell   }       EL_EVENT       = 2;      { Event Message                    }       EL_PROLOG      = 1;      { Protocol specific log message    }       EL_LOGSTATS    = 0;      { Used by logging subsystem only   }          {  Lengths and offsets into EvMon's Global Block }      { result code constants to return to caller }     ELEB = 7000;      { Event logging error base }      EL_SEVTOOLOW = ELEB + 1;   { severity of request too low }      EL_NOMONITOR = ELEB + 2;   { monitor not running }      EL_PIDNOTLOGGING = ELEB + 3;   { Log_Event[pid] = FALSE }     EL_BADVALUE      = ELEB + 4;  { bad parameter value }      $ page  TYPE      { The following type is useful for calls to send_event.  }         AscType = RECORD CASE Int16 OF            1 : (bufr : Int16);  { for mmgr }           2 : (chars : Packed Array[1..EMSG_BYTE_LEN] of CHAR);           3 : (emsg : EventMsgType);               END;  { AscType }               CONST      LOGFNAMESIZE   = 32;        { 64 charactersmax = 32 words }         LASTEVENT   = EL_TESTMSG;  &   { we need to know the exact size of the global block for initialization } &    EVGLOBALSIZE   = 17 + LOGFNAMESIZE;     CURRENTVERSION = 1;          TYPE     EventGlobal = RECORD CASE Int16 of   
      1  : (bufr : Int16); 
       2  : (sbufid      : Int16;  %            LogFNameLen : Int16;    { actual length of the log file name } % !            EvLogged    : Int16;    { number of messages logged }  ! !            EvDropped   : Int16;    { number of messages dropped } !             EvType      : ARRAY [0..LASTEVENT] of Int16;              MM_Err      : RECORD  { stats of errors }                             OutOfMem   : Int16;                             WouldBlock : Int16;                             OverLim    : Int16;                             IllSbId    : Int16;                             OtherErr   : Int16;                             END; { mm_err }   "            LogFileName : PACKED ARRAY [1..LOGFNAMESIZE*2] of CHAR); "                  END;  { EventGlobal }             ContextWords = RECORD CASE Int16 of           1 : (longint   : Int32);            2 : (ints      : ARRAY[1..2] of Int16);                    END;      $ PAGE $  
PROCEDURE Log_Event  
    (    eventtype : Int16;     { Disaster, error, etc    }          entity    : Int16;     { Who is sending this msg }          location  : Int16;     { Where in the code       }          pathref   : Contextwords;  { Context Identifier      }          infolen   : Int16;     { + words or - characters }      VAR info      : Int16;     { The message buffer }       VAR ierr      : Int16);           $ page $  IMPLEMENT       TYPE     NameType = RECORD CASE Int16 of                1 : (int  : Int16);                 2 : (name : ARRAY [1..6] of CHAR);  	              END; 	         { Returns byte address of the buffer.  Needed by SB_Put }       PROCEDURE Adrof   "   (VAR firstword : Int16;    { points to first word in the buffer } " 
        offset    : Int16; 
     VAR ByteAddress : Int16); { the address of the buffer }      EXTERNAL;      { Integer AND of two numbers }  FUNCTION IAND      $ direct $      (    first  : Int16;           second : Int16)                  : Int16;      EXTERNAL;          
{ Returns program's name } 
     PROCEDURE PName      (VAR MyName : NameType);      EXTERNAL;              { returns the session program is running under }      FUNCTION UsNum     : Int16;      EXTERNAL;      $ SUBTITLE 'Log_Event', PAGE $  {-----------------------------------------------}   {          PROCEDURE Log_Event                   }  {-----------------------------------------------}           
PROCEDURE Log_Event  
    (    eventtype : Int16;     { Disaster, error, etc    }          entity    : Int16;     { Who is sending this msg }          location  : Int16;     { Where in the code       }           pathref   : ContextWords;    { Context Identifier      }           infolen   : Int16;     { + words or - characters }      VAR info      : Int16;     { The message buffer }       VAR ierr      : Int16);       LABEL      99;      CONST      BIGVAL = MAXINT16;       TYPE     VdBufType = RECORD Case Boolean of         TRUE :  (long  : ARRAY [1..20] of Int16);         FALSE : (short : VectoredDataType);         END;              VAR      dispose_err : Int16;          { error disposing mbuf }   
   error    : Int16; 
 
   evtype   : mmflagstype; 
 !   evlmask  : mmflagstype;       { holds log mask in global area } !     gbl      : EventGlobal;       { holds stats and global info }      mask     : mmflagstype;       { eventtype mask }      mmflags  : mmflagstype;       { Flags for mmgr }      mc       : Int16;             { max characters to sbput }  %   m        : MbufIdType;        { points to the mbuf containing the msg } %    MyName   : Nametype;   $   queue    : SBQueueType;       { queue of sbuf to append message to }  $ 
   SessNo   : Int16; 
 "   vdbuf    : VdBufType;         { tells Sb_Put where the data is }  "    vdlen    : Int16;             { Length of vdbuf }  
   version  : Int16; 
     $page   {--------------------------------------------------}  {           SetStats                               }  {--------------------------------------------------}      	PROCEDURE SetStats 	    (VAR gbl   : EventGlobal;          error : Int16);          BEGIN { setStats }      gbl.evdropped := gbl.evdropped + 1;         WITH gbl.mm_err DO         BEGIN   
      CASE error OF  
          MMINSUFFICMEM : BEGIN                           outofmem := outofmem + 1;                           END;            MMOVERLIMIT   : BEGIN                           overlim := overlim + 1;                           END;            MMWOULDBLOCK  : BEGIN                           wouldblock := wouldblock + 1;                           END;            MMILLEGALSBID : BEGIN                           illsbid := illsbid + 1;                           END;            OTHERWISE       BEGIN                           { record which error it is }                            othererr := error;                            END;                END;  { case }       
      END;  { with } 
        DS_StoreElement (DS_EventGlobalsTD, 1, gbl.bufr);     END;  { SetStats }       $page   
BEGIN  { Log_Event } 
     
{ check for input errors } 
 IF (eventtype < 0) OR      (eventtype > LASTEVENT) THEN      BEGIN     ierr := EL_BADVALUE;      goto 99;      END;       ierr := 0;  { check sys severity in global block }  mask.int := 0;  mask.bits[-eventtype] := TRUE;      DS_FetchGlobal (DS_LogMask, 1, evlmask.int);  IF (IAND (evlmask.int, mask.int) = 0) THEN { etype enabled }     BEGIN     ierr := EL_SEVTOOLOW;     goto 99;      END;       DS_FetchElement (DS_EventGlobalsTD, 1, gbl.bufr);   IF ( gbl.sbufid  <> 0)  THEN                 { Evmon there   }     BEGIN { we have a match }         { This is a valid request.  Increment statistics }      WITH gbl DO        evtype[eventtype] := evtype[eventtype] + 1;          { get name and session Id }  	   PName (myname); 	 
   sessno := UsNum;  
    version := CURRENTVERSION;          evtype.int := eventtype;       { Now tell EVMON this is NOT from send_event }     evtype.bits[-15] := TRUE;         queue := 3;    { the data queue }     mc := BIGVAL;         Adrof (evtype.int, 0, vdbuf.long[1]);        { EVENTTYPE }      vdbuf.long[2] := 2;                          {     +     }      Adrof (version, 0, vdbuf.long[3]);           {  VERSION  }      VdBuf.long[4] := 2;                          {     +     }      Adrof (evlmask.int, 0, vdbuf.long[5]);       { TRACEMASK }      vdbuf.long[6] := 2;                          {     +     }      Adrof (Myname.int, 0, vdbuf.long[7]);        {  PROCNAME }      VdBuf.long[8] := 6;                          {     +     }      Adrof (sessno, 0, vdbuf.long[9]);            { SESSION ID}      vdbuf.long[10] := 2;                         {     +     }      Adrof (entity, 0, vdbuf.long[11]);           {   ENTITY  }      vdbuf.long[12] := 2;                         {     +     }      Adrof (location, 0, vdbuf.long[13]);         {  LOCATION }      vdbuf.long[14] := 2;                         {     +     }      Adrof (pathref.ints[1], 0, vdbuf.long[15]);  {  PATHREF  }      vdbuf.long[16] := 4;                         {     +     }      Adrof (infolen, 0, vdbuf.long[17]);          {  INFOLEN  }      vdbuf.long[18] := 2;                         {     +     }      Adrof (info, 0, vdbuf.long[19]);             {   INFO    }       #   { len is in  + words or  - chars.  vdbuf[even] is length in bytes } #    IF infolen < 0 THEN        vdbuf.long[20] := ABS(infolen)     ELSE vdbuf.long[20] := 2 * infolen;         vdlen := 40;   
   mmflags.int := 0; 
    mmflags.bits[0] := TRUE;      mmflags.bits[-1] := TRUE;     mmflags.bits[-2] := TRUE;      "   DS_SBPut (vdbuf.short, vdlen, gbl.sbufid, mmflags, m, mc, error); "    IF error <> 0 THEN         BEGIN   
      ierr := error; 
       SetStats (gbl, error);        goto 99;        END;     { clear the unnecessary flags }  
   mmflags.int := 0; 
    mmflags.bits[0] := TRUE;       "   DS_SBAppend (gbl.sbufid, m, queue,BIGVAL,BIGVAL, mmflags, error); "    IF error <> 0 THEN         BEGIN   
      ierr := error; 
       { we must get rid of this mbuf }        DS_MDispose (m, dispose_err);   #      { If it fails there is no one we can tell, so ignore the error } #       SetStats (gbl, error);        goto 99;        END;         WITH gbl DO  #      evlogged := evlogged + 1;   { This event logged successfully  }  #        END   { something to do }  ELSE     BEGIN     ierr := EL_NOMONITOR;     goto 99;      END;       DS_StoreElement (DS_EventGlobalsTD, 1, gbl.bufr);       99:   
END;  { Log_Event }  
     END.  { TrcMod } 