 $PASCAL '24398-16062 REV.5010 <881102.1601>'      !(***************************************************************** ! !*                                                                * ! !*   (C) COPYRIGHT HEWLETT-PACKARD COMPANY 1984.  ALL RIGHTS      * ! !*   RESERVED.  NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED,       * ! !*   REPRODUCED, OR TRANSLATED TO ANOTHER PROGRAMMING LANGUAGE    * ! !*   WITHOUT THE PRIOR WRITTEN CONSENT OF THE HEWLETT-PACKARD     * ! !*   COMPANY.                                                     * ! !*                                                                * ! !****************************************************************** ! *   	*     NAME:  EXER  	 *   SOURCE:  24398-18062 replacing rte-6 version 91711-18285  *    RELOC:  24398-16062 replacing rte-6 version 91711-16285  
*     PGMR:  J.R.C.(794x)  
 *   $* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  $ 
*  Revision History  
 *   *   DATE       PROGRAMER                   PURPOSE  &* --------    -------------    --------------------------------------------  & *   "* 10/06/84    Jeff Conrad      Modified to allow user interface, so  " #*                              that this can be used on line (but not  # $*                              done at this time).  Modified to support  $ "*                              794x line of disc drives.  Compressed " $*                              diagnostics to allow code to fit in 32K.  $ *   * 02/15/85     JC              Minor repairs  *   "* 12/05/85     Blaine Lang     Modified to support 7907 disc drive.  " &*                              Modified listlu procedure to list hpib addr.  & *                              Added change lu command.   *                              and a few other small changes.   *   $*  07/15/85    Dave Groves     Major changes.  Enhanced support of 7907. $ %*              DMD             Restructured output format for all logs and % %*                              tables.  Added external function FIND_LU to % &*                              return bus lu if passed the device lu.  This  & "*                              is used for the AMIGO CLEAR routine.  " '*                              Fixed bugs in REV command and other minor bugs  ' *   '*  07/30/85    Rich            Made minor changes so that one version of EXER  ' !*                Van Gaasbeck  would work on both RTE-6 and RTE-A. ! *   %*  02/07/86    Dave Groves     Created a son process (EXER1) to handle the % "*              DMD             routines that would not fit in EXER.  " *   %*                              Added support for EAGLE and BFD Disc Cache. % *   &*                              Added routines to release the ID segment for  & %*                              the son process, to RP the son, and to pass % *                              parms and a buffer to the son.   *   '*                              Added capability to print the physical address  ' *                              for the 793X/791X fault logs.  *   %*  04/14/86    Dave Groves     Moved ERROR_LOG and FAULT LOG from EXER to  % $*              DMD             EXER1 to allow RTE-V version to compile.  $ $*                              EXER had grown to big.  Also removed the  $ %*                              INPUT/OUTPUT specification from the PROGRAM % $*                              statement in EXER1.  Pascal was trying to $ &*                              open invalid input/output files depending on  & #*                              what data was passed in the run string. # %*                              I then had to add the output file variable  % *                              to all of the WRITE statements.  *   $*  06/03/86    Frank Root      Completed modifications for 795X devices. $ %*  08/01/86    DMD             Added CE MODE command to protect users from % '*                              destructive commands.  Changed command prompt.  ' !*                              Added partial command capabilities. ! $*                              Modified zfltlog to send buffer multiple  $ '*                              times if necessary.  Changed multiple character ' $*                              prompts to single where possible.  Added  $ %*                              getcode and more_lines to help break up the % $*                              output in various places.  Added ifbrk to $ &*                              ro ert.  Does not seem to be working.  Added  & &*                              procedure main to shield long procedure names & '*                              from linker.  Older versions recognize no more  ' '*                              than 5 characters causing non-unique problems.  ' %*                              Deleted PRINTER command.  Expanded function % %*                              of TERM.  Added INPUT and OUTPUT commands.  % %*                              Program now allows redirection of input and % $*                              output both in the run string and during  $ *                              execution.   #*  01/16/87    Frank Root      Removed main procedure and changed some # %*                              procedure names to ensure uniqueness.  The  % $*                              main procedure approach did not work with $ *                              the 4B loader at DSD.  *   %*  02-27-87    Leslee Doner    Changed all string functions to characters. % 
*               DMD  
 *  03-03-87    Leslee Doner    Moved putility in ZSERVO.  
*               DMD  
 $*  03-04-87    Leslee Doner    The screen message 'UTILITY' and 'UTILITY $ $*               DMD            COMPLETED' were not in the right place on $ $*                              the screen. Modified Putility, Good_end,  $ *                              Bad_end, and User_end.   *   #*  03-05-87    Leslee Doner    Found infinite loop in ZSEEK and added  # $*               DMD            Time_msg to it. Added Time_msg to ZXXERT. $ *   $*  03-06-87    Leslee Doner    Removed procedure Writelog and procedure  $ "*               DMD            Zwrite_cache_control. Added commands  " "*                              Readcacheon and Readcacheoff. Rewrote " &*                              procedure Zcache_control. Zcache_control now  & '*                              performs the following utilities, Readcacheon,  ' %*                              Readcacheoff, Writecacheon, Writecacheoff,  % $*                              Cacheon and Cacheoff and error checking.  $ *   #*  03-24-87    Leslee Doner    Transfered Cachetablearea to EXER1 from # !*               DMD            Cache_stats instead of extablearea. ! *   $*  04-21-87    Leslee Doner    Added read revision to Change Lu to keep  $ %*               DMD            for utilities to check revision of firmware % %*                              if necessary. RFSECT now checks 791X drives % $*                              firmware. See ZRFSECT, ZCHANGE_LU & ZREV. $ *   *  05-22-87    Leslee Doner    Removed Zwritelog.   *   &*  06-12-87    Leslee Doner    Fixed bug in ZXXERT. Made some modifications  & &*                              to it. See ZXXERT. Changed ZFRMAT to default  & %*                              to interleave of 1 for Eagle. Added warning % $*                              message about interleaving. Added code to $ %*                              Zdatalog to improve error count reporting.  % *   &*  06-17-87    Leslee Doner    Removed 795X's from ZAMCLEAR and added 795X's & *                              to ZSLDVCLR (SDClear command).   *   "*  06-18-87    Leslee Doner    Checking for Fbus LU = 0 in ZAMCLEAR. " *   '*  07-08-87    Leslee Doner    Removed parity error bit from error rate tests  ' &*                              on Eagles. Eagles now have a diag of 0 or 1.  & *   &*  09-02-87    Leslee Doner    Made enhancements to ZSPAR for new 795XB and  & %*                              796XB drives such as forced sparing, sector % $*                              or track spare reporting, improved error  $  *                              testing and informative messages.   *   %*  10-27-87    Leslee Doner    Added option to ZRDTBLS for 795XB and 796XB % %*                              drives to read all sector headers to report % *                              any spare sectors.   *   &*  11-16-87    Leslee Doner    Added function WRONG to check for block sizes & &*                              as valid CS80 devices. Modified ZCHANGE_LU to & *                              make the call to WRONG.  *   "*  11-30-87    Leslee Doner    Added messages to ZINPUT and ZOUTPUT. " *   %*  01-27-88    Leslee Doner    Moved ZCACHE_CONTROL to EXER1. Made mod to  % *                              PRNTSTATUS.  '*****************************************************************************  ' *   *        LINK   :  link exer.lod  *   '* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *) '     $cds off  $HEAPPARMS OFF,PARTIAL_EVAL OFF,RECURSIVE OFF$  $HEAP 0,IDSIZE 24,RUN_STRING 364,RANGE OFF$   	$HEAP_DISPOSE OFF$ 	     PROGRAM EXER(INPUT,OUTPUT);       label 0;      
$ include '[TYPE' $  
     const     rev_code = 'Rev. 5010  10-19-88';   
  noabort  = -32768; 
     VAR     f              : text;    IOBUF          : IOBUFTYPE;     INBUF          : PACKED ARRAY [1..MAXICHAR] OF CHAR;  
  OUTBUF         : char64; 
   LUBUF          : PACKED ARRAY [1..63] OF LUDATATYPE;    PRODNUM        : PACKED ARRAY [1..6] OF QUADTYPE;     FIRSTCHAR      : CHAR;    LU             : WORDTYPE;    DA             : WORDTYPE;    MAXNUMLU       : DOUBLETYPE;    MAXSECTOR      : DOUBLETYPE;    MAXHEAD        : wordtype;    MAXCYL         : DOUBLETYPE;    MAXBLOCK       : DOUBLETYPE;    INTERLEAVE     : DOUBLETYPE;    TAPE           : boolean;     DISC           : boolean;     CONTROLLER     : boolean;     ADDRMODE       : WORDTYPE;    lu_num         : lu_num_type;     COMP           : COMPTYPE;    NOERROR        : boolean;     UNITNUM        : WORDTYPE;    I              : WORDTYPE;    info           : packed array[0..10] of bytetype;     rrev           : REAL;    exitflag,     spareblock,   	  eagle_rfsector,  	   M794X,    M7907,    M791X,    M793X,    M9140,    M9144,    EAGLE,    M795X,    M795XA,     M795XB,     breakflag,  $  RTEA           : boolean;                                  (* RTE6 *)  $   track          : track_type;    device_type    : wordtype;    prog_name      : prog_type;     buffer         : bufrtype;  
  file_name      : char8;  
 
  rtn_file_name  : char8;  
 
  options        : char2;  
   line_cnt,     error,    cmd_len        : wordtype;  	  release_segment, 	   print_paddr,    describe_ok,    isp,rsp,    ce_mode        : boolean;     ce_mode_cmds   : set of cmds_type;    infile,   
  outfile        : char64; 
     procedure do_it $alias 'exec'$ (ecode:wordtype;   "  prog_name:prog_int_type; parm1,parm2,parm3,parm4,parm5 :wordtype;  "   bufr:bufrtype; bufln:wordtype); external;       procedure rmpar(var parm:parm_type);external;       $function which_os $ alias 'opsys' $ : wordtype; external;    (* RTE6 *)  $     $procedure get_trackmap $ alias 'exec' $                      (* RTE6 *)  $ 
  (     icode  : wordtype; 
 
        lu     : wordtype; 
     var buf    : track_type;  
        len    : wordtype; 
 
        dum1   : wordtype; 
         dum2   : wordtype  ); external;       PROCEDURE GETSCODE  $ ALIAS 'EXEC' $  "   (ECODE, LU: WORDTYPE; STAT1, STAT2: SELCOTYPE ; STAT3: WORDTYPE;  "                          STAT4: TAPEUNITTYPE ); EXTERNAL;       procedure getcode $ alias 'exec' $            (e,lu:wordtype;b:char2;l:wordtype);external;      procedure locklu $ alias 'LURQ' $             (option,luary : wordtype); external;      function ifbrk:wordtype;external;       FUNCTION  LUTRU (LU: WORDTYPE): WORDTYPE; EXTERNAL;       FUNCTION  LDTYP (LU: LUTYPE; VAR NUMTYPE: WORDTYPE):                  WORDTYPE; EXTERNAL;       PROCEDURE XUTIL (VAR LU,DA:WORDTYPE;VAR COMP:COMPTYPE;                  VAR IOBUF:IOBUFTYPE); EXTERNAL;       PROCEDURE XDIAG (VAR LU,DA:WORDTYPE;VAR COMP:COMPTYPE;                  VAR IOBUF:IOBUFTYPE);EXTERNAL;      PROCEDURE XINMD (VAR LU,DA:WORDTYPE;VAR COMP:COMPTYPE;                  VAR IOBUF:IOBUFTYPE);EXTERNAL;      PROCEDURE XCOMP (VAR LU,DA:WORDTYPE;VAR COMP:COMPTYPE;                  VAR IOBUF:IOBUFTYPE); EXTERNAL;       PROCEDURE XSPRE (VAR LU,DA:WORDTYPE;VAR COMP:COMPTYPE;                  VAR IOBUF:IOBUFTYPE); EXTERNAL;       PROCEDURE XLCRD (VAR LU,DA:WORDTYPE;VAR COMP:COMPTYPE;                  VAR IOBUF:IOBUFTYPE); EXTERNAL;       PROCEDURE XDESC (VAR LU,DA:WORDTYPE;VAR COMP:COMPTYPE;                  VAR IOBUF:IOBUFTYPE); EXTERNAL;       PROCEDURE XRQST (VAR LU,DA:WORDTYPE;VAR COMP:COMPTYPE;                  VAR IOBUF:IOBUFTYPE); EXTERNAL;       PROCEDURE XCNCL (VAR LU,DA:WORDTYPE;VAR COMP:COMPTYPE;                  VAR IOBUF:IOBUFTYPE); EXTERNAL;       PROCEDURE XCICL (VAR LU,DA:WORDTYPE;VAR COMP:COMPTYPE;                  VAR IOBUF:IOBUFTYPE); EXTERNAL;       PROCEDURE XSDCL (VAR LU,DA:WORDTYPE;VAR COMP:COMPTYPE;                  VAR IOBUF:IOBUFTYPE); EXTERNAL;       PROCEDURE XAMCL (VAR LU,DA:WORDTYPE;VAR COMP:COMPTYPE;                  VAR IOBUF:IOBUFTYPE); EXTERNAL;       function fbus (var lu:wordtype) :wordtype; external;      function getfilename $alias 'pas.filenamr'$                 (var f:text):char64;external;       procedure start_child (ecode:wordtype;pname:prog_int_type;                         p1,p2,p3,p4,p5 :wordtype;                         var bufr:bufrtype; bufln:wordtype);  var   	  parms:parm_type; 	   i:wordtype;   begin     if not (outfile[1] in ['1'..'9']) then      close(f);     bufr[299]:=ord(infile[1]);  
  for i:=1 to 64 do  
     bufr[i+299]:=ord(outfile[i]);     do_it(ecode,pname,p1,p2,p3,p4,p5,bufr,bufln);     rmpar(parms);     breakflag:=parms[1]<0;    if not (outfile[1] in ['1'..'9']) then      append(f,outfile,'exclus');   end;      PROCEDURE CLEAR_OUTBUF $DIRECT$;  VAR   	  count: integer;  	 BEGIN     for count:=1 to 30 do       outbuf[count]:=' ';   END;      procedure invalid_command $DIRECT$;     begin       writeln;      writeln('Command not supported for this device.');      goto 0;     end;      PROCEDURE INPUTERROR $DIRECT$;  (*OUTPUT ERROR MESSAGE*)    begin       writeln;      prompt('Invalid input, please try again: ');    end;      procedure print_binary $direct$ (data_byte:bytetype);     var   	    K : erraptype; 	 	    J : wordtype;  	   begin       k.allbits := data_byte;       for J := 0 to 7 do  
      if k.b[J] then 
 
        write(f,'1') 
        else           write(f,'0');     end;      (**************************************)  (* Write byte in two digit hex format *)  (**************************************)  PROCEDURE WRITEHEX $DIRECT$(HEXNUM:BYTETYPE);     begin        write(F,' ',HEXCHAR[HEXNUM DIV 16],HEXCHAR[HEXNUM MOD 16]);      end;          PROCEDURE SPACE $DIRECT$(I:BYTETYPE);   	  VAR J:BYTETYPE;  	   BEGIN       FOR J:=I DOWNTO 1 DO write(F,' ');    END;          procedure time_msg $DIRECT$;    begin       writeln;  !    writeln('This utility may take several minutes to complete.'); !   end;          PROCEDURE DEV_PRINT $direct$ (printout : boolean);  #{********************************************************************} # #{*  9-1-87  L. Doner :  Print out an A or B following the model type.} # #{*                      M795XA or M795XB. Also 796X models.          } # #{********************************************************************} #       var       I :bytetype;      J :bytetype;    begin       I := 1;       while prodnum[I] = 0 do   	      I := I + 1;  	     for J := I to 5 do  
      if not printout then 
         write(prodnum[J]:1)         else          write(f,prodnum[J]:1);      if M795XA or M795XB then  
      if not printout then 
         begin             if M795XA then              write('A');             if M795XB then              case prodnum[5] of                7: write('B / 7961B');                8: write('B / 7962B');                9: write('B / 7963B');                otherwise               end;          end         else          begin             if M795XA then  
            write(f,'A');  
           if M795XB then              case prodnum[5] of                7: write(f,'B / 7961B');                8: write(f,'B / 7962B');                9: write(f,'B / 7963B');                otherwise               end;          end;      if not printout then        writeln       else  	      writeln(f);  	 
  end;  (* of dev_print *) 
     procedure prntaddr $DIRECT$(ADDR:ADDRTYPE);     begin       if ADDRMODE = 0 then        writeln(F,'Block Address = ',ADDR.BLOCK:1)      else        begin           write(F,'Cylinder = ',ADDR.CYLINDER:1);   	        SPACE(5);  	         write(F,'Head = ',ADDR.HEAD:1);           if (spareblock) and (M7907) then            begin               writeln(F);             end           else            begin               SPACE(5);               writeln(F,'Sector = ',ADDR.SECTOR:1);             end;        end;    end;  (* prntaddr *)          PROCEDURE prntstatus $DIRECT$(VAR STATUSMSG:STATUSTYPE);  $(**********************************************************************) $ $(*  1-27-88  L. Doner  :  Added 99 in buffer to tell son, request comes  $ (*                        from father.  $(**********************************************************************) $   var       X      :bytetype;       parm4  :wordtype;       parm5  :wordtype;         begin       if spareblock then        parm4 := 0      else  	      parm4 := 1;  	         if disc then parm5 := 0 else      if tape then parm5 := 1 else      if controller then parm5 := 2 else      parm5 := 3;           for X := 0 to 19 do         buffer[X] := statusmsg.unformatted_status.status[X];      buffer[20] := 99;    {from father}      $    start_child(9,prog_name.prog_int,6,device_type,addrmode,parm4,parm5, $                   buffer,-bufrlen);     end;  (* of prntstatus *)       FUNCTION CHECKQSTAT $DIRECT$ (print_status:boolean) :boolean;     begin   
    if IOBUF.QSTAT=0 then  
       checkqstat := true      else        begin           if (IOBUF.QSTAT = 1) or (IOBUF.QSTAT = 2) then            if IOBUF.FQSTAT = 0 then  	            begin  	               if print_status then                  prntstatus(IOBUF.FSTATUS);              end             else              writeln('Error during Request Status');           checkqstat := false;        end;    end;  (* of checkqstat *)           procedure dash_write $DIRECT$;  var I :bytetype;    begin       for i := 0 to 60 do write(F,'-');       writeln(F);     end;          PROCEDURE PUTILITY $DIRECT$;  (*Prints test header*)  '{***************************************************************************}  ' '{*  Update 2-26-87 L. Doner  : Removed clear_outbuf prior to write Utility. }  ' '{*  3-3-1987  L. Doner : Put 'UTILITY' in outbuf for correct placement.     }  ' '{***************************************************************************}  ' const     utility = 'UTILITY';  var     toprinter : boolean;  #  foundit : boolean;          {Used when found the end of the string}  #   i,position : wordtype;      BEGIN     writeln(F);     dash_write;   
  foundit := false;  
   position:= 65;                 {Outbuf is a char64}   '  REPEAT     {Start at the end of the string and look for the first non-blank} ' 
    position:=position-1;  
     if(outbuf[position]<>blank) then  
      foundit:=true; 
   UNTIL (foundit OR (position=1));    position:= position+1;  &  if (position<=58) then               {There is enough room to add UTILITY} &    begin        FOR i:=1 to 7 do                    {Add UTILITY to outbuf}          outbuf[position+i]:= utility[i];      end;   
  writeln(F,outbuf); 
   write(F,'LU ',LU:1,' is a ');   
  toprinter := true; 
   dev_print(toprinter);     writeln(f);     write(F,'Current unit = ',unitnum:2);         if M7907 then       begin   
      if unitnum = 0 then  
         write(F,' (fixed)');  
      if unitnum = 1 then  
         write(F,' (removable)');      end;        if unitnum = 15 then        write(F,' (controller)');     writeln(F);   END;          
(***********************)  
 
(*Types of end messages*)  
 
(***********************)  
     PROCEDURE GOOD_END $DIRECT$;  '{***************************************************************************}  ' '{*  3-3-1987  L. Doner : Put 'COMPLETED' in outbuf for correct placement.   }  ' '{***************************************************************************}  '     const   
  completed = 'COMPLETED'; 
 var   #  foundit : boolean;          {Used when found the end of the string}  #   i,position : wordtype;      BEGIN     writeln(F);   
  foundit := false;  
   position:= 65;                 {Outbuf is a char64}   '  REPEAT     {Start at the end of the string and look for the first non-blank} ' 
    position:=position-1;  
     if(outbuf[position]<>blank) then  
      foundit:=true; 
   UNTIL (foundit OR (position=1));    position:= position+1;  #  if (position<=56) then              {There is room to add COMPLETED} #     begin   "      FOR i:=1 to 9 do                    {Add COMPLETED to outbuf}  "         outbuf[position+i]:= completed[i];      end;  
  writeln(F,outbuf); 
   clear_outbuf;     dash_write;   END;          PROCEDURE BAD_END $DIRECT$;   '{***************************************************************************}  ' '{*  3-3-1987  L. Doner : Put 'FAILED' in outbuf for correct placement.      }  ' '{***************************************************************************}  '     const   
  failed = 'FAILED'; 
 var   #  foundit : boolean;          {Used when found the end of the string}  #   i,position : wordtype;      BEGIN     writeln(F);   
  foundit := false;  
   position:= 65;                 {Outbuf is a char64}   '  REPEAT     {Start at the end of the string and look for the first non-blank} ' 
    position:=position-1;  
     if(outbuf[position]<>blank) then  
      foundit:=true; 
   UNTIL (foundit OR (position=1));    position:= position+1;  %  if (position<=59) then              {There is room for FAILED in outbuf} %     begin          FOR i:=1 to 6 do                    {Add FAILED to outbuf}           outbuf[position+i]:= failed[i];       end;  
  writeln(F,outbuf); 
   clear_outbuf;     dash_write;     goto 0;   END;          PROCEDURE USER_END $DIRECT$;  '{***************************************************************************}  ' '{*  3-3-1987  L. Doner : Put message in outbuf for correct placement.       }  ' '{***************************************************************************}  '     const     term = 'TERMINATED BY USER';  var   #  foundit : boolean;          {Used when found the end of the string}  #   i,position : wordtype;      BEGIN     writeln(F);   
  foundit := false;  
   position:= 65;                 {Outbuf is a char64}   '  REPEAT     {Start at the end of the string and look for the first non-blank} ' 
    position:=position-1;  
     if(outbuf[position]<>blank) then  
      foundit:=true; 
   UNTIL (foundit OR (position=1));    position:= position+1;  "  if (position<=47) then              {There is room to add message} "     begin   !      FOR i:=1 to 18 do                    {Add message to outbuf} !         outbuf[position+i]:= term[i];       end;  
  writeln(F,outbuf); 
   clear_outbuf;     dash_write;     goto 0;   END;      PROCEDURE DISPLAY_LOOP $direct$ (count:bytetype);   begin     writeln;    writeln(f,'Loop count = ',count:1);   end;      FUNCTION UPCASE $direct$ (c:char):char;   begin   
  if c in ['a'..'z'] then  
 
    upcase:=chr(ord(c)-32) 
    else       upcase:=c;  end;      FUNCTION MORE_LINES $direct$ :boolean;  var     c:char2;  begin     if ((line_cnt > 20) and (infile = '1 ')) then       begin         writeln;  &      prompt('More...(''s'' to stop listing)',chr(27),'A',chr(13)); {go up}  &       getcode(1,octal('101'),c,-1);   #      prompt(chr(27),'J',chr(13));                      {clear screen} # 	      line_cnt:=0; 	       more_lines:=upcase(c[0]) <> 'S';      end      else       more_lines:=true;   end;      (*******************************************************)   (* Input a line, convert to upper case, check for exit *)   (*******************************************************)    PROCEDURE READ $DIRECT$;  {Read command entered by user or file}     var       I:WORDTYPE;         begin (*read*)      if eof then         begin           close(input);   
        reset(input,'1');  
       end;      inbuf:='                ';  	    readln(inbuf); 	     cmd_len:=maxichar;      while (inbuf[cmd_len]=' ') and (cmd_len > 0) do         cmd_len:=pred(cmd_len);   "    for i:=1 to cmd_len do           {Convert command to upper case} "       inbuf[i]:=upcase(inbuf[i]);   
    firstchar := INBUF[1]; 
      if (inbuf = 'EXIT') or (inbuf = 'EX') or (inbuf = 'E') then          if exitflag then          begin   	          writeln; 	           writeln('Program halted by user request!');   	          writeln; 	 	          halt(0); 	         end         else  	        user_end;  	   end;   (* of Read *)          (**********************************************************)  (* Read input number.  Allows +/-, all, or inf.  Converts *)  (* - to +.  Checks for number in range minnum to maxnum.  *)  (* If minnum is -99, checks for a valid lu number.        *)  (**********************************************************)       FUNCTION READNUM $DIRECT$(MINNUM,MAXNUM:DOUBLETYPE):DOUBLETYPE;      VAR   
    INFFLAG,MINUS:boolean; 
     DIGITNUM,I,NUMDIGITS:WORDTYPE;      MULT,NUM:DOUBLETYPE;    begin        (* READNUM *)      repeat  
      NUMDIGITS:=0;  
 	      DIGITNUM:=1; 	 
      MINUS:=FALSE;  
 
      NOERROR:=TRUE; 
       MULT:=1;        NUM:=0;         READ;         if (INBUF='ALL') or (INBUF='INF') then          infflag := true         else  
        infflag := false;  
     
      if not infflag then  
         begin  (* inf not input *)            INBUF[MAXICHAR] := ' ';             if firstchar = '-' then   	            begin  	 
              MINUS:=TRUE; 
 
              DIGITNUM:=2; 
             end;                   (*Verify input as digits*)             while (INBUF[DIGITNUM]<>' ') and noerror do               if INBUF[DIGITNUM] IN ['0'..'9'] then   
              begin  
                 DIGITNUM:=DIGITNUM+1;                   NUMDIGITS:=NUMDIGITS+1;   	              end  	             else                noerror := false;       !          IF NOT NOERROR THEN writeln('Input was not a number.');  ! !          IF (NUMDIGITS>10) OR (NUMDIGITS=0) THEN NOERROR:=FALSE;  ! 
          if noerror then  
             FOR I:=NUMDIGITS DOWNTO 1 DO  
              begin  
                 DIGITNUM:=DIGITNUM-1;                   NUM:=NUM+(ORD(INBUF[DIGITNUM])-ORD('0'))*MULT;                  MULT:=MULT*10;  	              end; 	            IF MINUS THEN NUM:=-NUM;            (*Convert to +.*)              if (MINNUM = -99) and noerror then               begin                             (* Checking lu. *)                 NOERROR := FALSE;                 I := 1;                 while (I <= MAXNUM) and not noerror do                  begin                     IF LUBUF[I].LUNUM = NUM THEN                      NOERROR := TRUE;                    I := I+1;   
                end; 
              if not noerror then  
               begin 
 
                 writeln;  
 &                 writeln('Input was not a CS/80 LU # from the list above.'); & 
               end;  
             end             else  '            begin                             (* Check if number in range. *)  '               if (NUM>MAXNUM) or (NUM<MINNUM) then                  begin                     noerror := false;   %                  writeln('Number is out of bounds, it should be in the'); % %                  writeln('range of ',MINNUM:1,' <= # <= ',MAXNUM:1,'.');  % 
                end; 
             end;            if not noerror then inputerror;           end  (* of inf not input *)         else  
        num := 255;  
     until noerror;  (* end of repeat loop *)  
    readnum := num;  
   end;  (* READNUM *)               FUNCTION READPATTERN $DIRECT$:DOUBLETYPE;     VAR       I:WORDTYPE;       J:WORDTYPE;       K:WORDTYPE;       PATTERN:PATTERNTYPE;    BEGIN       REPEAT  
      NOERROR:=TRUE; 
       PATTERN.ALL:=0;         writeln;  #      prompt('Input the hexadecimal pattern of up to 8 hex digits: '); #       READ;         I:=1;         INBUF[16]:=' ';         WHILE (INBUF[I]<>' ') DO BEGIN  
        J:=ORD(INBUF[I]);  
         K:=-1;          IF (J>47) AND (J<58) THEN K:=J-48;          IF (J>64) AND (J<71) THEN K:=J-55;          IF K=-1 THEN NOERROR:=FALSE;          I:=I+1;         END;        I:=I-1;         IF (I=0) OR (I>8) THEN NOERROR:=FALSE;        IF NOERROR THEN BEGIN           J:=7;           WHILE I<>0 DO BEGIN             K:=ORD(INBUF[I]);   #          IF K<58 THEN PATTERN.HEX[J]:=K-48 ELSE PATTERN.HEX[J]:=K-55; # 	          I:=I-1;  	 	          J:=J-1;  	         END;  
      END ELSE INPUTERROR; 
 	    UNTIL NOERROR; 	     READPATTERN:=PATTERN.ALL;     END;              #(********************************************************************) # #(* Get address in either block or three vector mode, while checking *) # #(* for valid numbers.                                               *) # #(********************************************************************) # PROCEDURE GETADDR $DIRECT$;     VAR       mxsector:doubletype;      I:WORDTYPE;     begin       (* getaddr *)           if not eagle_rfsector then        begin  (* ask for block/three vector *)           writeln;  %        prompt('Do you want block (B) or three vector (V) addressing? ');  %         I := 99;          repeat            read;             case FIRSTCHAR of               'B': I := 0;              'V': I := 1;              OTHERWISE INPUTERROR;             end;  (* of case *)           until I <> 99;          writeln;          mxsector:=maxsector;        end (* of ask for block/three vector *)       else        begin   $        I := 1;  (* eagle rf sector always uses three vector address *)  $         mxsector:=maxsector + 1;        end;  
    COMP.ADDRRETMODE := I; 
     XCOMP(LU,DA,COMP,IOBUF);  	    ADDRMODE := I; 	     COMP := NULLCOMP;           with COMP.ADDRESS do        begin  (* input address *)          if ADDRMODE = 0 then            begin (* block address *)   !            prompt('Input block address (0 - ',MAXBLOCK:1,')? ');  !             BLOCK := READNUM(0,MAXBLOCK);   
            FILLER1 := 0;  
             if (spareblock and M7907) then                block := block - block mod 64;            end   (* of block address *)          else            begin (* three vector *)              prompt('Input cylinder (0 - ',maxcyl:1,')? ');              CYLINDER := READNUM(0,MAXCYL);              prompt('Input head (0 - ',maxhead:1,')? ');               HEAD := READNUM(0,MAXHEAD);               if (SPAREBLOCK AND (M794X or M7907)) then   
              sector := 0  
            else   	             begin 	                write('Input ');                  if eagle_rfsector then                    write('physical ');                 prompt('sector (0 - ',mxsector:1,')? ');                  sector := readnum(0,MXSECTOR);   	             end;  	           end;  (* of three vector *)         end; (* of input address *)     end;  (* of GETADDR *)              FUNCTION DESCRIBE:boolean $DIRECT$;   "{******************************************************************} " "{*  9-1-87  L. Doner :  Check location 6 of prodnum for 1 or 0 as *} " "{*                      well as 4. Indicates 795XB or 795XA. Also *} " "{*                      set the device type for them.             *} " "{******************************************************************} "     	VAR   I: WORDTYPE; 	   begin       DESCRIBE := FALSE;  
    M795XB := false; 
 
    M795XA := false; 
     COMP.UNITNUM := UNITNUM;  
    IF UNITNUM <> 15 THEN  
       begin   
        COMP.VOLUMENUM:=0; 
         COMP.ADDRRETMODE := ADDRMODE;         end;      XCOMP(LU,DA,COMP,IOBUF);      if checkqstat(true) then        if UNITNUM <> 15 then           begin  (* unit <> 15 *)   
          COMP:=NULLCOMP;  
           XDESC(LU,DA,COMP,IOBUF);            if checkqstat(true) then with IOBUF.DESCRIP do              begin   (* no error *)                MAXCYL     := DESMAXCYL;                MAXHEAD    := DESMAXHEAD;                 MAXSECTOR  :=DESMAXSECTOR;                MAXBLOCK   :=DESMAXBLOCK;                 INTERLEAVE :=DESINTLEAVE;                 TAPE       :=DESTYPE=2;                 DISC       :=DESTYPE<2;   
              IF DISC THEN 
                 FOR I:=1 TO 6 DO                    PRODNUM[I]:=DESPRODNUM[I];  &              if ((prodnum[4]=5) or (prodnum[4]=6)) and (prodnum[6]=1) then  &                 begin                     M795XB := true;                     device_type := 8;   
                end; 
 &              if ((prodnum[4]=5) or (prodnum[4]=6)) and (prodnum[6]=0) then  &                 begin                     M795XA := true;                     device_type := 7;   
                end; 
               CONTROLLER:=FALSE;                DESCRIBE:=TRUE;               end;  (* no error *)          end  (* unit <> 15 *)         else          begin  (* unit = 15 *)  
          MAXCYL:=0; 
           MAXHEAD:=0;             MAXSECTOR:=0;             MAXBLOCK:=0;            INTERLEAVE:=0;            TAPE:=FALSE;            DISC:=FALSE;            CONTROLLER:=TRUE;   
          DESCRIBE:=TRUE;  
         end;  (* of unit = 15 *)  
  end;  (* of DESCRIBE *)  
         procedure log_header $DIRECT$;    begin       start_child(9,prog_name.prog_int,3,device_type,0,0,0,                   buffer,-bufrlen);     end;  (* of log_header *)           procedure phys_print $direct$;    begin       writeln(f);       write(f,'Print physical address ');       if print_paddr then         begin           print_paddr := false;           writeln(f,'disabled');        end       else        begin           print_paddr := true;          writeln(f,'enabled');         end;    end;  (* of phys_print *)       $skip_text on$  procedure addr_print $DIRECT$ (index:bytetype);     begin   !    write(f,(((info[0+index] mod 128) * 256) + info[1+index]):4);  !     space(4);       write(f,info[2+index]:2);       space(3);       write(f,info[3+index]:3);     end;  (* of addr_print *)   $skip_text off$       PROCEDURE ZREQUESTSTAT $direct$;        begin       outbuf := 'REQUEST STATUS';       putility;           XRQST(lu,da,comp,iobuf);      if checkqstat(true) then     {Qstat = 0}        begin           prntstatus(iobuf.exreqstatrarea);   	        good_end;  	       end       else    {Qstat = 1}         bad_end;    end;  (* of ZREQUESTSTAT *)           procedure prnt_fault_error $direct$;    begin       start_child(9,prog_name.prog_int,4,device_type,0,0,0,                   buffer,-bufrlen);     end;  (* of prnt_fault_error *)           Procedure prt_error_info $DIRECT$ (logtype:wordtype);     begin        start_child(9,prog_name.prog_int,5,device_type,logtype,0,0,                    buffer,-bufrlen);     end;  (* of prt_error_info *)           &function DOUTIL $DIRECT$(UNUM,UTYPE,ULGN:WORDTYPE;UPARM1:BYTETYPE) :boolean; &   begin       with IOBUF.EXMISCTAREA do         begin   
        UTILNUM  := UNUM;  
 
        UTILTYPE := UTYPE; 
 
        PARMLGN  := ULGN;  
         PARM1    := UPARM1;   
        EXLGN    := 1024;  
       end;      XUTIL(LU,DA,COMP,IOBUF);      doutil := checkqstat(true);     END;          PROCEDURE SET_DEVICE_FLAGS (lu_print:boolean) $direct$;   %(************************************************************************) % %(*  9-1-87  L. Doner : 795X drives now include 796X drives. 795X device *) % %(*                     type is set in Describe.                         *) % %(*  9-2-87  L. Doner : Added a boolean variable, lu_print, to indicate  *) % %(*                     whether 'LU is ...' is printed to screen or not. *) % %(*                     True = print, False = do not print               *) % %(************************************************************************) % %(*  THIS PROCEDURE COMPARES THE SELECTED DEVICE TO A LIST OF PREDEFINED *) % %(*  DEVICES AND SETS THE FLAG OF THE TYPE OF DEVICE THAT HAS BEEN       *) % %(*  SELECTED, WHICH CAN THEN BE USED FOR IMPLEMENTING DEVICE-SPECIFIC   *) % %(*  FUNCTIONS.  IT ALSO TELLS WHAT DEVICE WAS SELECTED.                 *) % %(************************************************************************) %     var     J         : BYTETYPE;     toprinter : boolean;  begin   	  M791X  := false; 	 	  M793X  := false; 	 	  M794X  := false; 	 	  M7907  := false; 	 	  EAGLE  := false; 	 	  M795X  := false; 	   IF ((PRODNUM[2] = 7 ) AND (PRODNUM[3] = 9)) THEN     begin       IF (PRODNUM[4] = 4)  then         begin           M794X := true;   
         device_type := 0; 
        end;        IF ((PRODNUM[4] = 0) AND (PRODNUM[5] = 7)) then         begin           M7907 := true;   
         device_type := 1; 
        end;         IF ((PRODNUM[4] = 1) AND (PRODNUM[5] IN [1,2,4]    )) then           begin           M791X := true;   
         device_type := 2; 
        end;         IF ((PRODNUM[4] = 3) AND (PRODNUM[5] IN [3,5]      )) then           begin           M793X := true;   
         device_type := 3; 
        end;         IF ((PRODNUM[4] = 3) AND (PRODNUM[5] IN [6,7]      )) then           begin           EAGLE := true;   
         device_type := 6; 
        end;        if (prodnum[4] in [5,6] ) then          M795X := true;      end;      isp:=M794X or M7907 or M795X;     rsp:=M791X or M793X or EAGLE;  
   if lu_print then  
      begin         write('LU ',LU:1,' is a ');  
       toprinter := false; 
        dev_print(toprinter);         writeln;        end;   end;          (****************************************)  (* Read input until "Y", "N" or "EXIT"  *)  (****************************************)  function YESNOINPUT:boolean $DIRECT$;     begin       repeat  
      NOERROR:=TRUE; 
       READ;         CASE FIRSTCHAR OF            'Y': YESNOINPUT:=TRUE;            'N': YESNOINPUT:=FALSE;  	         OTHERWISE 	             INPUTERROR;               NOERROR:=FALSE;         end;  	    until noerror; 	   end;  (* of YESNOINPUT *)       PROCEDURE RUIN $DIRECT$;    begin       writeln('This routine will destroy current data.');       prompt('  Should it continue? ');       if not YESNOINPUT then user_end;    end;  (* of RUIN *)           function preset_drive $direct$ :boolean;    begin       writeln;      writeln('Preset in progress...');           if not DOUTIL(206,0,0,0) then         preset_drive := false       else        preset_drive := true;     end;  (* of preset_drive *)           PROCEDURE ZAMCLEAR $direct$;  $(**********************************************************************) $ $(*  This procedure implements the AMIGO CLEAR needed for 794X and     *) $ $(*  7907 devices.  The BUS LU is passed to the AMCLEAR external.      *) $ $(*  The fortran external FBUS is used to get the BUS LU from the      *) $ $(*  system tables.                                                    *) $ $(**********************************************************************) $ $(* 6-17-87  L. Doner : Removed the 795X drives from this command.     *) $ $(* 6-18-87  L. Doner : Added check for Fbus(Lu) = 0, fbuslu and message. $ $(**********************************************************************) $ var  fbuslu : boolean;      begin     if (ISP and NOT M795X) then       begin         outbuf := 'AMIGO CLEAR';        putility;         fbuslu := true;   	      if RTEA then 	         begin             iobuf.extablerarea.tbl[1]:=fbus(lu);            if (fbus(lu) = 0) then  	            begin  	               fbuslu := false;                writeln;  &    writeln('No HPIB Bus Controller LU has been assigned to the interface'); & '    writeln('card during system generation. On an RTE-A system, this LU is');  ' $    writeln('required to run the Amigo Clear command to a CS80 drive.'); $             end;          end;        xamcl(lu,da,comp,iobuf);        if (checkqstat(true) and fbuslu) then           good_end        else          bad_end;      end      else   
    invalid_command; 
 end;      PROCEDURE ZCANCEL $DIRECT$;     BEGIN       outbuf := 'CANCEL';       putility;           XCNCL(LU,DA,COMP,IOBUF);          if checkqstat(true) then        good_end      else        bad_end;    end;      PROCEDURE ZCHINCLR $DIRECT$;    begin       outbuf := 'CHANNEL INDEPENDENT CLEAR';      putility;           XCICL(LU,DA,COMP,IOBUF);      if checkqstat(true) then        good_end      else        bad_end;    end;  (* of channel independent clear *)          procedure zclearlog $DIRECT$;     var       LOGCODE:BYTETYPE;     begin       outbuf := 'CLEAR LOGS';       putility;           writeln;      writeln('Clear logs:');       writeln('  0 - all logs');      writeln('  1 - ERT log');       if ISP then         writeln('  2 - run-time log and fault log');  
    if M793X or EAGLE then 
       writeln('  3 - cache error log');       writeln;  
    prompt('Which log? '); 
     repeat        logcode := readnum (0,3);         if not preset_drive then          begin   	          writeln; 	           writeln('Warning: preset failed');          end;        case logcode of           0 : write(f,'All ');          1 : write(f,'ERT ');          2 : write(f,'Run-time and fault ');           3 : write(f,'Cache error ');  !      255 : inputerror;                {if 'all' or 'inf' entered} !       end;  
    until logcode <> 255;  
     if DOUTIL(205,0,1,LOGCODE) then         begin           writeln(f,'logs cleared');  	        good_end;  	       end       else        begin           writeln(f,'logs not cleared');          bad_end;        end;  
  end;  (* of zclearlog *) 
     procedure error_log $direct$ (logtype:wordtype);    var       x :bytetype;    begin       for x := 0 to 10 do         buffer[x] := info[x];        start_child(9,prog_name.prog_int,13,device_type,logtype,0,0,                     buffer,-bufrlen);   
  end;  (* of error_log *) 
     PROCEDURE ZDATALOG $direct$(logtype:wordtype);  $(*********************************************************************)  $ $(* 6-12-87  L. Doner : Sent a code to Log_header to let it know to   *)  $ $(*                     print 'Error' above 'Count'.                  *)  $ $(*********************************************************************)  $       VAR   
    I           :WORDTYPE; 
 
    J           :WORDTYPE; 
 
    K           :WORDTYPE; 
 
    INUM        :BYTETYPE; 
 
    found_error :boolean;  
   begin   
    found_error := false;  
 
    if LOGTYPE = 197 then  
       outbuf := 'READ RUN LOG'      else        outbuf := 'READ ERT LOG';       putility;           writeln;      prompt('Input the head (0 - ',maxhead:1,') or ALL? ');      I := READNUM(0,MAXHEAD);  
    if I = 255 then  
       begin           I := 0;           J := MAXHEAD;         end       else        J := I;       	    NOERROR:=TRUE; 	     REPEAT  (* repeat loop *)          if DOUTIL(LOGTYPE,2,1,I) then with IOBUF.EXDATALOGRAREA do           begin  (* display head info *)            writeln(F);             writeln(F,'Head # = ',I:1);             writeln(F,'# sectors read = ',NUMSECT:1);             if RSP then   	            begin  	               writeln(F,'Correctable errors = ',NUMCOR:1);                writeln(F,'Uncorrectable errors = ',ERR[0]:1);              end;            if numaddr > 0 then               begin  (* error address logged *)                  writeln(F,'Error addresses logged = ',numaddr:1);                  found_error := true;  
              writeln(F);  
               buffer[1] := 77;  {77 = print 'ERROR' }   
              log_header;  
               for K := 0 to numaddr-1 do                  begin (* display error *)   $                  for inum := 0 to 9 do info[inum] := err[K*10+inum+1];  $                   error_log(logtype);                   end;  (* display error *)               end    (* of error address logged *)            else              writeln(f,'  No errors logged');          end   (* of display head info *)        else          bad_end;        I:=I+1;       until I > J;  (* end of repeat loop *)          if found_error then         begin   
        writeln(F);  
         prt_error_info(logtype);        end;          good_end;     end;   (* datalog *)          PROCEDURE ZDESCRIBE $ direct $;   #{********************************************************************} # #{*  9-2-87  L. Doner  :  Added boolean variable lu_print to send as *} # #{*                       parameter to set_device_flags.             *} # #{********************************************************************} #     var     I,J       : WORDTYPE;     lu_print,     toprinter : boolean;      begin    (* ZDESCRIBE *)  	  if describe then 	     begin         outbuf := 'DESCRIBE';         putility;       	      writeln(F);  	 
      write(F,'MODEL:  '); 
       toprinter := true;  	      if tape then 	         write(F,'(CTD)')        else          dev_print(toprinter);             writeln(F,'UNIT:',UNITNUM:4);   
      write(F,'TYPE:   '); 
       IF TAPE THEN writeln(F,'TAPE');         IF CONTROLLER THEN writeln(F,'CONTROLLER');       	      if DISC then 	 
        begin  (* disc *)  
           writeln(F,'DISC');            writeln(F,'Maximum cylinder address =  ',MAXCYL);             writeln(F,'Maximum head address =      ',MAXHEAD);            writeln(F,'Maximum sector address =    ',MAXSECTOR);            writeln(F);             writeln(F,'Maximum block address =     ',MAXBLOCK);   !          writeln(F,'Current interleave factor = ',INTERLEAVE:1);  !         end;  (* of disc *)         lu_print := false;  locklu(0,LU);         set_device_flags(lu_print);         good_end;       end   (* of if describe *)    else      bad_end;  end;     (* ZDESCRIBE *)      $skip_text on$  procedure zeventlog $direct$;   var     i,j:bytetype;   begin     if eagle then       if doutil(165,2,0,0) then         with iobuf.eventlog do          for i:=1 to log_length do             begin               writeln(f,event[i].c_cyl : 6,                         event[i].c_head: 4,                         event[i].c_sect: 4,                         event[i].t_cyl :10,                         event[i].t_head: 4,                         event[i].t_sect: 4);              for j:=1 to 6 do  
              begin  
                 print_binary(event[i].table[j]);                  write(f,'    ');  	              end; 	             writeln(f,event[i].ef_ind:5,event[i].activity:10);            end;  end;  $skip_text off$       procedure zfltlog $DIRECT$;     const        max_errors = 18;   {18 * 11 = 198 and maximum buffer is 298}     VAR                  {helps break up output to screen}      tot_errors,       errors_left,      start_buf,      end_buf,      header,       x,      printflag :wordtype;    begin   
    outbuf := 'FAULT LOG'; 
     putility;       writeln(f);       if DOUTIL(199,2,0,0) then         begin           tot_errors:= iobuf.exfltlograrea.flt[0];          if tot_errors = 0 then            writeln(f,'No drive faults')           else             begin               printflag:=ord(print_paddr);              errors_left:=tot_errors;              header:=1;              line_cnt:=0;              while (errors_left > 0) and more_lines do   
              begin  
                  start_buf:=(tot_errors - errors_left) * 11 + 1;                    if errors_left > max_errors then                    begin                       buffer[0]:=max_errors;                       end_buf:= start_buf + (max_errors * 11) - 1;                        line_cnt:=30;   {force a more_lines message}                     end                    else                     begin                       buffer[0]:=errors_left;   !                    end_buf:= start_buf + (errors_left * 11) - 1;  !                   end;                  for x := start_buf to end_buf do  %                  buffer[x - start_buf + 1] := iobuf.exfltlograrea.flt[x]; % %                start_child(9,prog_name.prog_int,14,device_type,printflag, %                              header,tot_errors,buffer,-bufrlen);    
                header:=0; 
                 errors_left:=errors_left - max_errors;  	              end; 	             if RSP then   
              begin  
                 writeln(f);                   prompt('Display HFR values ? ');                  if yesnoinput then                    prnt_fault_error;   	              end; 	           end;        end   (* of DOUTIL *)       else        bad_end;      good_end;     end;  (* of zfltlog *)          
PROCEDURE ZFRMAT $direct$; 
 #(********************************************************************) # #(* 6-12-87  L. Doner : Changed Eagle to default to an interleave of *) # #(*                     1. Added warning message on interleave.      *) # #(********************************************************************) #       begin       outbuf := 'INIT MEDIA';       putility;       writeln;      ruin;       with IOBUF.EXFORMATTAREA do         begin           writeln;          writeln('Do you want to:');           option := 99;           repeat            if M7907 then               writeln(' I = retain no spares')             else               if M794X or M795X then                writeln(' R = read/write header (destructive)')   	             else  	               writeln(' M = initialize maintenance tracks');            writeln(' P = retain only primary spares');             writeln(' A = retain all spares');  	          writeln; 	           prompt('Option? ');             read;             writeln(f);             CASE FIRSTCHAR OF               'I': if M7907 then                     begin                       option:=2;                        writeln(f,'Retaining no spares');                     end                   else                      inputerror;              'M': if not (M7907 or M794X or M795X) then                     begin                       option:=2;   !                     writeln(f,'Initializing maintenance tracks'); !                    end                   else                      inputerror;              'R': if (M794X or M795X) then                      begin                       option:=2;   !                     writeln(f,'Read/write header (destructive)'); !                    end                   else                      inputerror;              'P': begin                     option:=1;                      writeln(f,'Retaining only primary spares');                   end;               'A': begin                     option:=0;   $                   writeln(f,'Retaining primary and secondary spares');  $                  end;   
           otherwise 
             inputerror;             end;(* of case *)           until OPTION <> 99;(* end of repeat loop *)           if M794X or M7907 or M795X or EAGLE then  
          interleave := 1  
          else             begin   
            writeln; 
 &            writeln('Warning: Interleave other than 1 on HP1000 systems,');  & $            writeln('could result in serious performance degradation.'); $ 
            writeln; 
 &            prompt('Input interleave value (1 <= value <= 32)? '); (*2525*)  &             INTERLEAVE := READNUM(1,32); (*2525*)               writeln(f);               writeln(f,'Interleave value = ', interleave:1);             end;  	        time_msg;  	         XINMD(LU,DA,COMP,IOBUF);        end;          if checkqstat(true) then        good_end       else         bad_end;    end;   (* of format *)      procedure ZHELP $direct$;              (* Located in EXER1 *)     begin       start_child(9,prog_name.prog_int,1,                      device_type,ord(ce_mode),0,0,buffer,-bufrlen);     end;      
PROCEDURE ZIDIAG $direct$; 
 #(*******************************************************************)  # #(* 07-08-87  L. Doner  : Changed Eagle max_diag to 1.              *)  # #(*  9-2-87   L. Doner  : Changed max_diag of M795XA and M795XB.    *)  # #(*******************************************************************)  #       VAR       temp_unit :wordtype;  
    I         :doubletype; 
     status    :boolean;       max_diag  :bytetype;    BEGIN       outbuf := 'INTERNAL DIAGNOSTIC';      putility;           writeln;      with IOBUF.EXDIAGTAREA do         begin            prompt('Input the loop count (1 <= count <= 65535)? ');            I := READNUM(1,65535);  
        display_loop( I);  
 #        IF I > 32767 THEN LOOPS := (-32768)+(I-32768) ELSE LOOPS := I; #             if M7907 then max_diag  := 6;           if M791X then max_diag  := 13;          if M793X then max_diag  := 40;          if M794X then max_diag  := 3;           if EAGLE then max_diag  := 1;           if M795XA then max_diag := 4;           if M795XB then max_diag := 1;               writeln;  %        prompt('Input the diagnostic # (0 <= diag <= ',max_diag:1,')? ');  %         diagnum := readnum(0,max_diag);   
        writeln(f);  
         writeln(f,'Diagnostic # = ',diagnum:1);           parmlgn := 3;         end;      
    temp_unit := unitnum;  
 	    if M794X then  	       begin (* 794X *)          writeln;          prompt('Input unit number? (0 - 15)? ');          comp.unitnum := readnum(0,15);  
        writeln(f);  
         writeln(f,'Unit number = ',comp.unitnum:1);   
      end   (* of 794X *)  
     else  #      comp.unitnum := 15;  (* diag has to be directed to controller *) #         XDIAG(LU,DA,COMP,IOBUF);      status := checkqstat(true);           with iobuf.exdiagtarea do         begin           if M793X and (diagnum <> 0) then            begin               comp.unitnum := 15;   
            diagnum := 0;  
             loops := 1;               XDIAG(lu,da,comp,iobuf);              status := checkqstat(true);             end;  (* of IF *)   
      end;  (* of with *)  
     
    unitnum := temp_unit;  
 
    if describe then 
       begin  (* describe ok *)          if status then  	          good_end 	         else  	          bad_end; 	       end    (* of describe ok *)       else        bad_end;   (* describe failed *)    end;  (* of diag *)       procedure ZPRESET $DIRECT$;     begin       outbuf := 'PRESET DRIVE';       putility;           if preset_drive then        good_end      else        bad_end;    end;  (* of preset *)           PROCEDURE CACHE_STATS $direct$;   %{************************************************************************} % ${* 03-24-1987  L. Doner  :  Transfered cachetablearea to son instead of  $ {*                          extablearea. (Now 26 bytes)   %{* 03-25-1987  L. Doner  :  Initialized Nchwrihits to 0 for old firmware.  % %{************************************************************************} %   VAR       X      :bytetype;         BEGIN   
    if EAGLE or M793X then 
       begin           clear_outbuf;           outbuf := 'CACHE STATISTIC TABLE';  	        putility;  	         iobuf.cachetablearea.nchwrihits := 0;           if doutil(196,2,1,7) then             begin                       (* Call EXER1 *)              for x := 0 to 25 do                 buffer[x] := iobuf.cachetablearea.cachebyte[x];   %            start_child(9,prog_name.prog_int,7,device_type,LU,0,0,buffer,  %                         -bufrlen);                           {7 = Disp_cache_stat_tble}               good_end;             end           else  	          bad_end; 	       end        else         invalid_command;    end;  (* of cache_stats *)          PROCEDURE ZRDTBLS $direct$ (lu:wordtype);   $(*********************************************************************)  $ #(* 10-27-87  L. Doner : Added an option for the 795XB and 796XB drives # #(*                      to read all sector headers to report any spare # (*                      sectors.  $(*********************************************************************)  $   VAR       i,j      : integer;       cyl,      cylinder : cyltype;       flag1,      hd       : bytetype;      X,      tablenum : wordtype;      break,      anyspares : boolean;        begin       outbuf := 'READ DRIVE TABLES';      putility;   
    break := false;  
         writeln;      if M794X or M791X or M7907 or M795X then  
      tablenum := 1  
     else        begin  (* EAGLE or 793X *)          writeln;          writeln('Drive tables are:');           writeln(' 1 = Spare track');          if M793X then             begin               writeln(' 2 = Head value');               writeln(' 3 = Configuration');              writeln(' 6 = Runout');             end;          writeln(' 7 = Cache table');          writeln;          prompt('Input table #? ');          tablenum := readnum(1,7);   
        writeln(f);  
         writeln(f,'Table # = ',tablenum:1);         end;  (* of EAGLE or 793X *)          if doutil(196,2,1,tablenum) then        begin           for x := 0 to 298 do            buffer[x] := iobuf.extablerarea.tbl[x];   #          start_child(9,prog_name.prog_int,11,device_type,lu,tablenum, #                         maxhead,buffer,-bufrlen);         end       else        bad_end;      	    if M795XB then 	       begin   
        writeln(f);  
         writeln(f,'Do you want to see the spare sectors?');   
        writeln(f);  
 '       writeln(f,'(This takes approximately 16 minutes on an A-series 1000)'); '         prompt('("y" or "n") ');  
        if YESNOINPUT then 
         begin             locklu(1,LU);   
          cyl := 0;  
 	          hd := 0; 	           flag1 := 0;             anyspares := false;             COMP := nullcomp;             COMP.unitnum := 0;            COMP.volumenum := 0;            COMP.addressmode := 1;  { 3 vector }            COMP.address.sector := 0;             COMP.setlength := 1;            COMP.length := 1;     {block}                 writeln(f);             writeln(f,'Location of spared sectors:');             writeln(f);   
          space(6);  
           write(f,'LOGICAL');   
          space(8);  
           writeln(f,'SPARE');   
          space(1);  
 
          write(f,'CYL');  
 
          space(3);  
 
          write(f,'HEAD'); 
 
          space(2);  
 
          write(f,'SECT'); 
 
          space(4);  
           writeln(f,'TYPE');            writeln(f,'=================   =========');             writeln(f);                 repeat  	            repeat 	               COMP.address.cylinder := cyl;                 COMP.address.head := hd;                XLCRD(lu,da,comp,iobuf);                if checkqstat(true) then                  begin   %                  if doutil(213,2,0,0) then        { Read Headers = 213  } % %                    with IOBUF.readheadr do        { 2 = device send text} % 
                    begin  
                       i := 1;                         j := 1;   '                      repeat                { Only 1 sector spared per track}  ' &                        if (data[j+5] = 255) then   { no errors in sector }  & $                          if (data[j+3] = 255) then  { a spared sector } $                             begin                                 anyspares := true;                                flag1 := data[j+4];   '                                          {Sector's address is in next sector} ' #                                          {because of sector shuffle}  #                               j := j + 6;                                 if (data[j] <> 0) then  '                           cylinder := (((data[j] mod 128) * 256) + data[j+1]) '                               else                                  cylinder := data[j+1];                                write(f,cylinder:4);                                space(4);                                 write(f,data[j+2]:2);                                 space(4);                                 write(f,data[j+3]:2);                                 space(4);                                 if (flag1 >= 128) then                                  flag1 := flag1 - 128;                                 if (flag1 >= 64) then                                   flag1 := flag1 - 64;                                if (flag1 >= 32) then                                   flag1 := flag1 - 32;                                if (flag1 >= 16) then                                   flag1 := flag1 - 16;                                 if (flag1 = 8) OR (flag1 = 9) then                                   writeln(f,' PRIMARY');                                 if (flag1 = 4) OR (flag1 = 5) then                                   writeln(f,'SECONDARY');                               end; { spare sector }                              i := i+1;     {Count sectors: 1 to 64}                             j := J+6;     {Check next sector}                             if (ifbrk < 0) then                               break := true;                         until (flag1 <> 0) or (i >= 64) or break;                          flag1 := 0;                       end  { With }                     else                      bad_end;  { Doutil }                  end   { XLCRD good }  	              else 	                 bad_end;  { XLCRD }                     hd := hd + 1;               until (hd = maxhead + 1) or break;                  cyl := cyl + 1;   
            hd := 0; 
           until (cyl = maxcyl + 1) or break;                if NOT anyspares and NOT break then   	            begin  	 
              writeln(f);  
               writeln(f,'There are no spare sectors.');               end;          end; {'Do you want to see spare sectors'}         end; { if M795XB }        locklu(0,LU);     good_end;   end;      
PROCEDURE ZSEEK $direct$;  
 '(****************************************************************************) ' '(* This routine issues the Butterfly seek utility to an EAGLE disc drive.   *) ' '(* Routine is called from servo test.                                       *) ' '(****************************************************************************) ' '(* 3-3-1987  L. Doner  : Changed loop from 0-255 to 1-255 [infinite loop]   *) ' '(*                     : added time_msg                                     *) ' '(****************************************************************************) '       var loop :bytetype;         head :bytetype;     begin       writeln;      prompt('Input head (0 - ',maxhead:1,') or ALL? ');      head := readnum(0,maxhead);       if head = 255 then head := maxhead + 1;       writeln;      prompt('Input loop (1 - 255)? ');       loop := readnum(1,255);       time_msg;       repeat        if not doutil(177,0,1,head) then          bad_end;        loop := loop - 1;   
    until loop = 0;  
     good_end;     end;      
PROCEDURE ZSERVO $DIRECT$; 
 &(**************************************************************************) & &(* Implements Servo command                                               *) & &(**************************************************************************) & &(* 3-3-1987  L. Doner  :  Moved putility                                  *) & &(**************************************************************************) &       var       NUMSEEKS:DOUBLETYPE;      NUMLOOP:BYTETYPE;   
  begin  (*ZSERVO*)  
 
    outbuf:= 'SERVO TEST'; 
     putility;   	    if EAGLE then  	       zseek        else   	      if isp then  	         begin   	          writeln; 	            prompt('Input the loop count (1 <= count <= 255)? ');              NUMLOOP := READNUM(1,255);            display_loop(numloop);  
          time_msg;  
 "          if DOUTIL(191,2,1,NUMLOOP) then with IOBUF.EXSERVOAREA do  " %            begin               (*DECODE THE BYTES RETRIEVED FROM XUTIL*)  %               NUMSEEKS := UNUMSEEKS;                NUMSEEKS := (NUMSEEKS * 256) + LNUMSEEKS;   
              writeln(F);  
               CASE COMPLETIONSTATUS OF  %                0:  writeln(F,'Number of seeks completed = ',NUMSEEKS:1);  %                 1:  writeln(F,'Seek Failure');                  2:  writeln(F,'Position Failure');                  3:  writeln(F,'Timeout Failure');                 end;  (* case *)                good_end;               end   (* of DOUTIL *)              else   
            bad_end; 
         end          else           invalid_command;    end;                       (*ZSERVO*)       
PROCEDURE ZSPAR $direct$;  
 $(*********************************************************************)  $ "(* 9-02-87  L. Doner  : Added code for enhancements of the 795XB and " "(*                      the 796XB drives such as force sparing, more " !(*                      descriptive messages and error testing. It ! (*                      reports sector or track sparing.  $(*********************************************************************)  $   label 2;    var       spareq,       error_flg,      done,       savedata,   
    spare_maint :boolean;  
 	    i : wordtype;  	     
  begin  (* spare *) 
     outbuf := 'SPARE BLOCK';      putility;       writeln;  	    if M795XB then 	 &      writeln('795XB drives attempt to save the data of the target sector.') &     else        begin   &        writeln('WARNING: a spare retaining data does not retain the data'); &         writeln('         of the target sector.');        end;          spareblock := true;    {P1 - P10 returned after sparing}      repeat  (* repeat loop *)         spare_maint := false;   
      if M7907 then  
         begin             repeat (* 7907 maint *)   
            writeln; 
             prompt('Spare maintenance track? ');              if YESNOINPUT then                begin  (* spare maint track *)                  spare_maint := true;                  iobuf.exsparetarea.option := 0;                   writeln;                  prompt('Logging or Scratch (LOG,SCR)? ');                   read;   %                if inbuf = 'LOG' then IOBUF.EXSPARETAREA.OPTION := 10 else % %                if inbuf = 'SCR' then IOBUF.EXSPARETAREA.OPTION := 11 else %                 inputerror;                 end   (* of spare maint track *)              else                goto 2;   
            writeln; 
           until iobuf.exsparetarea.option <> 0;           end  (* of 7907 maint *)        else          begin   	        2:writeln; 	           if M795XB then  %            prompt('Do you want to retain the data on the target track? ') %           else  '          prompt('Do you want to retain the data on the rest of the track? '); '           if yesnoinput then  	            begin  	               savedata := true;                 IOBUF.exsparetarea.option := 0;               end             else  	            begin  	               savedata := false;                IOBUF.exsparetarea.option := 1;               end;  	          getaddr; 	           COMP.addressmode:=addrmode;           end;      "    repeat                 { Loop is for force bit on 795XB drives } " 
      error_flg := false;  
 
      done := true;  
       XSPRE(lu,da,comp,iobuf);        if IOBUF.qstat = 0 then           spareq := true        else          spareq := false;        XRQST(lu,da,comp,iobuf);         if checkqstat(true) then    {if Request Status worked ok}            begin             if not spareq then          {Qstat = 1 during spare}  #            with IOBUF.exreqstatrarea.formatted_status.errorstatus do  # 
              begin  
                 for i := 3 to 50 do                     if statusbits[i] then                       error_flg := true;                  for i := 52 to 63 do                    if statusbits[i] then                       error_flg := true;                  if statusbits[51] then                    begin                       writeln;  '                  writeln('Possible media wear. One or fewer spares remain.'); '                   end;                  if error_flg then                     begin                       prntstatus(IOBUF.exreqstatrarea);                       bad_end;                    end;  
              end;  {with} 
         end         else   {checkqstat is false}          bad_end;      &      if spareq or NOT error_flg then         { Qstat was good, no errors }  &         with IOBUF.exreqstatrarea.formatted_status do             begin   
            writeln; 
 !            if (derrorn[0] = 1) and M795XB then   { P7 - 795XB's } !               writeln('Data at target sector was saved.');              if savedata and NOT M795XB then   #              writeln('Data on the rest of the track was retained.');  #             if NOT savedata then                 writeln('Data at target track was not retained.');               if M795XB and (derrorn[3] = 0) then   
              begin  
                 writeln;  'writeln('The drive has determined that the sector does not need to be spared.' ' );                  writeln;                  prompt('Do you want to force sparing? ');                   if yesnoinput then                    begin                       done := false;                      if savedata then                        IOBUF.exsparetarea.option := 8                      else                        IOBUF.exsparetarea.option := 9;                     end   
                else 
                   done := true;   	              end  	             else                if NOT spare_maint then                   begin                     writeln(F);                     writeln(F,'Spared address was:');                     prntaddr(comp.address);                     writeln(F);                     if (derrorn[3] = 1) then                       writeln(F,'Sector sparing has completed.');                      if (derrorn[3] = 63) then                       writeln(F,'Track sparing has completed.');  
                end; 
           end;   {with}   	       until done; 	           writeln;        prompt('Would you like to spare another location? ');       until not yesnoinput;  (* end of REPEAT loop *)           good_end;     end;  (* of zspar *)          PROCEDURE ZSLDVCLR $direct$;  $(*********************************************************************)  $  (* 6-17-87  L. Doner : Added 795X drives to Select Device Clear.   $(*********************************************************************)  $       begin   
    if (rsp or M795X) then 
       begin           outbuf := 'SELECTED DEVICE CLEAR';  	        putility;  	 $        if not preset_drive then   (* preset to store RAM log entries *) $           begin   
            writeln; 
             writeln('Warning: preset failed');            end;          XSDCL(LU,DA,COMP,IOBUF);          if checkqstat(true) then  	          good_end 	         else  	          bad_end; 	       end        else         invalid_command;    end;              
procedure ZSENSE $DIRECT$; 
   var       X :bytetype;    begin   	    if M793X then  	       begin           outbuf := 'READ SENSORS';   	        putility;  	         if DOUTIL(194,2,0,0) then             begin                       (* Calls EXER1 *)               for x := 0 to 6 do                buffer[x] := iobuf.extablerarea.tbl[x];   !            start_child(9,prog_name.prog_int,8,device_type,0,0,0,  !                   buffer,-bufrlen);               good_end;             end            else   	          bad_end; 	       end        else         invalid_command;    end;          PROCEDURE ZREV $direct$;  $(**********************************************************************) $ #(* 04-21-87   L. Doner  :  Added code that checks to see if the upper  # !(*                         nibble is used in location 0 (number of ! #(*                         revisions to follow). If it is, 15 must be  # "(*                         added to get decimal result by addition.  " (*                         Simplified For loops.  $(**********************************************************************) $       var       I:WORDTYPE;     begin   
    if M7907 or M794X then 
       invalid_command        else         begin           outbuf := 'READ REVISION NUMBER';   	        putility;  	 
        writeln(F);  
         if DOUTIL(195,2,0,0) then with IOBUF.EXREVRAREA do            begin               writeln(F,' Part   Revision');              writeln(F,'number   number');               writeln(F,'------  --------');              if (REV[0].A <> 0) then                 for I := 1 to ((REV[0].A + 15) + REV[0].B) do   !                writeln(F,I:4,'    ',REV[I].A:2,' - ',REV[I].B:2)  !             else                for i := 1 to REV[0].B do   !                writeln(F,i:4,'    ',REV[i].A:2,' - ',REV[i].B:2); !             good_end;             end           else  	          bad_end; 	       end;    end;      PROCEDURE ZRFSECT $direct$;   %(***********************************************************************)  % "(* 04-21-87  L. Doner  :  Added check for firmware revision on 791X  " $(*                        drives. Prior to 5.0 RFSECT was not supported. $ %(***********************************************************************)  %       var       X           : wordtype;   
    good_rfsect : boolean; 
       begin       if ISP then         invalid_command        else         begin           outbuf := 'READ FULL SECTOR';   	        putility;  	         if EAGLE then eagle_rfsector := true;   
        writeln(F);  
         getaddr;          comp.addressmode := addrmode;           if EAGLE then             begin               with iobuf.eaglerfarea do   
              begin  
                 utilnum := 163;                   utiltype := 2;                  parmlgn := 6;                   address.cylinder := comp.address.cylinder;                  address.head     := comp.address.head;                  address.sector   := comp.address.sector;                  msg_len          := 300;                  if EAGLE then                     comp.address.sector := 0;                   xutil(lu,da,comp,iobuf);                  good_rfsect:= checkqstat(true);   	              end; 	           end            else              if (M791X and (rrev < 5.0)) then   	             begin 	                writeln;   '  writeln(f,'Read Full Sector was not implemented on firmware prior to 5.0 '); ' #               writeln(f,'on 791X drives. Check firmware revision.');  #                bad_end;                end             else               good_rfsect:= doutil(192,2,0,0);          if good_rfsect then             begin   !            (***************************************************)  ! !            (* store data in transfer buffer for child program *)  ! !            (***************************************************)  !             for X := 0 to 279 do                buffer[X] := iobuf.extablerarea.tbl[X];               for X := 280 to 285 do                buffer[X] := comp.address.full_addr[X-280];               (***************************************)               (*   Parms:                            *)               (*     (1) command number(12)          *)               (*     (2) device type                 *)               (*     (3) addrmode                    *)               (*     (4) unused                      *)               (*     (5) unused                      *)               (***************************************)               { 9 = Immediate schedule with wait}   
            {12 = zrfsect} 
 #            start_child(9,prog_name.prog_int,12,device_type,addrmode,  #                         0,0,buffer,-bufrlen);               good_end;             end            else   	          bad_end; 	       end;    end;      
procedure zunit $DIRECT$;  
 
 var temp: wordtype; 
   begin       outbuf := 'SET UNIT NUMBER';      putility;           writeln;  
    temp := UNITNUM; 
     prompt('Input the unit # (0 <= unit <= 15)? ');       UNITNUM := READNUM(0,15);       writeln(F);  (* cr/lf *)  
    if describe then 
       writeln(F,'Unit Selected = ',UNITNUM:1)       else        begin   
        writeln(F);  
         writeln(F,'Unit ',UNITNUM:1,' was NOT selected.');          unitnum := temp;          bad_end;        end;      good_end;     end;  (* of UNIT *)           PROCEDURE ZXXERT $direct$(readonly:boolean);  $(**********************************************************************) $ $(* 03-05-87  L. Doner : Added Time_msg prior to inputting loop count. *) $ $(* 06-12-87  L. Doner : Added Print Option and Log Option messages to *) $ $(*                      outfile. Fixed bug in code; comparison of     *) $ $(*                      offset to parm2 failed because one was in the *) $ $(*                      2's complement and the other the unsigned byte*) $ $(*                      version. Compare on Outfrm instead. Made minor*) $ $(*                      changes to the screen format. Sent a code to  *) $ $(*                      Log_header to print 'Loop' above 'Count'.     *) $ $(* 07-08-87  L. Doner : No longer a choice on parity error bit = 0.   *) $ $(* 10-19-88  L. Doner : Added max_offset. 7911, 7912 = 7; 7914 = 4;   *) $ $(*                      793X's = 63;                                  *) $ $(**********************************************************************) $       VAR       i,      inum,       code,       area,       pattern,      outfrm,       loop_cnt,       count,      utltype        :bytetype;       offset         :wordtype;       max_offset     : integer;       data_displayed :boolean;        procedure init_iobuf $direct$;    begin       with iobuf.exmisctarea do         begin           utilnum := code;          utiltype := utltype;          exlgn := 1024;   (* check into this value *)          parmlgn := 3;           if count = 255 then             parm1:=count      {inf chosen for loop count}            else   %          parm1 := 1;       {this is for Breaking at the end of each loop} %         parm2 := offset;          parmx[0] := outfrm;   
        if code < 202 then 
           begin               parmx[1] := area;   
            parmlgn := 4;  
           end;          if not((code=201) or (code=204)) then             begin               if parmlgn=4 then                 parmx[2]:=pattern   	             else  	               parmx[1]:=pattern;              parmlgn := parmlgn + 1;             end;        end;    end;      	  begin   {zxxert} 	 
    if READONLY then 
       outbuf := 'RO ERT'      else  
      outbuf := 'WTR ERT'; 
     putility;           if not readonly then        begin           writeln;          ruin;         end;          (*********************************)       (* preset drive to store off ram *)       (*********************************)       if not preset_drive then        begin           writeln;          writeln('Warning: preset failed');        end;          writeln;      (**********************)      (* Clear the ERT logs *)      (**********************)      prompt('Clear the ERT logs? ');       if YESNOINPUT then        begin   '        if not doutil(205,0,1,1) then   (* 205 Utility to Clear the ERT logs*) ' 	          bad_end; 	       end;      time_msg;       writeln;       prompt('Input the loop count (1 <= count <= 254 or INF)? ');       count := readnum(1,254);      display_loop(count);  
    IF READONLY THEN 
 
      begin  (* RO ERT *)  
         writeln;          writeln('Types of Read Only ERTs:');          writeln('  P = Selected area RO ERT');          writeln('  R = Random RO ERT');               repeat  	          writeln; 	           prompt('Enter the type of test? ');   
          code := 0; 
           read;             writeln(f);             write(f,'RO test type = ');             case FIRSTCHAR of               'P': begin CODE:=201;                      writeln(f,'P') end;              'R': begin CODE:=204;                      writeln(f,'R') end;              OTHERWISE INPUTERROR;             end;          until code <> 0;   (* end of repeat *)        end       else  
      begin (* WTR ERT *)  
         writeln;          writeln('Types of Write Then Read ERTs:');          writeln('  P = Pattern test WTR ERT.');           writeln('  R = Random address WTR ERT.');           IF (M791X or M793X) then            writeln('  S = Short WTR ERT');               repeat  	          writeln; 	           prompt('Enter the type of test? ');   
          code := 0; 
           read;             writeln(f);   	          writeln; 	           write(f,'WTR test type = ');            CASE FIRSTCHAR OF               'P': begin CODE:=200;                      writeln(f,'P') end;              'R': begin CODE:=203;                      writeln(f,'R') end;              'S': begin                     writeln(f,'S');                     IF M794X or M7907 or EAGLE or M795X then                        CODE := 0                     else                        CODE := 202;                    end;               OTHERWISE INPUTERROR;             end; (* of case *)          until code <> 0;  (* end of repeat *)         end;  (* of WTR ERT *)          IF (CODE=201) OR (CODE=200) THEN        begin  (* non-random ERT *)           getaddr;          writeln;          writeln('Do you want to test the:');          writeln('  V = volume');          if M791X or M793X or EAGLE or M795X then            begin               writeln('  H = head');              writeln('  C = cylinder');            end;          writeln('  T = track');           writeln('  S = sector');  
        area := 255; 
         REPEAT  	          writeln; 	           prompt('Test area? ');            READ;             writeln(f);             write(f,'Test area = ');            CASE FIRSTCHAR OF               'V': begin AREA:=4;                      writeln(f,'V') end;              'H': IF M794X or M7907 THEN INPUTERROR                   ELSE begin AREA:=3;                          writeln(f,'H') end;               'C': IF M794X or M7907 THEN INPUTERROR                  ELSE begin AREA:=2;                          writeln(f,'C') end;              'T': begin AREA:=1;                      writeln(f,'T') end;              'S': begin AREA:=0;                      writeln(f,'S')end;               OTHERWISE INPUTERROR;             end; (* of case *)          until area <> 255;  (* end of repeat *)         end;  (* of non-random ERT *)           if ISP then   	      offset := 0; 	     
    if M791X or M793X then 
       begin           writeln;          prompt('Do you want to use head offset? ');   
        if YESNOINPUT then 
           begin                if ((PRODNUM[4] = 1) AND (PRODNUM[5] IN [1,2])) then                 max_offset := 7;              if ((PRODNUM[4] = 1) AND (PRODNUM[5] = 4)) then                 max_offset := 4;  
            if M793X then  
               max_offset := 63;   
            writeln; 
 '            prompt('Input offset (-',max_offset:1,' <= offset <= ',max_offset: ' 
                   1,')'); 
             OFFSET := READNUM(-(max_offset),max_offset);            end           else            offset := 0;        end;      	    if EAGLE then  	 
       offset := 0;  
         IF NOT((CODE=201) OR (CODE=204)) THEN   
      begin (* WTR ERT *)  
         writeln;          writeln('Sources of the bit pattern are:');           writeln('  P = ERT internal Pattern Table');          writeln('  R = ERT generates Random pattern table');          writeln('  U = ERT User selected Pattern');               repeat  	          writeln; 	           prompt('Enter the pattern source? ');   
          PATTERN := 255;  
           READ;             writeln(f);             write(f,'Pattern source = ');             CASE FIRSTCHAR OF               'P': begin pattern := 0;                     writeln(f,'P') end;              'R': begin                     if ISP then                       pattern := 8                      else                        pattern := 2;                     writeln(f,'R');                   end;               'U': begin pattern := 1;                     writeln(f,'U') end;              OTHERWISE INPUTERROR;             end;  (* of case *)           until pattern <> 255;  (* end of repeat loop *)               if pattern = 1 then             if RSP then   	            begin  	               with IOBUF.EXMISCTAREA do                   begin                     UPATTERN[1] := READPATTERN;   !                  FOR I := 2 TO 16 DO UPATTERN[I] := UPATTERN[1];  !                   EXLGN:=64;                    PARMLGN:=0;                     UTILTYPE:=1;                    UTILNUM:=209;   
                end; 
                   XUTIL(LU,DA,COMP,IOBUF);                if not CHECKQSTAT(true) then                  begin   #                  writeln('Device did not accept the user pattern.');  # 
                  bad_end; 
 
                end; 
             end  (* of 793X or 791X or EAGLE *)             else              begin  (* 794X, 795X or 7907 pattern *)                 writeln;                writeln('Available patterns are:');                 if M794X then                   begin                     writeln('  1 = DB6');                     writeln('  2 = 924');                     writeln('  3 = DA');                    writeln('  4 = 17');                    writeln('  5 = AA');                    writeln('  6 = FF');                    writeln('  7 = 00');  
                end; 
               if M795X then                   begin                     writeln('  1 = 39CE7');                     writeln('  2 = C30');                     writeln('  3 = 30E61CC3987');                     writeln('  4 = B8F32E3CC');                     writeln('  5 = CC');                    writeln('  6 = DB6');                     writeln('  7 = 33F94CFE5');   
                end; 
               if M7907 then                   begin                     writeln('  1 = CD');                    writeln('  2 = E739');                    writeln('  3 = 33');                    writeln('  4 = DB6DB6');                    writeln('  5 = 4933');                    writeln('  6 = FF');                    writeln('  7 = 00');  
                end; 
                   writeln;                prompt('Input pattern number: ');                 pattern := readnum(1,7);  
              writeln(f);  
               writeln(f,'Pattern number = ',pattern:1);               end;  (* of 7907 or 794X pattern *)         end; (* of WTR ERT *)           writeln;      writeln('Output formats are:');       writeln('  P = print error information');       writeln('  L = log in error rate log');       repeat        writeln;        prompt('Enter the format? ');   	      OUTFRM:=255; 	       READ;   	      writeln(f);  	       CASE FIRSTCHAR OF   
         'L': BEGIN  
                 OUTFRM:=0;    (* Short error report *)                  UTLTYPE:=0;   (* 0 = no execution message *)                  writeln(f,'L option: Log in error rate log');   	              END; 	 
         'P': BEGIN  
                 OUTFRM:=1;    (* Long error report *)                   UTLTYPE:=2;   (* 2 = device send text *)                   writeln(f,'P option : Print error information');   	              END; 	          OTHERWISE INPUTERROR;  
      end;  (* of case *)  
     until outfrm <> 255;   (* end of repeat loop *)           if M7907 then with IOBUF.EXMISCTAREA do         begin  (* 7907 *)           utilnum  := 201; (* RO ERT *)           utiltype := 0;   (* no execution msg *)           parmlgn  := 4;   (* four parms sent *)          parm1    := 1;   (* count *)          parm2    := 0;   (* offset *)           parmx[0] := 0;   (* report type *)          parmx[1] := 0;   (* test area - sector *)           exlgn    := 0;   (* execution msg length *)       %        xutil(lu,da,comp,iobuf);   (* send RO ERT ck for write protect *)  %         if not checkqstat(false) then             with iobuf.fstatus.formatted_status.errorstatus do              begin  (* check for write protect *)                if statusbits[36] then                  begin (* write protected *)                     writeln;  (* cr/lf *)                     if (code = 201) or (code = 204) then                      begin (* RO ERT's *)                        if utltype = 0 then  (* log errors *)                           begin   %                          writeln('Write protected - cannot log errors');  %                           bad_end;                          end   
                      else 
                         begin   %                          writeln('Write protected - cannot update logs'); %                         end;                      end (* of RO ERT's *)                     else                      begin (* WTR ERT's *)                         writeln('Disc write protected');                        bad_end;                      end;  (* WTR ERT's *)                   end   (* of write protected *)  	              else 	                 begin                     prntstatus(iobuf.fstatus);  
                  bad_end; 
 
                end; 
             end;  (* of check for write protect *)  
      end;  (* of 7907 *)  
         if code < 202 then        comp.addressmode:=addrmode;       data_displayed := false;      line_cnt:=5;      loop_cnt:=0;      repeat        loop_cnt:=succ(loop_cnt);   	      init_iobuf;  	       xutil(lu,da,comp,iobuf);        if not checkqstat(true) then          bad_end;        with iobuf.exmisctarea do   $        if (utiltype<>utltype) or (parm1<>1) or (parmx[0]<>outfrm) then  $           begin   (* error detected *)              if not data_displayed then  
              begin  
                 writeln(F);                   buffer[1] := 99;  {99 = print 'LOOP'}                   log_header;                   data_displayed := true;   	              end; 	             for inum := 0 to 8 do                 info[inum]:=iobuf.exertrarea.data[inum];              info[9]:=loop_cnt;              line_cnt:=succ(line_cnt);               if more_lines then                error_log(198)  	             else  	               loop_cnt:=count;            end;            if breakflag then           loop_cnt:=count;      until loop_cnt >= count;      
    if data_displayed then 
       begin   
        writeln(F);  
         prt_error_info(198);   (* print ERT error info *)         end;      if checkqstat(true) then        good_end;     end;  (* of ERT's *)      #(*******************************************************************)  # #(* THIS PROCEDURE WILL CHECK THE LU THAT WAS READ IN  AGAINST THE  *)  # #(* LIST OF VALID CS80 LU'S ON YOUR SYSTEM. WHEN THE LU IS VERIFIED *)  # #(* THE ASSOCIATED HPIB ADDRESS IS ASSIGNED TO THAT LU FOR FURTHER  *)  # #(* CALLS REGUIRING LU # AND HPIB ADDRESS.                          *)  # #(*******************************************************************)  # FUNCTION LUVERIFY :boolean $DIRECT$;  	VAR  I : WORDTYPE; 	       begin (* LUVERIFY *)      I := 1;       LUVERIFY := FALSE ;       for I := 1 to 63 do         begin           if LUBUF[I].LUNUM = LU then             begin                 LUVERIFY := TRUE ;                DA := LUBUF[I].HPIB;            end;        end;    end;  (* LUVERIFY *)          &(**************************************************************************) & &(* THIS PROCEDURE PERFORMS A BUBBLE SORT ON THE VECTOR OF                 *) & &(* CS/80 LUS, SORTING ON SELECT CODE.  BY CONSTRUCTION, THE LUS ARE       *) & &(* ALREADY ARRANGED IN ASCENDING ORDER.                                   *) & &(**************************************************************************) & PROCEDURE SORTLU $ DIRECT $ (MAXLU : WORDTYPE);   #VAR    TEMP: LUDATATYPE;           (* HOLDING VARIABLE FOR SWAPPING *) #        I,J: WORDTYPE;              (* INTERATION VARIABLES *)       
BEGIN  (* SORTLU *)  
 
   FOR I := 1 TO MAXLU DO  
        FOR J := 1 TO (MAXLU-I) DO BEGIN   !           IF (LUBUF[J].SCODE[1] > LUBUF[J+1].SCODE[1]) THEN BEGIN !                TEMP := LUBUF[J];                 LUBUF[J] := LUBUF[J+1];                 LUBUF[J+1] := TEMP;  
           END ELSE BEGIN  
                IF (LUBUF[J].SCODE[1] = LUBUF[J+1].SCODE[1])   $               AND (LUBUF[J].SCODE[2] > LUBUF[J+1].SCODE[2]) THEN BEGIN  $                    TEMP := LUBUF[J];                     LUBUF[J] := LUBUF[J+1];                     LUBUF[J+1] := TEMP;  
               END;  
            END;          END;   
END;   (* SORTLU *)  
         &(*************************************************************************)  & &(*     THIS PROCEDURE LISTS TO OUTPUT DEVICE ALL CS/80 LUS GROUPED       *)  & &(*     IS ASCENDING ORDER BY SELECT CODES                                *)  & &(*************************************************************************)  & procedure listlu $DIRECT$ (maxlu :wordtype);    var    I      : wordtype;            cur_sc :scodetype;       
 begin  (* LISTLU *) 
    I := 1;  	   cur_sc[1] := 0; 	 	   cur_sc[2] := 0; 	    writeln(f);     writeln(f,'*********  CS80 LU s  ************');      writeln(f,'Sel Code   LU #   HPIB Addr   Unit');      writeln(f,'========   ====   =========   ====');      line_cnt:=8;      while (I <= maxlu) and more_lines do        begin         with LUBUF[I] do            begin  #           if (cur_sc[1] <> scode[1]) or (cur_sc[2] <> scode[2]) then  # 	             begin 	 
               writeln(f); 
                space(3);                 write(f,SCODE[1]:1,SCODE[2]:1);                 cur_sc[1] := scode[1];                  cur_sc[2] := scode[2];                end             else                space(5);  
           space(7); 
            write(f,LUNUM:2);  
           space(7); 
            write(f,HPIB:2);   
           space(8); 
            line_cnt:=succ(line_cnt);             writeln(f,UNIT:2);            end;  (* of with *)         I := I+1;       end; (* of while *)   end;   (* of listlu *)           '(***************************************************************************)  ' '(*   THIS PROCEDURE ACCUMULATES THE LU NUMBERS AND SELECT CODES OF ALL     *)  ' '(*   CS/80 DEVICES AVAILABLE TO THE USER AND THEN CALLS THE PROCEDURES     *)  ' '(*   "SORTLU" AND "LISTLU" TO SORT THE DATA AND LIST THE DATA TO THE       *)  ' '(*   LIST DEVICE IN A USEFUL FORMAT.                                       *)  ' '(***************************************************************************)  ' Procedure CS80LUS(VAR MAXLU: DOUBLETYPE) $DIRECT$;      $TYPE WORD_BYTE_TYPE = RECORD                                 (* RTE6 *)  $                         CASE INTEGER OF   #                        1 : (BYTE : PACKED ARRAY [1..2] OF BYTETYPE);  #                         2 : (WORD : WORDTYPE );   #                        3 : (QUAD : PACKED ARRAY [1..4] OF QUADTYPE);  #                         END;      !VAR    LU     : LUTYPE;          (* LU NUMBER WITH SIGN BIT SET *) ! !       CTYPE,                    (* CHARACTER CODE FOR LU TYPE *)  !        NTYPE,                    (* NUMBER CODE FOR LU TYPE *)         I,J    : WORDTYPE;        (* ITERATION VARIABLES *)  #       STAT1,                    (* STATUS VARIABLES FOR EXEC CALL *)  # %       STAT2  : SELCOTYPE;       (* STATUS VAR. TO CONTAIN SELECT CODE *)  % %       STAT3  : WORDTYPE;        (* STATUS VAR. TO CONTAIN HPIB ADDR   *)  % &       STAT4  : TAPEUNITTYPE;    (* STATUS VAR. TO DETERMINE IF TAPE UNIT *) &        os     : wordtype;        (* RTE6 *)          dum1   : wordtype;        (* RTE6 *)          dum2   : wordtype;        (* RTE6 *)          newlu  : wordtype;        (* RTE6 *)          table  : track_type;      (* RTE6 *)          convert_hpib : word_byte_type;     (* RTE6 *)      
BEGIN  (* CS80LUS *) 
    I := 1;     FOR J := 1 TO 63 DO       BEGIN         IF (LUTRU(J) <> -1) THEN            BEGIN             LU.SIGNBIT := 1;   
           LU.NUMBER := J; 
            CTYPE := LDTYP(LU, NTYPE);              IF (NTYPE = 240) OR (NTYPE = 640) THEN   	             BEGIN 	                LUBUF[I].LUNUM := J;                  os := which_os;                 if (os <= -1) and (os >= -17) then                    begin                     RTEA := false;                      getscode(13,J,stat1,stat2,stat3,stat4);                     lubuf[I].scode := stat2.selcode;   #                   newlu := J + 1152;  (* subfunction 22, get table *) #                    get_trackmap(1,newlu,table,8,dum1,dum2);                      convert_hpib.word := 0;                     convert_hpib.byte[2] := table.hpib[2];                      lubuf[I].hpib := convert_hpib.word;                     convert_hpib.word := 0;                     convert_hpib.byte[1] := table.unit[1];                      lubuf[I].unit := convert_hpib.quad[2];                      I := I + 1;  
                 end 
 
                else 
                  if (os <= -33) and (os >= -128) then                      begin                       RTEA := true;  "                     GETSCODE(13, J, STAT1, STAT2 , STAT3 , STAT4 ); "                      LUBUF[I].SCODE := STAT2.SELCODE;                        LUBUF[I].HPIB  := STAT3;                        LUBUF[I].UNIT  := STAT4.UNIT;                       I := I+1;                     end                    else  !                   writeln('Illegal OP system - contact support'); ! 	             end;  	          end;        end;      MAXLU := I-1;  	   SORTLU(MAXLU);  	 	   LISTLU(MAXLU);  	 
end;   (* CS80LUS *) 
         PROCEDURE ZCACHE_CONTROL $direct$ (option:wordtype);  '(****************************************************************************) ' '(* 3-6-1987  L. Doner    Original version                                   *) ' '(* 1-26-1988  L. Doner   Moved code to son because father was too large.    *) ' '(****************************************************************************) ' '(* OPTION : Parameter passed to this procedure to indicate utility required.*) ' (* ------   
(*      1 : Read Cache On  
 
(*      2 : Read Cache Off 
 
(*      3 : Write Cache On 
 (*      4 : Write Cache Off   (*      5 : Read and Write Cache On   (CACHEON)   (*      6 : Read and Write Cache Off  (CACHEOFF)  '(****************************************************************************) ' var      parm4 ,  
   parm5 : wordtype; 
     BEGIN          if spareblock then        parm4 := 0      else        parm4 := 1;         if disc then parm5 := 0 else      if tape then parm5 := 1 else      if controller then parm5 := 2 else      parm5 := 3;      
   buffer[0] := LU;  
 
   buffer[1] := DA;  
     !   start_child(9,prog_name.prog_int,9,option,addrmode,parm4,parm5, !                buffer,-bufrlen);          END;       {ZCACHE_CONTROL}       procedure ZRESET_STATS  $direct$;     begin   
    if M793X or EAGLE then 
       begin           outbuf := 'CLEAR CACHE STATISTICS';   	        putility;  	 
        writeln(F);  
         prompt('Clear Cache Statistic Table? ');  
        if YESNOINPUT then 
           begin               if DOUTIL (208, 0, 0, 0) then                 good_end              else                bad_end;            end           else  
          user_end;  
       end        else         invalid_command;    end;      procedure ZLOGCACHE $DIRECT$;     begin   
    if M793X or EAGLE then 
       begin           outbuf := 'READ CACHE ERROR LOG';   	        putility;  	         if DOUTIL (190, 2, 0, 0) then             with IOBUF.CACHELOGAREA do  	            begin  	 
              writeln(F);  
               writeln(F,'Cache Memory Error Test Log');                 writeln(F,'===========================');   $              writeln(F,'Number of cache memory correctable errors = ',  $                          corrs:1);  %              writeln(F,'Number of cache memory uncorrectable errors = ',  %                          uncorrs:1);                good_end;               end              else   
            bad_end; 
       end        else         invalid_command;    end;      
PROCEDURE ZINPUT $direct$; 
 %(***********************************************************************)  % (* 11-30-1987  L. Doner : Added file name messages.   %(***********************************************************************)  % var     i:wordtype;       begin     writeln;    writeln('The Input File or LU is ', infile);    writeln;  %  writeln('CI allows file names up to 16 characters plus a 4 character ',  %           'extension.');  #  writeln('FMGR allows 6 character file names. (It will truncate.)');  #   writeln;    prompt ('Enter new Input File or LU: ');    read;     for i:=1 to 64 do      { clear infile }   
    infile[i]:=' ';  
   infile:=inbuf;    close(input);     reset(input,infile);  end;      PROCEDURE ZOUTPUT $direct$;   $(**********************************************************************) $ (* 11-30-1987  L. Doner  :  Added file name messages.   $(**********************************************************************) $ var     i:wordtype;       begin     writeln;    writeln('The Output File or LU is ', outfile);    writeln;  %  writeln('CI allows file names up to 16 characters plus a 4 character ',  %           'extension.');  #  writeln('FMGR allows 6 character file names. (It will truncate.)');  #   writeln;    prompt ('Enter new Output File or LU: ');     read;     for i:=1 to 64 do    { clear outfile }  
    outfile[i]:=' '; 
 	  outfile:=inbuf;  	   rewrite(f,outfile,'shared');  end;      
procedure zterm $direct$;  
 var     i:wordtype;   begin   
  for i:=1 to 64 do  
 
    infile[i]:=' ';  
 	  infile[1]:='1';  	 	  outfile:=infile; 	   close(f);     close(input);     close(output);  
  rewrite(f,infile); 
   reset(input,infile);  
  rewrite(output,outfile); 
   writeln;    writeln('Input/Output is Terminal');  end;      procedure set_ce_mode $direct$;   begin   	  if ce_mode then  	 	    ce_mode:=false 	    else   	    ce_mode:=true; 	 end;       FUNCTION WRONG (VAR describe_ok : boolean) : boolean   $direct$;   $(**********************************************************************) $ "(* 11-16-87  L. Doner :  This function checks the block size of the  "  (*                       selected LU. It returns the following:    (*                       true : Not a valid CS80 device.  (*                       false : A valid CS80 device.   $(**********************************************************************) $     var      lu_print : boolean;      begin   	  wrong := false;  	 
  lu_print := false; 
   if describe then        {if describe is true, it worked ok }      begin   
      describe_ok := true; 
       set_device_flags(lu_print);   
      if EAGLE then  
          if (MAXBLOCK <> 2232203) and (MAXBLOCK <> 1201955) then              wrong := true;  
      if M793X then  
         if (MAXBLOCK <> 1579915) then             wrong := true;  
      if M791X then  
 %        if (MAXBLOCK <> 109823) and (MAXBLOCK <> 256255) and (MAXBLOCK <>  %            516095) and (MAXBLOCK <> 64749) then             wrong := true;  
      if M794X then  
         if (MAXBLOCK <> 92927) and (MAXBLOCK <> 216831) then            wrong := true;  
      if M795X then  
 %        if (MAXBLOCK <> 319094) and (MAXBLOCK <> 510551) and (MAXBLOCK <>  % %           319787) and (MAXBLOCK <> 594215) and (MAXBLOCK <> 1188431) then %           wrong := true;      end  { if describe }    else  
    describe_ok := false;  
 end;  { Wrong }           FUNCTION GET_COMMAND $direct$ : cmds_type;  var     workcmd:packed array[1..maxichar] of char;  	  c,cmd:cmds_type; 	   i:wordtype;     match,  	  unique:boolean;  	     begin     match:=false;     unique:=true;   
  c:=non_unique_cmd; 
   repeat      c:=succ(c);     {each successive command from cmd_array}      workcmd:='                ';  
    for i:=1 to cmd_len do 
       workcmd[i]:=cmd_array[c,i];   %    if inbuf = workcmd then  {if this is the command the user chose, then} % 
      if match then  
         unique:=false          else           begin             match:=true;  	          cmd:=c;  	         end;    until (c = wtr_ert) or not unique;  #  if unique and match then              {User entered a valid command} #     begin         if not ce_mode and (cmd in ce_mode_cmds) then           get_command:=needs_ce_mode  !       else                  {It is a proper command for the mode} !         begin             if (cmd = ce_mode_cmd) then   	            begin  	               if inbuf = 'CE MODE' then                   get_command:=cmd  
               else  
 !                get_command:=bad_cmd;       {Not a valid command}  !             end              else               get_command:=cmd;           end;      end      else   	    if unique then 	       get_command:=bad_cmd     {Not a valid command}       else         get_command:=non_unique_cmd;  end;      PROCEDURE ZCHANGE_LU $direct$;  %(***********************************************************************)  % !(* 04-21-87  L. Doner  :  Added code that reads the smallest drive ! #(*                        revision and stores it in global parm, rrev. # #(*                        This will be used by utilities that are only # $(*                        implemented for certain revisions of firmware  $ (*                        such as RFSECT.   #(*  9-2-87   L. Doner  :  Added boolean variable lu_print to send as a # (*                        parameter to set_device_flag.   #(* 11-11-87  L. Doner  :  Added call to Wrong to check block sizes for # "(*                        valid CS80 devices. Added boolean 'pass'.  " %(***********************************************************************)  %     var     lu_print,     pass,     describe_ok : boolean;    i : wordtype;   	  tempreal : real; 	   revcount : wordtype;      begin   
  cs80lus(MAXNUMLU); 
   describe_ok:=false;     pass := true;     repeat      writeln;      prompt('Input DRIVE LU? ');   
    exitflag:=true;  
     LU := READNUM(-99,MAXNUMLU);      writeln;      if not luverify then        writeln('LU is not a valid CS80 device.')        else         begin           comp:=nullcomp;           spareblock := false;          print_paddr := false;           xcncl(lu,da,comp,iobuf);          unitnum  := 0;          addrmode := 0;          if wrong(describe_ok) then            begin               writeln('LU is not a valid CS80 device.');  
            pass := false; 
           end;          if not describe_ok then   "          writeln('Error on initial describe, please check drive.'); "       end;    until (describe_ok and pass);   
  lu_print := true;  
   set_device_flags(lu_print);   '                 (* Copy drive revision into global parm for utility calls *)  '   if (not M7907 and not M794X) then       if (doutil(195,2,0,0)) then  with IOBUF.EXREVRAREA do         begin           rrev := (REV[1].A + (REV[1].B / 10));           if (REV[0].A <> 0) then             revcount := ((REV[0].A + 15) + REV[0].B)          else            revcount := REV[0].B;           for i := 1 to revcount do             begin               tempreal := (REV[i].A + (REV[i].B / 10));               if (tempreal < rrev) then                 rrev := tempreal;             end;        end       else         writeln(f,'Error occured while checking drive revision.');     (**********************************************)    (* insure removable cartridge is default unit *)    (**********************************************)    if M7907 then   	    unitnum := 1;  	   write('Current unit = ',unitnum:1);     if M7907 then write(' (removable)');    writeln;  end;      begin  {exer}     infile:=getfilename(input);     outfile:=getfilename(output);     rewrite(output,'1');    rewrite(f,outfile,'shared');  	  ce_mode:=false;  	   clear_outbuf;   &  ce_mode_cmds:=[amclear,clear_logs,diag,init_media,sdclear,spare,wtr_ert];  &   write('CS/80 EXTERNAL EXERCISER -- ');  
  writeln(rev_code); 
   prog_name.prog_char:='EXER1';  {child program}    zchange_lu;   
  breakflag:=false;  
   repeat      0:comp := nullcomp;       if (ifbrk < 0) or breakflag then        begin           infile:='1 ';           reset(input,infile);  
        breakflag:=false;  
       end;      comp.unitnum := unitnum;      eagle_rfsector := false;      spareblock := false;      writeln;  
    if ce_mode then  
       prompt('CE EXER>')       else         prompt('EXER>');      exitflag := true;       read;                {Get command from user}      exitflag := false;      case get_command of   {all commands}  "      needs_ce_mode   : writeln('Command requires CE Capabilities'); "       bad_cmd         : writeln('Unknown Command');   !      non_unique_cmd  : writeln('Partial Command is not Unique');  !       change_lu       : zchange_lu;         amclear         : zamclear;         cache_log       : zlogcache;        cacheon         : zcache_control(5);        cacheoff        : zcache_control(6);        cache_stat      : cache_stats;        cancel          : zcancel;        ce_mode_cmd     : set_ce_mode;        ciclear         : zchinclr;         clear_logs      : zclearlog;        descri          : zdescribe;        diag            : zidiag;         ert_log         : zdatalog(198);  {     event_log       : zeventlog;}         fault_log       : zfltlog;        help            : zhelp;        init_media      : zfrmat;         input_it        : zinput;         output_it       : zoutput;        preset          : zpreset;        print_physica   : phys_print;         readcacheon     : zcache_control(1);        readcacheoff    : zcache_control(2);        reqstat         : zrequeststat;         reset_stats     : zreset_stats;         rev             : zrev;         rf_sector       : zrfsect;        ro_ert          : zxxert(true);         run_log         : zdatalog(197);        sdclear         : zsldvclr;         sense           : zsense;         servo           : zservo;         spare           : zspar;        term            : zterm;        tables          : zrdtbls(lu);        unit            : zunit;        writecacheon    : zcache_control(3);        writecacheoff   : zcache_control(4);        wtr_ert         : zxxert(false);      end; {case}     until false;  end. 