 $PASCAL '24398-16061 REV.5000 <860821.1300>'  $CDS OFF  {****************************************************************   *                                                               *   *  (C) COPYRIGHT HEWLETT-PACKARD COMPANY 1984. ALL RIGHTS       *   *  RESERVED. NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED,        *   *  REPRODUCED OR TRANSLATED TO ANOTHER PROGRAMMING LANGUAGE     *   *  WITHOUT THE PRIOR WRITTEN CONSENT OF THE HEWLETT-PACKARD     *   *  COMPANY.                                                     *   *                                                               *   *****************************************************************   *   *    NAME:  TAPE *  SOURCE:  24398-18061 REPLACING A/L VERSION 91711-18287 *   RELOC:  24398-16061 REPLACING A/L VERSION 91711-16287  *    PGMR:  E.H. @ DMD, R.V., W.J.A., J.R.C.  *   *   REVISIONS:  *   *   860620 Jeff Conrad      Added $CDS OFF statement  }   $ RECURSIVE OFF,HEAP 0,IDSIZE 24,RANGE OFF $ 
PROGRAM TAPE(INPUT,OUTPUT); 
    CONST    MAXICHAR=16;    MAXOCHAR=80;      TYPE  
  BOLTYPE       = BOOLEAN; 
   BITTYPE       = 0..1;     QUADTYPE      = 0..15;  
  BYTETYPE      = 0..255;  
   WORDTYPE      = -32768..32767;  
  DOUBLETYPE    = INTEGER; 
   CYLTYPE       = 0..16777215;    ERRORTYPE     = (TYPEN,TYPES,TYPEC,TYPED);    STATMSKTYPE   = ARRAY[0..3] OF WORDTYPE;    UNITTYPE      = PACKED ARRAY[0..5] OF BYTETYPE;     DERRORTYPE    = PACKED ARRAY[0..3] OF BYTETYPE;     HEXCHARTYPE   = PACKED ARRAY[0..15] OF CHAR;    COMMAND       = (MISCT,CLRLOGT,FORMATT,ERTT,RESTAT,COPYADDR,                    ERRSUMR,DESCRIB,TAPEDATA,USELOG,MANBLOCK);        ERRAPTYPE     = PACKED RECORD                       CASE BOOLEAN OF                         TRUE:(ALLBITS:BYTETYPE);                        FALSE:(B:PACKED ARRAY[0..7] OF BOLTYPE);                    END;        DIAGTYPE      = PACKED RECORD                       PARTA:BYTETYPE;                       PARTB:BYTETYPE;                       TESTA:BYTETYPE;                       TESTB:BYTETYPE;                       FILLER1:WORDTYPE;                     END;        ADDRTYPE      = PACKED RECORD                       CASE BOOLEAN OF                         TRUE:(CYLINDER:CYLTYPE;                               HEAD:BYTETYPE;                              SECTOR:WORDTYPE);                         FALSE:(FILLER1:WORDTYPE;                               SINGLE_VECTOR:DOUBLETYPE);                     END;        COLTYPE       = PACKED RECORD                       COL:PACKED ARRAY[1..32] OF BOLTYPE;                     END;        ROWTYPE       = PACKED RECORD                       ROW:PACKED ARRAY[1..16] OF COLTYPE;                     END;        STATUSTYPE    = PACKED RECORD                       VOLUME:QUADTYPE;                      UNIT:QUADTYPE;                      UNITS:BYTETYPE;                       STATUSBITS:PACKED ARRAY[0..63] OF BOLTYPE;                      CASE ERRORTYPE OF                          TYPEN:(ADDRN:ADDRTYPE;DERRORN:DERRORTYPE);                          TYPES:(ADDRS:ADDRTYPE;LENGTHS:DOUBLETYPE);                          TYPEC:(UNITC:UNITTYPE;DERRORC:DERRORTYPE);                          TYPED:(DIAGD:DIAGTYPE;DERRORD:DERRORTYPE);                     END;        COMPTYPE      = PACKED RECORD                       UNITNUM:WORDTYPE;                       VOLUMENUM:WORDTYPE;                       ADDRESSMODE:WORDTYPE;                       ADDRESS:ADDRTYPE;                       SETBLOCKDISP:WORDTYPE;                      BLOCKDISP:DOUBLETYPE;                       SETLENGTH:WORDTYPE;                       LENGTH:DOUBLETYPE;                      BURSTSIZE:WORDTYPE;                       RPST1:WORDTYPE;                       RPST2:WORDTYPE;                       RERDRETRIES:WORDTYPE;                       STATUSFLAG:WORDTYPE;                      STATUSMASK:STATMSKTYPE;                       SETRELEASE:WORDTYPE;                      ADDRRETMODE:WORDTYPE;                       SETOPTION:WORDTYPE                    END;        EXMISCTTYPE   = PACKED RECORD                       UTILNUM:WORDTYPE;                       UTILTYPE:WORDTYPE;                      PARMLGN:WORDTYPE;                       PARM1:BYTETYPE;                       FILLER1:BYTETYPE;                       FILLER2:WORDTYPE;                       FILLER3:WORDTYPE;                       FILLER4:WORDTYPE;                       EXMSGLN:WORDTYPE;                       UPATTERN: ARRAY[1..16] OF DOUBLETYPE;                     END;        EXCLRLOGTTYPE = PACKED RECORD                       UTILNUM:WORDTYPE;                       UTILTYPE:WORDTYPE;                      PARMLGN:WORDTYPE;                       LOGCODE:BYTETYPE;                     END;        EXFORMATTTYPE = PACKED RECORD                       OPTION:WORDTYPE;                      INTERLEAVE:WORDTYPE;                    END;        EXERRSUMRTYPE = PACKED RECORD                       SUM:PACKED ARRAY[1..4] OF ROWTYPE;                    END;        EXERTTYPE     = PACKED RECORD                       UTILNUM:WORDTYPE;                       UTILTYPE:WORDTYPE;                      PARMLGN:WORDTYPE;                       TLOOP:BYTETYPE;                       TTYPE:BYTETYPE;                       TAREA:BYTETYPE;                       TSOURCE:BYTETYPE;                     END;        EXTAPETYPE    = PACKED ARRAY[1..776] OF BYTETYPE;         EXUSELOGRTYPE = PACKED RECORD                       AUTOCNT:WORDTYPE;                       ACCESSCNT:DOUBLETYPE;                     END;        EXMANBLOCKTYPE= RECORD                      FILLER1:PACKED ARRAY[1..2] OF CHAR;                       CARTRIDGE:PACKED ARRAY[3..9] OF CHAR;                       INFO:PACKED ARRAY [11..75] OF CHAR;                     END;        DESCRIPTYPE   = PACKED RECORD                       FILLER0:DOUBLETYPE;                       FILLER1:BYTETYPE;                       DESTYPE:BYTETYPE;                       FILLER2:WORDTYPE;                       FILLER3:BYTETYPE;                       HBYTEBLOCK:BYTETYPE;                      LBYTEBLOCK:BYTETYPE;                      FILLER4:BYTETYPE;                       FILLER5:ARRAY[0..5] OF WORDTYPE;                      DESMAXCYL:CYLTYPE;                      DESMAXHEAD:BYTETYPE;                      DESMAXSECTOR:WORDTYPE;                      FILLER6:WORDTYPE;                       DESMAXBLOCK:DOUBLETYPE;                       FILLER7:BYTETYPE;                     END;        IOBUFTYPE     = RECORD                      FQSTAT:WORDTYPE;                      FSTATUS:STATUSTYPE;                       WORKSPACE:ARRAY[1..46] OF WORDTYPE;                       AREG:WORDTYPE;                      BREG:WORDTYPE;                      QSTAT:WORDTYPE;                       CASE COMMAND OF                         MISCT:(EXMISCTAREA:EXMISCTTYPE);                        CLRLOGT:(EXCLRLOGTAREA:EXCLRLOGTTYPE);                        FORMATT:(EXFORMATTAREA:EXFORMATTTYPE);                        TAPEDATA:(EXTAPE:EXTAPETYPE);                         USELOG:(EXUSELOG:EXUSELOGRTYPE);                        MANBLOCK:(EXMANBLOCK:EXMANBLOCKTYPE);                         ERRSUMR:(EXERRSUMRAREA:EXERRSUMRTYPE);                        DESCRIB:(DESCRIP:DESCRIPTYPE);                        RESTAT:(EXREQSTATAREA:STATUSTYPE);                        ERTT:(EXERTTAREA:EXERTTYPE);                        COPYADDR:(EXCOPYADDR:ADDRTYPE);                     END;      CONST     NULLCOMP      = COMPTYPE[UNITNUM:-1,                             VOLUMENUM:-1,                             ADDRESSMODE:-1,  $                           ADDRESS:ADDRTYPE[CYLINDER:16777215,HEAD:255,  $                                             SECTOR:-1],                              SETBLOCKDISP:-1,                              BLOCKDISP:-1,                             SETLENGTH:-1,                             LENGTH:0,                             BURSTSIZE:-1,                             RPST1:-1,                             RPST2:-1,                             RERDRETRIES:-1,                             STATUSFLAG:-1,                              STATUSMASK:STATMSKTYPE[4 OF -1],                              SETRELEASE:-1,                              ADDRRETMODE:-1,                             SETOPTION:-1];       #  HEXCHAR       = HEXCHARTYPE['0','1','2','3','4','5','6','7','8','9', #                  'A','B','C','D','E','F'];      VAR     IOBUF          : IOBUFTYPE;     INBUF          : PACKED ARRAY [1..MAXICHAR] OF CHAR;    OUTBUF         : PACKED ARRAY [1..MAXOCHAR] OF CHAR;    LU             : WORDTYPE;    DA             : WORDTYPE;    BYTESPERBLOCK  : WORDTYPE;    MAXSECTOR      : DOUBLETYPE;    MAXHEAD        : DOUBLETYPE;    MAXCYL         : DOUBLETYPE;    MAXBLOCK       : DOUBLETYPE;    CURRENT_ADDRESS: DOUBLETYPE;    TAPEUNIT       : BOLTYPE;     DISC           : BOLTYPE;     CONTROLLER     : BOLTYPE;     SPAREBLOCK     : BOLTYPE;     COMP           : COMPTYPE;    NOERROR        : BOLTYPE;     UNITNUM        : WORDTYPE;    I              : WORDTYPE;      PROCEDURE XUTIL (VAR LU,DA:WORDTYPE;VAR COMP:COMPTYPE;                  VAR IOBUF:IOBUFTYPE); EXTERNAL;       PROCEDURE XUNLD (VAR LU,DA:WORDTYPE;VAR COMP:COMPTYPE;                   VAR IOBUF:IOBUFTYPE); EXTERNAL;      PROCEDURE XCNCL (VAR LU,DA:WORDTYPE;VAR COMP:COMPTYPE;                   VAR IOBUF:IOBUFTYPE); EXTERNAL;      PROCEDURE XCICL (VAR LU,DA:WORDTYPE;VAR COMP:COMPTYPE;                   VAR IOBUF:IOBUFTYPE); EXTERNAL;      PROCEDURE XSDCL (VAR LU,DA:WORDTYPE;VAR COMP:COMPTYPE;                   VAR IOBUF:IOBUFTYPE); EXTERNAL;      PROCEDURE XFMRK (VAR LU,DA:WORDTYPE;VAR COMP:COMPTYPE;                   VAR IOBUF:IOBUFTYPE); EXTERNAL;      PROCEDURE XDIAG (VAR LU,DA:WORDTYPE;VAR COMP:COMPTYPE;                  VAR IOBUF:IOBUFTYPE); EXTERNAL;       PROCEDURE XINMD (VAR LU,DA:WORDTYPE;VAR COMP:COMPTYPE;                  VAR IOBUF:IOBUFTYPE); EXTERNAL;       PROCEDURE XCOMP (VAR LU,DA:WORDTYPE;VAR COMP:COMPTYPE;                  VAR IOBUF:IOBUFTYPE); EXTERNAL;       PROCEDURE XSPRE (VAR LU,DA:WORDTYPE;VAR COMP:COMPTYPE;                  VAR IOBUF:IOBUFTYPE); EXTERNAL;       PROCEDURE XDESC (VAR LU,DA:WORDTYPE;VAR COMP:COMPTYPE;                  VAR IOBUF:IOBUFTYPE); EXTERNAL;       PROCEDURE XRQST (VAR LU,DA:WORDTYPE;VAR COMP:COMPTYPE;                  VAR IOBUF:IOBUFTYPE); EXTERNAL;       PROCEDURE READ $DIRECT$;    VAR       I:WORDTYPE;     BEGIN       INBUF:='-2';      IF NOT EOF THEN READLN(INBUF)   	      ELSE RESET;  	     FOR I:=1 TO MAXICHAR DO IF (INBUF[I] IN ['a'..'z']) THEN        INBUF[I]:=CHR(ORD(INBUF[I])-(ORD('z')-ORD('Z')));       IF INBUF = 'EXIT            ' THEN BEGIN  "      WRITELN('YOU HAVE CHOSEN TO EXIT, THE PROGRAM WILL NOW HALT'); "       HALT(0);      END;    END;      PROCEDURE INPUTERROR $DIRECT$;    BEGIN       WRITELN('Invalid input, please try again');     END;      FUNCTION YESNOINPUT:BOLTYPE $DIRECT$;     BEGIN       REPEAT  
      NOERROR:=TRUE; 
       READ;         IF INBUF[1]='Y' THEN YESNOINPUT:=TRUE         ELSE IF INBUF[1]='N' THEN YESNOINPUT:=FALSE         ELSE BEGIN          WRITELN('Valid answers are either YES, NO, or EXIT');           WRITELN('Please try again');          NOERROR:=FALSE;         END;  	    UNTIL NOERROR; 	   END;       FUNCTION READNUM $DIRECT$(MINNUM,MAXNUM:DOUBLETYPE):DOUBLETYPE;      VAR   	    MINUS:BOLTYPE; 	     NUMDIGITS:WORDTYPE;       DIGITNUM:WORDTYPE;  
    MULT:DOUBLETYPE; 
 
    NUM:DOUBLETYPE;  
 
    INFFLAG:BOLTYPE; 
     I:WORDTYPE;     BEGIN       REPEAT  
      NUMDIGITS:=0;  
 	      DIGITNUM:=1; 	 
      MINUS:=FALSE;  
 
      NOERROR:=TRUE; 
       MULT:=1;        NUM:=0;         READ;   #      IF (INBUF='ALL             ') OR (INBUF='INF             ') THEN #       INFFLAG:=TRUE ELSE INFFLAG:=FALSE;        IF NOT INFFLAG THEN BEGIN           INBUF[MAXICHAR]:=' ';           IF INBUF[1]='-' THEN BEGIN            MINUS:=TRUE;            DIGITNUM:=2;          END;          WHILE (INBUF[DIGITNUM]<>' ') AND NOERROR DO           IF INBUF[DIGITNUM] IN ['0'..'9'] THEN BEGIN             DIGITNUM:=DIGITNUM+1;             NUMDIGITS:=NUMDIGITS+1;           END ELSE NOERROR:=FALSE;           IF NOT NOERROR THEN WRITELN('Input was not a number.');             IF (NUMDIGITS>10) OR (NUMDIGITS=0) THEN NOERROR:=FALSE;            IF NOERROR THEN           FOR I:=NUMDIGITS DOWNTO 1 DO BEGIN            DIGITNUM:=DIGITNUM-1;             NUM:=NUM+(ORD(INBUF[DIGITNUM])-ORD('0'))*MULT;            MULT:=MULT*10;          END;          IF MINUS THEN NUM:=-NUM;          IF (NUM>MAXNUM) OR (NUM<MINNUM) THEN BEGIN  
          NOERROR:=FALSE;  
 #          WRITELN('Number is out of bounds. Number should be in the'); # !          WRITELN('range of ',MINNUM:7,'<= number <= ',MAXNUM:7);  !         END;          IF NOT NOERROR THEN INPUTERROR;         END ELSE NUM:=255;  	    UNTIL NOERROR; 	 	    READNUM:=NUM;  	   END;      PROCEDURE WRITEHEX $DIRECT$(HEXNUM:BYTETYPE);     BEGIN       WRITE(' ');       WRITE(HEXCHAR[HEXNUM DIV 16]);      WRITE(HEXCHAR[HEXNUM MOD 16]);    END;      PROCEDURE PRNTSTATUS $DIRECT$(VAR STATUSMSG:STATUSTYPE);    VAR   
    IGNTGT:BOLTYPE;  
 
    HITFLG:BOLTYPE;  
     I:WORDTYPE;     BEGIN       WITH STATUSMSG DO BEGIN         WRITELN;        WRITELN('**IDENTIFICATION FIELD**');        WRITELN;        IF TAPEUNIT THEN WRITE('Tape');         IF DISC THEN WRITE('Disc');         IF CONTROLLER THEN WRITE('Controller');         WRITELN(' unit selected');        WRITELN('Unit =',UNIT:2,' Volume = ',VOLUME:2);   #      IF UNITS<>255 THEN WRITELN('Unit ',UNITS:2,' requires service')  #       ELSE WRITELN('No units require service');   
      IGNTGT:=FALSE; 
 
      HITFLG:=FALSE; 
       FOR I:=0 TO 15 DO IF STATUSBITS[I] THEN HITFLG:=TRUE;   
      IF HITFLG THEN BEGIN 
         WRITELN;          WRITELN('**REJECT ERRORS FIELD**');           WRITELN;          IF STATUSBITS[2] THEN WRITELN('Channel parity error');          IF STATUSBITS[5] THEN WRITELN('Illegal opcode');  $        IF STATUSBITS[6] THEN WRITELN('Illegal volume or unit number');  $         IF STATUSBITS[7] THEN WRITELN('Address bounds error');           IF STATUSBITS[8] THEN WRITELN('Parameter bounds error');           IF STATUSBITS[9] THEN WRITELN('Illegal parameter');   !        IF STATUSBITS[10] THEN WRITELN('Message sequence error');  !          IF STATUSBITS[12] THEN WRITELN('Message length error');          END;  
      HITFLG:=FALSE; 
       FOR I:=16 TO 31 DO IF STATUSBITS[I] THEN HITFLG:=TRUE;  
      IF HITFLG THEN BEGIN 
         WRITELN;          WRITELN('**FAULT ERRORS FIELD**');          WRITELN;          IF STATUSBITS[17] THEN BEGIN            WRITELN('Cross unit err during COPY DATA');             WRITELN('Units which had errs are:');             FOR I:=0 TO 5 DO IF UNITC[I]<>255 THEN             WRITELN('UNIT =',UNITC[I]);            IGNTGT:=TRUE;           END;          IF STATUSBITS[18] THEN WRITELN('Controller fault');           IF STATUSBITS[22] THEN WRITELN('Unit fault');           IF STATUSBITS[24] THEN BEGIN            WRITELN('Hardware failed diagnostic');            IF NOT IGNTGT THEN BEGIN              IF DIAGD.PARTA<>0 THEN               WRITELN('PART NUMBER =',DIAGD.PARTA:3,' failed');              IF DIAGD.PARTB<>0 THEN               WRITELN('PART NUMBER =',DIAGD.PARTB:3,' failed');              IF DIAGD.TESTA<>0 THEN  #             WRITELN('TEST ERROR number =',DIAGD.TESTA:3,' returned'); #             IF DIAGD.TESTB<>0 THEN  #             WRITELN('TEST ERROR number =',DIAGD.TESTB:3,' returned'); # 
            IGNTGT:=TRUE;  
           END;          END;  $        IF STATUSBITS[26] OR STATUSBITS[27] OR STATUSBITS[28] THEN BEGIN $           WRITE('Release required for ');             IF STATUSBITS[26] THEN WRITE('OPERATOR ');            IF STATUSBITS[27] THEN WRITE('DIAGNOSTICS ');             IF STATUSBITS[28] THEN WRITE('INTERNAL ');             WRITELN('MAINTENANCE before command can be executed');             IF NOT IGNTGT THEN BEGIN              WRITELN('Unit requesting release=',UNITC[0]:3);   
            IGNTGT:=TRUE;  
           END;          END;          IF STATUSBITS[30] THEN           WRITELN('Power failed or drive just powered on');  (        IF STATUSBITS[31] THEN WRITELN('Automatic release has been completed');  (       END;  
      HITFLG:=FALSE; 
       FOR I:=32 TO 47 DO IF STATUSBITS[I] THEN HITFLG:=TRUE;  
      IF HITFLG THEN BEGIN 
         WRITELN;          WRITELN('**ACCESS ERRORS FIELD**');           WRITELN;  #        IF STATUSBITS[32] THEN WRITELN('Illegal parallel operation');  #         IF STATUSBITS[33] THEN WRITELN('Unitialized media');  "        IF STATUSBITS[34] THEN WRITELN('No more spares available');  "         IF STATUSBITS[35] THEN WRITELN('Device is not ready');  "        IF STATUSBITS[36] THEN WRITELN('Volume is write protected'); "         IF STATUSBITS[37] THEN WRITELN('No data found');  #        IF STATUSBITS[40] THEN WRITELN('Unrecoverable data overflow'); #         IF STATUSBITS[41] THEN BEGIN  #          WRITELN('Unrecoverable data, address of bad data follows:',  #                    ADDRN.SINGLE_VECTOR);            IGNTGT:=TRUE;           END;  !        IF STATUSBITS[43] THEN WRITELN('End of file encountered'); ! "        IF STATUSBITS[44] THEN WRITELN('End of volume encountered'); "       END;  
      HITFLG:=FALSE; 
       FOR I:=48 TO 63 DO IF STATUSBITS[I] THEN HITFLG:=TRUE;  
      IF HITFLG THEN BEGIN 
         WRITELN;          WRITELN('**INFORMATION ERRORS FIELD**');          WRITELN;  %        IF STATUSBITS[48] THEN WRITELN('Operator is requesting release');  %         IF STATUSBITS[49] THEN           WRITELN('Release requested for a diagnostic result');          IF STATUSBITS[50] THEN            WRITELN('Release requested for internal maintenance');    !        IF STATUSBITS[48] OR STATUSBITS[49] OR STATUSBITS[50] THEN !          IF NOT IGNTGT THEN BEGIN             WRITELN('Unit requesting release=',UNITC[0]);             IGNTGT:=TRUE;           END;  &        IF STATUSBITS[52] THEN WRITELN('Latency induced for data overrun');  & (        IF STATUSBITS[55] THEN WRITELN('Automatic sparing invoked by the unit'); ( "        IF STATUSBITS[57] THEN WRITELN('Recoverable data overflow'); "         IF STATUSBITS[58] THEN BEGIN  &          WRITELN('Marginal data encountered. Data was recovered but with'); & !          WRITELN('much difficulty. Address of marginal data is:', !                    ADDRN.SINGLE_VECTOR);            IGNTGT:=TRUE;           END;          IF STATUSBITS[59] THEN BEGIN  &          WRITELN('Recoverable data -- but a latency was induced in order'); & '          WRITELN('to recover the data. Address of the recovered block is:' ,  '                    ADDRN.SINGLE_VECTOR);            IGNTGT:=TRUE;           END;  #        IF STATUSBITS[61] THEN WRITELN('Maintenance track overflow');  #       END;        IF (NOT IGNTGT) AND (NOT SPAREBLOCK) THEN BEGIN            WRITELN('New target address is:', ADDRN.SINGLE_VECTOR);          END;        IF NOT SPAREBLOCK THEN BEGIN          I:=0;           REPEAT            IF DERRORN[I]<>0 THEN   #            WRITELN('DRIVE ERROR number= ',DERRORN[I]:3,' returned');  #           IF DERRORN[I]=64 THEN BEGIN               WRITE('HARDWARE FAULT REG = ');   
            I:=I+1;  
             WRITEHEX(DERRORN[I]);               WRITELN(' hex');            END;          I:=I+1;   	        UNTIL I=4; 	       END ELSE IF NOT IGNTGT THEN BEGIN           WRITELN('Address of spare block is:',                    ADDRN.SINGLE_VECTOR);          WRITELN('Length of spare block is:',LENGTHS);         END;        WRITELN;        WRITELN;      END;    END;          FUNCTION CHECKQSTAT :BOLTYPE;     BEGIN       IF IOBUF.QSTAT=0 THEN CHECKQSTAT:=TRUE ELSE BEGIN         IF IOBUF.FQSTAT = 0 THEN PRNTSTATUS(IOBUF.FSTATUS)          ELSE WRITELN('No status message returned.');        CHECKQSTAT:=FALSE;      END;    END;      FUNCTION DESCRIBE:BOLTYPE $DIRECT$;     BEGIN   
    DESCRIBE:=FALSE; 
 
    COMP.UNITNUM:=UNITNUM; 
     COMP.ADDRRETMODE:=0;      XDESC(LU,DA,COMP,IOBUF);      IF UNITNUM<>15 THEN BEGIN         IF (IOBUF.QSTAT<>1) THEN WITH IOBUF.DESCRIP DO BEGIN  
        MAXCYL:=DESMAXCYL; 
         MAXHEAD:=DESMAXHEAD;          MAXSECTOR:=DESMAXSECTOR;          MAXBLOCK:=DESMAXBLOCK;          BYTESPERBLOCK:= HBYTEBLOCK*256 + LBYTEBLOCK;          TAPEUNIT:= DESTYPE=2;   
        DISC:= DESTYPE<2;  
 
        CONTROLLER:=FALSE; 
       END;        DESCRIBE:= CHECKQSTAT;  	    END ELSE BEGIN 	       MAXCYL:=0;  	      MAXHEAD:=0;  	 
      MAXSECTOR:=0;  
 	      MAXBLOCK:=0; 	       TAPEUNIT:=FALSE;  	      DISC:=FALSE; 	       CONTROLLER:=TRUE;         DESCRIBE:=TRUE;       END;    END;      !FUNCTION DOUTIL $DIRECT$(UNUM,UTYPE,ULGN:WORDTYPE;UPARM1:BYTETYPE; !  MSGLENGTH:WORDTYPE) :BOLTYPE;    BEGIN       IOBUF.EXMISCTAREA.UTILNUM:=UNUM;      IOBUF.EXMISCTAREA.UTILTYPE:=UTYPE;      IOBUF.EXMISCTAREA.PARMLGN:=ULGN;      IOBUF.EXMISCTAREA.PARM1:=UPARM1;     IOBUF.EXMISCTAREA.EXMSGLN:=MSGLENGTH;      XUTIL(LU,DA,COMP,IOBUF);     IF CHECKQSTAT THEN DOUTIL:=TRUE ELSE DOUTIL:=FALSE;    END;     PROCEDURE XHELP $DIRECT$;   BEGIN      WRITE('*AMCLEAR-amigo clear (794x)           ');      WRITELN('*CHANNEL-HPIB channel test');      WRITE('*DIAG-internal diagnostic test        ');      WRITELN('*DESCRIBE-describe selected unit');      WRITE('*ERRSUM-print error summary data      ');      WRITELN('*FAULT LOG-print drive fault log');      WRITE('*OPER-operator interface utility      ');      WRITELN('*REV-print revision data');      WRITE('*RF SECTOR-read full sector utility   ');      WRITELN('*SENSE-print sensor data');     WRITELN('*SERVO-perform servo test');      WRITELN;     WRITELN('* = load EXER');       WRITELN('Tape is designed to be used in addition to EXER.');  "    WRITELN('Use EXER to find which LUs are generated into system.'); " &    WRITELN('Default unit number is always 0 upon entering EXER and TAPE.'); &     WRITELN('    TAPE ROUTINES:');     WRITELN('CANCEL-cancels the previous command');     WRITELN('CERT-certify tape');     WRITELN('CICLEAR-channel independent clear utility');      WRITELN('CLEAR LOGS-clear internal logs');      WRITELN('ERT LOG-print ERROR RATE TEST summary data');     WRITELN('EXIT-exit program');      WRITELN('HELP-prints this file over');     WRITELN('INIT MEDIA-format media utility');     WRITELN('PRESET-preset drive utility');      WRITELN('RO ERT-read only error rate test');      WRITELN('REQSTAT-request status');     WRITELN('RUN LOG-print run time data error log');     WRITELN('SDCLEAR-selected device clear');     WRITELN('SPARE-spare block utility');      WRITELN('TABLES-print internal table data');     WRITELN('UNIT-set unit utility');      WRITELN('UNLOAD-unload tape utility');      WRITELN('USE LOG-print TAPE use log');     WRITELN('WRITE FM-write end of file mark on tape');     WRITELN('WTR ERT-write then read ERT');    END;     PROCEDURE XOPER $DIRECT$;   BEGIN  &    WRITELN('To execute this utility, exit the TAPE program and run OPER.'); &    PROMPT('Do you want to exit the TAPE program? ');      IF YESNOINPUT THEN        HALT(0);    END;          PROCEDURE XCANCEL $DIRECT$;     BEGIN       WRITELN('CANCEL UTILITY');      XCNCL(LU,DA,COMP,IOBUF);      IF CHECKQSTAT THEN      BEGIN         WRITELN;        WRITELN('CANCEL UTILITY COMPLETED');      END;    END;      PROCEDURE XXCICLEAR $DIRECT$;     BEGIN       WRITELN('CHANNEL INDEPENDENT CLEAR UTILITY');       XCICL(LU,DA,COMP,IOBUF);      IF CHECKQSTAT THEN      BEGIN         WRITELN;        WRITELN('CHANNEL INDEPENDENT CLEAR UTILITY COMPLETED');       END;    END;      PROCEDURE XXSDCLEAR $DIRECT$;     BEGIN       WRITELN('SELECTED DEVICE CLEAR UTILITY');       XSDCL(LU,DA,COMP,IOBUF);      IF CHECKQSTAT THEN      BEGIN         WRITELN;        WRITELN('SELECTED DEVICE CLEAR UTILITY COMPLETED');       END;    END;      PROCEDURE XPRESET $DIRECT$;     BEGIN       WRITELN('PRESET DRIVE UTILITY');      IF DOUTIL(206,0,0,0,0) THEN       BEGIN         WRITELN;        WRITELN('PRESET DRIVE UTILITY COMPLETED');      END;    END;      PROCEDURE XCLEARLOG $DIRECT$;     VAR       LOGCODE:BYTETYPE;     BEGIN       WRITELN('CLEAR LOGS UTILITY');  	    LOGCODE:=255;  	     REPEAT  
      NOERROR:=TRUE; 
 !      WRITELN('Do you want to clear all the logs (ALL) or just');  !       WRITELN('the ERT log (ERT)?');        READ;         IF INBUF[1]='A' THEN LOGCODE:=0;        IF INBUF[1]='E' THEN LOGCODE:=1;        IF LOGCODE=255 THEN BEGIN   
        INPUTERROR;  
         NOERROR:=FALSE;         END;  	    UNTIL NOERROR; 	     IF DOUTIL(205,0,1,LOGCODE,0) THEN       BEGIN         WRITELN;        WRITELN('CLEAR LOGS UTILITY COMPLETED');      END;    END;      
PROCEDURE XUNIT $DIRECT$;  
   BEGIN       WRITELN('SET UNIT NUMBER UTILITY');       WRITELN('Input the unit number <= 15?');      UNITNUM:=READNUM(0,15);   
    IF DESCRIBE THEN BEGIN 
       WRITELN('UNIT SELECTED =',UNITNUM:3);         WRITELN;        WRITELN('SET UNIT NUMBER UTILITY COMPLETED');       END;    END;      PROCEDURE XREQUESTSTAT $DIRECT$;  VAR I: WORDTYPE;    BEGIN       WRITELN('REQUEST STATUS UTILITY');      XRQST(LU,DA,COMP,IOBUF);      IF IOBUF.QSTAT = 0 THEN       BEGIN         PRNTSTATUS(IOBUF.EXREQSTATAREA);        WRITELN;        WRITELN('REQUEST STATUS UTILITY COMPLETED');      END       ELSE        WRITELN('No status message returned.');     END;      PROCEDURE XWRLOGRECS ( OFFSET, LAST_REC : WORDTYPE );   VAR MESSAGE: PACKED ARRAY [1..40] OF CHAR;      PRINT, HEADER: BOOLEAN;   BEGIN     HEADER:= TRUE;    WHILE OFFSET < LAST_REC DO    WITH IOBUF DO     BEGIN       CASE EXTAPE[OFFSET+2] DIV 64 OF         1: BEGIN             MESSAGE:= '        UNCORRECTABLE';              PRINT:= TRUE;           END;         2: BEGIN             MESSAGE:= '        UNLOCATABLE';              PRINT:= TRUE;           END;         3: BEGIN             MESSAGE:='        UNCORRECTABLE AND UNLOCATABLE';             PRINT:= TRUE;           END;         OTHERWISE PRINT:= FALSE;      END;      OFFSET:= OFFSET + 3;  	    IF PRINT THEN  	     BEGIN   
      IF HEADER THEN 
       BEGIN           WRITELN('LOGICAL ADDR      ERRORS');          WRITELN('------------      ------');          HEADER:= FALSE;         END;  "      WRITELN(EXTAPE[OFFSET]*256 + EXTAPE[OFFSET+1] : 10, MESSAGE);  "     END;    END;    WRITELN;    WRITELN;  END;      
PROCEDURE XLRUNLOG;  
 BEGIN   	  COMP:= NULLCOMP; 	   WRITELN('READ RUN TIME DATA ERROR LOG UTILITY');    IF DOUTIL(197,2,1,0,776) THEN      WITH IOBUF DO     BEGIN       WRITELN('      RUN LOG HEADER');        WRITELN('      --------------');        WRITELN;        WRITELN('# of RECORDS =', EXTAPE[1]:4);       WRITELN('# of UNCORRECTABLE BLOCKS =',EXTAPE[2]:4);       WRITELN('# of UNLOCATABLE BLOCKS =',EXTAPE[3]:4);       IF EXTAPE[4] IN [0..4] THEN         WRITE('CERTIFICATION: ');       CASE EXTAPE[4] OF         0: WRITELN('NOT certified');          1: WRITELN('3M certified');         2: WRITELN('HP factory certified');         3: WRITELN('UNDEFINED');          4: WRITELN('Certified ON-LINE');          OTHERWISE           WRITELN('Bad certify value =', EXTAPE[4]:4);        END;        IF (EXTAPE[1] > 0)  THEN          XWRLOGRECS(5,EXTAPE[1]*3+5);        WRITELN;         WRITELN('READ RUN TIME DATA ERROR LOG UTILITY COMPLETED');       END;   END;      
PROCEDURE XLERTLOG;  
     BEGIN   	  COMP:= NULLCOMP; 	   WRITELN('READ ERT TIME DATA ERROR LOG UTILITY');    IF DOUTIL(198,2,1,0,776) THEN      WITH IOBUF DO     BEGIN       WRITELN('      ERT LOG HEADER');        WRITELN('      --------------');        WRITELN;        WRITELN('# of RECORDS =', EXTAPE[1]:4);  $     WRITELN('# of BLOCKS read =', EXTAPE[2]*16777216 + EXTAPE[3]*65536  $        + EXTAPE[4]*256 + EXTAPE[5] :8);   "     WRITELN('# of BLOCKS corrected =', EXTAPE[6]*256 + EXTAPE[7] +  "        EXTAPE[8]*256 + EXTAPE[9] :5);   #     WRITELN('  due to:  Permanents =', EXTAPE[6]*256 + EXTAPE[7] :5); # #     WRITELN('           Transients =', EXTAPE[8]*256 + EXTAPE[9] :5); #      WRITELN('# of UNCORRECTABLE BLOCKS =', EXTAPE[10]: 4);        WRITELN('# of UNLOCATABLE BLOCKS =', EXTAPE[11] :4);   
     IF EXTAPE[1] > 0 THEN 
        XWRLOGRECS(12,EXTAPE[1]*3+12);        WRITELN;         WRITELN('READ ERT TIME DATA ERROR LOG UTILITY COMPLETED');       END;   END;      	PROCEDURE XUSELOG; 	 BEGIN   	  COMP:= NULLCOMP; 	   WRITELN('READ TAPE USE LOG UTILITY');     WRITELN;    IF DOUTIL (199,2,0,0,6) THEN    BEGIN   	    WITH IOBUF DO  	       IF BREG = 1 THEN          WRITELN('ONE BYTE USE LOG DATA =', EXTAPE[1] :4)        ELSE          BEGIN             WRITELN('USE COUNT =', EXUSELOG.AUTOCNT :6);  "          WRITELN('# OF BLOCKS ACCESSED =', EXUSELOG.ACCESSCNT :11); "         END;      WRITELN;      WRITELN('READ TAPE USE LOG UTILITY COMPLETED');     END;  END;      
PROCEDURE XLRDTBLS;  
 VAR TABLE: BYTETYPE; I,INDEX: WORDTYPE;   BEGIN        COMP:= NULLCOMP;        WRITELN('READ TABLES UTILITY');       WRITELN;        WRITELN('Drive tables are:');       WRITELN('  10 = Manufacturers''s table');       WRITELN('  11 = Tape spare table');       WRITELN('  12 = Copy data address');        WRITELN;        PROMPT('Input drive table number? ');       TABLE:= READNUM(10,12);       IF DOUTIL(196,2,1,TABLE,776) THEN       BEGIN            IF TABLE = 10 THEN            BEGIN                  WRITELN('MANUFACTURER''S BLOCK TABLE');                 WRITELN;                  IF IOBUF.BREG = 1 THEN                       WRITELN('No manufacturer''s block data')  
               ELSE  
                WITH IOBUF.EXMANBLOCK DO   
               BEGIN 
 (*                  WRITELN('Cartridge type = ', CARTRIDGE);   *)                       WRITE('Number of user blocks = ');                      FOR I:= 12 TO 15 DO WRITE(INFO[I]);                       WRITELN;                      WRITELN('  Copywrite notice');                      FOR I:= 18 TO 34 DO WRITE(INFO[I]);                       WRITELN;                      FOR I:= 35 TO 57 DO WRITE(INFO[I]);                       WRITELN;                      WRITE('Manufacturer''s code = ');                       FOR I:= 60 TO 65 DO WRITE(INFO[I]);                       WRITELN;                      WRITE('Date code = ');                      FOR I:= 66 TO 75 DO WRITE(INFO[I]);                       WRITELN;  
               END;  
           END             ELSE IF TABLE = 11 THEN             BEGIN                  WRITELN('TAPE SPARE BLOCK TABLE');                  WRITELN;                  IF IOBUF.BREG = 1 THEN                       WRITELN('No spare table data!')   
               ELSE  
                WITH IOBUF DO  
               BEGIN 
                     WRITELN('ENTRY   TRACK #   BLOCK #');                       FOR I:= 1 TO EXTAPE[1] DO   
                    BEGIN  
                          INDEX:= I * 3;                            WRITELN(I:4, EXTAPE[INDEX+1] :9,   $                              EXTAPE[INDEX-1]* 256 + EXTAPE[INDEX] :10); $                     END;  
               END;  
           END             ELSE            BEGIN                  WRITELN;                  IF IOBUF.BREG = 1 THEN                       WRITELN('No copy address data.')  
               ELSE  
                WITH IOBUF.EXCOPYADDR DO   
               BEGIN 
                     WRITELN('Copy data disc starting');                       WRITELN('address = ', SINGLE_VECTOR);   
               END;  
           END;  	          WRITELN; 	           WRITELN('READ TABLES UTILITY COMPLETED');        END;   END;      	PROCEDURE XFMWRT;  	 VAR TEMP_ADDRESS: DOUBLETYPE;   BEGIN   	  COMP:= NULLCOMP; 	   WRITELN('WRITE FILE MARK UTILITY');     WRITELN;    WRITELN('Current block addr =', CURRENT_ADDRESS);     PROMPT('Input new block address  ');    TEMP_ADDRESS:= READNUM(0,MAXBLOCK);   
    COMP.ADDRESSMODE:= 0;  
     COMP.ADDRESS.FILLER1:= 0;       COMP.ADDRESS.SINGLE_VECTOR:= TEMP_ADDRESS;      CURRENT_ADDRESS:= TEMP_ADDRESS;   
  XFMRK(LU,DA,COMP,IOBUF); 
 
  IF CHECKQSTAT THEN 
   BEGIN       WRITELN;      WRITELN('WRITE FILE MARK UTILITY COMPLETED');     END;  END;      
PROCEDURE XLUNLOAD;  
 BEGIN     WRITELN('UNLOAD UTILITY');    WRITELN;  
  XUNLD(LU,DA,COMP,IOBUF); 
 
  IF CHECKQSTAT THEN 
   BEGIN       WRITELN;      WRITELN('UNLOAD UTILITY COMPLETED');    END;  END;      	PROCEDURE XLSPAR;  	 
VAR ERROR: BOOLEAN;  
 BEGIN   
  SPAREBLOCK:= TRUE; 
   WRITELN('SPARE BLOCK UTILITY');     WRITELN;    REPEAT  	    ERROR:= FALSE; 	     WRITELN('Do you want S (Skip) or J (Jump) sparing? ');      READ;       IF INBUF[1] = 'S' THEN IOBUF.EXMISCTAREA.UTILNUM:= 1         ELSE IF INBUF[1] = 'J' THEN IOBUF.EXMISCTAREA.UTILNUM:= 5            ELSE          BEGIN   &          WRITELN('Valid responses are S for Skip and J for Jump sparing');  &           ERROR:= TRUE;           END;  	  UNTIL NOT ERROR; 	 	  COMP:= NULLCOMP; 	   PROMPT('Input the block address ');     CURRENT_ADDRESS:= READNUM(0,MAXBLOCK);    COMP.ADDRESSMODE:= 0;     COMP.ADDRESS.FILLER1:= 0;     COMP.ADDRESS.SINGLE_VECTOR:= CURRENT_ADDRESS;   
  XSPRE(LU,DA,COMP,IOBUF); 
 
  IF CHECKQSTAT THEN 
   BEGIN       WRITELN('SPARE BLOCK COMMAND SENT');  	    XREQUESTSTAT;  	     WRITELN('SPARE BLOCK UTILITY COMPLETED');     END;    SPAREBLOCK:= FALSE;   END;      
PROCEDURE GET_ADD_LENGTH;  
 VAR TEMP_ADDRESS, TEMP_LENGTH : DOUBLETYPE;   BEGIN     WRITELN('Current block addr =', CURRENT_ADDRESS);   &  PROMPT('Input new block address  ');                                       &   TEMP_ADDRESS:= READNUM(0,MAXBLOCK);       
    COMP.ADDRESSMODE:= 0;  
     COMP.ADDRESS.FILLER1:= 0;       COMP.ADDRESS.SINGLE_VECTOR:= TEMP_ADDRESS;      CURRENT_ADDRESS:= TEMP_ADDRESS;   #  PROMPT('Input the length of the test,(-1 for the entire tape) ? ');  #   TEMP_LENGTH:= READNUM(-1,(MAXBLOCK+1)*BYTESPERBLOCK);     COMP.SETLENGTH:= 1;     COMP.LENGTH:= TEMP_LENGTH;  
  XCOMP(LU,DA,COMP,IOBUF); 
 	  COMP:= NULLCOMP; 	 END;          FUNCTION READPATTERN $DIRECT$:DOUBLETYPE;     VAR       I:WORDTYPE;       J:WORDTYPE;       K:WORDTYPE;   
    PATTERN : RECORD 
                 CASE BOOLEAN OF                     TRUE:(ALL:DOUBLETYPE);                    FALSE:(HEX:PACKED ARRAY[0..7] OF QUADTYPE);   
                END; 
   BEGIN       REPEAT  
      NOERROR:=TRUE; 
       PATTERN.ALL:=0;   $      WRITELN('Input the hexadecimial pattern of up to 8 hex digits.');  $       READ;         I:=1;         INBUF[16]:=' ';         WHILE (INBUF[I]<>' ') DO BEGIN  
        J:=ORD(INBUF[I]);  
         K:=-1;          IF (J>47) AND (J<58) THEN K:=J-48;          IF (J>64) AND (J<71) THEN K:=J-55;          IF K=-1 THEN NOERROR:=FALSE;          I:=I+1;         END;        I:=I-1;         IF (I=0) OR (I>8) THEN NOERROR:=FALSE;        IF NOERROR THEN BEGIN           J:=7;           WHILE I<>0 DO BEGIN             K:=ORD(INBUF[I]);   #          IF K<58 THEN PATTERN.HEX[J]:=K-48 ELSE PATTERN.HEX[J]:=K-55; # 	          I:=I-1;  	 	          J:=J-1;  	         END;  
      END ELSE INPUTERROR; 
 	    UNTIL NOERROR; 	     READPATTERN:=PATTERN.ALL;   END;      FUNCTION XUSERINPUT: BOOLEAN;   VAR I: WORDTYPE;  BEGIN      WITH IOBUF.EXMISCTAREA DO BEGIN       UPATTERN[1]:=READPATTERN;       FOR I:=2 TO 16 DO UPATTERN[I]:=UPATTERN[1];  	     EXMSGLN:=64;  	      PARMLGN:=0;  	     UTILTYPE:=1;  	 	     UTILNUM:=209; 	    END;      XUTIL(LU,DA,COMP,IOBUF);      XUSERINPUT:= CHECKQSTAT;   END;      PROCEDURE XXXLERT (TEST_TYPE: BYTETYPE);  
VAR DONE,ERROR : BOOLEAN;  
     LOOPS, TEST_AREA, SOURCE : BYTETYPE;  BEGIN     DONE:= FALSE;   
  CASE TEST_TYPE OF  
     0: WRITELN('READ ONLY ERT TEST');       1: WRITELN('WRITE THEN READ ERT TEST');       2: WRITELN('CERTIFICATION ERT TEST');     END;    IF TEST_TYPE <> 0 THEN    BEGIN       WRITELN('This test will destroy current data.');      PROMPT('Should it countinue? ');  
    IF NOT YESNOINPUT THEN 
     BEGIN   	      DONE:= TRUE; 	       WRITELN('ERT terminated by user');      END;    END;  	  IF NOT DONE THEN 	   BEGIN       WRITELN('Input the loop count: ');      WRITELN('1 <= count <= 254 or INF');      LOOPS:= READNUM(1,254);     END;    IF (NOT DONE) AND (TEST_TYPE <> 2) THEN       REPEAT  
      ERROR:= FALSE; 
       WRITELN('Do you want to test the');         WRITELN('  C = current address');         WRITELN('  S = specified track');         WRITELN('  E = entire tape');         READ;         CASE INBUF[1] OF          'C': BEGIN TEST_AREA:= 0;  GET_ADD_LENGTH; END;           'E': TEST_AREA:= 2;   	        'S': BEGIN 	                PROMPT('Input the track number ');                  TEST_AREA:= READNUM(0,15)*16 + 1;  	             END;  	          OTHERWISE ERROR:= TRUE;         END;   
    UNTIL NOT ERROR; 
   IF (NOT DONE) AND (TEST_TYPE=2) THEN TEST_AREA:=2;    IF (NOT DONE) AND (TEST_TYPE <> 0) THEN      REPEAT   
     ERROR:= FALSE;  
      WRITELN('Sources of the bit patterns are:');        WRITELN('  PT = ERT internal Pattern Table');       WRITELN('  UP = user inputs pattern table');        WRITELN('  RN = ERT generates Random pattern table');       WRITELN;        PROMPT('Enter the pattern source? ');       READ;       CASE INBUF[1] OF          'P': SOURCE:= 0;          'R': SOURCE:= 2;   	       'U': BEGIN  	 
              SOURCE:= 1;  
               IF NOT XUSERINPUT THEN  
              BEGIN  
 !                WRITELN('Device did not accept the user pattern'); !                 PROMPT('Do you wish to continue? ');                  IF NOT YESNOINPUT THEN                  BEGIN                     DONE:= TRUE;                    WRITELN('The ERT has been terminated.');  
                END; 
 	              END; 	             END;  	        OTHERWISE  	           BEGIN   
            ERROR:= TRUE;  
           END;       END;   
   UNTIL NOT ERROR;  
 	  IF NOT DONE THEN 	   BEGIN       WITH IOBUF.EXERTTAREA DO      BEGIN   
      UTILNUM:= 200; 
 
      UTILTYPE:= 0;  
 	      PARMLGN:= 4; 	 
      TLOOP:= LOOPS; 
       TTYPE:= TEST_TYPE;        TAREA:= TEST_AREA;        TSOURCE:= SOURCE;       END;      XUTIL(LU,DA,COMP,IOBUF);      IF CHECKQSTAT THEN      BEGIN         PROMPT('Do you want to see the ERT log? ');         IF YESNOINPUT THEN          XLERTLOG        ELSE        BEGIN           WRITELN;  
        CASE TEST_TYPE OF  
           0: WRITELN('READ ONLY ERT TEST COMPLETED');             1: WRITELN('WRITE THEN READ ERT TEST COMPLETED');             2: WRITELN('CERTIFICATION ERT TEST COMPLETED');           END;        END;      END;    END;  END;      	PROCEDURE XTPINT;  	 VAR DONE, QUIT, CERT : BOOLEAN;   BEGIN   	  COMP:= NULLCOMP; 	   WRITELN('INITIALIZE TAPE UTILITY');     WRITELN;  !  PROMPT('This test may destroy data. Do you wish to continue? '); ! 
  IF YESNOINPUT THEN 
   BEGIN   #    PROMPT('Do you want to initialize the spare table on the tape? '); #     IF YESNOINPUT THEN      BEGIN         IOBUF.EXFORMATTAREA.OPTION:=  5;        IOBUF.EXFORMATTAREA.INTERLEAVE:= 0;         XINMD(LU,DA,COMP,IOBUF);        IF CHECKQSTAT THEN        BEGIN           WRITELN;          WRITELN('INITIALIZE TAPE UTILITY COMPLETED');         END;      END       ELSE      BEGIN   %      WRITELN('This program will attempt to read the run log to verify');  %       WRITELN(' whether the tape is certified or not.');        WRITELN('This may take a few minutes !!');  
      QUIT:= FALSE;  
       REPEAT  
        DONE:= TRUE; 
         IOBUF.EXMISCTAREA.UTILNUM := 197;           IOBUF.EXMISCTAREA.UTILTYPE:= 2;           IOBUF.EXMISCTAREA.PARMLGN:= 1;          IOBUF.EXMISCTAREA.PARM1:= 0;          IOBUF.EXMISCTAREA.EXMSGLN:= 776;          XUTIL(LU,DA,COMP,IOBUF);          IF IOBUF.QSTAT <> 0 THEN            BEGIN               PROMPT('Attempting to read the run log FAILED,',                     ' Do you want to try again? ');              IF YESNOINPUT THEN  
              DONE:= FALSE 
             ELSE  
              BEGIN  
                 QUIT:= TRUE;                  WRITELN('Tape may be bad, please check tape');  	              END; 	           END           ELSE            BEGIN               IF IOBUF.EXTAPE[4] IN [0..4] THEN                 WRITE('Tape was ');               CASE IOBUF.EXTAPE[4] OF                 0: WRITELN('NOT certified');                1: WRITELN('3M certified');                 2: WRITELN('HP factory certified');                 3: WRITELN('undefined certified');                4: WRITELN('ON-LINE certified');                OTHERWISE                   WRITELN('Bad certify value in run log =',                               IOBUF.EXTAPE[4] :2);              END;              CERT:= ( IOBUF.EXTAPE[4] IN [1,2,4] ) ;             END;  	      UNTIL DONE;  	       IF NOT QUIT THEN        BEGIN   %        IF CERT THEN                                                       % '          WRITELN('Tape will now have jump spares converted to skip spares.')  ' 	        ELSE BEGIN 	           WRITELN('Tape will now be certified.');             WRITELN('This may take a few minutes !!');          END;          IOBUF.EXFORMATTAREA.OPTION:=  0;          IOBUF.EXFORMATTAREA.INTERLEAVE:= 0;           XINMD(LU,DA,COMP,IOBUF);  
        IF CHECKQSTAT THEN 
         BEGIN             IF CERT THEN              WRITELN('Jump spares converted to skip spares.')            ELSE              WRITELN('Certify test complete.');  	          WRITELN; 	           WRITELN('INITIALIZE TAPE UTILITY COMPLETED');           END;        END;      END;    END;  
END;  { end xtpint } 
    	PROCEDURE REMINDER; 	BEGIN %  WRITELN('To use this utility the current unit must be set to the Tape.'); % '  WRITELN('If you wish to run the utility using a unit other than the Tape,'); '   WRITELN('EXIT from this program and run EXER.'); 
END; { end reminder } 
    PROCEDURE XEXR1 $DIRECT$;   BEGIN %    WRITELN('To execute this utility,exit the TAPE program and run EXER.'); %    WRITELN('Do you want to exit the TAPE program?');     IF YESNOINPUT THEN HALT(0);    END;     BEGIN 
  WRITELN('TAPE Rev.2440'); 
  SPAREBLOCK:= FALSE; 
   WRITELN;   WRITELN('CS/80 EXTERNAL TAPE EXERCISER');   WRITELN('              (use with EXER)');    WRITELN;   WRITELN('Input drive LU?');  
  LU:=READNUM(1,99); 
   WRITELN('Input DRIVE ADDRESS?'); 	  DA:=READNUM(0,7); 	  I:=0;   COMP:=NULLCOMP;    CURRENT_ADDRESS:= 0;  
  XCNCL(LU,DA,COMP,IOBUF); 
   IF IOBUF.QSTAT<>0 THEN BEGIN        WRITELN('Initial status: ');        IF IOBUF.FQSTAT=0 THEN PRNTSTATUS(IOBUF.FSTATUS)        ELSE BEGIN       WRITELN('Error on request status,please check drive.');        HALT(1);    END;  END;   UNITNUM:=0;    IF NOT DESCRIBE THEN BEGIN      WRITELN('Error on initial describe, please check drive.');      HALT(1);    END;    REPEAT  
    COMP:=NULLCOMP;  
     WRITELN;      WRITELN('Input the test name?');      READ;       WRITELN;      IF INBUF = 'HELP            ' THEN XHELP ELSE       IF INBUF = 'DIAG            ' THEN XEXR1 ELSE               IF INBUF = 'SENSE           ' THEN XEXR1 ELSE               IF INBUF = 'REV             ' THEN XEXR1 ELSE               IF INBUF = 'ERRSUM          ' THEN XEXR1 ELSE             IF INBUF = 'RF SECTOR       ' THEN XEXR1 ELSE           IF INBUF = 'CHANNEL         ' THEN XEXR1 ELSE             IF INBUF = 'OPER            ' THEN XOPER ELSE       IF INBUF = 'UNIT            ' THEN XUNIT ELSE       IF INBUF = 'CANCEL          ' THEN XCANCEL ELSE       IF INBUF = 'CICLEAR         ' THEN XXCICLEAR ELSE       IF INBUF = 'SDCLEAR         ' THEN XXSDCLEAR ELSE       IF INBUF = 'PRESET          ' THEN XPRESET ELSE       IF INBUF = 'REQSTAT         ' THEN XREQUESTSTAT ELSE  #    IF INBUF = 'TABLES          ' THEN IF TAPEUNIT THEN XLRDTBLS ELSE  # 
       REMINDER ELSE 
 $    IF INBUF = 'WTR ERT         ' THEN IF TAPEUNIT THEN XXXLERT(1) ELSE  $ 
       REMINDER ELSE 
 #    IF INBUF = 'RUN LOG         ' THEN IF TAPEUNIT THEN XLRUNLOG ELSE  # 
       REMINDER ELSE 
 #    IF INBUF = 'ERT LOG         ' THEN IF TAPEUNIT THEN XLERTLOG ELSE  # 
       REMINDER ELSE 
 $    IF INBUF = 'RO ERT          ' THEN IF TAPEUNIT THEN XXXLERT(0) ELSE  $ 
       REMINDER ELSE 
 #    IF INBUF = 'CLEAR LOGS      ' THEN IF TAPEUNIT THEN XCLEARLOG ELSE # 
       REMINDER ELSE 
 "    IF INBUF = 'SPARE           ' THEN IF TAPEUNIT THEN XLSPAR ELSE  " 
       REMINDER ELSE 
 "    IF INBUF = 'INIT MEDIA      ' THEN IF TAPEUNIT THEN XTPINT ELSE  " 
       REMINDER ELSE 
 "    IF INBUF = 'USE LOG         ' THEN IF TAPEUNIT THEN XUSELOG ELSE " 
       REMINDER ELSE 
 "    IF INBUF = 'WRITE FM        ' THEN IF TAPEUNIT THEN XFMWRT ELSE  " 
       REMINDER ELSE 
 #    IF INBUF = 'UNLOAD          ' THEN IF TAPEUNIT THEN XLUNLOAD ELSE  # 
       REMINDER ELSE 
 $    IF INBUF = 'CERT            ' THEN IF TAPEUNIT THEN XXXLERT(2) ELSE  $ 
       REMINDER ELSE 
     WRITELN('ILLEGAL USER COMMAND. PLEASE TRY AGAIN.');     UNTIL 1=2;  END. 