 $ {********************************************************************}  $  $PASCAL '91751-1X025 REV.5010 <880720.0844>'   $ {********************************************************************}  $ $ {                                                                    }  $ $ {    FILE  : XDISP.PAS                                               }  $ $ {    SOURCE: 91751-18025                                             }  $ $ {    RELOC.: 91751-1X025                                             }  $ $ {                                                                    }  $ $ {  ***************************************************************   }  $ $ {  * (C) COPYRIGHT HEWLETT-PACKARD COMPANY 1982.  ALL RIGHTS     *   }  $ $ {  * RESERVED.  NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED,      *   }  $ $ {  * REPRODUCED OR TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT*   }  $ $ {  * THE PRIOR WRITTEN CONSENT OF HEWLETT-PACKARD COMPANY.       *   }  $ $ {  ***************************************************************   }  $ $ {                                                                    }  $ $ {--------------------------------------------------------------------}  $ $ {                                                                    }  $ $ {  Contains the following procedures and functions :                 }  $ $ {                                                                    }  $ $ {  - XIO                                                             }  $ $ {  - PREP_STD_IBUF                                                   }  $ $ {  - GLOBAL_WRITES                                                   }  $ $ {  - GLOBAL_READS                                                    }  $ $ {                                                                    }  $ $ {  - EMA_USER_TRANSFER : - TRANSFER_REQ                              }  $ $ {                        - UPDATE_REQ                                }  $ $ {                        - RELEASE_BUFFER                            }  $ $ {                        - COMPLETE_REQ                              }  $ $ {                                                                    }  $ $ {  - ALL_VC_PKT_WRITES : - X25P_WRITES : - PREP_SEND_CALL            }  $ $ {                                        - PREP_CALL_CONF            }  $ $ {                                                                    }  $ $ {                        - DATA_PKT_WRITES                           }  $ $ {                                                                    }  $ $ {  - ALL_VC_TRANSFER                                                 }  $ $ {                                                                    }  $ $ {--------------------------------------------------------------------}  $ $page$  $ {--------------------------------------------------------------------}  $ $ {                                                                    }  $ $ { HISTORY :                                                          }  $ $ {                                                                    }  $ $ { Original    : 2201                                                 }  $ $ { Change #1   : 2226                                                 }  $ $ {   .support of RTE-A1                                               }  $ $ {   .use of XLUEX                                                    }  $ $ { Change #2   : 2326                                                 }  $ $ {   .support of RTE-A                                                }  $ $ { Change #3   : 2401                                                 }  $ $ {   .flow control enhancement                                        }  $ $ {   .user accessible Q-bit data packets                              }  $ $ {   .user accessible Call User Data field                            }  $ $ { Change #4   : 2440                                                 }  $ $ {   .PASCAL rev2440 support                                          }  $ $ { Change #5   : 5.0     (BG)                                         }  $ $ {   .Add updating of Lastbufferfilled pointer. (M10)                 }  $ $ {   .Improve Restart Network process. (M13)                          }  $ $ {   .Correct setting of Timer T3 to only read network LU . (M18)     }  $ $ {   .Add a read flush to the restart network sequence. (M19)         }  $ $ {   .adapt REGAB variable to a global declaration. (M27)             }  $ $ {   .Load segment XSEG3 before each call to XSUSP. (M30)             }  $ $ {    Add a call to XSUSP for unexpected case of X25P in X25P_WRITES. }  $ $ {   .Add the treatment of case D3 in all_vc_pkt_writes as well as an }  $ $ {    otherwise statement.                        (M38)               }  $ $ { Change #6   : 5.1     (BG)                                         }  $ $ {   .Add the treatment of case P3 and P7 in X25P_WRITES. (M45)       }  $ $ {   .Correct the transmission log calculation for PAD in procedure   }  $ $ {    Complete_req.                                       (M58)       }  $ $ {   .Add sending linkdown cause 'network ready' to each EQT of       }  $ $ {    a network when it becomes ready. This to allow for automatic    }  $ $ {    reenabling of VCs after any network failure. (M62)              }  $ $ {                                                                    }  $ $ {********************************************************************}  $     
 $STANDARD_LEVEL 'HP1000'$ 
  $SUBPROGRAM, RECURSIVE OFF $    $RANGE OFF$   $CDS OFF$  
 $HEAP_DISPOSE OFF$  
  $HEAP 2$       
 PROGRAM XDISPATCH;  
      $TITLE 'X.25/1000  XDISP dispatcher'$   $SUBTITLE ' '$    { includes  XTBLG.PASI, XTBLV.PASI, XNETG.PASI }    $LIST OFF$                 {subdirectories must be provided}    $INCLUDE 'XTBLG.PASI'$     {in the installation procedure. }    $INCLUDE 'XTBLV.PASI'$    $INCLUDE 'XNETG.PASI'$    $LIST ON$      $page$  	 $ HEAPPARMS OFF $ 	       procedure MSG1WRITE (msglu: word; msg: pa75c) ;   $direct$     external;      !  procedure Msgwrite(msglu:word; msg1,msg2,msg3,msg4,msg5: pa15c); !    external;        procedure CNUM  (n: word; var Nbconv: pa6c); $direct     external;        procedure XEXEC2 $ alias 'EXEC' {direct write}$      (icode,icnwd: word; ibuf:XMSGtype; ilen:word);      external;      "  procedure XMSGWR (msglu:word; msgindex:byte; lunb: word); $direct$ "    external;      #  Function  XIOWR  $ alias 'XLUEX' {class I/O write and read to card}$ #     (     icode: word;        var icnwd : XLUEXcnwdType ;   
      var ibuf : ibuftype; 
           ilen : word;  
          ip1 : ip1Type ;  
           ip2 : word;         var iclass : word ):  word {returns A Reg!} ;      external;      #  Function  XIOWX  $ alias 'XLUEX' {class I/O write and read to card}$ # #    (     icode: word;             {special RTE-A     CC 5/83       }  #       var icnwd : XLUEXcnwdType ;   
      var ibuf : ibuftype; 
           ilen : word;  
          ip1 : ip1Type ;  
           ip2 : word;         var iclass : word;            uv     : ip1Type ):  word {returns A Reg!} ;     external;         Function XIOCN   $alias 'XLUEX' {class I/O control to card} $        (     icode : word;         var icnwd : XLUEXcnwdType;        var ipram : word;         var iclass: word;   
          ip1   : ip1Type; 
           ip2   : word ):  word {returns A Reg!} ;      external;          Function XIOCX   $alias 'XLUEX' {class I/O control to card} $    !    (     icode : word;                   {---------------------}  ! !      var icnwd : XLUEXcnwdType;          { special for RTE-A   }  ! !      var ipram : word;                   {---------------------}  !       var iclass: word;                          { CC 5/83 }  !          ip2   : word;         { <-- "vive la difference !!!"  }  !           dummy1: word;         { CC 5/83 }             dummy2: word;              ip1   : ip1Type ):  word {returns A Reg!} ; {CC 5/83}        external;       !  procedure XWR0  $ alias 'EXEC' {CLASS I/O WRITE-READ to LU 0} $  !       ( icode, icnwd: word; var ibuf: ibuftype;           ilen,ip1,ip2,iclass: word);      external;  {used for XPLOG/XTLOG implementation}         procedure ABREG ( var Areg, Breg : word ) ; external;        $HEAPPARMS ON$   	  Procedure VMAIO  	     (icode: word; icnwd: XLUEXcnwdtype; var ibuf:Bwordstype ;   
     ilen,ip1,ip2: word);  
     external;         Procedure EMASAM  $ alias 'VMAIO' $       (icode: word; icnwd: XLUEXcnwdtype; var ibuf:word;  
     ilen,ip1,ip2: word);  
     external;         procedure LOADSEG $alias 'pas.segmentload'$                 ( Segname : string5 ); external;  {M30 BG 16FEB87}         $HEAPPARMS OFF$   $page$    {*******************************************************}   {   XNET   modules:                                     }   {*******************************************************}   Procedure XSUSP (n: word);  $direct$  external ;        Procedure XSEND (Messagetype: XSENDmsg;EPTR: Eqtptrtype;                     EQTid: bits2;W3value,W4value: word);    external;        Procedure INGNRES (rescause: byte);  $direct$   {PM 11/82}     external;        procedure P1SETUP ( VCPTR : VCptrType );   $direct$    external;        procedure  D1CLEANUP (vcptr: VCptrType);  $direct$     external;        procedure D1SETUP ( VCPTR: VCptrType) ;    $direct$    external;        procedure LINKUP (EqtPtr: EqtPtrType );     $direct$     external;       ! procedure  LINKDOWN                             {M62 BG 19JUL88}  ! !    (eqtptr : EqtPtrType ; reason : word ) ; $direct$  external ;  !      procedure  PDSUP                            $direct$     ( var task: byte; var ibuf: ibuftype;       var ilen:word; var immrq: bitsword );     external;        procedure FLUSH_MESSAGE (EQP: EQTPTRtype; LASTB: EMAPTRtype);                                              $direct$ external;      $page$    {*************************************************************}    PROCEDURE XDISP ;            $ direct $    {*************************************************************}        LABEL     999; {end of XDISP}       VAR    UpperNet : 0..MaxNbofNetworks;          CardCnwd : XLUEXcnwdType;           ip1 : ip1Type;  
        ip2 : word;  
         XIOcode, XIOpram, XIOlen : word;  !       $skip_text on$                             {M27 BG 11FEB87} !         Rab : ABtype;   	        regab:ab;  	        $skip_text off$       $SUBTITLE 'XIO  I/O to card', PAGE$  # {*******************************************************************} # # {                                                                   } # # {!}  PROCEDURE  XIO   ;                 $direct$                  {!} # # {                                                                   } # # { responsible for all I/O operations to the card                    } # # {                                                                   } # # { xiocode = -1    VMAIO            1  reading data from card to EMA } # # { xiocode = 17    CLASS I/O READ  17  used for global reads         } # # { xiocode = 18    CLASS I/O WRITE 18                                } # # { xiocode = 19    CLASS CONTROL   19 only used during configuration } # # {                                    and read flush                 } # # {                                                                   } # # { Will issue the NoSAM message to the system console after          } # # { the no SAM condition occured 10 times.                            } # # {                                                                   } # # { Logs write data for XPLOG tracing ( class I/O 20 write/read ).    } # # {                                                                   } # # {*******************************************************************} #          LABEL  77,88; {needed for exec with no abort bit}      " CONST NoAbort20 = 20 - 32768; {exec code 20 with no abort bit set}  "      VAR areg, dummy1, dummy2 {for A!!! CC 5/83} : word;  !     II : byte; {test only}  NNN: array[0..6] of pa6c; {test only} !      BEGIN         dummy1 := 0 ; dummy2 := 0 ;            {M13 BG 02JUN86}         If MsgLu <> 0 then begin        CNUM(cardcnwd[1]-SessionBit,nbconv); {test only}   !     Msgwrite(Msglu,' XIO   LU=',nbconv,' ',' ',' '); {test only}  !    end;       "   If XIOCODE = -1 then   {*********** CARD-EMA READ *************}  "    begin  
     with Netwp^ do  
        begin           VMAIO ( 1, Cardcnwd, respeqt^.nextfreebuffer^.Bwords,                   XIOLEN, XIOPRAM, 0 ) ;            $skip_text on$                          {M27 BG 11FEB87}            ABREG(rab.a,rab.b);          $skip_text off$            ABREG ( regab.w.A, regab.w.B ) ;          end;      end     else begin   "     If XIOCODE = 19  {************* Class I/O Control ************} "      then begin          If SystemType <> RTE_A   	       then begin  	 #         areg := XIOCN (19,CardCnwd,XIOpram,XNETclassNoWait,IP1,IP2);  #        end         else begin {special for RTE_A1}           areg:= XIOCX (19,Cardcnwd,XIOpram,XNETclassNoWaitA,                               IP2,dummy1,dummy2,IP1); { CC 5/83 }           end       end      $page$  #     else begin {*********** class I/O Read 17 or Write 18 **********} # 
       {test only:}  
        If ( MsgLu <> 0 ) and ( XIOcode = 18 )   	       then begin  	        {} Msg1write (Msglu,' XIO (write): XNETIBUF first 7:');         {} for ii := 0 to 6  do         {}    CNUM( XNETIBUF.W[ii],NNN[ii] );          {} Msgwrite ( msglu,nnn[0],nnn[1],nnn[2],nnn[3],nnn[4]);           {} Msgwrite ( msglu,nnn[5],nnn[6],' ',' ',' ');         end;              IF SystemType <> RTE_A THEN           areg := XIOWR ( XIOcode, CardCnwd, XNETIBUF,                            XIOLEN, IP1, IP2, XNETclassNoWait )         ELSE          areg := XIOWX ( XIOcode, CardCnwd, XNETIBUF,   !                       XIOLEN, IP1, IP2, XNETclassNoWaitA, IP1 ) ; !      end;       $     If areg  < 0  {**** No SAM available to issue the class I/O? ****}  $      then begin   
       If MsgLu <> 0 
           then Msg1Write ( MsgLu,' XNET: ** No SAM (XDISP) **');               {Issue msg on LU 1 only after 10 times No SAM:}           If NoSamCount >= 9   
         then begin  
            NoSamCount := 0;   #           XEXEC2 (2, 1{LU}, NoSamMsg , -NoSamMsgLength);{direct I/O!} #          end           else NoSamCount:= NoSamCount+1;         SAMOK := false;         Goto  999 { end XDISP}        end;          end;{if xiocode =-1 }   $page$      { Here we are sure that SAM was available }     { for the class I/O operation.}         {************ XPLOG TRACING **************}         {Log only "real" write (i.e., not indirect packet read)}      If LogClass <> 0  {test if tracing is ON}     then begin        If (XIOcode=18 {write})        then begin  {log only "real" write}          {} If IP1.code <> ip1ConfigData   {do not log config data}   
      {} then begin  
 !      {}   If LogAct>=32767 then Logact:=0 else Logact:=Logact+1;  ! #      {}   XNETIBUF.W[0]:= CardCnwd[1]-SessionBit; {positive write lu} #       {}   XNETIBUF.W[1]:= LogAct;  !      {}     {XIOLEN and rest of XNETIBUF are OK as set for XIOWR} ! $      {}   XWR0 ( NoAbort20,0,XNETIBUF, XIOlen,0,0,LogClass+NoWaitBit);  $       {}   Goto 77; {aborted}   #      {}   Goto 88; {Normal return; if no SAM available, just ignore}  #       {}        {}  77: {aborted: class nb invalid; turn trace OFF}         {}      LogClass := 0;        {}      XMSGWR (1{lu}, TracingOff, 0 );         {}  88: {Reset values modified by tracing:}         {}      XNETIBUF.W[0] := XNETsecCode;         {}      XNETIBUF.W[1] := 0;         {} end;         end;  
   end {if XIOcode}  
  end { XIO };        $subtitle 'Prepare Packet buffer', page$   # {******************************************************************}  # # {                                                                  }  # # {!}  PROCEDURE  PREP_STD_IBUF ( VCN : word ) ;    $direct$       {!}  # # {                                                                  }  # # {  prepare standard values in XNETIBUF before a Packet Write       }  # # {  parm: virtual circuit number                                    }  # # {                                                                  }  # # {  Called from GLOBAL_WRITES case Wrestart, WrestartConf           }  # # {              ALL_VC_PKT_WRITES                                   }  # # {                                                                  }  # # {******************************************************************}  #      BEGIN           XNETIBUF.W[0] := XNETSECCODE ;        XNETIBUF.W[1] := 0;       XNETIBUF.W[2] := 0;  #     XNETIBUF.W[3] := -3; {default standard packet length (in bytes)}  #          XNETIBUF.W[4] := VCN + NormalPktNumbering ;                         {extended pkt numbering not yet supported}                         { Qbit=0 ; Dbit=0 }        XNETIBUF.W[5]:=0; { test only ??}       XNETIBUF.W[6]:=0; {test only ??}        IP2 := 0;         end {PREP_STD_IBUF} ;   $subtitle 'Common writes to one network', page$  # {******************************************************************}  # # {                                                                  }  # # {!}  PROCEDURE  GLOBAL_WRITES ;    $direct$                      {!}  # # {                                                                  }  # # {  Responsible for write operations to a specific network.         }  # # {  It is general to a network, all VCs get affected.               }  # # {                                                                  }  # # {  Called from XDISP                                               }  # # {                                                                  }  # # {******************************************************************}  #     VAR  i : byte;      BEGIN { GLOBAL_WRITES  for NETWP^ }         With NETWP^ do begin         Cardcnwd [1]:= CardWriteLU ;      case GlobalWrite of          {}  { Note: DIAG pkt code is in comments }          {}  {       (not supported yet)          }       wRestart, wRestartConf {,wDiag} :          {} begin          {}   PREP_STD_IBUF( 0 ); {VC number = 0}          {}   XIOcode := 18; {class I/O write}           {}   CardCnwd[2] := 0; {subf}           {}   IP1.code := ip1IgnoreFromCard;           {}   case GlobalWrite of  	        {}     {}  	         {}    wRestart: begin           {}     {}  If MsgLu<>0           {}     {}    then MSG1WRITE(Msglu,' XDISP: GW restart');           {}     {}  XNETIBUF.B[10] := RestartPkt; {ccitt type}   
        {}     {}  If DCE  
         {}     {}     then XNETIBUF.B[11] := GWCAUSE  !        {}     {}     else XNETIBUF.B[11] := 0; { DTE originated } !         {}     {}  XNETIBUF.B[12] := GWDIAG;          {}     {}  XNETIBUF.W[3] := -5; {pkt header length}           {}     {}  XIOlen:=-13 {header-8};          {}     {}  XIO ;          {}     {}  X25R := R3; {wait rest conf}   	        {}     {}  	 "        {}     {}  {set timer (be careful with possible overflow): } "         {}     {}  If (32767-LastTime) >= RestconfTO          {}     {}    then RestConfWaitTO:=RestConfTO+LastTime   "        {}     {}    else RestConfWaitTO := ( -32768 + RestConfTO )  "         {}     {}                           + LastTime;   	        {}     {}  	         {}     {}  If RestRetryCtr<=0           {}     {}    then RestRetryCtr:= RestartRetryNb;  	        {}     {}  	 !        {}     {}  X25TOctr:= 1; {mutually exclusive with others}  !         {}     {}  GlobalTOctr:=GlobalTOctr+1           {}     {} end;          {}    wRestartConf: begin           {}     {}   If msglu<>0   !        {}     {}     then msg1write(Msglu,' XDISP: GW RestConf'); !          {}     {}   XNETIBUF.B[10] := RestConfPkt; {ccitt type}            {}     {}   XIOlen := -11 {std header-8};   
        {}     {}   XIO ;  
         {}     {}   X25R := R1;           {}     {}   XMSGWR ( 1, NetworkReady, CardWriteLU );  $        {}     {}   EQTPTR := FirstEqt ;               {M62 BG 19JUL88}  $         {}     {}   while  ( EQTPTR <> NIL ) do   
        {}     {}   begin  
         {}     {}     LINKDOWN ( EQTPTR, NetworkReady ) ;           {}     {}     EQTPTR := EQTPTR^.NextEqt ;   $        {}     {}   end; { while }                     {M62 BG 19JUL88}  $         {}     {} end;  	        {}     {}  	         {}  { wDiag : begin                       }           {}  {           DIAG PKT NOT  IMPLEMENTED }           {}  {         end                         }   	        {}     {}  	         {}    end {case}          {} end;    $page$       { Group Global Write of Class I/O Control }   
     wHandshakeCardWrite,  
      wHandshakeCardRead,       wConfDvrRespWLU,          {M13 BG 22apr86}        wConfDvrRespRLU,          {M13 BG 22apr86}        wResetCard,               {M13 BG 22apr86}        wSetWritePortID,          {M13 BG 22apr86}        wSetReadPortID,           {M13 BG 22apr86}        wCardTimerT3,             {M13 BG 22apr86}        wOpenLine ,       wReadFlush :              {M19 BG 01dec86}           {}          {} begin   { Group Global Write of Class I/O Control }          {}          {}   case GlobalWrite of  	        {}     {}  	         {}    wHandshakeCardWrite :           {}     {} begin           {}     {}   If GenResCause = DVXschedule          {}     {}     then begin          {}     {}       if msglu<>0 then msg1write ( Msglu ,  #        {}     {}     ' XDISP: Hdshk Card Write : Close Line CN32B');  # #        {}     {}       Cardcnwd[2] := CN_32_00 ; { 3200B close line}  #         {}     {}       XIOpram     := XNETseccode;   
        {}     {}     end  
 #        {}     {}   else   { GenResCause = XINITschedule, PowerFail }  # #        {}     {}          {    NetworkDown, IFCardError, CardDown, }  # #        {}     {}          {    RestartReceived, RestartInitiated.  }  # 
        {}     {}    begin 
         {}     {}     if msglu<>0 then msg1write ( Msglu ,  #        {}     {}   ' XDISP: Hdshk Card Write : Dynamic Status CN6');  # #        {}     {}     CardCnwd[2] := CN_06_00 ; { 600B Dynamic stat.}  #         {}     {}     XIOpram     :=  0;          {}     {}   end;          {}     {}   IP1.code := ip1handshakeWrite ;           {}     {} end ; { wHandshakeCardWrite }   	        {}     {}  	         {}    wHandshakeCardRead :          {}     {} begin           {}     {}   if msglu<>0 then msg1write ( Msglu ,  #        {}     {}    ' XDISP: Hdshk Card Read : Dynamic Status CN6');  #         {}     {}   Cardcnwd [1]:= Cardcnwd [1]+ 1; {read LU}   #        {}     {}   Cardcnwd [2] := CN_06_00 ; { 600B Dynamic status}  #         {}     {}   XIOpram      := 0;          {}     {}   IP1.code     := ip1HandshakeRead ;          {}     {} end ; { wHandshakeCardread }  	        {}     {}  	         {}    wConfDvrRespWLU :           {}     {} begin           {}     {}   if msglu<>0 then msg1write ( Msglu ,  $        {}     {}' XDISP: Configure Driver Response Write LU : CN33B');  $ "        {}     {}   Cardcnwd [2] := CN_33_00; {3300B Conf DVR Resp.} " !        {}     {}   XIOpram  := CN33_conf_word + DDX60_entry_num ; !         {}     {}   IP1.code := ip1ConfDvrRespWLU ;           {}     {} end ; { wConfDvrRespWLU }   	        {}     {}  	         {}    wConfDvrRespRLU :           {}     {} begin           {}     {}   if msglu<>0 then msg1write ( Msglu ,  $        {}     {} ' XDISP: Configure Driver Response Read LU : CN33B');  $ !        {}     {}   Cardcnwd [1] := CardWriteLU + 1 ; {CardreadLU} ! $        {}     {}   Cardcnwd [2] := CN_33_01; {3301B Conf DVR Response}  $ !        {}     {}   XIOpram  := CN33_conf_word + DDX60_entry_num ; !         {}     {}   IP1.code := ip1ConfDvrRespRLU ;           {}     {} end ; { wConfDvrRespRLU }   	        {}     {}  	 
        {}    wResetCard : 
         {}     {} begin           {}     {}   if msglu<>0 then msg1write ( Msglu ,          {}     {}       ' XDISP: Reset Card : CN35B,"RS"');   !        {}     {}   Cardcnwd [2] := CN_35_00 ; {3500B Reset Card}  !         {}     {}   XIOpram  := CN35_RS_PARM ;  {'RS'}          {}     {}   IP1.code := ip1ResetCard;           {}     {} end ; { wResetCard }  	        {}     {}  	         {}    wSetWritePortID :           {}     {} begin           {}     {}   if msglu<>0 then msg1write ( msglu ,  !        {}     {}       ' XDISP: Set Write Port ID : CN30B,0' ) ;  ! !        {}     {}   Cardcnwd [2] := CN_30_00 ; {3000B Set Port ID} !          {}     {}   XIOpram  := Write_port ;  { Write Port ID }            {}     {}   IP1.code := ip1SetWritePortID;          {}     {} end ; { wSetWritePortID }   	        {}     {}  	         {}    wSetReadPortID :          {}     {} begin           {}     {}   if msglu<>0 then msg1write ( msglu ,          {}     {}       ' XDISP: Set Read Port ID : CN30B,1');  !        {}     {}   Cardcnwd [1] := CardWriteLU + 1 ; {CardreadLU} ! !        {}     {}   Cardcnwd [2] := CN_30_00 ; {3000B Set Port ID} !         {}     {}   XIOpram  := Read_port ;  { Read Port ID }           {}     {}   IP1.code := ip1SetReadPortID;           {}     {} end ; { wSetReadPortID }  	        {}     {}  	 #        {}     {}                                     {M18 BG 13OCT86} # #        {}    wCardTimerT3 : {set Card Keep Alive Timer T3 on READ LU} #         {}     {} begin           {}     {}   if SystemType = RTE_A then          {}     {}     begin           {}     {}       if msglu<>0 then msg1write ( Msglu ,  $        {}     {}      ' XDISP: Set Card Timer T3 on READ LU : CN50B');  $ "        {}     {}       Cardcnwd [2] := CN_50_00 ; {5000B Set Timer} " 
        {}     {}     end  
         {}     {}   else   { system is RTE-VI }           {}     {}     begin           {}     {}       if msglu<>0 then msg1write ( Msglu ,  $        {}     {}      ' XDISP: Set Card Timer T3 on READ LU : CN10B');  $ "        {}     {}       Cardcnwd [2] := CN_10_00 ; {1000B Set Timer} "         {}     {}     end ;   $        {}     {}                                      {M18 BG 13OCT86}  $ "        {}     {}   Cardcnwd [1] := CardWriteLU + 1 ; { CardreadLU } " #        {}     {}   { CardSubfunction = function 5  : Control Card 0 } #         {}     {}   XIOpram  := CardSubFunction + Timer_T3 ;          {}     {}   IP1.code := ip1CardTimerT3 ;          {}     {} end ; { wCardTimerT3 }  	        {}     {}  	         {}    wOpenLine:          {}     {} begin           {}     {}   if msglu<>0 then msg1write ( Msglu ,          {}     {}       ' XDISP: Open Line : CN31B' ) ;            {}     {}   Cardcnwd [2] := CN_31_00 ; {3100B Open Line}           {}     {}   XIOpram  := XNETseccode;          {}     {}   IP1.code := ip1OpenLine ;           {}     {} end ; { wOpenLine }   	        {}     {}  	 "        {}    wReadFlush :                    {added M19 BG 01DEC86} "         {}     {} begin           {}     {}   if msglu<>0 then msg1write ( Msglu ,          {}     {}       ' XDISP: Read Flush : CN26B' ) ;  !        {}     {}   Cardcnwd [2] := CN_26_00 ; {2600B Read Flush } !         {}     {}   XIOpram  := XNETseccode;          {}     {}   IP1.code := ip1ReadFlush ;          {}     {} end ; { wReadFlush }  	        {}     {}  	         {}   end ; { case GlobalWrite }           {}          {}   XIOcode := 19 ; { class I/O control }  	        {}   XIO ; 	         {}          {} end ; { Group GlobalWrite of Class I/O Control }           {}  
     wConfigurationData :  
         {} begin  "        {}   If msglu<>0 then msg1write(Msglu,' XDISP: Conf data');  " "        {}   {Prepare XNETIBUF:}                           { test }  "         {}       XNETIBUF.w[0] := XNETseccode ;           {}       {transfer config data into XNETIBUF}           {}          For I:=1 to XTBLcardParmLength          {}          do XNETIBUF.W[I] := CardParm.T[I];           {}    Cardcnwd [2] := CN_06_00 ; { 600B Card conf data }           {}    IP1.code := ip1ConfigData ;           {}    XIOcode := 18 { class I/O write } ;   #        {}    XIOlen := - ( XTBLcardParmLength + 1 ) * 2 ; {in bytes}  # 
        {}    XIO ;  
         {} end;           end { case GlobalWrite };   !    GlobalWrite:= NoWrite { XIO jumps to end of XDISP if no SAM }  !   end { with NETWP^ }   end ; { GLOBAL_WRITES }    $subtitle 'Common reads to one network', page$   # {******************************************************************}  # # {                                                                  }  # # {!}  PROCEDURE  GLOBAL_READS ;    $direct$                       {!}  # # {                                                                  }  # # {  Responsible for read operations to a specific network.          }  # # {  It is general to a network, all VCs get affected.               }  # # {                                                                  }  # # {  Called from XDISP                                               }  # # {                                                                  }  # # {******************************************************************}  #      BEGIN  { GLOBAL READs for NETWP^ }           { IP1.NetwNb already set. GlobalRead <> noread }         With NETWP^ do begin             CardCnwd [1] := CardWriteLU + 1 ;             Repeat  { until globalread = NoRead }         {}        {} Case GlobalRead of         {}    {}        {}    CardEMAread: begin  $      {}    {} If msglu<>0 then Msg1Write(Msglu,' XDISP: CardEMAread');  $       {}    {} { prepare request to DDX60 to transfer data }        {}    {} { from card into EMA. }        {}    {}        {}    {}   CardCnwd[2]:=0;   {Subfunction 0 : flush}        {}    {}   XIOlen  := -GRP2;        {}    {}   XIOpram := XNETseccode;        {}    {}   XIOcode:= -1;        {}    {}        {}    {}   XIO  ; { VMAIO direct read, no ip1 code }  "      {}    {------------------------------------------------------} " "      {}    {    PROCESS_CARD_STATUS                               } " "      {}    {                                                      } " "      {}    {    status bit 0 :  not used                          } " "      {}    {    status bit 1 :  card needs configuration data     } " "      {}    {    status bit 2 :  data available on card            } " "      {}    {    status bit 3 :  maximum packet length exceeded    } " "      {}    {    status bit 4 :  network down                      } " "      {}    {    status bit 5 :  flush performed indication        } " "      {}    {    status bit 6 :  programming error indication      } " "      {}    {    status bit 7 :  unrecoverable card error          } " "      {}    {------------------------------------------------------} " "      {}    {}  $skip_text on$                      {M27 BG 11FEB87} "       {}    {}   regab.a.w:=rab.a;        {}    {}   regab.b:=rab.b;        {}    {}        {}    {}   IF REGAB.B = 0   { tlog = 0 error }        {}    {}  $skip_text off$         {}    {}        {}    {}   IF REGAB.W.B = 0   { tlog = 0 error }        {}    {}   then begin { TEST ERROR BITS }         {}    {}         {}    {}     If REGAB.bits.A.bit6 = 1 { request error ? }          {}    {}      {} then begin          {}    {}      {}   LOADSEG ( 'XSEG3' ) ; {M30 BG 16FEB87}          {}    {}      {}   XSUSP ( 3 );  { suspend XNET }          {}    {}      {}   LOADSEG ( 'XSEG4' ) ; {M30 BG 16FEB87}    
      {}    {}      {} end 
       {}    {}      {}        {}    {}     else  If REGAB.bits.A.bit7 = 1         {}    {}      {}   { unrecoverable Card Error }         {}    {}      {} then begin         {}    {}      {}  If recoverycounter >= 9   $      {}    {}      {}   then begin { 10th consecutive retry recovery }  $ $      {}    {}      {}   {} recoverycounter := 0;     { stop recovery }  $       {}    {}      {}   {} INGNRES ( CardDown );         {}    {}      {}   end        {}    {}      {}  else begin  "      {}    {}      {}   {} recoverycounter := recoverycounter + 1 ; " #      {}    {}      {}   {} INGNRES ( IFCardError ) ; {M13 BG 22apr86} #       {}    {}      {}  end;  
      {}    {}      {} end 
       {}    {}      {}        {}    {}     else  If REGAB.bits.A.bit1 = 1         {}    {}      {}   { needs configuration data }         {}    {}      {} then begin         {}    {}      {}  If recoverycounter >= 9   $      {}    {}      {}   then begin { 10th consecutive retry recovery }  $ $      {}    {}      {}   {} recoverycounter := 0;     { stop recovery }  $       {}    {}      {}   {} INGNRES ( CardDown );         {}    {}      {}   end        {}    {}      {}  else begin  "      {}    {}      {}   {} recoverycounter := recoverycounter + 1 ; "       {}    {}      {}   {} INGNRES ( PowerFail ) ;         {}    {}      {}  end;  
      {}    {}      {} end 
       {}    {}      {}  "      {}    {}     else  If REGAB.bits.A.bit4 = 1 { Network down ? } "       {}    {}      {} then begin         {}    {}      {}  {} INGNRES ( NetworkDown );   
      {}    {}      {} end 
       {}    {}      {}        {}    {}   { else no error }        {}    {}      {}        {}    {}     end        {}    {}     {XNETmoreDataOnCard := XNETstatus.bit2 ;}        {}    {}     {XNETpktTooLong := XNETstatus.bit3 ;    }        {}    {}     else begin  {No error}   "      {}    {}        WITH Respeqt^,Nextfreebuffer^,AssociatedVC^ DO "       {}    {}        BEGIN   #      {}    {}        {Update variables to indicate that a new buffer} #       {}    {}        {was filled in in EMA.}         {}    {}           EMAcounter:=EMAcounter + 1;        {}    {}           Length := REGAB.W.B ; {in bytes}         {}    {}           Index:=1;        {}    {}           Qbit:=PKTheader.Qbit;        {}    {}           Mbit:=PKTheader.Mbit;        {}    {}           PR:=RPS;         {}    {}           IF EMAcounter = 1  !      {}    {}           then   { The first data packet was just } !       {}    {}           {}     { stocked in EMA for this VC }        {}    {}           {} Nextbuffertoread := GRPP;         {}    {}           {else   Nextbuffertoread already set}        {}    {}           Lastbufferfilled := Nextfreebuffer;        {}    {}                               {M10 BG06FEB86}        {}    {}           Nextfreebuffer:=Nextfreebuffer^.Next;        {}    {}        END;{with}        {}    {}        {}    {}        GlobalRead := ReadHeader;         {}    {}     end;         {}    end {CardEMAread};        {}  
      {}    RFlush : begin 
 $      {}    {}    If msgLu<>0 then msg1write(Msglu,' XDISP: GR Flush');  $       {}    {}    cardcnwd [2] := 1408; {subf 2600B = flush}        {}    {}    XIOpram      := XNETsecCode ;         {}    {}    ip1.code     := ip1IgnoreFromCard ;         {}    {}    XIOcode      := 19; {control}         {}    {}    XIO  ;        {}    {}    GlobalRead   := ReadHeader        {}    {} end {RFlush};        {}    {}        {}    otherwise    $page$         {}    {}  Case GlobalRead  of         {}    {}     {}         {}    {}     ReadHeader: begin        {}    {}     {}   If msgLu<>0   { test }  "      {}    {}     {}     then Msg1Write(Msglu,' XDISP: GR Header'); " $      {}    {}     {}   XIOlen       := -3; {-4 if Extended Pkt Nbring}  $       {}    {}     {}   IP1.code     := ip1PktHeader;   #      {}    {}     {}   cardcnwd [2] := 512 {subf 1000B ='keep data'}  #       {}    {}     {}           end;        {}    {}     {}         {}    {}     ReadRest : begin         {}    {}     {}   If msgLu<>0   { test }  #      {}    {}     {}     then Msg1write ( Msglu,' XDISP: GR Rest' );  #       {}    {}     {}   XIOlen       := -GRP1;        {}    {}     {}   ip1.code     := ip1RestNonDataPkt;        {}    {}     {}   cardcnwd [2] := 0; { subf 0 = flush }   
      {}    {}     {} end; 
       {}    {}     {}         {}    {}     ReadQbitData : begin         {}    {}     {}  If msglu <> 0    { test }  $      {}    {}     {}    then Msg1Write ( Msglu,' XDISP: GR Qbitdata');  $       {}    {}     {}  XIOlen       := -128;  #      {}    {}     {}                  {max length of Q bit data pkt}  #       {}    {}     {}  ip1.code     := ip1QbitData;         {}    {}     {}  cardcnwd [2] := 0 ; { subf 0 = flush }   
      {}    {}     {} end; 
       {}    {}     {}         {}    {}   end{case};         {}    {}        {}    {}   XIOcode := 17 {read};        {}    {}   XIO  ; { send it }         {}    {}        {}    {}   If GlobalRead=ReadHeader         {}    {}   then GlobalRead := NoRead        {}    {}   else begin         {}    {}     If GlobalRead = ReadQbitdata   #      {}    {}       then RespEqt^.AssociatedVC^.DataAvailable:=false; #       {}    {}     GlobalRead := ReadHeader;  
      {}    {}   end 
 
      {} end;{case}  
       {}        Until GlobalRead = NoRead ;       
   end {with NETWP^} 
   end {GLOBAL_READS};    $subtitle 'EMA_USER_TRANSFER', page$    $heapparms on $  # {******************************************************************}  # # {                                                                  }  # # {!} PROCEDURE EMA_USER_TRANSFER ( EQTPTR: EQTPTRtype ); $direct$ {!}  # # {                                                                  }  # # {  Responsible for data transfer from EMA buffers to user's buffer }  # # {  in SAM.                                                         }  # # {                                                                  }  # # {  - EMA_USER_TRANSFER : - TRANSFER_REQ                            }  # # {                        - UPDATE_REQ                              }  # # {                        - RELEASE_BUFFER                          }  # # {                        - COMPLETE_REQ                            }  # # {                                                                  }  # # {  Called from ALL_VC_TRANSFER                                     }  # # {                                                                  }  # # {******************************************************************}  #      LABEL 99;       VAR  Lastw3  : word;         Lastbuf : EMAPTRtype;         Reqcompleted :boolean;        Gotonextbuf :boolean;         DataInExcess : word;       {M58 BG 06JUL88}    $page$   # {******************************************************************}  # # {                                                                  }  # # {!} PROCEDURE TRANSFER_REQ ( Len : word ) ; $direct$             {!}  # # {                                                                  }  # # {  Sends a request to DVX00 to transfer data from EMA buffers      }  # # {  into user's buffer in SAM.                                      }  # # {                                                                  }  # # {  Called from EMA_USER_TRANSFER                                   }  # # {                                                                  }  # # {******************************************************************}  #      VAR test, word_index :word;       BEGIN         WITH EQTPTR^, WriteReadeqt[2] {read EQT}      DO BEGIN         word_index := 1;        Cnwdwritereslu[1]:= Writereservedlu;        Cnwdwritereslu[2]:= 256;  {VMAIO WRITE to DVX00}                                  { 400B : subfunction 4 }      !      { Check and see if buffer index points to a word boundary. } ! !      { If index is even it points to an odd byte boundary which } ! !      { indicates that previous read did not finished on a word  } ! !      { boundary. In this case set subfunction code to 14B and   } ! !      { tell DVX to translate the address before the transfer.   } !            IF Nextbuffertoread^.index <> 1   { not the reset value }          then begin  { check for odd/even byte length }           test := (Nextbuffertoread^.index div 2) * 2;                if test = Nextbuffertoread^.index  !         then      { index is even, so translation is needed to }  !                    { move bytes on word boundaries }  !            cnwdwritereslu[2] := 768; { 1400B : subfunction 14B }  !              word_index := ( Nextbuffertoread^.index + 1) div 2;        end;            { VMAIO write to DVX00 write reserved LU }  $      EMASAM ( 2, Cnwdwritereslu, Nextbuffertoread^.Bwords[word_index],  $                len, XNETseccode, W2 { address in SAM }) ;             abreg ( regab.w.A, regab.w.B ) ;            IF regab.w.A   <> 0    {Procedure error}        THEN          begin             LOADSEG ( 'XSEG3' ) ; {M30 BG 16FEB87}  
          XSUSP(4);  
           LOADSEG ( 'XSEG4' ) ; {M30 BG 16FEB87}          end ;      END;{WITH}       
 END;{Transfer_req}  
     $page$      # {******************************************************************}  # # {                                                                  }  # # {!}  PROCEDURE UPDATE_REQ ;   $direct$                           {!}  # # {                                                                  }  # # {  Update length of request to what is still expected.             }  # # {                                                                  }  # # {  W2 : updated word address of the user's buffer in SAM           }  # # {  W3 : updated expected data length in bytes                      }  # # {  Breg after VMAIO : the length of data just transferred          }  # # {  EQTlog : the total effective length of data transferred         }  # # {  LastW3 : Last value of remaining expected data length.          }  # # {                                                                  }  # # {  Called from EMA_USER_TRANSFER  3 times                          }  # # {                                                                  }  # # {******************************************************************}  #      BEGIN           WITH EQTPTR^, WriteReadeqt[2] {Read eqt}        DO BEGIN           Lastw3 := W3 ;          W2 := W2 + ( regab.w.B div 2 ) ;          W3 := W3 - regab.w.B ;          EQTtlog := EQTtlog + regab.w.B ;       END; {WITH}      	  END;{Update_req} 	      $page$   # {******************************************************************}  # # {                                                                  }  # # {!} PROCEDURE RELEASE_BUFFER ( Gotonextbuf: boolean ) ; $direct$ {!}  # # {                                                                  }  # # {  Update pointers : go to next buffer if the request "eats" all   }  # # {  the buffer or stay on the same buffer (update index & length)   }  # # {  if the request "eats" only a part of the buffer. In this case   }  # # {  adjust the data length and buffer index to point to the         }  # # {  remaining data.                                                 }  # # {                                                                  }  # # {  Called from EMA_USER_TRANSFER                                   }  # # {                                                                  }  # # {******************************************************************}  #      BEGIN         WITH EQTPTR^      DO BEGIN       	    IF Gotonextbuf 	     THEN BEGIN        Nextbuffertoread^.Index := 1 ; { reset index in buffer }  !      Nextbuffertoread := Lastbuf^.Next; { point to next buffer }  !       { decrement nb of EMA buffers with data available }         EMAcounter := EMAcounter - 1;       END       ELSE BEGIN        {Nextbuffertoread unchanged}        {update index within nextbuffertoread}  "      Nextbuffertoread^.Index:=Nextbuffertoread^.Index + regab.w.B;  "           {update remaining length}   #      Nextbuffertoread^.Length:=Nextbuffertoread^.Length - regab.w.B;  #     END          END; {WITH}        END;{Release_buffer}      $page$      # {******************************************************************}  # # {                                                                  }  # # {!} PROCEDURE COMPLETE_REQ ( EQTTLOG : word ) ;  $direct$        {!}  # # {                                                                  }  # # {  Called from EMA_USER_TRANSFER                                   }  # # {                                                                  }  # # {******************************************************************}  #      VAR S : 0..4; {status}        BEGIN    {}    {} WITH EQTPTR^, AssociatedVC^, WriteReadeqt[2]     {} DO BEGIN     {}    {}    Dataavailable := false;     {}    Msginprogress := false;     {}    Reqcompleted  := false;     {}    S := 0; { no data available }     {}    {}    IF (W1.Reqsubf = 0)  {****** FLUSH ******}  	  {}    THEN Begin 	   {}  $  {}      { For PAD strip off EOL character from the transmission log }  $ $  {}      { though the EOL character has been already transferred.    }  $   {}    {}      IF EQTtype = PADEQTtype   
  {}      THEN Begin 
 
  {}        SendLF:=true;  
 "  {}       $skip_text on$                          {M58 BG 06JUL88}  "   {}        IF W3 > 0 Then EQTtlog := EQTtlog - 1;  
  {}       $skip_text off$ 
   {}        IF (( W3 > 0 ) or     {}           (( W3 = 0 ) and ( DataInExcess = 0 )))   #  {}           { case where the exact number of characters requested } # #  {}           { has been received, but the last one is the EOL char.} #   {}          Then EQTtlog := EQTtlog - 1;    {}     End;     {}    {}     FLUSH_MESSAGE (EQTPTR,Lastbuf);    {}    {}    End     {}    ELSE Begin           {****** SAVE ******}     {}    {}       IF EMAcounter > 0    {}       THEN Begin {more data in EMA}    {}       {  IF Lastbuf^.Mbit             Cdf 03/26/84}    {}       {  Then Begin                   Cdf 03/26/84}    {}             Msginprogress := true;     {}             Dataavailable := true;     {}             S := 4; { unsolicited data available }     {}       {  End;                         Cdf 03/26/84}  "  {}          {Else  End of Message; An interrupt msg will be sent}  " 
  {}          {later on }  
   {}       End    {}       ELSE Begin {no more data in EMA}     {}          IF Lastbuf^.Mbit    {}          Then Begin {more data are expected}     {}             Msginprogress := true;     {}             S := 4; { unsolicited data available }   	  {}          End; 	   {}          {Else no more data}     {}       End;     {}    {}    End;    {}    {} XSEND ( Normalcompmsg, EQTPTR, 2, S, EQTtlog );  
  {} Reqcompleted := true; 
   {}    END;{WITH}      
  END;{Complete_req} 
  $page$     BEGIN   {****** EMA_USER_TRANSFER ******}            { W3 is the updated requested data length in bytes }         { Nextbuffertoread^.length holds the incoming data length }        { EMACOUNTER holds the number of non empty EMA buffers }            WITH EQTPTR^, WRITEREADEQT[2], AssociatedVC^        DO BEGIN        {}        {} Reqcompleted := false;       {} LastBuf := Nextbuffertoread; { LastBuff precedes }       {}                              { Nextbuffertoread  }       {}   "     {} {*** DO WE EXPECT MORE DATA THAN PRESENTLY AVAILABLE IN ***} " "     {} {*** BUFFER  AND OTHER EMA BUFFER(S) IS/ARE AVAILABLE ? ***} "      {}         {} IF (W3 > Nextbuffertoread^.Length) AND (EMAcounter >= 1)   	     {} THEN BEGIN 	      {}    Gotonextbuf := true;        {}    TRANSFER_REQ (Nextbuffertoread^.Length);        {}    UPDATE_REQ;       {}        { update address of user's buffer in SAM }        {}        { update expected data length }  !     {}        { update total length of data already transferred } !      {}        {}    IF Not Nextbuffertoread^.Mbit       {}    THEN BEGIN {Message consists on one packet}       {}    {} RELEASE_BUFFER(Gotonextbuf);       {}    END       {}    ELSE BEGIN {Message consists on several packets}        {}    {} RELEASE_BUFFER(Gotonextbuf);  #     {}    {} WHILE (Lastbuf^.Mbit) AND (W3>Nextbuffertoread^.Length)  #      {}    {} AND (EMAcounter>0)       {}    {} DO BEGIN       {}    {}    TRANSFER_REQ (Nextbuffertoread^.Length);        {}    {}    UPDATE_REQ;  "     {}    {}    LastBuf := NextBufferToRead;   { LastBuf precedes } " "     {}    {}                                   { NextBufferToRead.} "      {}    {}    RELEASE_BUFFER(Gotonextbuf);   
     {}    {} END;{WHILE}  
      {}    END; {ELSE}       {}   
     {}    SENDRR := true; 
      {}    PRTS := Lastbuf^.PR;        {}    Pktwriteneeded := true;       {}    IF Not Lastbuf^.Mbit        {}      then begin        {}        COMPLETE_REQ ( EQTtlog );       {}        Goto 99;   	     {}      end;  	      {}        {} END ; { IF W3 > length...}       {}   "     {} DataInExcess := NextBuffertoread^.length - W3 ; { for PAD }  " "     {}                                            {M58 BG 06JUL88}  "      {}       $page$       {} {*** IS IT THE END OF USER'S BUFFER ? ***}  	     {} IF W3 <= 0 	      {} THEN   COMPLETE_REQ ( EQTtlog )        {}   "     {} ELSE  {*** IS THERE MORE DATA VAILABLE THAN REQUESTED ? ***} " "     {}       {*** OR JUST WHAT IS REQUESTED ?                  ***} "      {}   "     {}    IF (W3 <= Nextbuffertoread^.Length) AND (EMAcounter >= 1) "      {}    THEN BEGIN        {}       TRANSFER_REQ (W3);   {transfer only W3 bytes}   
     {}       UPDATE_REQ;  
      {}       Lastbuf := Nextbuffertoread;       {}        {}       IF (Lastbuf^.Length > Lastw3)        {}       THEN BEGIN       {}       {} Gotonextbuf := false;       {}       {} RELEASE_BUFFER(Gotonextbuf);        {}       {} { don't send RR }  	     {}       END  	      {}       ELSE BEGIN       {}       {} Gotonextbuf := true;        {}       {} RELEASE_BUFFER ( Gotonextbuf );       {}       {} SENDRR := true;       {}       {} PRTS := Lastbuf^.PR;        {}       {} Pktwriteneeded := true;       {}       END;{IF Lastbuf....}       {}        {}       COMPLETE_REQ(EQTtlog);       {}        {}    END {IF W3 <= Length....}       {}    ELSE        {}       IF Not Lastbuf^.Mbit       {}       THEN  COMPLETE_REQ(EQTtlog);       {}        {}        END;  { with eqtptr^, writereadeqt[2], associatedVC^ }        99: WITH EQTPTR^, WRITEREADEQT[2], AssociatedVC^        DO BEGIN        {} If (EMAcounter > 0) AND (Msginprogress = false)        {} THEN begin {new message}       {}    MSGinprogress:=true;        {}    IF Nextbuffertoread^.Qbit       {}    THEN        {}       XSEND(Qbitdatamsg,eqtptr,2,0,0)        {}    else        {}       XSEND(datapktmsg,eqtptr,2,0,0);        {} end;       END;{WITH}       
  End; {EMA_USER_TRANSFER} 
      $subtitle 'ALL_VC_PKT_WRITES', page$   # {******************************************************************}  # # {                                                                  }  # # {!} PROCEDURE  ALL_VC_PKT_WRITES ;          $direct$             {!}  # # {                                                                  }  # # { Iterate over ALL VC tables ( round robin from successor of       }  # # { RRobinLastVC ) to issue ALL packet writes, as long as we are     }  # # { not SAM or QLength blocked.                                      }  # # {                                                                  }  # # {  - ALL_VC_PKT_WRITES : - X25P_WRITES : - PREP_SEND_CALL          }  # # {                                        - PREP_CALL_CONF          }  # # {                                                                  }  # # {                        - DATA_PKT_WRITES                         }  # # {                                                                  }  # # {                                                                  }  # # {  Called from ALL_VC_TRANSFER                                     }  # # {                                                                  }  # # {******************************************************************}  #       LABEL  99 { Q Length blocked},           90 { end of treatment for current VC};         VAR  LoopLimit : VCptrType;               # {******************************************************************}  # # {                                                                  }  # # {!}  PROCEDURE  X25P_WRITES ;       $direct$                     {!}  # # {                                                                  }  # # {  Responsible for emission of packets when X25P is not            }  # # {  - P1 ( call set up ready, no VC established )                   }  # # {  - P4 ( data transfer ready )                                    }  # # {                                                                  }  # # {  - X25P_WRITES : - PREP_SEND_CALL                                }  # # {                  - PREP_CALL_CONF                                }  # # {                                                                  }  # # {  Called from ALL_VC_PKT_WRITES                                   }  # # {                                                                  }  # # {******************************************************************}  #        VAR FacilityLengthIndex, FFindex, K : 0..4095;        $page$   # {******************************************************************}  # # {                                                                  }  # # {!}  PROCEDURE  PREP_SEND_CALL ;    $direct$                     {!}  # # {                                                                  }  # # {  Prepares a CALL packet in XNETIBUF and send it via XIO          }  # # {  and set a VC timer waiting for call conf.                       }  # # {                                                                  }  # # {  Local address is inserted in call packet as calling address     }  # # {  only if node is DCE                                             }  # # {    or if node is DTE when network type is 0 = 'HP'               }  # # {                           or is > 254 = 'PRIVATE' or 'LOOPBACK'. }  # # {  In all other cases, call packet only holds called address.      }  # # {                                                                  }  # # {  Called from X25P_WRITES  cases P5 ( send call )                 }  # # {                             and P6 ( retry call )                }  # # {                                                                  }  # # {  XNETibuf format :                    call pkt type : 0B hex     }  # # {                                                                  }  # # {       +-------------------------------------------+              }  # # {  W 0  !          XNET  security  code             !              }  # # {       !-------------------------------------------!              }  # # {  W 1  !                   0                       !              }  # # {       !-------------------------------------------!              }  # # {  W 2  !                   0                       !              }  # # {       !-------------------------------------------!              }  # # {  W 3  !         packet  header  length            !              }  # # {       !-------------------------------------------!              }  # # {  W 4  !  (D)     !        logical  VC number      !              }  # # {       !-------------------------------------------!              }  # # {  W 5  ! call pkt type     ! calling l. ! called l.!              }  # # {       !-------------------------------------------!              }  # # {  W 6  !                                           !              }  # # {       !--                                       --!              }  # # {       +          called  address field            +              }  # # {       !--                                       --!              }  # # {       !                                           !              }  # # {       !-------------------------------------------!              }  # # {       !                                           !              }  # # {       !--                                       --!              }  # # {       +     calling address field ( if any )      +              }  # # {       !--                                       --!              }  # # {       !                                           !              }  # # {       !-------------------------------------------!              }  # # {       !                                           !              }  # # {       !--                                       --!              }  # # {       +        facility field ( if any )          +              }  # # {       !--                                       --!              }  # # {       !                                           !              }  # # {       !-------------------------------------------!              }  # # {       !                                           !              }  # # {       !--                                       --!              }  # # {       +        call user data ( if any )          +              }  # # {       !--                                       --!              }  # # {  W n  !                                           !              }  # # {       +-------------------------------------------+              }  # # {                                                                  }  # # {******************************************************************}  #      VAR  I,K1,K2, HDRbyteLength : 0..4095;       $page$   BEGIN    { PREP_SEND_CALL }          With NETWP^, VCPTR^, AssociatedEQT^ do begin      
        If Facilities.Dbit 
             then XNETIBUF.W[4] := XNETIBUF.W[4] + 16384; {D bit}                XNETIBUF.B[10] := CallPkt; { ccitt type 0B hex }            {Calling and Called addresses: }          {insert remote add as called add}                  K := Remote.Add [1];  {length}                  XNETIBUF.BCD[23] := K;                  For I := 1 to K                 do  XNETIBUF.BCD [23+I] := Remote.Add [I+1] ;      "        { insert local add as Calling Add                          } " "        { only if (DCE) or (DTE on "HP" or "private" network type) } "           With CardParm do begin              If  DCE  or                ( ( NetworkType = 0 { HP } ) or                 ( NetworkType >= 254 { private/loopback } ) )              then begin                 K2 := LOCALADDR.Add [1]; {length}                 K1 := 23 + K; {skip over called address}                  For I := 1 to K2                   do  XNETIBUF.BCD [ K1+I ] := LocalAddr.Add [I+1];               end   
            else  K2 := 0; 
           end {with cardparm};               XNETIBUF.BCD[22] := K2; {insert calling add length}                {Fill last half byte if needed:}                 K := K + K2 ; {total address field length}   "               If ODD(K) then begin {must add 0 digit to fill byte}  "                               K := K + 1 ;                                XNETIBUF.BCD [23+K] := 0;                            end;               HDRbyteLength := 4 + (K DIV 2) ;              {process facilities:}              FacilityLengthIndex := 8+HDRbyteLength;                                    { save index to fill later }  "           FFindex := FacilityLengthIndex+1; {facility field index}  "             {Initialize effectivePTW:}             EffectivePTW := DesiredPTW;                 {--------------------------- CUG number ? -------}                If Facilities.CUbit               then begin                      XNETIBUF.B [FFindex] := 3; {CUG facility code}                     XNETIBUF.B [FFindex+1]:= CUGnb ;                    FFindex:=FFindex + 2               end {CUG facility} ;                  {----------------------  Reverse Charging ? ------}               If Facilities.RCbit               then begin                     XNETIBUF.B [FFindex] := 1; {facility code}  $                  XNETIBUF.B [FFindex+1] := 1; {rev charging requested}  $                   FFindex:= FFindex+2                end {Reverse charging};      "           {------------------------ Packet size negotiation ? ---}  "              If facilities.PSbit               then begin                   XNETIBUF.B [FFindex] := 66; {facility code}                    XNETIBUF.B [FFindex+1] := DesiredPTW.INpktSize;                                              { From called }                    XNETIBUF.B [FFindex+2] := DesiredPTW.OUTpktSize;                                             { From Calling }                  FFindex := FFindex+3 ;               end {Packet Size Negotiation};       "           {----------------------- Window Size Negotiation ? ----}  "              If Facilities.WSbit               then begin                   XNETIBUF.B [FFindex] := 67;                    XNETIBUF.B [FFindex+1] := DesiredPTW.INwdwSize;                                              { from called }                    XNETIBUF.B [FFindex+2] := DesiredPTW.OUTwdwSize;                                             { From calling }                  FFindex := FFindex + 3 ;               end {window size negotiation};       $           {----------------------- Throughput Class Negotiation ? ---}  $              If Facilities.TCbit               then begin                   XNETIBUF.B [FFindex] := 2; {facility code}                  XNETIBUF.B [FFindex+1] := DesiredPTW.B [2];   #                  {Note: "from called"+"from calling"=inTHcl+outTHcl}  # #                  {      as in PTW type                             }  #                 FFindex := FFindex+2               end {throughput class negotiation};                 {Update Facility length field:}               K:= FFindex - FacilityLengthIndex -1;               XNETIBUF.B[FacilityLengthIndex]:= K ;                 {Insert Call User Data Field:}                WITH EQText do begin                IF   CUDout.length <> 0                THEN { We have to insert outgoing Call User data }                    BEGIN   #                  FFINDEX := FFINDEX - 1 ; {Convenient for next loop}  #                   FOR I := 1 to CUDout.length   
                  do begin 
                             XNETIBUF.B[FFINDEX + I] := CUDout.B[I] ;        
                  end{FOR} 
                 END ;                    {ELSE no Call User Data to add}              {Update header length:}   #           XNETIBUF.W[3] := - (HDRbyteLength + 1 + K + CUDout.length); # #                 { 1= fac.length field, length = call user data bytes} #              END {with};        {Send call pkt via XIO:}      #             XIOlen:= XNETibuf.W[3] - 8; {add 8 bytes for real length} #                  XIO  ;  { send the call packet }                    X25P := P3 ; { wait call conf }               {set Timer (be careful with possible overflow): }               If (32767 - LastTime) >= CallConfTO                 then VCTO:= CallConfTO + LastTime                 else VCTO := (-32768+CallConfTO) + LastTime ;               CallRetryCtr := CallRetryCtr-1;               X25TOctr := X25TOctr + 1;               GlobalTOctr := GlobalTOctr + 1       end {with};      end {PREP_SEND_CALL};     $page$   # {******************************************************************}  # # {                                                                  }  # # {!}  PROCEDURE  PREP_CALL_CONF ;    $direct$                     {!}  # # {                                                                  }  # # {  Prepares a CALL CONF packet in XNETIBUF.                        }  # # {                                                                  }  # # {  Called from X25P_WRITES  case P2 ( send call conf )             }  # # {                                                                  }  # # {  XNETibuf format :                   Call conf pkt type : 0F hex }  # # {                                                                  }  # # {       +-------------------------------------------+              }  # # {  W 0  !          XNET  security  code             !              }  # # {       !-------------------------------------------!              }  # # {  W 1  !                   0                       !              }  # # {       !-------------------------------------------!              }  # # {  W 2  !                   0                       !              }  # # {       !-------------------------------------------!              }  # # {  W 3  !         packet  header  length            !              }  # # {       !-------------------------------------------!              }  # # {  W 4  !  (D)     !        logical  VC number      !              }  # # {       !-------------------------------------------!              }  # # {  W 5  ! call conf pkt type!                       !              }  # # {       !-------------------------------------------!              }  # # {  W 6  !                                           !              }  # # {       !--                                       --!              }  # # {       +        facility field ( if any )          +              }  # # {       !--                                       --!              }  # # {  W n  !                                           !              }  # # {       +-------------------------------------------+              }  # # {                                                                  }  # # {******************************************************************}  #     
   VAR  I : 0..4095; 
        BEGIN  { Prepares CALL CONF packet in XNETIBUF }           With VCPTR^, AssociatedEQT^ do begin               If Facilities.Dbit                then XNETIBUF.W[4] := XNETIBUF.W[4] + 16384; {D bit}             XNETIBUF.B[10] := CallConfPkt; {ccitt type  0000 1111}    	      {addresses:} 	           XNETIBUF.B[11]:= 0; {no need to insert addresses}         {process facilities:}              FacilityLengthIndex:= 12;{save index to fill later}  !           FFindex:= FacilityLengthIndex+1; {facility field index} ! "           {------------------------ Packet size negotiation ? ---}  "              If facilities.PSbit               then begin                  XNETIBUF.B[FFindex] := 66; {facility code}                   XNETIBUF.B[FFindex+1] := EffectivePTW.OUTpktSize;                                           { from called }                   XNETIBUF.B[FFindex+2] := EffectivePTW.INpktSize;                                            { from calling }                 FFindex := FFindex+3                end {Packet Size Negotiation};   "           {----------------------- Window Size Negotiation ? ----}  "              If Facilities.WSbit               then begin                  XNETIBUF.B[FFindex] := 67;                   XNETIBUF.B[FFindex+1] := EffectivePTW.OUTwdwSize;                                           { from called }                   XNETIBUF.B[FFindex+2] := EffectivePTW.INwdwSize;                                            { from calling }                 FFindex := FFindex + 3 ;                end {window size negotiation};   $           {----------------------- Throughput Class Negotiation ? ---}  $              If Facilities.TCbit               then begin                   XNETIBUF.B [FFindex] := 2; {facility code}                  I:= (FFindex+1)*2; {half byte index}                  XNETIBUF.BCD [I] := EffectivePTW.outTHcl;                                       { from called }                   XNETIBUF.BCD[I+1] := EffectivePTW.inTHcl ;                                       { from calling }                   FFindex := FFindex+2 ;               end {throughput class negotiation};             {Update lengths:}            K:= FFindex - FacilityLengthIndex -1;              If K > 0       {if 0, headerlength already set to -3}    
          then begin 
           {Update facility length field:}                XNETIBUF.B [FacilityLengthIndex]:= K ;   $          {Update header length: 3 byte header+add length+fac length+K}  $              XNETIBUF.W[3] := - (5 + K )            end        end {with}   
   end {PREP_CALL_CONF} ;  
  $page$     {**********************************************}    BEGIN { X25P_WRITES  body ( on VCPTR of NETWP) }    {**********************************************}        With NETWP^, VCPTR^ do begin      	    Case X25P  of  	       {}  !     P2 : begin  {----- prepare and send a CALL CONF packet -----} !       {}   If msglu<>0 then          {}     Msg1write ( Msglu, ' XDISP: P2 send Call Conf' ) ;          {}   Prep_CALL_CONF ;   #      {}   XIOlen := XNETibuf.W[3] - 8; {add 8 bytes for real length}  #       {}        {}   XIO  ; { send it, ip1 = QlengthGroup }         {}        {}   X25P := p4 ; { Data transfer ready }         {}        {}   D1CleanUp ( VCPTR ) ;        {}   LINKUP ( AssociatedEQT ) ;         {} end;         {}       P3: begin {------ wait CALL CONF packet -------}         {}   If Msglu <> 0 then  {test only}        {}      Msg1Write(Msglu,' XDISP: P3 Wait Call Conf');         {}   if AssociatedEQT^.SendRR         {}     then AssociatedEQT^.SendRR := false ;        {} end ;             { case P3 added M45 BG 16FEB88}        {}       P5 : begin {----- prepare and send a CALL packet -----}  !      {} If MsgLu<>0 then Msg1write(Msglu,' XDISP: P5 send Call'); !       {}      Prep_Send_CALL;         {} end;         {}        P6 : begin {----- Prepare and send CLEAR CONF packet -----}   
      {} If MsgLu<>0 
       {}   then Msg1Write(Msglu,' XDISP: P6 Send Clear Conf');  "      {}      XNETIBUF.B[10] := ClearConfPkt; {ccitt type 0001 0111} "       {}      XIOlen := -11 {std header + 8 bytes};         {}        {}      XIO  ;  { send it, IP1 = Qlengthgroup }         {}  $      {}      {enter state P1 ( Call setup ready, no VC established ) :} $ !      {}      P1SETUP (VCPTR) ;  { sets X25P either to P1 or P5 }  ! #      {}                         { P5 : send Call if retry is needed } #       {}      If X25P = P5 { send Call }        {}      then begin        {}      {}   RRobinLastVC := VCPTR;         {}      {}   Qlength:= Qlength + 1;         {}      {}   {same as P5 treatment above:}        {}      {}   If msglu <> 0  then  "      {}      {}     Msg1write ( msglu, ' XDISP: P6(P5) Send Call'); "       {}      {}   Prep_Send_CALL;        {}      {}  	      {}      end  	       {} end;         {}       P7: begin {------ wait CLEAR CONF packet -------}        {}   If Msglu <> 0 then  {test only}        {}      Msg1Write(Msglu,' XDISP: P7 Wait Clear Conf');        {}   if AssociatedEQT^.SendRR         {}     then AssociatedEQT^.SendRR := false ;        {} end ;             { case P7 added M45 BG 16FEB88}        {}       P8 : begin {------ send CLEAR packet ---------}  "      {}      XNETIBUF.B [10] := ClearPkt ; {ccitt type: 0001 0011}  "       {}      If DCE then XNETIBUF.B[11] := cause   !      {}             else XNETIBUF.B[11] := 0; { DTE originated }  !       {}      XNETIBUF.B [12] := diag;        {}        {}      If msglu <> 0 then        {}        begin         {}          CNUM ( XNETIBUF.B[11], nbconv ) ; {test}        {}          CNUM ( diag, nbconv2 ); {test}        {}          Msgwrite ( msglu,' XDISP: send',        {}                     'CLEAR ',nbconv,nbconv2,' ');  
      {}        end; 
       {}        {}      XNETIBUF.W [3] := -5; {header data length}        {}      XIOlen := -13; {w[3]-8 bytes}         {}        {}      XIO  ; { send it, ip1 = QlengthGroup }        {}        {}      X25P := P7 ; {wait clear conf}        {}      {Set timer (be careful of possible overflow) :}         {}      If (32767 - LastTime) >= ClearConfTO        {}         then VCTO := ClearConfTO + LastTime         {}         else VCTO := (-32768 + ClearConfTO) + LastTime;   "      {}      If RetryCtr <= 0 { if last retry, need to be reset ? } "       {}        then RetryCtr := ClearRetryNb ;         {}      X25TOctr := X25TOctr + 1;         {}      GlobalTOctr := GlobalTOctr + 1        {} end        {}       otherwise        {}      { unexpected case of X25P : }         {}      { - P1 call set up ready, VC not established }        {}      { - P4 data transfer ready }        {}        {}      LOADSEG ( 'XSEG3' ) ; {M30}   
      {}      XSUSP (6) ;  
       {}      LOADSEG ( 'XSEG4' ) ; {M30}         {}      End {case X25P} ;       
    RRobinLastVC := VCPTR; 
 
    Qlength := Qlength +1  
   end {with}    end {  X25P_WRITES } ;       $ subtitle 'DATA_PKT_WRITES' , page $  # {******************************************************************}  # # {                                                                  }  # # {!} PROCEDURE  DATA_PKT_WRITES ;          $direct$               {!}  # # {                                                                  }  # # { Process emision of data packets for one VC.                      }  # # {                                                                  }  # # {  Called from ALL_VC_PKT_WRITES in P4 ( data transfer ready )     }  # # {                                   D1 ( flow control ready )      }  # # {                                   if not X25RNR.                 }  # # {                                                                  }  # # {  Calls  Prep_Std_ibuf                                            }  # # {         X25P_Writes                                              }  # # {         XIO                                                      }  # # {         D1SETUP                                                  }  # # {                                                                  }  # # {******************************************************************}  #      VAR  GFIQ , Mbit, WindowOK,TSTMOD, TSTMOD2 : boolean;        L ,  REMAININGLENGTH : word ;         EPRlim , MbitValue : byte;  	      P : 0..4095; 	     
 CONST  addCR = 64; {100B} 
         addCRandLF = 128; {200B}          LFcode = 10 ; {12B ascii}        BEGIN  { DATA_PKT_WRITES }          With NETWP^, VCPTR^, AssociatedEQT^, WriteReadEqt[1] do begin            EPRLIM := EPR + EffectivePTW.OUTWDWsize - 1;  "    If EPRLIM>= 8 then EPRLIM := EPRLIM - 8;{128 if extd numbering}  " 
    {verify window:} 
       TSTMOD := (epr <= eps); TSTMOD2 := (eps<=eprlim);         If EPR <= EPRLIM        then TSTMOD := TSTMOD  and TSTMOD2        else TSTMOD := TSTMOD  or TSTMOD2 ;       If TSTMOD       then begin         IP1.CODE := ip1DataPktWrite ;         IP2 := Writeeqtadd ;   
       If Facilities.Dbit  
          then XNETIBUF.W[4]:=XNETIBUF.W[4]+16384;{D bit}             Repeat { until not windowok}          {}    $page$   "       {} {-------------------------------------------------------}  " "       {} {----   Prep DATA pkt  ---------------------------------}  " "       {} {-------------------------------------------------------}  "        {}  GFIQ := false;  Mbit := false;          {}   #       {}  If W1.ReqSubf = 2  {Qbit data write subf (for PAD support)} #        {}  then begin          {}  {} {----------------------------------------------}         {}  {} {obtain Q bit data and prepare Qbit data packet}         {}  {} {----------------------------------------------}         {}  {}    Task := 2; {"Give Qbit Data"}  
       {}  {}    L := 11 ; 
         {}  {}    { index of first byte to fill with Q bit Data }          {}  {}    {12 if extended pkt numbering}           {}  {}    EQTPTR := AssociatedEQT; {parm needed by PDSUP}   #       {}  {}    PDSUP (task, XNETIBUF,L, IMMRQ); {always returns L>0} #        {}  {}          {}  {}    GFIQ := true;  "       {}  {}    XNETIBUF.W[4] := XNETIBUF.W[4]-32768; {sets Q bit}  " "       {}  {}    XNETIBUF.W[3] := XNETIBUF.W[3] - L  {update length} "        {}  end         {}  else begin          {}  {}  {----------------------------------}          {}  {}  { Prepare Normal Write:            }          {}  {}  {  (W3>0:  # of bytes to write)    }          {}  {}  {  (W3<=0: CR+LF/ LF to send)      }          {}  {}  {----------------------------------}          {}  {}  {-------------------------------------}         {}  {}  { Subfunction 0 : normal data write   }         {}  {}  { Subfunction 4 : Q-Bit data write    }         {}  {}  {-------------------------------------}  
       {}  {}   If W3 <= 0 
 #       {}  {}   then begin  {special: no data, only "send LF or CR+LF} #        {}  {}        L := 0 ; {no data bytes }         {}  {}        XNETIBUF.W[2]:=0; XNETIBUF.W[1]:=0 ;          {}  {}        If W3 = -1          {}  {}        then begin {send only a LF char}          {}  {}           XNETibuf.B[11]:=LFcode ;         {}  {}             { in B[12] if extd numbering }         {}  {}           XNETibuf.W[3]:= -4;          {}  {}             { -5 if extd numbering }         {}  {}        end         {}  {}        else CardCNWD[2] := addCRandLF;  
       {}  {}   end  
  $page$          {}  {}   else begin {W3>0 = # of bytes to send}         {}  {}     If  SendLF         {}  {}     then begin {send only LF char}         {}  {}     {} L:=0; XNETIBUF.W[1]:=0; XNETIBUF.W[2]:=0;         {}  {}     {} XNETIBUF.B[11]:=LFcode;         {}  {}     {}   {in B[12] if extd numbering }         {}  {}     {} XNETIBUF.W[3]:=-4;          {}  {}     {}   { -5 if extd numbering }          {}  {}     end          {}  {}     else begin {normal case}         {}  {}     {} XNETIBUF.W [1] := W2 ; {@ in SAM}         {}  {}     {} {computation of Length L:}   #       {}  {}     {}    P := PKTSIZETABLE [ EffectivePTW.OUTPKTSIZE ]; #        {}  {}     {}    If W3 > P   "       {}  {}     {}    then begin  {more than one packet to write}  "        {}  {}     {}     {}  L := P ;          {}  {}     {}     {}  MBIT := true          {}  {}     {}    end          {}  {}     {}    else begin {W3 <= P}  "       {}  {}     {}     {}  L := W3; {transfer ALL remaining bytes} " !       {}  {}     {}     {}  If W1.ReqSubf = 1 {means "add CR+LF"} !        {}  {}     {}     {}  then begin          {}  {}     {}     {}    If L < P-1          {}  {}     {}     {}    then { enough space }         {}  {}     {}     {}    {}   { "CR+LF" in packet }          {}  {}     {}     {}    {}  CardCnwd[2] := addCRandLF  #       {}  {}     {}     {}    else begin {at most one byte available} #        {}  {}     {}     {}    {}  MBIT := true;         {}  {}     {}     {}    {}  If L < P {i.e. = P-1}         {}  {}     {}     {}    {}  then begin   !       {}  {}     {}     {}    {}     { enough space for CR only } !        {}  {}     {}     {}    {}     CardCnwd [2] := addCR ;          {}  {}     {}     {}    {}     RemainingLength := -1;         {}  {}     {}     {}    {}  end  #       {}  {}     {}     {}    {}  else {L=P: no space for CR and LF}  #        {}  {}     {}     {}    {}     RemainingLength := -2;         {}  {}     {}     {}    end         {}  {}     {}     {}  end         {}  {}     {}     end;   #       {}  {}     {} XNETIBUF.W [2] := -L; {negative number of bytes}  #        {}  {}     {} IF W1.reqsubf = 4    {Q-Bit user write}         {}  {}     {} then begin   "       {}  {}     {}    {Treatment like as for normal write, except} "        {}  {}     {}    {that the Q-Bit is set}          {}  {}     {}    XNETibuf.W[4] := XNETibuf.W[4] - 32768         {}  {}     {} end {IF}          {}  {}     end   
       {}  {}   end  
        {}  end;    $page$          {}  {----------------------}          {}  {Prepare Packet Header:}          {}  {----------------------}          {}    {Dbit (if needed) already set}          {}    {Normal Packet Numbering:  P(R)   M   P(S)  0   }         {}    If Mbit then MbitValue := 16 else MbitValue := 0;         {}      If EMAcounter = 0         {}        then           {}          XNETIBUF.B[10] := RPS*32 + MbitValue + EPS*2           {}        else   !       {}          XNETIBUF.B[10] := RPR*32 + MbitValue + EPS*2 ;  ! $       {}        {Note:if extended pkt numbering, subtract 1 from W[3]}  $ $       {}  {----------------------------------------------------------}  $ $       {}  {------ End of  PREP DATA PKT   ---------------------------}  $ !       {} XIOlen := XNETIBUF.W[3]-8; {add 8 bytes for real length} !        {}          {} XIO  ;         {}    $page$          {} CardCnwd[2] := 0; {cancel possible subf "add CR"}          {} {Update flow control:}         {}     {Normal pkt numbering: modulo 8:}          {}       If EPS < 7 then EPS := EPS + 1 else EPS := 0;          {}       If EMAcounter = 0   
       {}       then 
        {}          RPR := RPS;         {}   	       {} If GFIQ  	        {} then  EQTtlog := L  
       {} else begin 
        {}    If SendLF         {}    then begin          {}    {} SendLF := false; {just done}         {}    {} Mbit := true;           {}    {}   { trick, because we still have data to write }          {}    {}   { This value is NOT used in the DATA pkt }         {}    {} XNETIBUF.W[3] := -3;  $       {}    {}                  {reset to std hdr length (-4 if extd)}  $        {}    end         {}    else begin           {}    {} W2 := W2 + (L div 2); {update @address in words}          {}    {} W3 := W3 - L; {update remaining length}          {}    {} EQTtlog := EQTtlog + L         {}    end         {} end;         {}          {} WriteCount := WriteCount + 1;          {} RRobinLastVC := VCPTR;         {} Qlength := Qlength + 1;          {}          {} If Not Mbit then begin {no need to send RR}          {}               PKTwriteNeeded := false;         {}               ReqState := CompleteWaitState;         {}                           { wait writecount = 0 }          {}               Goto  90 {end treatement for this VC}   
       {}             end; 
 
       {} {Mbit set} 
 "       {}    If W3 = 0 then W3:= RemainingLength; {add LF or CR+LF}  "        {}    {Verif window:}          {}      WindowOk := (EPR<=EPS); TSTMOD2:= (EPS<=EPRLIM);           {}      If EPR<=EPRLIM          {}      then WindowOk := WindowOk and TSTMOD2         {}      else WindowOk := WindowOk or TSTMOD2;         {}    PKTwriteNeeded := WindowOK ;          {}    If Qlength >= MaxQlength then goto 99 ;{Qblocked}         {}          Until NOT WINDOWOK ;       !       Goto  90  {end treatment for this VC (no need to send RR) } !     end     end {With}    end; {DATA_PKT_WRITES}   $subtitle ' ' , page $     {************************************}    BEGIN  { ALL_VC_PKT_WRITES body }     {************************************}       With NETWP^ do begin          { X25R = R1 and Qlength < MaxQlength }          XIOcode := 18 { write only in this module };      CardCnwd[1] := CardWriteLU ;      CardCnwd[2] := 0 { subf 0 };          LoopLimit := RRobinLastVC ;     VCPTR := LoopLimit;         REPEAT { until VCPTR = LoopLimit }           VCPTR := VCPTR^.NextVC ;          If VCPTR^.PKTwriteNeeded      Then begin      {---------------------------------------------------}       {     ONEVC_PKT_WRITES                              }       {---------------------------------------------------}       With VCPTR^ do begin            Prep_Std_Ibuf (VCNb) ;        IP1.code := ip1QlengthGroup ;       "      If X25P <> p4 { not data transfer ready ? } then  X25P_WRITES  "           else begin  { X25P = P4  data transfer ready }        {}        {} If X25D <> D1  { not flow control ready ? }  
      {} then begin  
       {}   {---------------------------------------------}        {}   {              X25D_WRITES                    }        {}   {---------------------------------------------}        {}        {}   case X25D of         {}      {}        {}     D2: begin {------ send RESET CONF packet -------}        {}      {}   If Msglu <> 0 then  {test only}  !      {}      {}      Msg1Write(Msglu,' XDISP: Send Reset Conf');  !        {}      {}   XNETIBUF.B [10] := ResetConfPkt; {ccitt type}          {}      {}   XIOlen := -11; {std header-8 for real length}   
      {}      {}   XIO  ;  
       {}      {}   D1SETUP (VCPTR)  {enter state D1}        {}      {} end ;        {}      {}        {}     D3: begin {------ wait RESET CONF packet -------}        {}      {}   If Msglu <> 0 then  {test only}  !      {}      {}      Msg1Write(Msglu,' XDISP: Wait Reset Conf');  !       {}      {}   if AssociatedEQT^.SendRR         {}      {}     then AssociatedEQT^.SendRR := false ;  !      {}      {} end ;             { case D3 added M38 BG 28AUG87} !       {}      {}        {}     D4: begin {------- send RESET packet -----------}  #      {}      {}   XNETIBUF.B[10] := ResetPkt; {ccitt type 0001 1011}  #       {}      {}   If DCE then XNETIBUF.B[11] := cause  #      {}      {}          else XNETIBUF.B[11] := 0; { DTE originated } #       {}      {}   XNETIBUF.B[12] := diag;        {}      {} If MsgLu <> 0 then begin {test only}         {}      {}   CNUM ( XNETIBUF.B[11], Nbconv );         {}      {}   CNUM ( diag, nbconv2 );         {}      {}   Msgwrite(msglu,' XDISP: send','RESET',nbconv,         {}      {}            nbconv2, ' ');        {}      {} end ;        {}      {}   XNETIBUF.W[3] := -5; {header length}         {}      {}   XIOlen := -13; {w[3]-8 for real length}  
      {}      {}   XIO  ;  
       {}      {}   X25D := D3 ; {wait reset conf}         {}      {}  !      {}      {}   {Set timer (be careful of possible overflow) :} !       {}      {}   If (32767-LastTime) >= ResetConfTO         {}      {}     then VCTO := ResetConfTO + LastTime  #      {}      {}     else VCTO := ( -32768 + ResetConfTO ) + LastTime; # #      {}      {}   If RetryCtr <= 0 {if last retry, need to be reset?} #       {}      {}     then RetryCtr := ResetRetryNb;         {}      {}   X25TOctr := X25TOctr + 1;        {}      {}   GlobalTOctr := GlobalTOctr + 1         {}      {} end;         {}      {}  !      {}     otherwise                      {added M38 BG 28AUG87} !       {}      {}  { unexpected case of X25D  }        {}      {}  { with pktwriteneeded true }        {}      {}        {}   end { case X25D };         {}        {}   RRobinLastVC := VCPTR;         {}   Qlength := Qlength + 1;        {}   {----------------------------------------------}         {}   {  end of X25D_WRITES                          }         {}   {----------------------------------------------}         {} end        {} else begin  { X25P = P4 data transfer ready }        {}             { X25D = D1 flow control ready  }        {}        {}   If X25RI = SendIntConf          {}   then begin {-------------- SEND INT CONF -----------}         {}   {}  If MsgLu <> 0 then   #      {}   {}    Msg1write(Msglu,' XDISP: Send Int Conf');{test only}  #       {}   {}  XNETIBUF.B [10] := IntConfPkt; {ccitt type}        {}   {}  XIOlen := -11; {std header -8 for real length}         {}   {}  XIO  ;         {}   {}  X25RI := NotInterrupted ;        {}   {}  {---------- end of SEND_INT_CONF --------}         {}   {}  RRobinLastVC :=  VCPTR;        {}   {}  QLength := QLength + 1         {}   end;         {}  "      {}   If AssociatedEQT^.WriteReadEQT[1].ReqState <> WriteState  "       {}   then begin         {}   {}  If X25EI = SendInt          {}   {}  then begin {----------- SEND INT ---------------}   #      {}   {}    If Msglu<>0 then Msg1write(Msglu,' XDISP: Send Int'); #       {}   {}    XNETIBUF.W[5]:= diag; {interrupt data byte}        {}   {}    XNETIBUF.B [10] := InterruptPkt; {ccitt type}        {}   {}    XNETIBUF.W [3] := -4; {header length}        {}   {}    XIOlen := -12; {header-8 for real length}        {}   {}    XIO  ;         {}   {}    X25EI := WaitIntConf ;         {}   {}    {-------- end of SEND_INT -----------}         {}   {}    RRobinLastVC := VCPTR ;        {}   {}    QLength := Qlength + 1   
      {}   {}  end;  
       {}   end        {}   else         {}   {}   If Not X25RNR then DATA_PKT_WRITES ;        {}        {}   If AssociatedEQT^.SendRR   !      {}   THEN BEGIN {--------------SEND RR--------------------}  !       {}   { Test only }         {}   If MsgLu <> 0 then Msg1write(Msglu,' XDISP: SendRR');   $      {}   XNETibuf.B[10] := PRTS * 32 + 1; { P(R) to send shifted to }  $ $      {}                                    { bits <6:8>; +1 : bit 0  }  $ $      {}                                    { for packet type id.     }  $       {}   XNETibuf.W[3] := -3;   
      {}   XIOLEN := -11;  
       {}   XIO ;        {}   RPR := PRTS ;        {}   RRobinlastvc := VCPTR ;        {}   QLength := QLength + 1;        {}   AssociatedEQT^.sendrr := false ;         {}   END ;        {}   { no more automatic RR sending }         {} end        {}        end { if X25P } ;             PKTwriteNeeded := false;      !    90 : If QLength >= MaxQlength then goto 99 { QLength blocked } !         end { with VCPTR }      end; { if VCPTR^.PKTwriteNeeded }   !    {-----------------------------------------------------------}  ! !    {--  end of ONEVC_PKT_WRITES -------------------------------}  ! !    {-----------------------------------------------------------}  !     
  Until VCPTR = LoopLimit; 
     
  end {with NETWP^}; 
      99: {Qlength blocked}       END ; { ALL_VC_PKT_WRITES}        $SUBTITLE 'ALL_VC_TRANSFER',PAGE$  # {******************************************************************}  # # {                                                                  }  # # {!} PROCEDURE  ALL_VC_TRANSFER ;          $direct$               {!}  # # {                                                                  }  # # { Iterate over ALL VC tables ( round robin from successor of       }  # # { RRobinLastVC ) to transfer data from EMA to user's buffer is SAM.}  # # {                                                                  }  # # {  Called from XDISP                                               }  # # {                                                                  }  # # {  Calls EMA_USER_TRANSFER                                         }  # # {                                                                  }  # # {******************************************************************}  #       VAR Looplimit : VCPTRtype;        BEGIN       
     WITH NETWP^ DO  
      BEGIN          Looplimit:=RRobinlastvc;  
        VCPTR:=Looplimit;  
             REPEAT    {Until VCptr = Looplimit}                  VCPTR:=VCPTR^.NextVC;             IF VCPTR^.Setup_EMA_User              THEN BEGIN   
              WITH VCPTR^  
               DO BEGIN {One VC Transfer}                   EMA_USER_TRANSFER(AssociatedEQT);                   Setup_EMA_user:=false;   
              END; {WITH}  
                END;{If VCPTR...}          UNTIL VCPTR = Looplimit;       END;{WITH}         End ; { ALL_VC_TRANSFER }        $subtitle 'XDISP main program', page $     {********************************************************}    BEGIN  { XDISP  body }    {********************************************************}      #  { CURRENTNET <> -1 }  { currentnet = -1 means skip the dispatcher }  #       If (CURRENTNET = 0) or ( NOT  SAMOK  {previous no SAM pb})      then begin { set up to dispatch over all networks}           upperNet := NbofNetworks ;   
         CURRENTNET := 1;  
          SAMOK := true;       end       else {Dispatch only on CURRENTNET}           UpperNet:= CURRENTNET;       {SAMOK always true here}       {Main loop:  }     Repeat  {until CurrentNet > UpperNet}      {}      {}  NETWP := NetwPtrTbl [ CURRENTNET ];     {}  with Netwp^ do begin      {}     {Prepare common parm:}     {}        IP1.NetwNb := CURRENTNET ;      {}      {}     If GlobalWrite <> NoWrite      {}     then  GLOBAL_WRITES ; {on NETWP^}      {}      {}     If GlobalRead <> NoRead      {}     then  GLOBAL_READS ; {on NETWP^}     {}      {}     If X25R = R1     {}     then  ALL_VC_TRANSFER;     {}      {}     If (X25R = R1) and (Qlength < MaxQlength)      {}     then  ALL_VC_PKT_WRITES ; {on NETWP^}      {}  end ; { with Netwp^ }     {}      {}  CURRENTNET := CURRENTNET + 1;     {}     until CURRENTNET > UpperNet ;            999:      end {XDISP} ;   . { end of program unit  XDISP }  