.TH PMV 1P "22 June 1983"
.UC 4
.SH NAME
pmv \- move or rename files
.SH SYNOPSIS
.B pmv
[\fB\-f\^i\fR] [\fB\-\fR] file1 file2
.PP
.B pmv
[\fB\-f\^i\fR] [\fB\-\fR] file ... dirname
.SH DESCRIPTION
.I Pmv
moves (changes the name of)
.I file1
to
.I file2.
If
.I file2
already exists, it is removed before
.I file1
is moved. If
.I file2
has a mode that forbids
writing,
.I pmv
prints the mode and reads the standard input to obtain a line. The move
takes place only if the line begins with \fBy\fR. In the second form,
one or more
.I files
are moved to
.I dirname
with their original file names.
.PP
.I File
and
.I dirname
may be either regular or project pathnames. However, because
.I pmv
interprets both
.I file
and
.I dirname
arguments as project pathnames, if
.I file
matchs the name of a project directory within the same project, then
.I pmv
will print the error message `pmv: can't move project directory
.I file',
unless
.I file
is disguised as ./\fIfile\fR.
.PP
.I Pmv
blindly supercedes
existing files unless the
.B \-i
option is specified.
.PP
.I Pmv
refuses to move a file onto itself.
.SH OPTIONS
.TP
.IP \fB\-f\fR
Stands for force. This option
overrides any mode restrictions and the
.B \-i
switch.
.IP \fB\-i\fR
Interactive mode. Whenever a move is to supercede an existing file,
the user is prompted by the name of the file followed by a question mark. If
answered with a line starting with `y', the move continues. Any other reply
prevents the move from occurring.
.IP \fB\-\fR
Interpret all the following arguments to
.I pmv
as file names. This allows file names starting with minus.
.SH "SEE ALSO"
mv(1)
.SH DIAGNOSTICS
Exit status 0 is normal. Exit status 1 indicates an error.
.SH AUTHOR
Peter J. Nicklin
.SH BUGS
If
.I file1
and
.I file2
lie on different file systems,
.I pmv
must copy the file and delete the original. In this case the owner name
becomes that of the copying process and any linking relationship with
other files is lost.
